///////////////////////////////////////////////////////////////////////////
// HD_export2
///////////////////////////////////////////////////////////////////////////
// 16/04/2002
//
// Copyright (c) 2002-2003, E. Ravon (Bat)
//
// Auteur : manu_bat_manu@yahoo.fr
//
// Import/Export simple des donnes d'HD
//
// Ce code est un exemple d'accs en C aux donnes du logiciel HelloDOC
// Il utilise la bibliothque HDAPI.
//
// Ce code a t dvelopp pour HelloDOC Etendu 4.56.116
// Ainsi que pour la version d'hdapi.h associe.
//
// Il a t test avec HD 4.56 tendu et HDESe
// Son fonctionnement n'est en aucun cas guaranti
//
// Chacun peut utiliser ce logiciel a des fins diverses,
// le modifier et le redistribuer librement, conformement aux conditions ci dessous :
//
//  1. L'origine de ce programme ne doit pas etre falsifie; vous ne devez pas
//      prtendre que vous en tes l'auteur. Si vous utilisez ce logiciel dans
//      un produit, une remarque dans votre documentation serait la bienvenue.
//
//  2. Les versions modifies du programme doivent etre notifies en tant que
//      tel, et ne doivent pas etre prsentes comme tant le programme original
//
//  3. Cette notice ne doit pas etre retire ou altre pour chaque diffusion
//
//  4. Toute utilisation commerciale requiert l'accord de l'auteur.
//
// HelloDOC est dvelopp par Imagine Editions.
// Windows est une marque de Microsoft Corporation
// Palm est une marque de Palm, Inc.
////////////////////////////////////////////////////////////////////////////

#include <windows.h>		// Prototypes des fonctions Windows
#include "res.h"			// Constantes des ressources (boite d'affichage,etc,etc)
#include "hdapi.h"			// Prototypes des fonction disponibles dans HDAPI.DLL
#include "config.h"			// Prototypes des fonctions de configuration
#include "process.h"		// Prototypes des fonctions d'export
#include "main.h"			// Fonctions d'affichage

HINSTANCE 		hInst;		// Handle sur l'instance
CONFIG			config;		// Contient toute la configuration

BOOL _stdcall Main_Dlg(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);
							// CallBack fenetre principale
void aff_config(HWND hwnd);	// Affiche la configuration
void grab_config(HWND hwnd);// Rcupre ce qui est entr dans les boites


/************************************************************************************************/
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, INT nCmdShow){
/************************************************************************************************/
hInst=hInstance;

if (!HDOpenSession(TRUE)){		// Ouvre la session HD
	aff_erreur(NULL,"Impossible d'ouvrir une session HD\nARRET\n");
	return 0;
	}

lit_config();					// Lit la config en BDR
process_cmd_line(lpCmdLine);	// Lit les options en ligne de commande
DialogBox(hInst,MAKEINTRESOURCE(IDD_MAIN),NULL,Main_Dlg);	// Cration boite principale
ecrit_config();					// Ecrit la config en BDR

HDCloseSession();				// Ferme la session HD
return 0;
}


///////////////////////////////////////////////////////////////////////////////////
// MAIN DLG CALLBACK
///////////////////////////////////////////////////////////////////////////////////
/******************************************************************************/
BOOL _stdcall Main_Dlg(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam){
/******************************************************************************/

switch(msg) {
	case WM_INITDIALOG:
		aff_config(hwnd);			// Affiche la config
		switch (config.mode){		// Effectue les actions automatiques
			case MODE_AUTO_TXT:
				hd_traite_agenda(hwnd,EXPORT_TEXTE);
				config.mode=MODE_NORMAL;
				break;
			case MODE_AUTO_PALM:
				hd_traite_agenda(hwnd,EXPORT_PALM);
				config.mode=MODE_NORMAL;
				break;
			case MODE_AUTO_PSION:
				hd_traite_agenda(hwnd,EXPORT_PSION);
				config.mode=MODE_NORMAL;
				break;
			}
		return 1;
		break;
	case WM_COMMAND:
		switch (LOWORD(wParam)){
			case IDD_MAIN_CH:				// Configuration
				hd_conf_cabinet(hwnd);
				aff_config(hwnd);
				break;
			case IDD_MAIN_EXP_AGENDA:
				grab_config(hwnd);
				hd_traite_agenda(hwnd,EXPORT_TEXTE);		// Export Agenda
				break;
			case IDD_MAIN_EXP_PALM:
				grab_config(hwnd);
				hd_traite_agenda(hwnd,EXPORT_PALM);		// Export Agenda vers Palm
				break;
			case IDD_MAIN_EXP_PSION:
				grab_config(hwnd);
				hd_traite_agenda(hwnd,EXPORT_PSION);		// Export Agenda vers Psion
				break;
			case IDD_MAIN_EXIT:
				PostMessage(hwnd,WM_CLOSE,0,0);
				break;
			case IDD_MAIN_IMP_PALM:
				hd_traite_agenda(hwnd,IMPORT_PALM);		// Import depuis Palm vers Agenda
				break;
			case IDD_MAIN_IMP_PSION:
				hd_traite_agenda(hwnd,IMPORT_PSION);	// Import depuis Psion vers Agenda
				break;
			}
		break;
	case WM_CLOSE:
		grab_config(hwnd);
		EndDialog(hwnd,0);
		break;
	}
return 0;
}


/*************************************/
void aff_config(HWND hwnd){
/*************************************/
HICON icon;

icon=LoadIcon(hInst,MAKEINTRESOURCE(IDI_ICON));
SendMessage(hwnd,WM_SETICON,ICON_SMALL,(LPARAM)icon);
SendMessage(hwnd,WM_SETICON,ICON_BIG,(LPARAM)icon);

SendDlgItemMessage(hwnd,IDD_MAIN_PATH,WM_SETTEXT,0,(LPARAM)config.path);
SendDlgItemMessage(hwnd,IDD_MAIN_CABINET,WM_SETTEXT,0,(LPARAM)config.cabinet);
SendDlgItemMessage(hwnd,IDD_MAIN_USER,WM_SETTEXT,0,(LPARAM)config.user);

SendDlgItemMessage(hwnd,IDD_MAIN_PAT_LST,EM_LIMITTEXT,MAX_LISTE,0);
SendDlgItemMessage(hwnd,IDD_MAIN_PAT_LST,WM_SETTEXT,0,(LPARAM)config.liste_patient);

SendDlgItemMessage(hwnd,IDD_MAIN_PAT_ONLY,BM_SETCHECK,config.use_patient,0);
SendDlgItemMessage(hwnd,IDD_MAIN_V_ONLY,BM_SETCHECK,config.use_visite,0);
SendDlgItemMessage(hwnd,IDD_MAIN_TODAY,BM_SETCHECK,config.today_only,0);

char buf[MAX_PATH];
wsprintf(buf,"%d.%02d",config.version,config.sversion);
SendDlgItemMessage(hwnd,IDD_MAIN_VER,WM_SETTEXT,0,(LPARAM)buf);
}

/*************************************/
void grab_config(HWND hwnd){
/*************************************/
SendDlgItemMessage(hwnd,IDD_MAIN_PAT_LST,WM_GETTEXT,MAX_LISTE,(LPARAM)config.liste_patient);
config.use_patient=SendDlgItemMessage(hwnd,IDD_MAIN_PAT_ONLY,BM_GETCHECK,0,0);
config.use_visite=SendDlgItemMessage(hwnd,IDD_MAIN_V_ONLY,BM_GETCHECK,0,0);
config.today_only=SendDlgItemMessage(hwnd,IDD_MAIN_TODAY,BM_GETCHECK,0,0);
}

/*************************************/
void aff_erreur(HWND hwnd,char *err){
/*************************************/
MessageBox(hwnd,err,"HD Export - Erreur",MB_OK|MB_ICONERROR);
}
