///////////////////////////////////////////////////////////////////////////
// HD_export2
///////////////////////////////////////////////////////////////////////////
// 16/04/2002
//
// Copyright (c) 2002-2003, E. Ravon (Bat)
///////////////////////////////////////////////////////////////////////////

#include <windows.h>
#include "config.h"


/////////////////////////////
// Accs  la registry
/////////////////////////////

#define READ_KEY(_type,_lg,_key,_var)		lg=_lg;type=_type;RegQueryValueEx(key,_key,NULL,&type,&_var,&lg);
#define WRITE_KEY_STR(_type,_lg,_key,_var)	RegSetValueEx(key,_key,0,_type,&_var,strlen(_var));
#define WRITE_KEY(_type,_lg,_key,_var)	RegSetValueEx(key,_key,0,_type,&_var,_lg);

/*****************************************/
void lit_config(){
/*****************************************/
HKEY key=NULL;
int type;
int lg;

memset(&config,0,sizeof(config));			// met  0 toutes les donnes

RegOpenKey(HKEY_CURRENT_USER,_CLE,&key);	// lit les donnes (si disponibles)
if (key!=NULL){
	READ_KEY(REG_SZ,MAX_PATH,"Chemin",config.path);
	READ_KEY(REG_SZ,MAX_PATH,"Cabinet",config.cabinet);
	READ_KEY(REG_SZ,MAX_PATH,"User",config.user);
	READ_KEY(REG_DWORD,sizeof(int),"Version",config.version);
	READ_KEY(REG_DWORD,sizeof(int),"SVersion",config.sversion);
	READ_KEY(REG_DWORD,sizeof(int),"PatientOnly",config.use_patient);
	READ_KEY(REG_DWORD,sizeof(int),"VisiteOnly",config.use_visite);
	READ_KEY(REG_SZ,MAX_LISTE,"ListePatient",config.liste_patient);
	READ_KEY(REG_DWORD,sizeof(int),"TodayOnly",config.today_only);
	//Palm
	READ_KEY(REG_SZ,MAX_PATH,"DateBookPath",config.path_datebook);
	RegCloseKey(key);
	}
config.version=_VERSION_;
config.sversion=_SVERSION_;
}

/*****************************************/
void ecrit_config(){
/*****************************************/
HKEY key;
int type;

type=REG_SZ;
RegCreateKeyEx(HKEY_CURRENT_USER,_CLE,0,"",REG_OPTION_NON_VOLATILE,KEY_ALL_ACCESS,NULL,&key,&type);
WRITE_KEY_STR(REG_SZ,MAX_PATH,"Chemin",config.path);
WRITE_KEY_STR(REG_SZ,MAX_PATH,"Cabinet",config.cabinet);
WRITE_KEY_STR(REG_SZ,MAX_PATH,"User",config.user);
WRITE_KEY(REG_DWORD,sizeof(int),"Version",config.version);
WRITE_KEY(REG_DWORD,sizeof(int),"SVersion",config.sversion);
WRITE_KEY_STR(REG_SZ,MAX_LISTE,"ListePatient",config.liste_patient);
WRITE_KEY(REG_DWORD,sizeof(int),"PatientOnly",config.use_patient);
WRITE_KEY(REG_DWORD,sizeof(int),"VisiteOnly",config.use_visite);
WRITE_KEY(REG_DWORD,sizeof(int),"TodayOnly",config.today_only);
//Palm
WRITE_KEY(REG_SZ,MAX_PATH,"DateBookPath",config.path_datebook);
RegCloseKey(key);
}









/////////////////////////////
// Parse la ligne de commande
/////////////////////////////

/*****************************************/
void process_cmd_line(char *txt){
/*****************************************/
int lg,pt=0,i,j;

lg=strlen(txt);
while (pt<lg){
	if (txt[pt]=='/'){
		pt++;
		switch(txt[pt]){
			case 'A': case 'a':
				config.mode=MODE_AUTO_TXT;
				break;
			case 'B': case 'b':
				config.mode=MODE_AUTO_PALM;
				break;
			case 'C': case 'c':
				config.mode=MODE_AUTO_PSION;
				break;
			}
		}
	pt++;
	}
}



/********************************************************************************************/
BOOL ouvre_fichier(HWND hwnd,char *sortie,int taille_buffer,char *filtre,char *titre_fenetre){
/********************************************************************************************/
char nom_fic_in[MAX_PATH];
OPENFILENAME ofn;
int tmp,ret;

strcpy(nom_fic_in,sortie);

ofn.lStructSize=sizeof(ofn);
ofn.hwndOwner=hwnd;
ofn.lpstrFilter=filtre;
ofn.lpstrCustomFilter=NULL;
ofn.nFilterIndex=0;
ofn.lpstrFile=nom_fic_in;
ofn.nMaxFile=200;
ofn.lpstrFileTitle=NULL;
ofn.nMaxFileTitle=0;
ofn.lpstrInitialDir=NULL;
ofn.lpstrTitle=titre_fenetre;
ofn.Flags=OFN_EXPLORER | OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT;
ofn.nFileOffset=0;
ofn.nFileExtension=0;
ofn.lpstrDefExt=0;


ret=GetOpenFileName(&ofn);
if (ret!=0)
	strcpy(sortie,nom_fic_in);
return 0;
}
