//////////////////////////////////////////////////////////////////////
//
//  A P I   p o u r   H e l l o D O C
//
//  Version 4.21 du 19/10/1999
//
//////////////////////////////////////////////////////////////////////
//
//  pour Microsoft Windows 95, Windows 98
//  Windows NT 4.0, Windows 2000
//
//  avec Microsoft Foundation Classes 4.2
//
//////////////////////////////////////////////////////////////////////
//
//  Copyright  1989-1999, IMAGINE Editions.
//  Tous droits rservs
//
//////////////////////////////////////////////////////////////////////
//
//  hdapi.h
//

#define API_EXPORT		FAR PASCAL //__declspec(dllexport)
#define TLA_VERSION
#define EURO_VERSION

#if !defined(HDAPI_H_INCLUDED)
#define HDAPI_H_INCLUDED

// Lien automatique
//////////////////////////////////////////////////////////////////////
//#pragma comment (lib, "hdapi.lib")

#ifdef __cplusplus
extern "C" {
#endif

//////////////////////////////////////////////////////////////////////
//
//  Macros
//
//////////////////////////////////////////////////////////////////////
#ifdef __cplusplus
#define API_EXPORT		extern "C"
#else
//#define API_EXPORT		__declspec(dllexport)
#endif

#define HDAPI			PASCAL WINAPI

#define TYPEDEF(name)	name, NEAR* P##name, FAR* LP##name

//////////////////////////////////////////////////////////////////////
//
//  Identificateurs des noms de fichiers en resources (hdapi.rc)
//
//////////////////////////////////////////////////////////////////////
#define IDS_FNAME_ADRESSES						10000
#define IDS_FNAME_AGENDAS						10001
#define IDS_FNAME_AGENDASX						10002
#define IDS_FNAME_CONFIG						10003
#define IDS_FNAME_DEPENSES						10004
#define IDS_FNAME_DEPENSESX						10005
#define IDS_FNAME_DICTIONNAIRE_POSOLOGIES		10006
#define IDS_FNAME_DOSSIERS						10007
#define IDS_FNAME_DOSSIERSX						10008
#define IDS_FNAME_DSIABSTRATS					10009
#define IDS_FNAME_DSIABSTRATSX					10010
#define IDS_FNAME_DSICIPX						10011
#define IDS_FNAME_DSICLASSES					10012
#define IDS_FNAME_DSICLASSESX					10013
#define IDS_FNAME_DSIGRAVITES					10014
#define IDS_FNAME_DSIGRAVITESX					10015
#define IDS_FNAME_DSIINTERACTIONS				10016
#define IDS_FNAME_DSIINTERACTIONSX				10017
#define IDS_FNAME_DSIMEDICAMENTS				10018
#define IDS_FNAME_DSIMEDICAMENTSX				10019
#define IDS_FNAME_DSITEXTS						10020
#define IDS_FNAME_DSITEXTSX						10021
#define IDS_FNAME_FORMULAIRES					10022
#define IDS_FNAME_INBOX							10023
#define IDS_FNAME_INBOXX						10024
#define IDS_FNAME_PATIENTS						10025
#define IDS_FNAME_PATIENTSX						10026
#define IDS_FNAME_PHARMACIES					10027
#define IDS_FNAME_PHARMACIESX					10028
#define IDS_FNAME_POSOLOGIES					10029
#define IDS_FNAME_POSOLOGIESX					10030
#define IDS_FNAME_POSTES						10031
#define IDS_FNAME_PROFESSIONS					10032
#define IDS_FNAME_RECETTES						10033
#define IDS_FNAME_RECETTESX						10034
#define IDS_FNAME_SPECIALS						10035
#define IDS_FNAME_TEMPORAIRES					10036
#define IDS_FNAME_TEMPORAIRESX					10037
#define IDS_FNAME_TEXTES						10038
#define IDS_FNAME_VIDALDOCUMENTS				10039
#define IDS_FNAME_VIDALRUBRIQUES				10040
#define IDS_FNAME_VIDALSPECIALS					10041
#define IDS_FNAME_HDINI							10042
#define IDS_FNAME_OLDPHARMACIES					10043
#define IDS_FNAME_OLDPHARMACIESX				10044
#define IDS_FNAME_LIENVITALEX					10045
#define IDS_FNAME_ORDONNANCE_SECURE_STD			10046
#define IDS_FNAME_COURRIER_STD					10047
#define IDS_FNAME_DEFAUT						10048
#define IDS_FNAME_DELETED						10049
#define IDS_FNAME_DEPENSELOG					10050
#define IDS_FNAME_DUPLICATA						10051
#define IDS_FNAME_ENTETE						10052
#define IDS_FNAME_DICTIONNAIRE_ALLERGIES		10053
#define IDS_FNAME_DICTIONNAIRE_BIOLOGIES		10054
#define IDS_FNAME_DICTIONNAIRE_CHIRURGIES		10055
#define IDS_FNAME_DICTIONNAIRE_OBSERVATIONS		10056
#define IDS_FNAME_DICTIONNAIRE_CORRESPONDANCES	10057
#define IDS_FNAME_DICTIONNAIRE_FAMILLES			10058
#define IDS_FNAME_DICTIONNAIRE_GYNECOLOGIES		10059
#define IDS_FNAME_DICTIONNAIRE_INTOLERANCES		10060
#define IDS_FNAME_DICTIONNAIRE_MEDICAUX			10061
#define IDS_FNAME_DICTIONNAIRE_OBSTETRIES		10062
#define IDS_FNAME_DICTIONNAIRE_VACCINS			10063
#define IDS_FNAME_IMPORTATION					10064
#define IDS_FNAME_LETTRES						10065
#define IDS_FNAME_MODEMS						10066
#define IDS_FNAME_ORDONNANCE_STD				10067
#define IDS_FNAME_PARBIOLOGIES					10068
#define IDS_FNAME_RECETTELOG					10069
#define IDS_FNAME_REFERENCE						10070
#define IDS_FNAME_SOUND							10071
#define IDS_FNAME_ZONE1							10072
#define IDS_FNAME_ZONE2							10073
#define IDS_FNAME_VIEWER						10074
#define IDS_FNAME_OLDCONFIG						10075
#define IDS_FNAME_OLDHDINI						10076
#define IDS_FNAME_RMO							10077
#define IDS_FNAME_DSIPOSOLOGIES					10078
#define IDS_FNAME_DSIPOSOLOGIESX				10079
#define IDS_FNAME_HOMEO							10080
#define IDS_FNAME_HOMEOX						10081
#define IDS_FNAME_MEDIAVIDALX					10082
#define IDS_FNAME_KEYWORDSX						10083
#define IDS_FNAME_NOTKEYWORDSX					10084
#define IDS_FNAME_KEYWORDSINI					10085
#define IDS_FNAME_MEDIAVIDAL					10088
#define IDS_FNAME_INIMEDIAVIDAL					10089
#define IDS_FNAME_NEWFILE						10090
#define IDS_FNAME_FSE							10091
#define IDS_FNAME_FSEX							10092
#define IDS_FNAME_LOT							10093
#define IDS_FNAME_LOTX							10094
#define IDS_FNAME_MAIL							10095
#define IDS_FNAME_MAILX							10096
#define IDS_FNAME_DFCC							10097
#define IDS_FNAME_DFCCX							10098
#define	IDS_FNAME_CPTLIBINI						10099
#define	IDS_FNAME_JOURNAL						10100
#define	IDS_FNAME_JOURNALX						10101
#define	IDS_FNAME_PLAN							10102
#define	IDS_FNAME_PLANX							10103
#define	IDS_FNAME_RUBRIQUES						10104
#define	IDS_FNAME_RUBRIQUESX					10105
#define	IDS_FNAME_BANQUES						10106
#define	IDS_FNAME_BANQUESX						10107
#define	IDS_FNAME_LIBELLE						10108
#define	IDS_FNAME_VERSION						10109
#define	IDS_FNAME_IMMOBILISATIONS				10110
#define	IDS_FNAME_IMMOBILISATIONSX				10111
#define	IDS_FNAME_AMORTISSEMENTS				10112
#define	IDS_FNAME_AMORTISSEMENTSX				10113
#define	IDS_FNAME_USER							10114
#define	IDS_FNAME_OLDRECETTES					10115
#define	IDS_FNAME_OLDRECETTESX					10116
#define IDS_FNAME_PEDIATRIE						10117
#define IDS_FNAME_PEDIATRIEX					10118
#define IDS_FNAME_SEANCES						10119
#define IDS_FNAME_SEANCESX						10120
#define	IDS_FNAME_TRAITEMENTSIDX				10121
#define	IDS_FNAME_ARCHIVE						10122
#define	IDS_FNAME_FSP							10123
#define	IDS_FNAME_FSPX							10124
#define	IDS_FNAME_TEMPORAIRES2					10125
#define	IDS_FNAME_TEMPORAIRES2X					10126


//////////////////////////////////////////////////////////////////////
//
// Identificateurs des fichiers
//
//////////////////////////////////////////////////////////////////////
enum
{
	FILE_AGENDAS,
	FILE_PATIENTS,
	FILE_RECETTES,
	FILE_DEPENSES,
	FILE_PHARMACIES,
	FILE_DSIMEDICAMENTS,
	FILE_POSOLOGIES,
	FILE_DSIINTERACTIONS,
	FILE_DSICLASSES,
	FILE_DSIGRAVITES,
	FILE_DSITEXTS,
	FILE_DSIABSTRATS,
	FILE_VIDALSPECIALS,
	FILE_VIDALRUBRIQUES,
	FILE_VIDALDOCUMENTS,
	FILE_HOMEOPATHIQUE,
	FILE_MEDIAVIDAL,
	FILE_DATASEMP,
	FILE_DOSSIERS,
	FILE_INBOX,
	FILE_MAIL,
	FILE_KEYWORDS,
	FILE_LIENVITALE,
	FILE_FSE,
	FILE_LOT,
	FILE_PLAN,
	FILE_JOURNAL,
	FILE_RUBRIQUES,
	FILE_BANQUES,
	FILE_IMMOBILISATIONS,
	FILE_AMORTISSEMENTS,
	FILE_DFCC,
	FILE_PEDIATRIE,
	FILE_SEANCES,
	FILE_FSP
} ;

//////////////////////////////////////////////////////////////////////
//
// Identificateurs des fichiers pour accs C-Tree
//
//////////////////////////////////////////////////////////////////////
enum
{
	AGENDAS = 1,
	AGENDASX,
	AGENDAS1X = AGENDASX,
	AGENDAS2X,
	AGENDAS3X,

	PATIENTS,
	PATIENTSX,
	PATIENTS1X = PATIENTSX,
	PATIENTS2X,
	PATIENTS3X,
	PATIENTS_,
	PATIENTSX_,
	PATIENTS1X_ = PATIENTSX_,
	PATIENTS2X_,
	PATIENTS3X_,

	RECETTES,
	RECETTESX,
	RECETTES1X = RECETTESX,
	RECETTES2X,
	RECETTES3X,
	RECETTES4X,
	RECETTES_,
	RECETTESX_,
	RECETTES1X_ = RECETTESX_,
	RECETTES2X_,
	RECETTES3X_,
	RECETTES4X_,

	DEPENSES,
	DEPENSESX,

	PHARMACIES,
	PHARMACIESX,

	POSOLOGIES,
	POSOLOGIESX,

	DSIMEDICAMENTS,
	DSIMEDICAMENTSX,
	DSICIPX,

	DSIINTERACTIONS,
	DSIINTERACTIONSX,

	DSICLASSES,
	DSICLASSESX,

	DSIGRAVITES,
	DSIGRAVITESX,

	DSITEXTS,
	DSITEXTSX,

	DSIABSTRATS,
	DSIABSTRATSX,

	HOMEO,
	HOMEOX,

	DOSSIERS,
	DOSSIERSX,
	ANTECEDENTS = DOSSIERS,
	ANTECEDENTSX = DOSSIERSX,
	CONSULTATIONS = DOSSIERS,
	CONSULTATIONSX = DOSSIERSX,
	ORDONNANCES = DOSSIERS,
	ORDONNANCESX = DOSSIERSX,
	COURRIERS = DOSSIERS,
	COURRIERSX = DOSSIERSX,
	VACCINS = DOSSIERS,
	VACCINSX = DOSSIERSX,
	BIOLOGIES35 = DOSSIERS,
	BIOLOGIES35X = DOSSIERSX,
	BIOLOGIES = DOSSIERS,
	BIOLOGIESX = DOSSIERSX,
	NOTES = DOSSIERS,
	NOTESX = DOSSIERSX,
	BITMAPS = DOSSIERS,
	BITMAPSX = DOSSIERSX,
	PIECESJOINTES = DOSSIERS,
	PIECESJOINTESX = DOSSIERSX,
	INFOSESAM = DOSSIERS,
	INFOSESAMX = DOSSIERSX,
	SITFACTTLA = DOSSIERS,
	SITFACTTLAX = DOSSIERSX,
	TRAITEMENTS = DOSSIERS,
	TRAITEMENTSX = DOSSIERSX,
	DOSSIERS_,
	DOSSIERSX_,

	MEDIAVIDALX,

	INBOX,
	INBOXX,
	INBOX1X = INBOXX,
	INBOX2X,

	MAILX,
	MAIL1X = MAILX,
	MAIL2X,

	KEYWORDS,
	KEYWORDSX,

	LIENVITALEX,

	FSE,
	FSEX,
	FSE1X = FSEX,
	FSE2X,
	FSE3X,
	FSE4X,
	FSE5X,

	FSE_,
	FSEX_,
	FSE1X_ = FSEX_,
	FSE2X_,
	FSE3X_,
	FSE4X_,
	FSE5X_,

	LOT,
	LOTX,
	LOT1X = LOTX,
	LOT2X,
	LOT3X,
	LOT4X,

	LOT_,
	LOTX_,
	LOT1X_ = LOTX_,
	LOT2X_,
	LOT3X_,
	LOT4X_,

	PLAN,
	PLANX,
	PLAN1X = PLANX,
	PLAN2X,
	PLAN3X,
	PLAN4X,
	PLAN5X,

	JOURNAL,
	JOURNALX,
	JOURNAL1X = JOURNALX,
	JOURNAL2X,
	JOURNAL3X,
	JOURNAL4X,
	JOURNAL5X,
	JOURNAL6X,

	RUBRIQUES,
	RUBRIQUESX,
	RUBRIQUES1X = RUBRIQUESX,
	RUBRIQUES2X,
	RUBRIQUES3X,
	RUBRIQUES4X,

	BANQUES,
	BANQUESX,
	BANQUES1X = BANQUESX,
	BANQUES2X,
	BANQUES3X,

	DFCCX,
	DFCC1X = DFCCX,
	DFCC2X,

	IMMOBILISATIONS,
	IMMOBILISATIONSX,
	IMMOBILISATIONS1X = IMMOBILISATIONSX,
	IMMOBILISATIONS2X,

	AMORTISSEMENTS,
	AMORTISSEMENTSX,

	PEDIATRIE,
	PEDIATRIEX,

	SEANCES,
	SEANCESX,
	SEANCES1X = SEANCESX,
	SEANCES2X,
	SEANCES3X,
	SEANCES4X,
	SEANCES5X,
	SEANCES6X,

	TRAITEMENTSIDX,
	TRAITEMENTSID1X = TRAITEMENTSIDX,
	TRAITEMENTSID2X,
	TRAITEMENTSID3X,
	TRAITEMENTSID4X,

	FSP,
	FSPX,

	HD_TEMP_FILE,
	HD_TEMP_FILEX
} ;

//////////////////////////////////////////////////////////////////////
//
// ATTENTION NE PAS NEGLIGER CETTE VALEUR
// CETTE VALEUR INDIQUE LE NOMBRE DE FICHIER MAXIMUM.
//
// A METTRE A JOUR PAR RAPPORT AU DERNIER FICHIER
//
//////////////////////////////////////////////////////////////////////
#define MAX_FILES		(HD_TEMP_FILEX + 6)


////////////////////////////////////////////////////////////////////////////
//
// Types
//
////////////////////////////////////////////////////////////////////////////
//typedef unsigned short				USHORT ;
typedef short						SBOOL ;
typedef	unsigned long				HDDATE ;
typedef	unsigned long				HDTIME ;
typedef	HDDATE FAR*					LPHDDATE ;
typedef	HDTIME FAR*					LPHDTIME ;

typedef short						HDFILE ;	// Identificateur fichier de squentiel index
typedef long						HDFILEPOS ;	// Position dans un fichier

typedef DWORD						(CALLBACK* WORKPROC)(UINT, UINT, WPARAM, LPARAM) ;	// uProc, wWork, wParam, lParam


//////////////////////////////////////////////////////////////////////
//
// Constantes
//
//////////////////////////////////////////////////////////////////////

// Longueur maximale pour une cl
//////////////////////////////////////////////////////////////////////
#define MAX_KEYLEN					64		// Constante utilise pour les dclarations des cls (char szKey [MAX_KEYLEN] ;)

// Limites
//////////////////////////////////////////////////////////////////////
#define	MAX_COEFFICIENTS			20		// Nombre de coeficients de recettes
#define MAX_JOURS					7		// Nombre de jours dans la semaine
#define MAX_WARNINGS				10		// Nombre de niveau d'alarme
#define MAX_POSOLOGIES				5		// Nombre de posologies usuelles
#define MAX_BIOLOGIES35				20		// Nombre d"lments de formulaire (3.5)
#define MAX_ITEMS					255		// Nombre d'entres dans les listes
#define MAX_PHARMACIES				6		// Nombre de pharmacies gres
#define MAX_CHOICES					40		// Nombre de chox dans les listes formulaire
#define MAX_MRUDOSSIERS				24		// Nombre de patients mmoriss
#define MAX_TOOLS					16		// Nombre de programmes exterieurs
#define MAX_DIC						16		// Nombre de dictionnaires dans le menu
#define MAX_FORM_ROWS				255		// Nombre max de lignes dans un formulaire
#define MAX_MEDICAMENTS				32		// Nombre max de mdicaments dans une prescription
#define MAX_INTERACTIONS			64		// Nombre max d'interactions dans une prescription
#define	MAX_ECRAUTO					400		// Nombre d'critures automatiques max


// Tailles
//////////////////////////////////////////////////////////////////////
#define SIZE_USER					16		// Taille de l'identifcateur de l'utilisateur
#define SIZE_CODE					8		// Taille d'un code
#define SIZE_NAME					20		// Taille d'un nom
#define	SIZE_VACCIN					128		// Taille du texte vaccins
#define SIZE_PHONE					12		// Taille d'un numro de tlphone
#define SIZE_FORMTITLE				40		// Taille du titre d'un formulaire
//#ifdef IMS_VERSION
#define	SIZE_DFCC					7		// Taille d'un code DFCC
#define	SIZE_CIM9					6		// Taille d'un code CIM9
#define	SIZE_CIM10					6		// Taille d'un code CIM10
#define	SIZE_CISP					3		// Taille d'un code CISP
//#endif	// IMS_VERSION
#define SIZE_CODE					8		// Taille d'un code
#define	SIZE_CPT					10		// Taille d'un numro de compte
#define	SIZE_FICHE					5		// Taille d'un numro de fiche
#define	SIZE_DATE					8		// Taille d'une date
#define	SIZE_TIME					6		// Taille d'une heure
#define	SIZE_YEAR					4		// Taille d'une anne
#define	SIZE_RUB					3		// Taille d'une rubrique
#define	SIZE_MVT					10		// Taille de l'identifiant d'un mouvement
#define	SIZE_IMMO					10		// Taille de l'identifiant d'une immobilisation
#define	SIZE_LINE					10		// Taille d'une ligne
#define	SIZE_MVTJLINE				10		// Taille d'un numro de ligne du journal
#define	SIZE_KLIB					20		// Taille d'un libelle dans une cl
#define	SIZE_LIB					80		// Taille d'un libelle
#define SIZE_CALC					128		// Taille d'une ligne de calcul
#define	SIZE_CPTTYPE				1		// Taille d'un type de compte
#define	SIZE_PLANTYPE				1		// Taille d'un type de plan
#define	SIZE_RUBTYPE				1		// Taille d'un type de rubrique
#define	SIZE_LINETYPE				1		// Taille d'un type de plan
#define	SIZE_MVTTYPE				1		// Taille d'un type de mouvement
#define	SIZE_RUBLINE				3		// Taille d'un numro de ligne d'une rubrique
#define	SIZE_IDX					sizeof (HDFILEPOS)	// Taille d'un index
#define	SIZE_BOOL					1		// Taille d'un booleen

// Jours de la semaine
//////////////////////////////////////////////////////////////////////
#define DAY_DIMANCHE				0
#define DAY_LUNDI					1
#define DAY_MARDI					2
#define DAY_MERCREDI				3
#define DAY_JEUDI					4
#define DAY_VENDREDI				5
#define DAY_SAMEDI					6

//  Pharmacies
//////////////////////////////////////////////////////////////////////
#define	PHARMACIE_PERSO				0	// Pharmacie personnelle
#define PHARMACIE_DSI				1	// Donnes Scientifiques et Informatiques OVP-Vidal
#define PHARMACIE_VIDAL				2	// CD-ROM Vidal
#define PHARMACIE_SEMP				3	// Base de donnes SEMP
#define	PHARMACIE_MEDIAVIDAL		4	// MEDIA VIDAL
#define	PHARMACIE_HOMEO				5	// Base homopathique

// Type de libell de pharmacie
//////////////////////////////////////////////////////////////////////
#define	PHARMKEY_ALL				0	// Tous
#define	PHARMKEY_MEDICAMENT			1	// Libell de mdicament
#define	PHARMKEY_SUBSTANCE			2	// Libell de substance
#define	PHARMKEY_LABO				3	// Libell de laboratoire

// Identificateurs d'un lment de dossier patient (au sens large)
// A utiliser pour la RMC ou autre...
//////////////////////////////////////////////////////////////////////
#define PATIENT_ETATCIVIL			0
#define PATIENT_ANTECEDENTS			1
#define PATIENT_NOTES				2
#define PATIENT_NOTEBITMAPS			3
#define PATIENT_PHOTO				4

#define PATIENT_CONSULTATIONS		10
#define PATIENT_VACCINS				11
#define PATIENT_BIOLOGIES			12
#define PATIENT_COURRIERS			13
#define PATIENT_ORDONNANCES			14
#define PATIENT_RECETTES			15
#define PATIENT_BITMAPS				16
#define PATIENT_INFOSESAM			17
#define PATIENT_RENDEZVOUS			18
#define PATIENT_FSE					19
#define PATIENT_PIECESJOINTES		20
#define PATIENT_TRAITEMENTS			21
#define PATIENT_COMPTERENDUS		22

// Dossiers patients
//////////////////////////////////////////////////////////////////////
#define DOSSIERS_ANTECEDENTS		0
#define DOSSIERS_NOTES				1
#define DOSSIERS_CONSULTATIONS		2
#define DOSSIERS_VACCINS			3
#define DOSSIERS_BIOLOGIES35		4		// Formulaire version 3.5
#define DOSSIERS_BIOLOGIES			5		// Formulaire ou Texte
#define DOSSIERS_COURRIERS			6
#define DOSSIERS_ORDONNANCES		7
#define DOSSIERS_RECETTES			8
#define DOSSIERS_BITMAPS			9
#define DOSSIERS_INFOSESAM			10		// Infos pour Sesam-Vitale
#define DOSSIERS_PIECESJOINTES		11
#define DOSSIERS_TRAITEMENTS		12
#define DOSSIERS_COMPTERENDUS		13
#define DOSSIERS_SITFACTTLA			14		// Infos pour TLA

// Antecedents
//////////////////////////////////////////////////////////////////////
#define TOKEN_ANTECEDENT			'#'
#define TOKEN_ALLERGIE				'A'
#define TOKEN_INTOLERANCE			'I'
#define TOKEN_CHIRURGIE				'C'
#define TOKEN_MEDICAL				'M'
#define TOKEN_OBSTETRIE				'O'
#define TOKEN_GYNECOLOGIE			'G'
#define TOKEN_FAMILLIAL				'F'

#define ALARME_ALLERGIE				0x01
#define ALARME_INTOLERANCE			0x02
#define ALARME_CHIRURGIE			0x04
#define ALARME_MEDICAL				0x08
#define ALARME_OBSTETRIE			0x10
#define ALARME_GYNECOLOGIE			0x20
#define ALARME_FAMILLIAL			0x40

// Type d'un enregistrement vaccin (Vaccins, Examens, etc)
//////////////////////////////////////////////////////////////////////
#define VACCIN_VACCIN				0
#define VACCIN_EXAMEN				1

// Token d'identification des textes dans les dossiers
//////////////////////////////////////////////////////////////////////
#define TOKEN_TEXT					"#TEXT"
#define TOKEN_RTF					"#RTF"
#define TOKEN_FORM					"#FORM"
#define TOKEN_CODE					"#CODE"

// Types des Consultations
//////////////////////////////////////////////////////////////////////
#define CONSULTATION_TEXT			0
#define CONSULTATION_FORM			1

// Types des Biologies
//////////////////////////////////////////////////////////////////////
#define BIOLOGIE_TEXT				0
#define BIOLOGIE_FORM				1
#define BIOLOGIE_FORM35				2

// Types d'image
//////////////////////////////////////////////////////////////////////
#define BITMAP_IDENTITE				0
#define BITMAP_SCHEMA				1
#define BITMAP_RADIO				2
#define BITMAP_ECHO					3
#define BITMAP_NOTE					4

// Format des images
//////////////////////////////////////////////////////////////////////
#define PICTURE_DIB					0
#define PICTURE_GIF					1
#define PICTURE_PCX					2
#define PICTURE_JPEG				3
#define PICTURE_TIFF				4
#define PICTURE_AWD					5

// Compressions des bitmaps
//////////////////////////////////////////////////////////////////////
#define BMP_ZIP						0	// Image  compresser
#define BMP_NOZIP					1	// Image  ne pas compresser
#define BMP_ZIPPED					2	// Image dj compresse

// Compressions des pices jointes
//////////////////////////////////////////////////////////////////////
#define PIECEJOINTE_ZIP				0	// Pice jointe  compresser
#define PIECEJOINTE_NOZIP			1	// Pice jointe  ne pas compresser
#define PIECEJOINTE_ZIPPED			2	// Pice jointe dj compresse

// Attributs
//////////////////////////////////////////////////////////////////////
#define ATTRIBUT_NORMAL				0
#define ATTRIBUT_ITALIC				1
#define ATTRIBUT_BOLD				2
#define ATTRIBUT_UNDERLINE			4
#define ATTRIBUT_STRIKEOUT			8

#define ATTRIBUT_ITALICBOLD			(ATTRIBUT_ITALIC | ATTRIBUT_BOLD)

//	TOKEN Dictionnaires
//////////////////////////////////////////////////////////////////////
#define TOKEN_TITLE					'@'
#define TOKEN_LINE					'='
#define TOKEN_DICIN					'['
#define TOKEN_DICOUT				']'
#define TOKEN_PAGEIN				'{'
#define TOKEN_PAGEOUT				'}'

// Direction des messages MAIL
//////////////////////////////////////////////////////////////////////
#define MSG_IN						0	// Message reu
#define MSG_OUT						1	// Message envoy
#define MSG_XFR						2	// Message transfr

// Type des messages MAIL (INBOX)
//////////////////////////////////////////////////////////////////////
#define MSG_MESSAGE					0	// Message quelconque
#define MSG_EMAIL					1	// Message d'un autre utilisateur
#define	MSG_HPRIM					2	// Rception biologie
#define MSG_AGENDA					3	// Alarme Agenda
#define MSG_VACCINATION				4	// Alarme Agenda : rappel de vaccination
#define MSG_VISITE					5	// Alarme Agenda : visite

// Gestion du cot (pharmacie)
//////////////////////////////////////////////////////////////////////
#define	COUT_ERR_OK			0x00000000		// Pas d'erreur
#define	COUT_ERR_PRICE		0x00000001		// Prix non renseign
#define	COUT_ERR_UNIT		0x00000002		// Nombre d'unit de prise non renseign
#define	COUT_ERR_INFOPOSO	0x00000004		// Pas d'information de posologie

// Types des mots cls (recherche multicritres)
//////////////////////////////////////////////////////////////////////
#define KEYWORD_ANTECEDENTS		0
#define KEYWORD_NOTES			1
#define KEYWORD_CONSULTATIONS	2
#define KEYWORD_VACCINS			3
#define KEYWORD_BIOLOGIES35		4
#define KEYWORD_BIOLOGIES		5
#define KEYWORD_COURRIERS		6
#define KEYWORD_ORDONNANCES		7
#define KEYWORD_RECETTES		8
#define KEYWORD_ETATCIVIL		9
#define KEYWORD_BITMAPS			10

// Format de text
//////////////////////////////////////////////////////////////////////
#define	TEXT_ANSI				0
#define	TEXT_RTF				1
#define	TEXT_FORM				2

// Modes de paiement
//////////////////////////////////////////////////////////////////////
enum
{
	PAIEMENT_BANQUE = 1,
	PAIEMENT_CB,
	PAIEMENT_CCP,
	PAIEMENT_CHEQUE
} ;

// Tiers des paiements
//////////////////////////////////////////////////////////////////////
#ifdef MULTITIERS_VERSION
#define P_TIERS_AMO			1	// 00000001 : paiement par tiers AMO
#define P_TIERS_AMC			2	// 00000010 : paiement par tiers AMC
#define P_PATIENT			4	// 00000100 : paiement par patient
#endif // MULTITIERS_VERSION

// Type de rubriques
//////////////////////////////////////////////////////////////////////
#define RUB_RECETTE			0
#define RUB_DEPENSE			1
#define RUB_RESULTAT		2
#define RUB_TVA				3
#define RUB_OPERDIV			4

// Type de mouvement
//////////////////////////////////////////////////////////////////////
#define	MVT_UNKNOWN			0			//
#define	MVT_RECETTE			1			// Ecriture de recette
#define	MVT_DEPENSE			2			// Ecriture de depense
#define	MVT_OD				3			// Opration Diverse
#define	MVT_RECETTEFSE		4			// Recette FSE
#define	MVT_TEST			9			// Gestion version dmo

// Mode d'edition du mouvement
//////////////////////////////////////////////////////////////////////
#define	MODE_UNKNOWN		0			//
#define	MODE_ECRSTANDARD	1			// Edition sous forme d'criture standard
#define	MODE_ECRSIMPLE		2			// Edition sous forme d'criture simplifie

// Application source d'un mouvement
//////////////////////////////////////////////////////////////////////
#define APPSRC_HELLODOC		0			// Gamme HelloDOC
#define APPSRC_HDES			1			// Gamme HelloDOC Edition Spciale
#define APPSRC_CPTLIB		2			// Gamme Compta Librale
#define	APPSRC_HELLOSANTE	3			// Gamme HelloSant

// Type de compte
//////////////////////////////////////////////////////////////////////
#define CPT_TRESOR			0			// Compte de trsorerie
#define CPT_RECETTE			1			// Compte de recette
#define CPT_DEPENSE			2			// Compte de dpense
#define CPT_TVA				3			// Compte de TVA
#define CPT_AUTRECPT		4			// Autre compte
#define CPT_TOUSCPT		    9			// Tous

// Modes de paiements
//////////////////////////////////////////////////////////////////////
#define	PAIEMENT_CHEQUE		0			// Paiement par chque
#define	PAIEMENT_VIREMENT	1			// Virement

// Taux de conversion euro par dfaut
//////////////////////////////////////////////////////////////////////
#define	TAUXCONV_DEFAULT	6.55957

// Priodicit des ecritures automatiques
//////////////////////////////////////////////////////////////////////
#define	PER_UNKNOWN			0			//
#define	PER_UNIQUE			1			// Unique
#define	PER_SEMAINE			2			// Semaine
#define	PER_2SEMAINES		3			// Deux semaines
#define	PER_2PARMOIS		4			// Deux fois / mois
#define	PER_4SEMAINES		5			// Quatre semaines
#define	PER_MENSUELLE		6			// Mensuelle
#define	PER_2MOIS			7			// Deux mois
#define	PER_TRIMESTRIELLE	8			// Trimestrielle
#define	PER_BIANNUELLE		9			// Bi-annelle

// Type de taux d'immobilisation
//////////////////////////////////////////////////////////////////////
#define	TAUX_LINEAIRE		0			// Taux lineaire
#define	TAUX_DEGRESSIF		1			// Taux degressif
#define	TAUX_EXCEPTIONNEL	2			// Taux exceptionnel

// Mode d'immobilisation
//////////////////////////////////////////////////////////////////////
#define	IMMO_DUREE			0			// Saisie en dure
#define	IMMO_TAUX			1			// Saisie en taux

// Libell d'une criture de recette
//////////////////////////////////////////////////////////////////////
#define LIBREC_ACTE			0			// Nom de l'acte
#define LIBREC_NOM			1			// Nom du patient
#define LIBREC_PAYEUR		2			// Nom du payeur
#define LIBREC_TIERS		3			// Nom du tiers
#define LIBREC_BANQUE		4			// Nom de la banque
#define LIBREC_CHEQUE		5			// Numro du chque
#define LIBREC_COMPTE		6			// Numro du compte

// Type de procdure
//////////////////////////////////////////////////////////////////////
#define PROC_CONVERT_PLAN		1			// Conversion du fichier plan
#define PROC_CONVERT_BANQUES	2			// Conversion du fichier banque
#define PROC_CONVERT_JOURNAL	4			// Conversion du fichier journal
#define PROC_CONVERT_RUBRIQUES	5			// Conversion du fichier journal
#define PROC_CONVERT_TEXTES		6			// Conversion du fichier textes
#define PROC_CONVERT_IMMO		7			// Conversion des immobilisations et amortissements
#define PROC_CONVERT_ECRAUTO	8			// Conversion des critures automatiques
#define PROC_CONVERT_REQUEST	9			// Demande de conversion
#define PROC_CALCUL				10			// Recalcul
#define PROC_CREATE_EXERCICE	11			// Cration d'un exercice
#define PROC_CREATE_COMPTE		12			// Cration d'un compte
#define PROC_CREATE_LIEN		13			// Cration d'un lien entre HelloDOC et la Compta Lib
#define PROC_UPDATE_JOURNAL		14			// Modification des journaux

// Traitement en cours
//////////////////////////////////////////////////////////////////////
#define WORK_START				1		// Dbut du traitement
#define WORK_END				2		// Fin de traitement
#define WORK_TEXT				3		// Texte correspondant au traitement
#define WORK_RANGE				4		// Nombre d'lments  traiter
#define	WORK_POS				5		// Position du traitement
#define	WORK_ERR				6		// Message d'erreur
#define	WORK_MSG				7		// Message
#define	WORK_CREATE_EXERCICE	8		// Demande de cration d'exercice
#define	WORK_CREATE_COMPTE		9		// Demande de cration d'un compte
#define	WORK_CREATE_ACTES		10		// Demande de cration d'un code des actes
#define	WORK_CREATE_PAIES		11		// Demande de cration d'un mode de paiement
#define	WORK_CREATE_FRAIS		12		// Demande de cration d'un code de dpense
#define	WORK_CREATE_BANKS		13		// Demande de cration d'un code banques
#define	WORK_UPDATE_RECETTES	14		// Modification du journal des recettes
#define	WORK_UPDATE_DEPENSES	15		// Modification du journal des dpenses

// Creation exercice flag
//////////////////////////////////////////////////////////////////////
#define	WORKFLAG_ADD			1		// Ajout
#define	WORKFLAG_UPDATE			2		// Mise  jour
#define	WORKFLAG_DEL			3		// Suppression

// Creation actes/paies/frais/banks flag
//////////////////////////////////////////////////////////////////////
#define	WORKFLAG_CODENOTFOUND	1		// Code introuvable
#define	WORKFLAG_COMPTENOTFOUND	2		// Compte introuvable

// Rang gmellaire
//////////////////////////////////////////////////////////////////////
#define	RANG_GEMELLAIRE_UNKNOWN	0		//
#define	RANG_GEMELLAIRE_1		1		// (sans jumeau) ou Premier jumeau, tripl ou plus
#define	RANG_GEMELLAIRE_2		2		// Deuxime jumeau, tripl ou plus
#define	RANG_GEMELLAIRE_3		3		// Troisime tripl, quadrupl ou plus
#define	RANG_GEMELLAIRE_4		4		// Quatrime quadrupl, quintupl ou plus
#define	RANG_GEMELLAIRE_5		5		// Cinquime quintupl, sextupl ou plus
#define	RANG_GEMELLAIRE_6		6		// Sixime sextupl ou plus
#define	RANG_GEMELLAIRE_7		7		// Septime septupl ou plus
#define	RANG_GEMELLAIRE_8		8		// Huitime octupl ou plus
#define	RANG_GEMELLAIRE_9		9		// Neuvime <<jumeau>>


//////////////////////////////////////////////////////////////////////
//
//	Lecture du numro de version de la DLL
//
//////////////////////////////////////////////////////////////////////
API_EXPORT DWORD HDAPI		HDApiVersion			() ;

//////////////////////////////////////////////////////////////////////
//
//	Lecture d'un nom de fichier
//
//////////////////////////////////////////////////////////////////////
API_EXPORT LPSTR HDAPI		HDGetFilename			(UINT uID, LPSTR lpFilename) ;

//////////////////////////////////////////////////////////////////////
//
//	REGISTRY
//
//////////////////////////////////////////////////////////////////////
API_EXPORT void HDAPI		HDSetPathRegistry		(LPCSTR lpPath) ;
API_EXPORT LPSTR HDAPI		HDGetPathRegistry		(LPSTR lpPath, int nLen) ;

API_EXPORT BOOL HDAPI		HDGetApplicationInfo	(LPCSTR lpSection, LPCSTR lpEntry, LPSTR lpValue) ;
API_EXPORT BOOL HDAPI		HDGetApplicationInfoInt	(LPCSTR lpSection, LPCSTR lpEntry, LPINT lpnValue) ;
API_EXPORT BOOL HDAPI		HDSetApplicationInfo	(LPCSTR lpSection, LPCSTR lpEntry, LPCSTR lpValue) ;
API_EXPORT BOOL HDAPI		HDSetApplicationInfoInt	(LPCSTR lpSection, LPCSTR lpEntry, int nValue) ;

//////////////////////////////////////////////////////////////////////
//
//	Gestion de Callback
//
//////////////////////////////////////////////////////////////////////
API_EXPORT WORKPROC HDAPI	HDSetCallback			(WORKPROC lpWorkProc /*= NULL*/) ;

//////////////////////////////////////////////////////////////////////
//
//	CABINET
//
//////////////////////////////////////////////////////////////////////
API_EXPORT void HDAPI		HDSetPathProgrammes		(LPCSTR lpPath) ;
API_EXPORT LPSTR HDAPI		HDGetPathProgrammes		(LPSTR lpPath, int nLen) ;
API_EXPORT void HDAPI		HDSetPathCabinet		(LPCSTR lpPath) ;
API_EXPORT LPSTR HDAPI		HDGetPathCabinet		(LPSTR lpPath, int nLen) ;
API_EXPORT void HDAPI		HDSetNomCabinet			(LPCSTR lpCabinet) ;
API_EXPORT LPSTR HDAPI		HDGetNomCabinet			(LPSTR lpCabinet, int nLen) ;
API_EXPORT void HDAPI		HDSetUserCabinet		(LPCSTR lpUser) ;
API_EXPORT LPSTR HDAPI		HDGetUserCabinet		(LPSTR lpUser, int nLen) ;
API_EXPORT BOOL HDAPI		HDOpenCabinet			(LPCSTR lpPath, LPCSTR lpCabinet, LPCSTR lpUser, LPCSTR lpPassword) ;
API_EXPORT void HDAPI		HDCloseCabinet			() ;
API_EXPORT int HDAPI		HDOpenCabinetDlg		(HWND hWnd, LPSTR lpPath, LPSTR lpCabinet, LPSTR lpUser, LPSTR lpPassword) ;
//#ifdef EURO_VERSION
API_EXPORT void HDAPI		HDSetCurrentMonnaie		(BOOL bEuro) ;
API_EXPORT BOOL	HDAPI		HDGetCurrentMonnaie		() ;
//#endif	// EURO_VERSION

//////////////////////////////////////////////////////////////////////
//
//	COMPTA
//
//////////////////////////////////////////////////////////////////////

//  Statistiques
//////////////////////////////////////////////////////////////////
typedef struct
{
	LONG	lRecette ;					// Nombre d'critures de RECETTE
	LONG	lDepense ;					// Nombre d'critures de DEPENSE
	LONG	lOperDiv ;					// Nombre d'critures de DEPENSE
	double	dValueFranc ;				// Montant T.T.C. en franc
	double	dTaxeFranc ;				// Montant de taxe en franc
	double	dPersoFranc ;				// Montant personnel en franc
	double	dValueEuro ;				// Montant T.T.C. en euro
	double	dTaxeEuro ;					// Montant de taxe en euro
	double	dPersoEuro ;				// Montant personnel en euro
	LONG	lRapp ;						// Rapprochement
	LONG	lMark ;						// Pointage
	LONG	lRemis ;					// Remis en banque
	LONG	lValid ;					// Valides
	LONG	lNoRapp ;					// Lignes non rapproches
} ECRSTAT, FAR* LPECRSTAT ;


//  Gestion
//////////////////////////////////////////////////////////////////

API_EXPORT BOOL HDAPI		HDIsComptaPassword		(LPCSTR lpPathComptaINI) ;
API_EXPORT BOOL HDAPI		HDSetComptaPassword		(LPCSTR lpPathComptaINI, LPCSTR lpOldPassword, LPCSTR lpNewPassword) ;
API_EXPORT BOOL HDAPI		HDSetPathComptaINI		(LPCSTR lpPathComptaINI) ;
API_EXPORT BOOL HDAPI		HDGetPathComptaINI		(LPSTR lpPathComptaINI, int nLen) ;
API_EXPORT BOOL HDAPI		HDIsWithHelloDOC		() ;
API_EXPORT BOOL HDAPI		HDSetWithHelloDOC		(BOOL bWith, USHORT uGamme) ;
API_EXPORT BOOL HDAPI		HDOpenCompta			(LPCSTR lpPathComptaINI, LPCSTR lpPassword /*= NULL*/) ;
API_EXPORT void HDAPI		HDCloseCompta			() ;
API_EXPORT LPSTR HDAPI		HDGetExercice			(LPSTR lpExercice, int nLen) ;
API_EXPORT BOOL HDAPI		HDOpenExercice			(LPCSTR lpExercice) ;
API_EXPORT void HDAPI		HDCloseExercice			() ;
API_EXPORT BOOL HDAPI		HDDeleteExercice		(LPCSTR lpExercice) ;
API_EXPORT BOOL HDAPI		HDIsExerciceExist		(LPCSTR lpSearchPath, LPCSTR lpExercice) ;

API_EXPORT BOOL HDAPI		HDConvertCompta			(LPCSTR lpExercice) ;
API_EXPORT BOOL	HDAPI		HDCalculCompta			(LPCSTR lpExercice, LPECRSTAT pEcrStat /*= NULL*/) ;
API_EXPORT BOOL HDAPI		HDCreateExercice		(LPCSTR lpExercice, HDDATE Debut, HDDATE Fin, BOOL bEuro, BOOL bTVA) ;



//////////////////////////////////////////////////////////////////////
//
//  Fonctions date et heure
//
//////////////////////////////////////////////////////////////////////

//  Format des dates
//////////////////////////////////////////////////////////////////////
// Anne : bit 16  31
//  Mois : bit 8  15
//  Jour : bit 0  7

//  Format des heures
//////////////////////////////////////////////////////////////////////
//  Heures : bit 16  bit 31
// Minutes : bit 8  15
// Seconde : bit 0  7

//  Macros
//////////////////////////////////////////////////////////////////////
#define DAY(Date)						((int) (Date & (HDDATE) 0xFF))
#define MONTH(Date)						((int) ((Date >> 8) & (HDDATE) 0xFF))
#define YEAR(Date)						((int) ((Date >> 16) & (HDDATE) 0xFFFF))
#define MAKEDATE(Day,Month,Year)		((((HDDATE) Year) << 16) + (((HDDATE) Month) << 8) + (HDDATE) Day)
#define ISBISSEXTILE(Date)				((YEAR (Date) % 4) == 0)
#define SECONDE(Time)					((int) Time & 0xFF)
#define MINUTE(Time)					((int) (Time >> 8) & 0xFF)
#define HOUR(Time)						((int) (Time >> 16) & 0xFFFF)
#define MAKETIME(Hour,Minute,Seconde)	((((HDTIME) Hour) << 16) + (((HDTIME) Minute) << 8) + (HDTIME) Seconde)

// Heures
//////////////////////////////////////////////////////////////////////
API_EXPORT void HDAPI	InitTime						() ;
API_EXPORT LPSTR HDAPI	StrTime							(HDTIME Time) ;
API_EXPORT LPSTR HDAPI	StrSTime						(HDTIME Time) ;
API_EXPORT LPSTR HDAPI	StrHHMM							(HDTIME Time) ;
API_EXPORT LPSTR HDAPI	StrMMSS							(HDTIME Time) ;
API_EXPORT HDTIME HDAPI	GetTime							(LPCSTR lpszTime) ;
API_EXPORT HDTIME HDAPI	Now								() ;
API_EXPORT HDTIME HDAPI	NextHour						(HDTIME Time) ;
API_EXPORT HDTIME HDAPI	NextQuarter						(HDTIME Time) ;
API_EXPORT HDTIME HDAPI	NextMinute						(HDTIME Time) ;
API_EXPORT HDTIME HDAPI	NextSeconde						(HDTIME Time) ;
API_EXPORT HDTIME HDAPI	PrevHour						(HDTIME Time) ;
API_EXPORT HDTIME HDAPI	PrevQuarter						(HDTIME Time) ;
API_EXPORT HDTIME HDAPI	PrevMinute						(HDTIME Time) ;
API_EXPORT HDTIME HDAPI	PrevSeconde						(HDTIME Time) ;

// Date
//////////////////////////////////////////////////////////////////////
API_EXPORT void HDAPI	InitDate						() ;
API_EXPORT HDDATE HDAPI	Today							() ;
API_EXPORT int HDAPI	GetNbJours						(HDDATE Date) ;
API_EXPORT HDDATE HDAPI	NextDate						(HDDATE Date) ;
API_EXPORT HDDATE HDAPI	PrevDate						(HDDATE Date) ;
API_EXPORT HDDATE HDAPI	NextWeek						(HDDATE Date) ;
API_EXPORT HDDATE HDAPI	PrevWeek						(HDDATE Date) ;
API_EXPORT HDDATE HDAPI	NextMonth						(HDDATE Date) ;
API_EXPORT HDDATE HDAPI	PrevMonth						(HDDATE Date) ;
API_EXPORT int HDAPI	GetWeekNumber					(HDDATE Date) ;
API_EXPORT int HDAPI	DayOfWeek						(HDDATE Date) ;
API_EXPORT void HDAPI	GetWeek							(HDDATE Date, HDDATE* pdateBegin, HDDATE* pdateEnd) ;
API_EXPORT void HDAPI	GetMonth						(HDDATE Date, HDDATE* pdateBegin, HDDATE* pdateEnd) ;
API_EXPORT void HDAPI	GetQuarter						(HDDATE Date, HDDATE* pdateBegin, HDDATE* pdateEnd) ;
API_EXPORT int HDAPI	GetPeriodeJours					(HDDATE DateStart, HDDATE DateEnd) ;
API_EXPORT int HDAPI	GetPeriodeMois					(HDDATE DateStart, HDDATE DateEnd) ;
API_EXPORT LPSTR HDAPI	StrDate							(HDDATE Date) ;
API_EXPORT LPSTR HDAPI	StrDay							(HDDATE Date) ;
API_EXPORT LPSTR HDAPI	StrMonth						(HDDATE Date) ;
API_EXPORT LPSTR HDAPI	StrSDate						(HDDATE Date) ;
API_EXPORT LPSTR HDAPI	StrLDate						(HDDATE Date) ;
API_EXPORT LPSTR HDAPI	StrJJMM							(HDDATE Date) ;
API_EXPORT BOOL HDAPI	IsDateOk						(HDDATE Date) ;
API_EXPORT void HDAPI	GetJJMMAA						(LPCSTR lpszDate, int* pnDay, int* pnMonth, int* pnYear) ;
API_EXPORT HDDATE HDAPI	GetDate							(LPCSTR lpszDate) ;
API_EXPORT HDDATE HDAPI	GetDateNotFormated				(LPCSTR lpszDate) ;
API_EXPORT HDDATE HDAPI	GetSDate						(LPSTR lpszDate) ;
API_EXPORT HDDATE HDAPI	GetAge							(HDDATE dateNaissance, HDDATE dateDeces) ;
API_EXPORT LPSTR HDAPI	StrAge							(HDDATE dateNaissance, HDDATE dateDeces, char cSexe) ;

API_EXPORT char HDAPI	GetDateSeparator				() ;
API_EXPORT char HDAPI	GetTimeSeparator				() ;


//////////////////////////////////////////////////////////////////////
//
//  Fonctions d'accs aux fichiers bas niveau
//
//////////////////////////////////////////////////////////////////////

// Types d'ouvertures
//////////////////////////////////////////////////////////////////////
#define		HD_READ_ACCESS		GENERIC_READ
#define		HD_WRITE_ACCESS		GENERIC_WRITE
#define		HD_READWRITE_ACCESS	(GENERIC_READ | GENERIC_WRITE)

// Codes d'erreur en ouverture
//////////////////////////////////////////////////////////////////////
#define		HD_CREAT_ERROR		INVALID_HANDLE_VALUE
#define		HD_OPEN_ERROR		INVALID_HANDLE_VALUE

// Codes d'erreur en lecture / ecritures
//////////////////////////////////////////////////////////////////////
#define		HD_SIZE_ERROR		INVALID_FILE_SIZE	// HDGetFileSize
#define		HD_SEEK_ERROR		INVALID_FILE_SIZE	// HDSeekFile
#define		HD_WRITE_ERROR		INVALID_FILE_SIZE	// HDWriteFile
#define		HD_READ_ERROR		INVALID_FILE_SIZE	// HDReadFile

// Codes de dplacement pour HDSeekFile
//////////////////////////////////////////////////////////////////////
#define		HD_SEEK_SET			FILE_BEGIN			// Dbut du fichier
#define		HD_SEEK_CUR			FILE_CURRENT		// Position courante
#define		HD_SEEK_END			FILE_END			// Fin du fichier

// Prototypes
//////////////////////////////////////////////////////////////////////
API_EXPORT HANDLE HDAPI			HDCreateFile		(LPCTSTR lpFileName) ;
API_EXPORT HANDLE HDAPI			HDOpenFile			(LPCTSTR lpFileName, DWORD dwAccess) ;
API_EXPORT BOOL HDAPI			HDExistFile			(LPCTSTR lpFileName) ;
API_EXPORT BOOL HDAPI			HDCloseFile			(HANDLE hFile) ;

API_EXPORT DWORD HDAPI			HDWriteFile			(HANDLE hFile, LPCVOID lpBuffer, DWORD nNumberOfBytesToWrite) ;
API_EXPORT DWORD HDAPI			HDReadFile			(HANDLE hFile, LPVOID lpBuffer, DWORD nNumberOfBytesToRead) ;
API_EXPORT DWORD HDAPI			HDSeekFile			(HANDLE hFile, LONG lPosition, DWORD dwMethod) ;
API_EXPORT DWORD HDAPI			HDGetFileSize		(HANDLE hFile) ;

API_EXPORT BOOL HDAPI			HDDeleteFile		(LPCTSTR lpFileName) ;
API_EXPORT BOOL HDAPI			HDCopyFile			(LPCTSTR lpExistingFileName, LPCTSTR lpNewFileName) ;
API_EXPORT BOOL HDAPI			HDMoveFile			(LPCTSTR lpExistingFileName, LPCTSTR lpNewFileName) ;
API_EXPORT BOOL HDAPI			HDRenameFile		(LPCTSTR lpExistingFileName, LPCTSTR lpNewFileName) ;

API_EXPORT BOOL HDAPI			HDLockFile			(HANDLE hFile, DWORD dwFileOffset, DWORD nNumberOfBytesToLock) ;
API_EXPORT BOOL HDAPI			HDUnlockFile		(HANDLE hFile, DWORD dwFileOffset, DWORD nNumberOfBytesToLock) ;

API_EXPORT BOOL HDAPI			HDIsLockFileOK		() ;

API_EXPORT BOOL HDAPI			HDGetFileTime		(LPCSTR lpFileName, FILETIME* lpFileTime) ;

//////////////////////////////////////////////////////////////////////
//
//  Fonctions d'accs aux fichier du squentiel-index
//
//////////////////////////////////////////////////////////////////////

// Indicateur de cls dupliques
//////////////////////////////////////////////////////////////////////
#define DUP_KEY					TRUE
#define NODUP_KEY				FALSE

// Prototypes
//////////////////////////////////////////////////////////////////////
API_EXPORT BOOL HDAPI			HDOpenSession		(BOOL bNetwork) ;
API_EXPORT void HDAPI			HDCloseSession		() ;
API_EXPORT BOOL HDAPI			HDNewDat			(HDFILE hFile, LPCSTR lpFileName, short nRecLen) ;
API_EXPORT BOOL HDAPI			HDNewIdx			(HDFILE hFile, LPCSTR lpFileName, short nKeyLen, BOOL bKeyDup, short nMemb) ;
API_EXPORT BOOL HDAPI			HDNewIdxEx			(HDFILE hFile, LPCSTR lpFileName, short nKeyLen, short nKeyType, BOOL bKeyDup, short nMemb, short nExtdSize) ;
API_EXPORT BOOL HDAPI			HDAddIdx			(HDFILE hFile, short nKeyLen, BOOL bKeyDup, short nMemb) ;
API_EXPORT BOOL HDAPI			HDAddIdxEx			(HDFILE hFile, short nKeyLen, short nKeyType, BOOL bKeyDup, short nMemb) ;
API_EXPORT BOOL HDAPI			HDOpen				(HDFILE hFile, LPCSTR lpFileName) ;
API_EXPORT void HDAPI			HDClose				(HDFILE hFile) ;
API_EXPORT DWORD HDAPI			HDNumberOfKey		(HDFILE hFile) ;
API_EXPORT HDFILEPOS HDAPI		HDFirstKey			(HDFILE hFile, LPSTR lpKey) ;
API_EXPORT HDFILEPOS HDAPI		HDLastKey			(HDFILE hFile, LPSTR lpKey) ;
API_EXPORT HDFILEPOS HDAPI		HDNextKey			(HDFILE hFile, LPSTR lpKey) ;
API_EXPORT HDFILEPOS HDAPI		HDPrevKey			(HDFILE hFile, LPSTR lpKey) ;
API_EXPORT HDFILEPOS HDAPI		HDFindKey			(HDFILE hFile, LPCSTR lpKey) ;
API_EXPORT HDFILEPOS HDAPI		HDBrowseKey			(HDFILE hFile, LPSTR lpKey) ;
API_EXPORT BOOL HDAPI			HDAddKey			(HDFILE hFile, LPCSTR lpKey, HDFILEPOS Idx) ;
API_EXPORT BOOL HDAPI			HDDelKey			(HDFILE hFile, LPCSTR lpKey) ;
API_EXPORT BOOL HDAPI			HDDelDupKey			(HDFILE hFile, LPCSTR lpKey, HDFILEPOS Idx) ;
API_EXPORT DWORD HDAPI			HDGetKeySize		(HDFILE hFile) ;
API_EXPORT DWORD HDAPI			HDGetRecSize		(HDFILE hFile) ;
API_EXPORT DWORD HDAPI			HDNumberOfRec		(HDFILE hFile) ;
API_EXPORT BOOL HDAPI			HDReadRec			(HDFILE hFile, HDFILEPOS Idx, LPSTR lpBuffer) ;
API_EXPORT HDFILEPOS HDAPI		HDAddRec			(HDFILE hFile, LPSTR lpBuffer) ;
API_EXPORT BOOL HDAPI			HDWriteRec			(HDFILE hFile, HDFILEPOS Idx, LPSTR lpBuffer) ;
API_EXPORT BOOL HDAPI			HDDelRec			(HDFILE hFile, HDFILEPOS Idx) ;
API_EXPORT HDFILEPOS HDAPI		HDGetFirstRecPos	(short nRecLen) ;
API_EXPORT short HDAPI			HDLockRec			(HDFILE nFile, HDFILEPOS Idx) ;
API_EXPORT short HDAPI			HDUnlockRec			(HDFILE nFile, HDFILEPOS Idx) ;
API_EXPORT int HDAPI			HDFileErrorCode		() ;
API_EXPORT void HDAPI			HDFileError			(LPCSTR lpFormat, ...) ;
API_EXPORT void HDAPI			HDFileError2		(int nID, ...) ;

//////////////////////////////////////////////////////////////////////
//
//	Fonctions d'accs aux fichiers profiles
//
//////////////////////////////////////////////////////////////////////
API_EXPORT BOOL HDAPI			WriteHDProfileString	(LPCSTR lpSection, LPCSTR lpEntry, LPCSTR lpString, LPCSTR lpFile) ;
API_EXPORT DWORD HDAPI			ReadHDProfileString		(LPCSTR lpSection, LPCSTR lpEntry, LPCSTR lpDefault, LPSTR lpString, UINT uLen, LPCSTR lpPath) ;

//////////////////////////////////////////////////////////////////////
//
//  Fichier temporaire
//
//////////////////////////////////////////////////////////////////////
API_EXPORT BOOL HDAPI			GetHDTempFileName	(LPSTR lpFileName) ;

//////////////////////////////////////////////////////////////////////
//
//	Fichiers HDC
//
//////////////////////////////////////////////////////////////////////

//  Fichier des Actes
//////////////////////////////////////////////////////////////////////
#pragma pack(1)

typedef struct
{
	char		szCode [SIZE_CODE + 1] ;			// Codification de l'actes
	char		szLib  [151] ;						// Libell de l'actes
	char		szCompta [11] ;						// Compte comptable
	double		dMontant ;							// Montant de l'acte
	char		szNomenclature [SIZE_CODE + 1] ;	// Nomenclature
	double		dCoef ;								// Coefficient
} TYPEDEF (RECActes) ;

#pragma pack()

API_EXPORT HGLOBAL HDAPI 	OpenActes (void) ;
API_EXPORT void HDAPI 		CloseActes (HGLOBAL) ;
API_EXPORT void HDAPI 		FlushActes () ;
API_EXPORT BOOL HDAPI 		ReadActes (int nIdx, LPRECActes lpActes) ;
API_EXPORT void HDAPI 		WriteActes (int nIdx, LPRECActes lpActes) ;
API_EXPORT void HDAPI 		DeleteActes (int nIdx) ;
API_EXPORT int HDAPI 		GetMaxActes (HGLOBAL hRec /*= NULL*/) ;
API_EXPORT void HDAPI		GetDefaultActes (LPSTR lpCode, size_t nCodeLen) ;
API_EXPORT void HDAPI		SetDefaultActes (LPSTR lpCode) ;

//  Fichier des modes de paiement
//////////////////////////////////////////////////////////////////////
#pragma pack(1)

typedef struct
{
	char		szCode [SIZE_CODE + 1] ;	// Codification du mode
	char		szLib  [31] ;				// Libell du mode de paiement
	char		szCompta [11] ;				// Compte comptable
	short		nType ;						// Type du mode de paiement
}  TYPEDEF (RECPaies) ;

#pragma pack()

API_EXPORT HGLOBAL HDAPI 	OpenPaies (void) ;
API_EXPORT void HDAPI 		ClosePaies (HGLOBAL) ;
API_EXPORT void HDAPI 		FlushPaies () ;
API_EXPORT BOOL HDAPI 		ReadPaies (int nIdx, LPRECPaies lpPaies) ;
API_EXPORT void HDAPI 		WritePaies (int nIdx, LPRECPaies lpPaies) ;
API_EXPORT void HDAPI 		DeletePaies (int nIdx) ;
API_EXPORT int HDAPI 		GetMaxPaies (HGLOBAL hRec /*= NULL*/) ;
API_EXPORT void HDAPI		GetDefaultPaies (LPSTR lpCode, size_t nCodeLen) ;
API_EXPORT void HDAPI		SetDefaultPaies (LPSTR lpCode) ;

//  Fichier des Frais
//////////////////////////////////////////////////////////////////////
#pragma pack(1)

typedef struct
{
	char		szCode [SIZE_CODE + 1] ;	// Code du poste
	char		szLib [31] ;				// Libell du poste
	char		szCompta [11] ;				// Compte comptable
	double		dMontant ;					// Cumul des dpenses
} TYPEDEF (RECFrais) ;

#pragma pack()

API_EXPORT HGLOBAL HDAPI 	OpenFrais (void) ;
API_EXPORT void HDAPI 		CloseFrais (HGLOBAL) ;
API_EXPORT void HDAPI 		FlushFrais () ;
API_EXPORT BOOL HDAPI 		ReadFrais (int nIdx, LPRECFrais lpFrais) ;
API_EXPORT void HDAPI 		WriteFrais (int nIdx, LPRECFrais lpFrais) ;
API_EXPORT void HDAPI 		DeleteFrais (int nIdx) ;
API_EXPORT int HDAPI 		GetMaxFrais (HGLOBAL hRec /*= NULL*/) ;


//  Fichier des Banks
//////////////////////////////////////////////////////////////////////
#pragma pack(1)

typedef struct
{
	char		szCompte [31] ;				// Numro du compte bancaire
	char		szNom [SIZE_NAME + 1] ;		// Nom de la banque
	char		szAdresse [81] ;			// Adresse de la banque
	char		szCompta [11] ;				// Compte comptable
} TYPEDEF (RECBanks) ;

#pragma pack()

API_EXPORT HGLOBAL HDAPI 	OpenBanks (void) ;
API_EXPORT void HDAPI 		CloseBanks (HGLOBAL) ;
API_EXPORT void HDAPI 		FlushBanks () ;
API_EXPORT BOOL HDAPI 		ReadBanks (int nIdx, LPRECBanks lpBanks) ;
API_EXPORT void HDAPI 		WriteBanks (int nIdx, LPRECBanks lpBanks) ;
API_EXPORT void HDAPI 		DeleteBanks (int nIdx) ;
API_EXPORT int HDAPI 		GetMaxBanks (HGLOBAL hRec /*= NULL*/) ;

//  Fichier des Utilisateurs
//////////////////////////////////////////////////////////////////////
#pragma pack(1)

typedef struct
{
	char		szCode [SIZE_CODE + 1] ;	// Mot de passe
	SBOOL		bMaster ;					// VRAI si mot de passe gnral
	char		szUser [SIZE_USER] ;		// Nom utilisateur
	char		szInitial [3] ;				// Initiales de l'utilisateur
	char		szDirectory [9] ;			// Rpertoire pour cet utilisateur
	char		szMedecin [21] ;			// Nom du mdecin
	HDDATE		Date ;						// Date modification du passe
	SBOOL		bCabinet ;					// Gestion de dossiers
	SBOOL		bPreference ;				// Acces aux parametres
	SBOOL		bPatient ;					// Consultation patient
	SBOOL		bRecette ;					// Acces recettes
	SBOOL		bDepense ;					// Acces aux depenses
	SBOOL		bAgenda ;					// Acces agenda
	SBOOL		bTexte ;					// Acces correspondances
	char		szIdent [128] ;				// Identification de l'utilisateur medecin
	char		szEntete [13] ;				// Entete ordonnance (Fichier)
	SBOOL		bAgendaON ;					// Prsence agenda
	short		nInterAgenda ;				// Interval agenda en minutes
	USHORT		uCount ;					// Compteur pour raffraichissement
	HDTIME		BegAgenda ;					// Heure de dbut de l'agenda
	HDTIME		EndAgenda ;					// Heure de fin de l'agenda
	short		nOperateur ;				// Oprateur pour caisse VeriFone
	short		nConnected ;				// 0 pas connect 1, 2, ...n connect n fois simultanment (rseau)
	char		szIDNational [10] ;			// Identificateur national (8 + 1)
	COLORREF	crAgenda ;					// Couleur utilis pour l'agenda
#ifdef IMS_VERSION
	ULONG		uCountIMS ;					// Nombre de consultations exportes pour IMS
	HDDATE		DateExportIMS ;				// Date de la dernire exportation IMS
	char		szContratIMS [10] ;			// No de Contrat IMS
#endif	// IMS_VERSION
} TYPEDEF (RECPasses) ;

#pragma pack()

API_EXPORT HGLOBAL HDAPI 	OpenPasses (void) ;
API_EXPORT void HDAPI 		ClosePasses (HGLOBAL) ;
API_EXPORT void HDAPI 		FlushPasses () ;
API_EXPORT BOOL HDAPI 		ReadPasses (int nIdx, LPRECPasses lpPasses, LPCSTR lpCabinet /*= NULL*/) ;
API_EXPORT int HDAPI 		WritePasses (int nIdx, LPRECPasses lpPasses) ;
API_EXPORT void HDAPI 		DeletePasses (int nIdx) ;
API_EXPORT BOOL HDAPI 		ReadCode (LPCSTR lpCabinet, LPCSTR lpUser, LPSTR lpPasse) ;
API_EXPORT int HDAPI 		GetMaxPasses (HGLOBAL hRec /*= NULL*/) ;

//  Adresses
//////////////////////////////////////////////////////////////////////
#pragma pack(1)

typedef struct
{
	char		szNom [SIZE_NAME + 1] ;		// Nom
	char		szAdresse [121] ;			// Adresse
	char		szCPostal [6] ;				// Code Postal
	char		szVille [21] ;				// Ville
	char		szTelephone1 [SIZE_PHONE] ;	// Numro de tlphone 1
	char		szTelephone2 [SIZE_PHONE] ;	// Numro de tlphone 2
	char		szEmail [128] ;				// Adresse Email
	char		szSpecialite [61] ;			// Spcialit
	char		szNumPrescr [9] ;			// Numro prescripteur
	char		cCle ;						// Cl de prescription
} TYPEDEF (RECAdresses) ;

#pragma pack()

API_EXPORT HGLOBAL HDAPI 	OpenAdresses (void) ;
API_EXPORT void HDAPI 		CloseAdresses (HGLOBAL) ;
API_EXPORT void HDAPI 		FlushAdresses () ;
API_EXPORT BOOL HDAPI 		ReadAdresses (LPCSTR lpSection, int nIdx, LPRECAdresses lpAdresses) ;
API_EXPORT void HDAPI 		WriteAdresses (LPCSTR lpSection, int nIdx, LPRECAdresses lpAdresses) ;
API_EXPORT void HDAPI 		DeleteAdresses (LPCSTR lpSection, int nIdx) ;
API_EXPORT int HDAPI 		GetMaxAdresses (LPCSTR lpSection, HGLOBAL hRec /*= NULL*/) ;

//  Fichier des Courriers types
//////////////////////////////////////////////////////////////////////
#pragma pack(1)

typedef struct
{
	char		szFileName [_MAX_FNAME] ;	// Nom du fichier associ
	char		szTitle  [81] ;				// Titre du courriers type
} TYPEDEF (RECCourriersTypes) ;

#pragma pack()

API_EXPORT HGLOBAL HDAPI 	OpenCourriersTypes (void) ;
API_EXPORT void HDAPI 		CloseCourriersTypes (HGLOBAL) ;
API_EXPORT void HDAPI 		FlushCourriersTypes () ;
API_EXPORT BOOL HDAPI 		ReadCourriersTypes (int nIdx, LPRECCourriersTypes lpARECCourriersTypes) ;
API_EXPORT void HDAPI 		WriteCourriersTypes (int nIdx, LPRECCourriersTypes lpRECCourriersTypes) ;
API_EXPORT void HDAPI 		DeleteCourriersTypes (int nIdx) ;
API_EXPORT int HDAPI 		GetMaxCourriersTypes (HGLOBAL hRec /*= NULL*/) ;
//  Fichier des Comptes Rendus types
//////////////////////////////////////////////////////////////////////
#pragma pack(1)

typedef struct
{
	char		szFileName [_MAX_FNAME] ;	// Nom du fichier associ
	char		szTitle  [81] ;				// Titre du courriers type
} TYPEDEF (RECCompteRendusTypes) ;

#pragma pack()

API_EXPORT HGLOBAL HDAPI 	OpenCompteRendusTypes (void) ;
API_EXPORT void HDAPI 		CloseCompteRendusTypes (HGLOBAL) ;
API_EXPORT void HDAPI 		FlushCompteRendusTypes () ;
API_EXPORT BOOL HDAPI 		ReadCompteRendusTypes (int nIdx, LPRECCompteRendusTypes lpARECCompteRendusTypes) ;
API_EXPORT void HDAPI 		WriteCompteRendusTypes (int nIdx, LPRECCompteRendusTypes lpRECCompteRendusTypes) ;
API_EXPORT void HDAPI 		DeleteCompteRendusTypes (int nIdx) ;
API_EXPORT int HDAPI 		GetMaxCompteRendusTypes (HGLOBAL hRec /*= NULL*/) ;

//  Fichier des Ordonnances types
//////////////////////////////////////////////////////////////////////
#pragma pack(1)

typedef struct
{
	char		szFileName [_MAX_FNAME] ;	// Nom du fichier associ
	char		szTitle  [81] ;				// Titre de l'ordonnance type
} TYPEDEF (RECOrdonnancesTypes) ;

#pragma pack()

API_EXPORT HGLOBAL HDAPI 	OpenOrdonnancesTypes (void) ;
API_EXPORT void HDAPI 		CloseOrdonnancesTypes (HGLOBAL) ;
API_EXPORT void HDAPI 		FlushOrdonnancesTypes () ;
API_EXPORT BOOL HDAPI 		ReadOrdonnancesTypes (int nIdx, LPRECOrdonnancesTypes lpOrdonnancesTypes) ;
API_EXPORT void HDAPI 		WriteOrdonnancesTypes (int nIdx, LPRECOrdonnancesTypes lpOrdonnancesTypes) ;
API_EXPORT void HDAPI 		DeleteOrdonnancesTypes (int nIdx) ;
API_EXPORT int HDAPI 		GetMaxOrdonnancesTypes (HGLOBAL hRec /*= NULL*/) ;

//  Fichier des Libells utilisateurs
//////////////////////////////////////////////////////////////////////
#pragma pack(1)

typedef struct
{
	char		szFileName [_MAX_FNAME] ;	// Nom du fichier associ
	char		szTitle  [81] ;				// Titre du libell
} TYPEDEF (RECLibelles) ;

#pragma pack()

API_EXPORT HGLOBAL HDAPI 	OpenLibelles (void) ;
API_EXPORT void HDAPI 		CloseLibelles (HGLOBAL) ;
API_EXPORT void HDAPI 		FlushLibelles () ;
API_EXPORT BOOL HDAPI 		ReadLibelles (int nIdx, LPRECLibelles lpLibelles) ;
API_EXPORT void HDAPI 		WriteLibelles (int nIdx, LPRECLibelles lpLibelles) ;
API_EXPORT void HDAPI 		DeleteLibelles (int nIdx) ;
API_EXPORT int HDAPI 		GetMaxLibelles (HGLOBAL hRec /*= NULL*/) ;

//  Ligne de formulaires
//////////////////////////////////////////////////////////////////////
#pragma pack(1)

typedef struct
{
	char		szText [SIZE_FORMTITLE + 1] ;// Libell de la ligne
	short		nType ;						// Type de valeur TEXT | NUM | CHECK | LIST
	char		szDefault [41] ;			// Valeur par defaut
	double		dMin ;						// Seuil min
	double		dMax ;						// Seuil max
	char		szUnit [41] ;				// Unit
	struct
	{
		char	szChoice [41] ;				// Elments de choix
	} Choice [MAX_CHOICES] ;
} TYPEDEF (RECForms) ;

#pragma pack()

#define SIZE_FORMLINE		(sizeof (RECForms) + 128)

API_EXPORT HGLOBAL HDAPI 	OpenForms (void) ;
API_EXPORT void HDAPI 		CloseForms (HGLOBAL) ;
API_EXPORT void HDAPI 		FlushForms () ;

API_EXPORT int HDAPI 		ReadFormTitle (int nIdx, LPSTR lpTitle, LPCSTR lpPathName /*= NULL*/) ;
API_EXPORT void HDAPI 		WriteFormTitle (int nIdx, LPCSTR lpTitle, int nType, LPCSTR lpPathName /*= NULL*/) ;
API_EXPORT void HDAPI 		DelFormSection (LPCSTR lpTitle, int nType, LPCSTR lpPathName /*= NULL*/) ;
API_EXPORT int HDAPI 		GetMaxForm (int nType, LPCSTR lpPathName /*= NULL*/) ;

API_EXPORT BOOL HDAPI 		ReadFormLine (LPCSTR lpTitle, int nType, int nIdx, LPRECForms lpForms, LPCSTR lpPathName /*= NULL*/) ;
API_EXPORT void HDAPI 		WriteFormLine (LPCSTR lpTitle, int nType, int nIdx, LPRECForms lpForms, LPCSTR lpPathName /*= NULL*/) ;
API_EXPORT void HDAPI 		DelFormLine (LPCSTR lpTitle, int nType, int nIdx, LPCSTR lpPathName /*= NULL*/) ;

//////////////////////////////////////////////////////////////////////
//
//	Fichiers squentiels indexs  enregistrements fixes
//
//////////////////////////////////////////////////////////////////////

//  Fichier Agenda
//////////////////////////////////////////////////////////////////////
#define	AGENDASLEN1		30		// USER + HDDATE + HDTIME	Rendez-vous
#define	AGENDASLEN2		30		// USER + HDDATE + HDTIME	Alarme
#define	AGENDASLEN3		19		// PATIENT + HDDATE + HDTIME

#define AGENDA_BY_RDV		0
#define AGENDA_BY_WARNING	1
#define AGENDA_BY_PATIENT	2

#pragma pack(1)

typedef struct
{
	WORD	wStatus ;			// Etat enregistrement (0 = OK)
	HDDATE	Date ;				// Date du jour
	HDTIME	Time ;				// Heure du rendez-vous
	char	szUser [SIZE_USER] ;// Nom de l'utilisateur
	short	nWarning ;			// Source du rendez-vous RDV_RENDEZVOUS, RDV_VACCIN
	USHORT	uFiche ;			// Numro de fiche patient
	char	szText [128] ;		// Textes
	char	szTextName [13] ;	// Nom du fichier texte associ
	char	szSoundName [13] ;	// Nom du fichier son associ
	char	szBitmapName [13] ;	// Nom du fichier image associ
	SBOOL	bAlarme ;			// VRAI si gnration d'une alarme ou Type de journe AGENDA_FERIE, AGENDA_GARDE, AGENDA_CONGE, AGENDA_AUTRE
	short	nRappel ;			// Rappel xx xxxxxxxx avant l'alarme
	short	nTypeRappel ;		// 0=Minute, 1=Heures, 2=Jours, 3=Semaine, 4=Mois
	HDDATE	DateSeance ;		// Date de la sance associe
	HDTIME	TimeSeance ;		// Heure de la sance associe
	BYTE	Extension [8] ;		// Rserve pour extension
} TYPEDEF (RECAgendas) ;

#pragma pack()

API_EXPORT BOOL HDAPI 		CreatAgendas (LPCSTR lpPath /*= NULL*/) ;
API_EXPORT HGLOBAL HDAPI 	OpenAgendas (LPCSTR lpPath /*= NULL*/) ;
API_EXPORT void HDAPI 		CloseAgendas (HGLOBAL) ;
API_EXPORT void HDAPI 		FlushAgendas () ;
API_EXPORT int HDAPI 		GetOpenFlagAgendas () ;
API_EXPORT LPSTR HDAPI		MakeAgendas1Key (LPSTR lpKey, LPCSTR lpUser, HDDATE Date, HDTIME Time) ;
API_EXPORT LPSTR HDAPI		MakeAgendas2Key (LPSTR lpKey, LPCSTR lpUser, HDDATE Date, HDTIME Time) ;
API_EXPORT LPSTR HDAPI		MakeAgendas3Key (LPSTR lpKey, UINT uFiche, HDDATE Date, HDTIME Time) ;
API_EXPORT HDFILEPOS HDAPI 	ReadAgendas (LPRECAgendas lpAgendas, int nKey) ;
API_EXPORT BOOL HDAPI 		WriteAgendas (LPRECAgendas lpAgendas) ;
API_EXPORT BOOL HDAPI 		DeleteAgendas (HDFILEPOS Idx) ;
API_EXPORT DWORD HDAPI 		GetAgendasSize (LPCSTR lpPath /*= NULL*/) ;
API_EXPORT DWORD HDAPI 		GetAgendasRec (LPCSTR lpPath /*= NULL*/) ;


//  Fichier patients
//////////////////////////////////////////////////////////////////////
#define	PATIENTSLEN1	41	// Nom + Prenom
#define	PATIENTSLEN2	6	// Fiche
#define	PATIENTSLEN3	16	// Dossier

#define PATIENTS_BY_NAME	0
#define PATIENTS_BY_REC		1
#define PATIENTS_BY_REF		2

#pragma pack(1)

typedef struct
{
	WORD	wStatus ;					// Etat enregistrement (0 = OK)
	SBOOL	bDeleted ;					// Flag si supprim / archiv
	char	szDossier [16] ;			// Rfrence de dossier papier	(Cl 3)
	char	szNom [21] ;				// Nom du patient        (Cle 1)
	char	szPrenom [21] ;				// Prnom du patient     (Cle 1)
	char	szNomJF [21] ;				// Nom de jeune fille
	char	cSexe ;						// H = Homme,  F = Femme
	char	cSitFam ;					// C = Celibataire, M = Mari, D = Divorc(e), V = Veuf(ve), O = Cocubin(e), P = Parent clibataire
	HDDATE	DateNai ;					// Date de naissance
	char	szLieuNai [41] ;			// Lieu de naissance
	char	szAdresse [81] ;			// Adresse
	char	szCPostal [6] ;				// Code Postal
	char	szVille [21] ;				// Ville
	char	szTelPerso [SIZE_PHONE] ;	// Numro de tlphone personnel
	char	szTelPro [SIZE_PHONE] ;		// Numro de tlphone professionnel
	short	nEnfants ;					// Nombre d'enfants
	short	nTaille ;					// Taille en Cm
	short	nPoids ;					// Poids en Kg
	char	szGroupe [11] ;				// Groupe sanguin
	char	szProfession [41] ;			// Profession
	char	szNumSS [31] ;				// Numro de scurit sociale
	char	szCaisse [SIZE_NAME + 1] ;	// Caisse d'assur social
	char	szTiers [SIZE_NAME + 1] ;	// Tiers payant
	char	szRemarque [81] ;			// Remarque
	USHORT	uFiche ;					// Numro de fiche patient (Cl 2)
	char	szUser [SIZE_USER] ;		// Nom de l'utilisateur
	HDDATE	DateFiche ;					// Date de cration fiche
	HDDATE	DateConsulte ;				// Date derniere consultation
	short	nCourrier ;					// Numro squentiel courrier
	short	nOrdonnance ;				// Numro squentiel ordonnance.
	char	szMedecin [81] ;			// Medecin traitant
	char	szLibZone1 [11] ;			// Libll de la zone supplmentaire 1
	char	szLibZone2 [11] ;			// Libll de la zone supplmentaire 2
	char	szLibZone3 [11] ;			// Libll de la zone supplmentaire 3
	char	szLibZone4 [11] ;			// Libll de la zone supplmentaire 4
	char	szZone1 [25] ;				// Zone supplmentaire 1
	char	szZone2 [25] ;				// Zone supplmentaire 2
	char	szZone3 [25] ;				// Zone supplmentaire 3
	char	szZone4 [25] ;				// Zone supplmentaire 4
	char	szLibCZone1 [11] ;			// Libll de la zone supplmentaire en consultation 1
	char	szLibCZone2 [11] ;			// Libll de la zone supplmentaire en consultation 2
	char	szLibCZone3 [11] ;			// Libll de la zone supplmentaire en consultation 3
	char	szLibCZone4 [11] ;			// Libll de la zone supplmentaire en consultation 4
	BYTE	cMaskEvent ;				// Elments affich dans le dossier (1 bit par lment)
	BYTE	cSeparatorPos ;				// Position du sparateur dans le dossier (en %)
	USHORT	nItems ;					// Nombres d'lments dans le dossier
	HDDATE	DateDeces ;					// Date de dcs (brrrrr)
#ifdef IMS_VERSION
	ULONG	uIDIMS ;					// Identifiant IMS
	USHORT	uTraitementID ;				// N du dernier traitement
#else	//IMS_VERSION
	USHORT	uTraitementID ;				// N du dernier traitement
	BYTE	Extension1 [4] ;			// Rserve pour extension
#endif	//IMS_VERSION
	char	cRangGemellaire ;			// Rang gmellaire (RANG_GEMELLAIRE_1/RANG_GEMELLAIRE_2...)
	BYTE	Extension2 [1] ;			// Rserve pour extension
} TYPEDEF (RECPatients) ;

#pragma pack()

API_EXPORT BOOL HDAPI 		CreatPatients (LPCSTR lpPath /*= NULL*/) ;
API_EXPORT HGLOBAL HDAPI 	OpenPatients (LPCSTR lpPath /*= NULL*/) ;
API_EXPORT HGLOBAL HDAPI 	OpenPatients_ (LPCSTR lpPath) ;
API_EXPORT void HDAPI 		ClosePatients (HGLOBAL) ;
API_EXPORT void HDAPI 		ClosePatients_ (HGLOBAL) ;
API_EXPORT void HDAPI 		FlushPatients () ;
API_EXPORT int HDAPI 		GetOpenFlagPatients () ;
API_EXPORT LPSTR HDAPI		MakePatients1Key (LPSTR lpKey, LPCSTR lpNom, LPCSTR lpPrenom) ;
API_EXPORT LPSTR HDAPI 		MakePatients2Key (LPSTR lpKey, USHORT uFiche) ;
API_EXPORT LPSTR HDAPI 		MakePatients3Key (LPSTR lpKey, LPCSTR lpDossier) ;
API_EXPORT void HDAPI 		UpdatePatient (LPRECPatients lpPatients) ;
API_EXPORT HDFILEPOS HDAPI 	ReadPatients (LPRECPatients lpPatients, int nKey) ;
API_EXPORT BOOL HDAPI 		WritePatients (LPRECPatients lpPatients) ;
API_EXPORT BOOL HDAPI 		DeletePatients (HDFILEPOS Idx) ;
API_EXPORT DWORD HDAPI 		GetPatientsSize (LPCSTR lpPath /*= NULL*/) ;
API_EXPORT DWORD HDAPI 		GetPatientsRec (LPCSTR lpPath /*= NULL*/) ;

//  Fichier recettes
//////////////////////////////////////////////////////////////////////
#define	RECETTESLEN1	20	// Date Acte + Fiche + Heure
#define	RECETTESLEN2	20	// Date Paie + Fiche + Heure
#define	RECETTESLEN3	20	// Fiche + Date Acte + Heure
#define	RECETTESLEN4	21	// Date Paiement + Heure + Fiche + No Paiement

#define RECETTES_BY_DATEA	0
#define RECETTES_BY_DATEP	1
#define RECETTES_BY_PATIENT	2
#define RECETTES_BY_PAIEMENT	3
#pragma pack(1)

#ifdef	EURO_VERSION

typedef struct
{
	WORD		wStatus ;					// Etat enregistrement (0 = OK)
	USHORT		uFiche ;					// Numro de fiche patient
	HDDATE		Date ;						// Date de la recette
	HDTIME		Time ;						// Heure de la recette
	HDDATE		DatePaie ;					// Date de paiement
	char		szUser [SIZE_USER] ;		// Nom de l'utilisateur
	char		szActe [SIZE_CODE + 1] ;	// Code de l'acte
	double		dMontant ;					// Montant de l'acte
	double		dCoef ;						// Coeficient multiplicateur
	short		nKilometre ;				// Nombre de kilometres
	double		dIDKilometre ;				// Indemnit Kilometrique
	double		dTotal ;					// Montant total
	struct
	{
		char	szCode [SIZE_CODE + 1] ;	// Codification du mode
		double	dMontant ;					// Montant pour ce mode
		SBOOL	bMontantEuro ;				// Montant en euro
		char	szBanque [SIZE_NAME + 1] ;	// Banque
		char	szCheque [21] ;				// Numro du cheque
		char	szCompte [22] ;				// Numro du compte
		HDDATE	Date ;						// Date de paiement
		char	szLibelle [SIZE_LIB + 1] ;	// Libell du paiement
#ifdef MULTITIERS_VERSION
		BYTE	wTiers ;					// Pay par P_TIERS_AMO, P_TIERS_AMC ou P_PATIENT
		BYTE	Extension [15] ;			// Rserve pour extension
#else // MULTITIERS_VERSION
		BYTE	Extension [16] ;			// Rserve pour extension
#endif // MULTITIERS_VERSION
	} Paie [4] ;
	double		dReste ;					// Montant restant  payer
#ifdef MULTITIERS_VERSION
	char		szTiersAMO [SIZE_NAME + 1] ;	// Identificateur tiers payant AMO
#else // MULTITIERS_VERSION
	char		szTiers [SIZE_NAME + 1] ;	// Identificateur tiers payants
#endif // MULTITIERS_VERSION
	USHORT		uPayeur ;					// Numro de fiche du payeur
	SBOOL		bXfr ;						// VRAI si transfre en compta
	BYTE		bFSE ;						// VRAI si cette recette  t cre  partir d'une FSE
	BYTE		bFSEUpdated ;				// VRAI si le flag bFSE a t mis  jour
	SBOOL		bEuro ;						// VRAI si recette en Euro
	HDDATE		DateFSE ;					// date de l'enregistrement FSE associ

#ifdef MULTITIERS_VERSION
	double		dResteAMO ;
	double		dResteAMC ;
	double		dRestePatient ;
	char		szTiersAMC [SIZE_NAME + 1] ;	// Identificateur tiers payant AMC
	HDDATE		DateFSP ;					// date de l'enregistrement FSP associ
	BYTE		bPaieGroupe ;				// Paiement groupe => recette solde
	BYTE		Extension [75] ;			// Rserve pour extension
#else // MULTITIERS_VERSION
	BYTE		Extension [125] ;			// Rserve pour extension
#endif // MULTITIERS_VERSION
} TYPEDEF (RECRecettes) ;

#else	// EURO_VERSION

typedef struct
{
	WORD		wStatus ;					// Etat enregistrement (0 = OK)
	USHORT		uFiche ;					// Numro de fiche patient
	HDDATE		Date ;						// Date de la recette
	HDTIME		Time ;						// Heure de la recette
	HDDATE		DatePaie ;					// Date de paiement
	char		szUser [SIZE_USER] ;		// Nom de l'utilisateur
	char		szActe [SIZE_CODE + 1] ;	// Code de l'acte
	double		dMontant ;					// Montant de l'acte
	double		dCoef ;						// Coeficient multiplicateur
	short		nKilometre ;				// Nombre de kilometres
	double		dIDKilometre ;				// Indemnit Kilometrique
	double		dTotal ;					// Montant total
	struct
	{
		char	szCode [SIZE_CODE + 1] ;	// Codification du mode
		double	dMontant ;					// Montant pour ce mode
		char	szBanque [SIZE_NAME + 1] ;	// Banque
		char	szCheque [21] ;				// Numro du cheque
#ifdef COMPTA_VERSION
		char	szCompte [22] ;				// Numro du compte
		HDDATE	Date ;						// Date de paiement
#else	// COMPTA_VERSION
		char	szCompte [26] ;				// Numro du compte
#endif	// COMPTA_VERSION
	} Paie [4] ;
	double		dReste ;					// Montant restant  payer
	char		szTiers [SIZE_NAME + 1] ;	// Identificateur tiers payants
	USHORT		uPayeur ;					// Numro de fiche du payeur
	SBOOL		bXfr ;						// VRAI si transfre en compta
	BYTE		bFSE ;						// VRAI si cette recette  t cre  partir d'une FSE
	BYTE		bFSEUpdated ;				// VRAI si le flag bFSE a t mis  jour
	HDDATE		DateFSE ;					// date de l'enregistrement FSE associ

	BYTE		Extension [10] ;			// Rserve pour extension
} TYPEDEF (RECRecettes) ;

#endif	// EURO_VERSION

#pragma pack()

API_EXPORT BOOL HDAPI 		CreatRecettes (LPCSTR lpPath /*= NULL*/) ;
API_EXPORT HGLOBAL HDAPI 	OpenRecettes (LPCSTR lpPath /*= NULL*/) ;
API_EXPORT HGLOBAL HDAPI 	OpenRecettes_ (LPCSTR lpPath /*= NULL*/) ;
API_EXPORT void HDAPI 		CloseRecettes (HGLOBAL) ;
API_EXPORT void HDAPI 		CloseRecettes_ (HGLOBAL) ;
API_EXPORT void HDAPI 		FlushRecettes () ;
API_EXPORT int HDAPI 		GetOpenFlagRecettes () ;
API_EXPORT LPSTR HDAPI		MakeRecettes1Key (LPSTR lpKey, HDDATE Date, USHORT uFiche, HDTIME Time) ;
API_EXPORT LPSTR HDAPI 		MakeRecettes2Key (LPSTR lpKey, HDDATE Date, USHORT uFiche, HDTIME Time) ;
API_EXPORT LPSTR HDAPI 		MakeRecettes3Key (LPSTR lpKey, USHORT uFiche, HDDATE Date, HDTIME Time) ;
API_EXPORT LPSTR HDAPI 		MakeRecettes4Key (LPSTR lpKey,  HDDATE Date, HDTIME Time, USHORT uFiche,int i) ;
API_EXPORT HDFILEPOS HDAPI 	ReadRecettes (LPRECRecettes lpRecettes, int nKey) ;
API_EXPORT BOOL HDAPI 		WriteRecettes (LPRECRecettes lpRecettes) ;
API_EXPORT BOOL HDAPI 		UpdateRecettes (HDFILEPOS Idx, LPRECRecettes lpRecettes) ;
API_EXPORT BOOL HDAPI 		DeleteRecettes (HDFILEPOS Idx) ;
API_EXPORT BOOL HDAPI 		DeleteRecettesOnly (HDFILEPOS Idx) ;
API_EXPORT DWORD HDAPI 		GetRecettesSize (LPCSTR lpPath /*= NULL*/) ;
API_EXPORT DWORD HDAPI 		GetRecettesRec (LPCSTR lpPath /*= NULL*/) ;
API_EXPORT BOOL HDAPI 		RemoveComptaRecette (LPRECRecettes lpRecettes) ;

//  Fichier depenses
//////////////////////////////////////////////////////////////////////
#define	DEPENSESLEN		22	// Date + Code + Heure

#define DEPENSE_BY_DATE	0

#pragma pack(1)

typedef struct
{
	WORD		wStatus ;					// Etat enregistrement (0 = OK)
	HDDATE		Date ;						// Date de la depense
	HDTIME		Time ;						// Heure de la depense
	char		szUser [SIZE_USER] ;		// Nom de l'utilisateur
	char		szCode [SIZE_CODE + 1] ;	// Code de la depense
	double		dMontant ;					// Montant de la dpense
	double		dMontantPerso ;				// Montant personnel
	SBOOL		bPerso ;					// Depense personnelle
	char		szBanque [SIZE_NAME + 1] ;	// Banque
	char		szCompte [26] ;				// Numro du compte
	char		szCheque [21] ;				// Numro du cheque
	char		szLibelle [SIZE_LIB + 1] ;	// Libelle
	SBOOL		bXfr ;						// VRAI si transfre en compta
#ifdef	EURO_VERSION
	SBOOL		bEuro ;						// Monnaie en euro

	BYTE		Extension [14] ;			// Rserve pour extension
#else	// EURO_VERSION
	BYTE		Extension [16] ;			// Rserve pour extension
#endif	// EURO_VERSION
} TYPEDEF (RECDepenses) ;

#pragma pack()

API_EXPORT BOOL HDAPI 		CreatDepenses (LPCSTR lpPath /*= NULL*/) ;
API_EXPORT HGLOBAL HDAPI 	OpenDepenses (LPCSTR lpPath /*= NULL*/) ;
API_EXPORT void HDAPI 		CloseDepenses (HGLOBAL) ;
API_EXPORT void HDAPI 		FlushDepenses () ;
API_EXPORT int HDAPI 		GetOpenFlagDepenses () ;
API_EXPORT LPSTR HDAPI 		MakeDepensesKey (LPSTR lpKey, HDDATE Date, LPCSTR lpCode, HDTIME Time) ;
API_EXPORT HDFILEPOS HDAPI 	ReadDepenses (LPRECDepenses lpDepenses, int nKey) ;
API_EXPORT BOOL HDAPI 		WriteDepenses (LPRECDepenses lpDepenses) ;
API_EXPORT BOOL HDAPI 		UpdateDepenses (HDFILEPOS Idx, LPRECDepenses lpDepenses) ;
API_EXPORT BOOL HDAPI 		DeleteDepenses (HDFILEPOS Idx) ;
API_EXPORT BOOL HDAPI 		DeleteDepensesOnly (HDFILEPOS Idx) ;
API_EXPORT DWORD HDAPI 		GetDepensesSize (LPCSTR lpPath /*= NULL*/) ;
API_EXPORT DWORD HDAPI 		GetDepensesRec (LPCSTR lpPath /*= NULL*/) ;

//  Posologies / dures des mdicaments
//////////////////////////////////////////////////////////////////////
#pragma pack(1)

typedef	struct
{
	char	szPosologie [61] ;		// Posologie
	char	szDuree [41] ;			// Dure
	double	dQuantite ;				// Nombre d'unit de prise
	short	nJours ;				// Nombre de jours
	BYTE	Extension [16] ;		// Rserve pour extension
} TYPEDEF (RECPoso) ;

#pragma pack()


//  Fichier pharmacies
//////////////////////////////////////////////////////////////////////
#define	PHARMACIESLEN	41			// Nom

#define PHARMACIES_BY_NAME	0

#pragma pack(1)

typedef struct
{
	WORD			wStatus ;						// Etat enregistrement (0 = OK)
	char			szNom [41] ;					// Nom lment
	RECPoso			Posologies [MAX_POSOLOGIES] ;	// Posologies/Dures
	short			nLastPosologie ;				// Dernire posologie selectionne
	short			nLastDuree ;					// Dernire posologie dure
#ifdef	NEWPHARMPERSO_VERSION
	WORD			wType ;							// Type de l'lment (cf section [Pharmacie Personnelle] dans cabinet.hdc)
	BYTE			Extension [15] ;				// Rserve pour extension
#else	// NEWPHARMPERSO_VERSION
	BYTE			Extension [16] ;				// Rserve pour extension
#endif	// NEWPHARMPERSO_VERSION
} TYPEDEF (RECPharmacies) ;

#pragma pack()

API_EXPORT BOOL HDAPI 		CreatPharmacies (LPCSTR lpPath /*= NULL*/) ;
API_EXPORT HGLOBAL HDAPI 	OpenPharmacies (LPCSTR lpPath /*= NULL*/) ;
API_EXPORT void HDAPI 		ClosePharmacies (HGLOBAL) ;
API_EXPORT void HDAPI 		FlushPharmacies () ;
API_EXPORT int HDAPI 		GetOpenFlagPharmacies () ;
API_EXPORT LPSTR HDAPI 		MakePharmaciesKey (LPSTR lpKey, LPCSTR lpNom) ;
API_EXPORT HDFILEPOS HDAPI 	ReadPharmacies (LPRECPharmacies lpPharmacies, int nKey) ;
API_EXPORT BOOL HDAPI 		WritePharmacies (LPRECPharmacies lpPharmacies) ;
API_EXPORT BOOL HDAPI 		DeletePharmacies (HDFILEPOS Idx) ;
API_EXPORT DWORD HDAPI 		GetPharmaciesSize (LPCSTR lpPath /*= NULL*/) ;
API_EXPORT DWORD HDAPI 		GetPharmaciesRec (LPCSTR lpPath /*= NULL*/) ;

//  Fichiers Posologies usuelles
//////////////////////////////////////////////////////////////////////
#define	POSOLOGIESLEN		8						// Code CIP

#pragma pack(1)

typedef struct
{
	char			szCIP [8] ;						// Numro CIP
	RECPoso			Posologies [MAX_POSOLOGIES] ;	// Posologies/Dures
	short			nLastPosologie ;				// Dernire posologie selectionne
	short			nLastDuree ;					// Dernire posologie dure
} TYPEDEF (RECPosologies) ;

#pragma pack()

API_EXPORT BOOL HDAPI		CreatPosologies (LPCSTR lpPath /*= NULL*/) ;
API_EXPORT HGLOBAL HDAPI	OpenPosologies (LPCSTR lpPath /*= NULL*/) ;
API_EXPORT void HDAPI		ClosePosologies (HGLOBAL) ;
API_EXPORT void HDAPI 		FlushPosologies () ;
API_EXPORT int HDAPI 		GetOpenFlagPosologies () ;
API_EXPORT LPSTR HDAPI		MakePosologiesKey (LPSTR lpKey, LPCSTR lpCIP) ;
API_EXPORT HDFILEPOS HDAPI 	ReadPosologies (LPRECPosologies lpPosologies, int nKey) ;
API_EXPORT BOOL HDAPI 		WritePosologies (LPRECPosologies lpPosologies) ;
API_EXPORT BOOL HDAPI 		DeletePosologies (HDFILEPOS Idx) ;
API_EXPORT DWORD HDAPI 		GetPosologiesSize (LPCSTR lpPath /*= NULL*/) ;
API_EXPORT DWORD HDAPI 		GetPosologiesRec (LPCSTR lpPath /*= NULL*/) ;

//  Fichiers Mdicaments DSI
//////////////////////////////////////////////////////////////////////
#define	DSIMEDICAMENTSLEN	(15 + 8)	// Nom + Code CIP
#define	DSICIPLEN			8			// Code CIP

#define DSIMEDICAMENTS_BY_NAME	0
#define DSIMEDICAMENTS_BY_CIP	1

#pragma pack(1)

typedef struct
{
	char	szCIP [8] ;					// Numro CIP
	char	szNom [66] ;				// Nom du mdicament
	double	dTaux ;						// Taux de remboursement
	char	cListe ;					// Liste / stupfiant
	SBOOL	bAgrement ;					// Agrment collectivit (O/N)
	SBOOL	bRetrait ;					// Retrait du march
	char	szLabo [16] ;				// Nom du laboratoire
	short	nLen ;						// Nombre de classes
	short	nClasses [12] ;				// Liste des classes
	long	lAbstrat ;					// Numro d'abstrat
} TYPEDEF (RECDSIMedicaments) ;

#pragma pack()

API_EXPORT HGLOBAL HDAPI 	OpenDSIMedicaments (void) ;
API_EXPORT void HDAPI 		CloseDSIMedicaments (HGLOBAL) ;
API_EXPORT int HDAPI 		GetOpenFlagDSIMedicaments () ;
API_EXPORT LPSTR HDAPI 		MakeDSIMedicamentsKey (LPSTR lpKey, LPCSTR lpNom, LPCSTR lpCIP) ;
API_EXPORT LPSTR HDAPI 		MakeDSICIPKey (LPSTR lpKey, LPCSTR lpCIP) ;
API_EXPORT HDFILEPOS HDAPI 	ReadDSIMedicaments (LPRECDSIMedicaments lpDSIMedicaments, int nLen) ;

//  Fichiers Interactions DSI
//////////////////////////////////////////////////////////////////////
#define DSIINTERACTIONSLEN		(3 + 3)	// Classe 1 + Classe 2

#define  DSIINTERACTIONS_BY_CLASS	0

#pragma pack(1)

typedef struct
{
	short	nClasse1 ;					// Classe 1
	short	nClasse2 ;					// Classe 2
	short	nGravite ;					// Niveau de gravit
	short	nText ;						// Numro du texte
} TYPEDEF (RECDSIInteractions) ;

#pragma pack()

API_EXPORT HGLOBAL HDAPI 	OpenDSIInteractions (void) ;
API_EXPORT void HDAPI 		CloseDSIInteractions (HGLOBAL) ;
API_EXPORT int HDAPI 		GetOpenFlagDSIInteractions () ;
API_EXPORT LPSTR HDAPI 		MakeDSIInteractionsKey (LPSTR lpKey, short nClasse1, short nClasse2) ;
API_EXPORT HDFILEPOS HDAPI 	ReadDSIInteractions (LPRECDSIInteractions lpDSIInteractions, int nKey) ;

//  Fichiers Classes DSI
//////////////////////////////////////////////////////////////////////
#define DSICLASSESLEN			3		// Classe

#define DSICLASSES_BY_NUMBER	0

#pragma pack(1)

typedef struct
{
	short	nNumero ;					// Numro de la classe
	char	szName [66] ;				// Nom de la classe
} TYPEDEF (RECDSIClasses) ;

#pragma pack()

API_EXPORT HGLOBAL HDAPI 	OpenDSIClasses (void) ;
API_EXPORT void HDAPI 		CloseDSIClasses (HGLOBAL) ;
API_EXPORT int HDAPI 		GetOpenFlagDSIClasses () ;
API_EXPORT LPSTR HDAPI 		MakeDSIClassesKey (LPSTR lpKey, short nClasse) ;
API_EXPORT HDFILEPOS HDAPI 	ReadDSIClasses (LPRECDSIClasses lpDSIClasses, int nKey) ;

//  Fichiers Gravits DSI
//////////////////////////////////////////////////////////////////////
#define DSIGRAVITESLEN			3		// Niveau

#define DSIGRAVITES_BY_LEVEL	0

#pragma pack(1)

typedef struct
{
	short	nNiveau ;					// Niveau de la gravit
	char	szLibelle [26] ;			// Libell du niveau de gravit
} TYPEDEF (RECDSIGravites) ;

#pragma pack()

API_EXPORT HGLOBAL HDAPI 	OpenDSIGravites (void) ;
API_EXPORT void HDAPI 		CloseDSIGravites (HGLOBAL) ;
API_EXPORT int HDAPI 		GetOpenFlagDSIGravites () ;
API_EXPORT LPSTR HDAPI 		MakeDSIGravitesKey (LPSTR lpKey, short nNiveau) ;
API_EXPORT HDFILEPOS HDAPI 	ReadDSIGravites (LPRECDSIGravites lpDSIGravites, int nKey) ;

//  Fichiers Textes DSI
//////////////////////////////////////////////////////////////////////
#define DSITEXTSLEN			4			// Texte

#define DSITEXTS_BY_NUMBER	0

#pragma pack(1)

typedef struct
{
	short	nNumero ;					// Numro du texte
	char	szAction [321] ;			// Mcanisme d'action
	char	szConduite [321] ;			// Conduite  tenir
} TYPEDEF (RECDSITexts) ;

#pragma pack()

API_EXPORT HGLOBAL HDAPI 	OpenDSITexts (void) ;
API_EXPORT void HDAPI 		CloseDSITexts (HGLOBAL) ;
API_EXPORT int HDAPI 		GetOpenFlagDSITexts () ;
API_EXPORT LPSTR HDAPI 		MakeDSITextsKey (LPSTR lpKey, short nText) ;
API_EXPORT HDFILEPOS HDAPI 	ReadDSITexts (LPRECDSITexts lpDSITexts, int nKey) ;

//  Fichiers Abstrats DSI
//////////////////////////////////////////////////////////////////////
#define DSIABSTRATSLEN		(8 + 1 + 3)		// Identit + Zone + Ligne

#define DSIABSTRATS_BY_NUMBER	0

#pragma pack(1)

typedef struct
{
	long	lIdentite ;					// Numro de l'abstrat
	char	cZone ;						// Code zone
	short	nLigne ;					// Numro de ligne
	char	szText [81] ;				// Texte affichable
} TYPEDEF (RECDSIAbstrats) ;

#pragma pack()

API_EXPORT HGLOBAL HDAPI 	OpenDSIAbstrats (void) ;
API_EXPORT void HDAPI 		CloseDSIAbstrats (HGLOBAL) ;
API_EXPORT int HDAPI 		GetOpenFlagDSIAbstrats (void) ;
API_EXPORT LPSTR HDAPI		MakeDSIAbstratsKey (LPSTR lpKey, long lIdentite, char cZone, short nLigne) ;
API_EXPORT HDFILEPOS HDAPI 	ReadDSIAbstrats (LPRECDSIAbstrats lpDSIAbstrats, int nKey) ;

//  Fichier homopathique
//////////////////////////////////////////////////////////////////////
API_EXPORT BOOL HDAPI		CreatHomeo (LPCSTR lpPath /*= NULL*/) ;
API_EXPORT HGLOBAL HDAPI	OpenHomeo (LPCSTR lpPath /*= NULL*/) ;
API_EXPORT void HDAPI		CloseHomeo (HGLOBAL) ;
API_EXPORT void HDAPI 		FlushHomeo () ;
API_EXPORT int HDAPI 		GetOpenFlagHomeo () ;
API_EXPORT LPSTR HDAPI		MakeHomeoKey (LPSTR lpKey, LPCSTR lpCIP) ;
API_EXPORT HDFILEPOS HDAPI 	ReadHomeo (LPRECPharmacies lpPharmacies, int nKey) ;
API_EXPORT BOOL HDAPI 		WriteHomeo (LPRECPharmacies lpPharmacies) ;
API_EXPORT BOOL HDAPI 		DeleteHomeo (HDFILEPOS Idx) ;

//////////////////////////////////////////////////////////////////////
//
//	Fichiers squentiels indexs  enregistrements variables
//
//////////////////////////////////////////////////////////////////////

//  Fichier dossiers
//////////////////////////////////////////////////////////////////////
#define DOSSIERSLEN				20			// Fiche + Type + Date + Heure

#define DOSSIERS_HEADER_SIZE	128
#define DOSSIERS_RECORD_IDENT	0x50444448	// "HDDP"

#define	DOSSIERS_RECORD					\
	DWORD		dwIdent ;				\
	WORD		wStatus ;				\
	DWORD		dwLength ;				\
	char		cType ;					\
	USHORT		uFiche ;				\
	HDDATE		Date ;					\
	HDTIME		Time ;					\
	char		szUser [SIZE_USER] ;	\
	short		nWarning ;				\
	USHORT		uRecLen ;				\
	USHORT		uTextLen ;

//	DWORD		dwIdent ;				"HDDP" 0x50444448L
//	WORD		wStatus ;				Etat fichier (0 = Ok)
//	DWORD		dwLength ;				Longueure totale de l'enregistrement (version 4.1 et suprieure)
//	char		cType ;					'0', '1', '2', '3' ...
//	USHORT		uFiche ;				Fiche associe
//	HDDATE		Date ;					Date de l'venement
//	HDTIME		Time ;					Heure de l'venement
//	char		szUser [SIZE_USER] ;	Nom de l'utilisateur
//	short		nWarning ;				Niveau d'importance
//	USHORT		uRecLen ;				Longueur Record
//	USHORT		uTextLen ;				Longueur Texte (version 4.0 et infrieur)

// A T T E N T I O N
// A partir de la version 4.1, la longueur d'un enregistrement n'est plus
// limite  64 Ko (65536) mais  4 Go (4294967295). La conversion des
// anciens enregistrements se fait si dwLength est gale  zro, ou
// si le type est DOSSIERS_BIOLOGIE35 et dwLength diffrent de
// uRecLen plus uTextLen.
// Lors de l'criture ou de la rcriture d'un enregistrement on converti
//   - dwLength gal  la longueure totale de l'enregistrement
//   - uRecLen gal  la longueure de l'enregistrement fixe
//   - uTextLen gal  dwLength (limit  65536)

#pragma pack(1)

typedef struct
{
	DOSSIERS_RECORD
} TYPEDEF (RECDossiers) ;

#pragma pack()

API_EXPORT HANDLE HDAPI 	GetDossierHandle () ;
API_EXPORT HANDLE HDAPI 	GetDossierHandle_ () ;
API_EXPORT BOOL HDAPI 		CreatDossiers (LPCSTR lpPath /*= NULL*/) ;
API_EXPORT BOOL HDAPI 		CreatDossiers2 (short nID, short nIDX) ;
API_EXPORT HGLOBAL HDAPI 	OpenDossiers (short nRecLen, LPCSTR lpPath /*= NULL*/, short nID /*= 0*/, short nIDX /*= 0*/) ;
API_EXPORT HGLOBAL HDAPI 	OpenDossiers2 (short nRecLen, short nID, short nIDX) ;
API_EXPORT HGLOBAL HDAPI 	OpenDossiers_ (LPCSTR lpPath, short nRecLen) ;
API_EXPORT void HDAPI 		CloseDossiers (HGLOBAL) ;
API_EXPORT void HDAPI 		CloseDossiers_ (HGLOBAL) ;
API_EXPORT void HDAPI 		FlushDossiers () ;
API_EXPORT int HDAPI 		GetOpenFlagDossiers () ;
API_EXPORT LPSTR HDAPI 		MakeDossiersKey (LPSTR lpKey, USHORT uFiche, char cType, HDDATE Date, HDTIME Time) ;
API_EXPORT HGLOBAL HDAPI 	ReadDossiers (HDFILEPOS Idx, LPRECDossiers lpDossiers, short nLen) ;
API_EXPORT BOOL HDAPI 		ReadDossiers2 (HDFILEPOS Idx, LPRECDossiers lpDossiers) ;
API_EXPORT HGLOBAL HDAPI 	ReadDossiers3 (HANDLE hFile, HDFILEPOS Idx, LPRECDossiers lpDossiers, short nLen) ;
API_EXPORT BOOL HDAPI 		ReadDossiers4 (HANDLE hFile, HDFILEPOS Idx, LPRECDossiers lpDossiers) ;
API_EXPORT HGLOBAL HDAPI 	ReadDossiers_ (HDFILEPOS Idx, LPRECDossiers lpDossiers, short nLen) ;
API_EXPORT BOOL HDAPI 		ReadDossiers2_ (HDFILEPOS Idx, LPRECDossiers lpDossiers) ;
API_EXPORT HDFILEPOS HDAPI 	WriteDossiers (HGLOBAL hText, DWORD dwTextLen, LPRECDossiers lpDossiers, short nLen) ;
API_EXPORT HDFILEPOS HDAPI 	WriteDossiers2 (HANDLE hFile, HGLOBAL hText, DWORD dwTextLen, LPRECDossiers lpDossiers, short nLen) ;
API_EXPORT HDFILEPOS HDAPI 	WriteDossiers_ (HGLOBAL hText, DWORD dwTextLen, LPRECDossiers lpDossiers, short nLen) ;
API_EXPORT void HDAPI 		DeleteDossiers (HDFILEPOS Idx) ;
API_EXPORT void HDAPI 		DeleteDossiers2 (HANDLE hFile, HDFILEPOS Idx) ;
API_EXPORT void HDAPI 		DeleteDossiers_ (HDFILEPOS Idx) ;
API_EXPORT BOOL HDAPI 		IsDossiersType (LPCSTR lpKey, short nType) ;
API_EXPORT UINT HDAPI		GetDossiersFiche (LPCSTR lpKey) ;
API_EXPORT DWORD HDAPI		GetDossiersLen (LPRECDossiers lpDossiers) ;
API_EXPORT DWORD HDAPI 		GetDossiersSize (LPCSTR lpPath /*= NULL*/) ;
API_EXPORT DWORD HDAPI 		GetDossiersRec (LPCSTR lpPath /*= NULL*/) ;

//  Dossier : Antcdents
//////////////////////////////////////////////////////////////////////
#pragma pack(1)

typedef struct
{
	DOSSIERS_RECORD
	SBOOL		bFullScreen ;		// Mode plein cran
	BYTE		cLast ;				// Si mode plein cran, rubrique active
	BYTE		cWarning ;			// Alarme par antcdents
	BYTE		cFistView395 ;		// Premier acces en version 3.95
	BYTE		Extension [14] ;	// Rserve pour extension
} TYPEDEF (RECAntecedents) ;

#pragma pack()

API_EXPORT HGLOBAL HDAPI 	OpenAntecedents (LPCSTR lpPath /*= NULL*/) ;
API_EXPORT void HDAPI 		CloseAntecedents (HGLOBAL) ;
API_EXPORT void HDAPI 		FlushAntecedents () ;
API_EXPORT LPSTR HDAPI 		MakeAntecedentsKey (LPSTR lpKey, USHORT uFiche) ;
API_EXPORT HGLOBAL HDAPI 	ReadAntecedents (HDFILEPOS Idx, LPRECAntecedents lpAntecedents) ;
API_EXPORT HDFILEPOS HDAPI 	WriteAntecedents (HGLOBAL hRec, LPRECAntecedents lpAntecedents) ;
API_EXPORT void HDAPI 		DeleteAntecedents (HDFILEPOS Idx) ;

//  Dossier : Consultations
//////////////////////////////////////////////////////////////////////
#pragma pack(1)

typedef struct
{
	DOSSIERS_RECORD
	char		szZone1 [25] ;		// Zone supplmentaire 1
	char		szZone2 [25] ;		// Zone supplmentaire 2
	char		szZone3 [25] ;		// Zone supplmentaire 3
	char		szZone4 [25] ;		// Zone supplmentaire 4
	char		szSoundPath [13] ;	// Nom du fichier son associ
	char		szBitmapPath [13] ;	// Nom du fichier image associ
#ifdef IMS_VERSION
	ULONG		uIDIMS ;			// Identifiant IMS
	BYTE		Extension [12] ;	// Rserve pour extension
#else // IMS_VERSION
	BYTE		Extension [16] ;	// Rserve pour extension
#endif // IMS_VERSION
} TYPEDEF (RECConsultations) ;

#pragma pack()

API_EXPORT HGLOBAL HDAPI 	OpenConsultations (LPCSTR lpPath /*= NULL*/) ;
API_EXPORT void HDAPI 		CloseConsultations (HGLOBAL) ;
API_EXPORT void HDAPI 		FlushConsultations () ;
API_EXPORT LPSTR HDAPI		MakeConsultationsKey (LPSTR lpKey, USHORT uFiche, HDDATE Date, HDTIME Time) ;
API_EXPORT HGLOBAL HDAPI 	ReadConsultations (HDFILEPOS Idx, LPRECConsultations lpConsultations) ;
API_EXPORT HDFILEPOS HDAPI 	WriteConsultations (HGLOBAL hRec, LPRECConsultations lpConsultations) ;
API_EXPORT void HDAPI 		DeleteConsultations (HDFILEPOS Idx) ;

//  Dossier : Ordonnances
//////////////////////////////////////////////////////////////////////
#pragma pack(1)

typedef struct
{
	DOSSIERS_RECORD
	SBOOL		bType ;				// VRAI si ordonnnance type
	char		szTitle [81] ;		// Titre d'une ordonnance type
	USHORT		uStartOfText ;		// Premiere ligne  sauvegarder
	USHORT		uEndOfText ;		// Dernire ligne  sauvegarder
	BYTE		Extension [12] ;	// Rserve pour extension
} TYPEDEF (RECOrdonnances) ;

#pragma pack()

API_EXPORT HGLOBAL HDAPI 	OpenOrdonnances (LPCSTR lpPath /*= NULL*/) ;
API_EXPORT void HDAPI 		CloseOrdonnances (HGLOBAL) ;
API_EXPORT void HDAPI 		FlushOrdonnances () ;
API_EXPORT LPSTR HDAPI 		MakeOrdonnancesKey (LPSTR lpKey, USHORT uFiche, HDDATE Date, HDTIME Time) ;
API_EXPORT HGLOBAL HDAPI 	ReadOrdonnances (HDFILEPOS Idx, LPRECOrdonnances lpOrdonnances, int nText /*= TEXT_RTF*/) ;
API_EXPORT HDFILEPOS HDAPI 	WriteOrdonnances (HGLOBAL hText, HGLOBAL hRTF, HGLOBAL hForm, LPRECOrdonnances lpOrdonnances) ;
API_EXPORT HDFILEPOS HDAPI 	WriteOrdonnances2 (HGLOBAL hText, LPRECOrdonnances lpOrdonnances) ;
API_EXPORT void HDAPI 		DeleteOrdonnances (HDFILEPOS Idx) ;

//  Dossier : Courrier
//////////////////////////////////////////////////////////////////////
#pragma pack(1)

typedef struct
{
	DOSSIERS_RECORD
	SBOOL		bRecu ;				// VRAI si reu
	HDDATE		DateDoc ;			// Date du document
	char		szDest [21] ;		// Nom du destinataire
	char		szExp [21] ;		// Nom de l'expediteur
	char		szInfo [41] ;		// Information (Classement)
	char		szBitmapPath [13] ;	// Nom du fichier image associ
	USHORT		uStartOfText ;		// Premiere ligne  sauvegarder
	USHORT		uEndOfText ;		// Dernire ligne  sauvegarder
	BYTE		Extension [12] ;	// Rserve pour extension
} TYPEDEF (RECCourriers) ;

#pragma pack()

API_EXPORT HGLOBAL HDAPI 	OpenCourriers (LPCSTR lpPath /*= NULL*/) ;
API_EXPORT void HDAPI 		CloseCourriers (HGLOBAL) ;
API_EXPORT void HDAPI 		FlushCourriers () ;
API_EXPORT LPSTR HDAPI 		MakeCourriersKey (LPSTR lpKey, USHORT uFiche, HDDATE Date, HDTIME Time) ;
API_EXPORT HGLOBAL HDAPI 	ReadCourriers (HDFILEPOS Idx, LPRECCourriers lpCourriers, BOOL bRTF /*= TRUE*/) ;
API_EXPORT HDFILEPOS HDAPI 	WriteCourriers (HGLOBAL hText, HGLOBAL hRTF, LPRECCourriers lpCourriers) ;
API_EXPORT HDFILEPOS HDAPI 	WriteCourriers2 (HGLOBAL hText, LPRECCourriers lpCourriers) ;
API_EXPORT void HDAPI 		DeleteCourriers (HDFILEPOS Idx) ;

//  Dossier : Compte Rendu Opratoires
//////////////////////////////////////////////////////////////////////
#pragma pack(1)

typedef struct
{
	DOSSIERS_RECORD
	SBOOL		bRecu ;				// VRAI si reu
	HDDATE		DateDoc ;			// Date du document
	char		szDest [21] ;		// Nom du destinataire
	char		szExp [21] ;		// Nom de l'expediteur
	char		szInfo [41] ;		// Information (Classement)
	char		szBitmapPath [13] ;	// Nom du fichier image associ
	USHORT		uStartOfText ;		// Premiere ligne  sauvegarder
	USHORT		uEndOfText ;		// Dernire ligne  sauvegarder
	BYTE		Extension [12] ;	// Rserve pour extension
} TYPEDEF (RECCompteRendus) ;

#pragma pack()

API_EXPORT HGLOBAL HDAPI 	OpenCompteRendus (LPCSTR lpPath /*= NULL*/) ;
API_EXPORT void HDAPI 		CloseCompteRendus (HGLOBAL) ;
API_EXPORT void HDAPI 		FlushCompteRendus () ;
API_EXPORT LPSTR HDAPI 		MakeCompteRendusKey (LPSTR lpKey, USHORT uFiche, HDDATE Date, HDTIME Time) ;
API_EXPORT HGLOBAL HDAPI 	ReadCompteRendus (HDFILEPOS Idx, LPRECCompteRendus lpCompteRendus, BOOL bRTF /*= TRUE*/) ;
API_EXPORT HDFILEPOS HDAPI 	WriteCompteRendus (HGLOBAL hText, HGLOBAL hRTF, LPRECCompteRendus lpCompteRendus) ;
API_EXPORT HDFILEPOS HDAPI 	WriteCompteRendus2 (HGLOBAL hText, LPRECCompteRendus lpCompteRendus) ;
API_EXPORT void HDAPI 		DeleteCompteRendus (HDFILEPOS Idx) ;

//  Dossier : Vaccins / Examens
//////////////////////////////////////////////////////////////////////
#pragma pack(1)

typedef struct
{
	DOSSIERS_RECORD
	SBOOL		bVaccin ;				// VRAI si vaccin
	char		szText [SIZE_VACCIN] ;	// Libell du vaccins
	HDDATE		Rappel ;				// Date du rappel
	SBOOL		bRappel ;				// Rappel effectu
	BYTE		nTypeRappel ;			// Type du rappel (Rappel - Lecture - Contrle)
	BYTE		nType ;					// Type (VACCIN_VACCIN, VACCIN_EXAMEN)
	BYTE		Extension [14] ;		// Rserve pour extension
} TYPEDEF (RECVaccins) ;

#pragma pack()

API_EXPORT HGLOBAL HDAPI 	OpenVaccins (LPCSTR lpPath /*= NULL*/) ;
API_EXPORT void HDAPI 		CloseVaccins (HGLOBAL) ;
API_EXPORT void HDAPI 		FlushVaccins () ;
API_EXPORT LPSTR HDAPI 		MakeVaccinsKey (LPSTR lpKey, USHORT uFiche, HDDATE Date, HDTIME Time) ;
API_EXPORT HGLOBAL HDAPI 	ReadVaccins (HDFILEPOS Idx, LPRECVaccins lpVaccins) ;
API_EXPORT HDFILEPOS HDAPI 	WriteVaccins (HGLOBAL hRec, LPRECVaccins lpVaccins) ;
API_EXPORT void HDAPI 		DeleteVaccins (HDFILEPOS Idx) ;

//  Dossier : Biologies (formulaire version 3.5)
//////////////////////////////////////////////////////////////////////
#pragma pack(1)

typedef struct
{
	DOSSIERS_RECORD
	char		szTitre [41] ;			// Titre de la fiche
	struct
	{
		char	szLibelle [31] ;		// Nom de la rubrique
		char	szResultat [11] ;		// Resultat
		char	szUnite [11] ;			// Unite du resultat
		SBOOL	bWarning ;				// Alarme
	} Rub [MAX_BIOLOGIES35] ;
	char		szPathName [13] ;		// Nom du fichier texte/image associ
	BYTE		Extension [16] ;		// Rserve pour extension
} TYPEDEF (RECBiologies35) ;

#pragma pack()

API_EXPORT HGLOBAL HDAPI 	OpenBiologies35 (LPCSTR lpPath /*= NULL*/) ;
API_EXPORT void HDAPI 		CloseBiologies35 (HGLOBAL) ;
API_EXPORT void HDAPI 		FlushBiologies35 () ;
API_EXPORT LPSTR HDAPI 		MakeBiologies35Key (LPSTR lpKey, USHORT uFiche, HDDATE Date, HDTIME Time) ;
API_EXPORT HGLOBAL HDAPI 	ReadBiologies35 (HDFILEPOS Idx, LPRECBiologies35 lpBiologies35) ;
API_EXPORT HDFILEPOS HDAPI 	WriteBiologies35 (HGLOBAL hRec, LPRECBiologies35 lpBiologies35) ;
API_EXPORT void HDAPI 		DeleteBiologies35 (HDFILEPOS Idx) ;

//  Dossier : Biologie (formulaire ou texte)
//////////////////////////////////////////////////////////////////////
#pragma pack(1)

typedef struct
{
	DOSSIERS_RECORD
	char		szTitre [41] ;			// Titre de la fiche
	char		szPathName [13] ;		// Nom du fichier texte/image associ
	BYTE		Extension [16] ;		// Rserve pour extension
} TYPEDEF (RECBiologies) ;

#pragma pack()

API_EXPORT HGLOBAL HDAPI 	OpenBiologies (LPCSTR lpPath /*= NULL*/) ;
API_EXPORT void HDAPI 		CloseBiologies (HGLOBAL) ;
API_EXPORT void HDAPI 		FlushBiologies () ;
API_EXPORT LPSTR HDAPI 		MakeBiologiesKey (LPSTR lpKey, USHORT uFiche, HDDATE Date, HDTIME Time) ;
API_EXPORT HGLOBAL HDAPI 	ReadBiologies (HDFILEPOS Idx, LPRECBiologies lpBiologies) ;
API_EXPORT HDFILEPOS HDAPI 	WriteBiologies (HGLOBAL hRec, LPRECBiologies lpBiologies) ;
API_EXPORT void	 HDAPI 		DeleteBiologies (HDFILEPOS Idx) ;

//  Dossier : Notes
//////////////////////////////////////////////////////////////////////
#pragma pack(1)

typedef struct
{
	DOSSIERS_RECORD
	BYTE		Extension [16] ;	// Rserve pour extension
} TYPEDEF (RECNotes) ;

#pragma pack()

API_EXPORT HGLOBAL HDAPI 	OpenNotes (LPCSTR lpPath /*= NULL*/) ;
API_EXPORT void HDAPI 		CloseNotes (HGLOBAL) ;
API_EXPORT void HDAPI 		FlushNotes () ;
API_EXPORT LPSTR HDAPI 		MakeNotesKey (LPSTR lpKey, USHORT uFiche) ;
API_EXPORT HGLOBAL HDAPI 	ReadNotes (HDFILEPOS Idx, LPRECNotes lpNotes) ;
API_EXPORT HDFILEPOS HDAPI 	WriteNotes (HGLOBAL hRec, LPRECNotes lpNotes) ;
API_EXPORT void HDAPI 		DeleteNotes (HDFILEPOS Idx) ;


//  Dossier : Images
//////////////////////////////////////////////////////////////////////
#pragma pack(1)

typedef struct
{
	DOSSIERS_RECORD
	short		nType ;				// Type de l'image
	char		szTitre [41] ;		// Titre de l'image
	HDDATE		DateDoc ;			// Date du document
	char		szExp [21] ;		// Nom de l'expediteur
	char		szInfo [41] ;		// Information (Classement)
	char		szText [256] ;		// Texte descriptif
	BYTE		cFormat ;			// Format de l'image : PICTURE_DIB, PICTURE_TIFF, etc
	BYTE		cZip ;				// Compress avec ZLib
	DWORD		dwBitmapLen ;		// Taille exacte de l'image
	WORD		wZipLen ;			// Taille exacte de l'image compresse
	BYTE		Extension [8] ;		// Rserve pour extension
} TYPEDEF (RECBitmaps) ;

#pragma pack()

API_EXPORT HGLOBAL HDAPI 	OpenBitmaps (LPCSTR lpPath /*= NULL*/) ;
API_EXPORT void HDAPI 		CloseBitmaps (HGLOBAL) ;
API_EXPORT void HDAPI 		FlushBitmaps () ;
API_EXPORT LPSTR HDAPI 		MakeBitmapsKey (LPSTR lpKey, USHORT uFiche, HDDATE Date, HDTIME Time) ;
API_EXPORT HGLOBAL HDAPI 	ReadBitmaps (HDFILEPOS Idx, LPRECBitmaps lpBitmaps, BOOL bUnCompress /*= TRUE*/) ;
API_EXPORT HDFILEPOS HDAPI 	WriteBitmaps (HGLOBAL hBuffer, DWORD dwLen, LPRECBitmaps lpBitmaps, int nZip /*= BMP_ZIP*/) ;
API_EXPORT void HDAPI 		DeleteBitmaps (HDFILEPOS Idx) ;

//  Dossier : Pices jointes
//////////////////////////////////////////////////////////////////////
#pragma pack(1)

typedef struct
{
	DOSSIERS_RECORD
	SBOOL		bRecu ;				// VRAI si reu
	HDDATE		DateDoc ;			// Date du document
	char		szDest [21] ;		// Nom du destinataire
	char		szExp [21] ;		// Nom de l'expediteur
	char		szTitre [41] ;		// Titre de la pice jointe
	char		szInfo [81] ;		// Information (Classement)
	char		szFilename [256] ;	// Nom du fichier
	SBOOL		bInterne ;			// VRAI si le fichier est dans le dossier
	BYTE		cZip ;				// Compress avec ZLib
	DWORD		dwPieceJointeLen ;	// Taille exacte de la pice jointe
	WORD		wZipLen ;			// Taille exacte de la pice jointe compresse
	BYTE		Extension [16] ;	// Rserve pour extension
} TYPEDEF (RECPiecesJointes) ;

#pragma pack()

API_EXPORT HGLOBAL HDAPI 	OpenPiecesJointes (LPCSTR lpPath /*= NULL*/) ;
API_EXPORT void HDAPI 		ClosePiecesJointes (HGLOBAL) ;
API_EXPORT void HDAPI 		FlushPiecesJointes () ;
API_EXPORT LPSTR HDAPI 		MakePiecesJointesKey (LPSTR lpKey, USHORT uFiche, HDDATE Date, HDTIME Time) ;
API_EXPORT HGLOBAL HDAPI 	ReadPiecesJointes (HDFILEPOS Idx, LPRECPiecesJointes lpPiecesJointes, BOOL bUnCompress /*= TRUE*/) ;
API_EXPORT HDFILEPOS HDAPI 	WritePiecesJointes (HGLOBAL hBuffer, DWORD dwLen, LPRECPiecesJointes lpPiecesJointes, int nZip /*= PIECEJOINTE_ZIP*/) ;
API_EXPORT void HDAPI 		DeletePiecesJointes (HDFILEPOS Idx) ;

//  Dossier : Infos pour Sesam-Vitale
//////////////////////////////////////////////////////////////////////
#pragma pack(1)

typedef struct
{
	DOSSIERS_RECORD
	BYTE	cTypeIN ;					// Type Immatriculation
	char	szNumeroIN [14] ;			// Numro Immatriculation Nationale
	char	szCleIN [3] ;				// Cl du numro national d'immatriculation
	BYTE	cRang ;						// Rang gmellaire
	char	szQualite [3] ;				// Qualit d'assur ou ayant-droits
	char	szCodeCouverture [6] ;		// Code couverture (facultatif)
	char	szCodeRegime [3] ;			// Code rgime AMO
	char	szCaisseGestion [4] ;		// Caisse gestionnaire AMO
	char	szCentreGestion [5] ;		// Centre gestionnaire AMO
	HDDATE	DateNai ;					// Date de naissance de la carte
	char	szContratReferent [9] ;		// N ADELI du PS avec lequel est pass un contrat rfrent (sans la clef)
	BYTE	cDep ;						// Dpartement Employeur
} TYPEDEF (RECInfoSesam) ;

#pragma pack()

API_EXPORT HGLOBAL HDAPI 	OpenInfoSesam		(LPCSTR lpPath /*= NULL*/) ;
API_EXPORT void HDAPI 		CloseInfoSesam		(HGLOBAL) ;
API_EXPORT void HDAPI 		FlushInfoSesam		() ;
API_EXPORT LPSTR HDAPI 		MakeInfoSesamKey	(LPSTR lpKey, USHORT uFiche) ;
API_EXPORT HGLOBAL HDAPI 	ReadInfoSesam		(HDFILEPOS Idx, LPRECInfoSesam lpInfoSesam) ;
API_EXPORT HDFILEPOS HDAPI 	WriteInfoSesam		(HGLOBAL hRec, LPRECInfoSesam lpInfoSesam) ;
API_EXPORT void HDAPI		UpdateInfoSesam		(LPRECInfoSesam lpInfoSesam) ;
API_EXPORT void HDAPI 		DeleteInfoSesam		(HDFILEPOS Idx) ;


//  Dossier : Infos Situation de Facturation issues du TLA
//////////////////////////////////////////////////////////////////////
#pragma pack(1)

typedef struct
{
	DOSSIERS_RECORD
	char	szSitFactAssurance [3] ;// Nature d'assurance "ML", "MT" ou "AT"
	char	cSitFactDroitCommun ;	// Accident de droit commun "O" ou "N"
	HDDATE	DateSitFactAssurance ;	// Date Assurance (Accident droit commun ou de Maternit ou d'AT selon natute d'ass)
	char	szSitFactNumAT [10] ;	// N AT
	BYTE	Extension [32] ;		// Rserve pour extension
} TYPEDEF (RECSitFactTLA) ;

#pragma pack()

API_EXPORT HGLOBAL HDAPI 	OpenSitFactTLA		(LPCSTR lpPath /*= NULL*/) ;
API_EXPORT void HDAPI 		CloseSitFactTLA		(HGLOBAL) ;
API_EXPORT void HDAPI 		FlushSitFactTLA		() ;
API_EXPORT LPSTR HDAPI 		MakeSitFactTLAKey	(LPSTR lpKey, USHORT uFiche) ;
API_EXPORT HGLOBAL HDAPI 	ReadSitFactTLA		(HDFILEPOS Idx, LPRECSitFactTLA lpSitFactTLA) ;
API_EXPORT HDFILEPOS HDAPI 	WriteSitFactTLA		(HGLOBAL hRec, LPRECSitFactTLA lpSitFactTLA) ;
API_EXPORT void HDAPI		UpdateSitFactTLA		(LPRECSitFactTLA lpSitFactTLA) ;
API_EXPORT void HDAPI 		DeleteSitFactTLA		(HDFILEPOS Idx) ;


// #ifdef HELLOSANTE_VERSION
//  Dossier : Traitements
//////////////////////////////////////////////////////////////////////
#pragma pack(1)

typedef struct
{
	DOSSIERS_RECORD
	USHORT	uTraitement ;						// Numro de traitement
	SBOOL	bAssure ;							// Bnficiaire = assur
	char	szNomAssure [21] ;					// Nom de l'assur
	char	szPrenomAssure [21] ;				// Prnom de l'assur
	char	szAdresse [81] ;					// Adresse
	char	szCPostal [6] ;						// Code Postal
	char	szVille [21] ;						// Ville
	char	szNumSS [31] ;						// Numro de scurit sociale
	char	szAMO [SIZE_NAME + 1] ;				// AMO
	char	szAMC [SIZE_NAME + 1] ;				// AMC
	char	szPrescripteur [SIZE_NAME + 1] ;	// Code Prescripteur
	HDDATE	DatePresc ;							// Date prescription
	char	szAdresseVisite [81] ;				// Adresse de la visite
	char	szCPostalVisite [6] ;				// Code Postal de la visite
	char	szVilleVisite [21] ;				// Ville de la visite
	BOOL	bEntente ;							// Entente pralable
	UINT	uRepEntente ;						// Code entente pralable (0: pas de rep sous 10 jrs, 4: rep favorable, 5: urgence)
	char	szIdentEP [16] ;					// Ident. entente pralable
	HDDATE	DateEntente ;						// Date entente

	HDDATE	DateAss ;							// Date assurance
	BOOL	bMaladie ;							// Indicateur assurance Maladie
	BOOL	bAccident ;							// Indicateur assurance Accident
	BOOL	bMaternite ;						// Indicateur assurance Maternit
	UINT	unDroitCommun ;						// Indicateur accident de droit commun (Maladie), Date grossesse (Maternit) ou Date AT (Accident)
	char	szNumAT [9] ;						// Numro d'accident de travail
	char	cCleAT ;							// Cl du numro d'accident de travail

	HDDATE	DateLastVisite ;					// Date dernire visite
	HDDATE	DateNextVisite ;					// Date prochaine visite
	SBOOL	bCloture ;							// Traitement cltur
	SBOOL	bWaitCloture ;						// Traitement en cours de clture
	struct
	{
		SBOOL	bKms ;							// FALSE = Acte / TRUE = Kilometres
		LONG	lQPrevue ;						// Quantit prvue
		LONG	lQPlanifiee ;					// Quantit planifie
		LONG	lQPointee ;						// Quantit effectue
		LONG	lQFacturee ;					// Quantit facture
		char	szCode [SIZE_CODE + 1] ;		// Code acte
		char	szNomenclature [SIZE_CODE + 1] ;// Nomenclature
		double	dMontant ;						// Montant pour ce mode
		double	dCoef ;							// Coefficient
		char	cNumTM ;						// Ticket Modrateur
		char	cCodeJust ;						// Justificatif de dpense
		BYTE	Extension [30] ;				// Rserve pour extension
	} Actes [10] ;
	USHORT	uSeanceID ;							// N de la dernire sance
	SBOOL	bEuro ;								// VRAI si traitement en Euro


	HDDATE	DateDemande ;						// Date de la demande d'entente
	SBOOL	bAttenteRep ;						// En attente de rponse DEP
	SBOOL	bUrgent ;							// Traitement urgent
	BYTE	Extension [38] ;					// Rserve pour extension

} TYPEDEF (RECTraitements) ;

#pragma pack()

API_EXPORT HGLOBAL HDAPI 	OpenTraitements		(LPCSTR lpPath /*= NULL*/) ;
API_EXPORT void HDAPI 		CloseTraitements	(HGLOBAL) ;
API_EXPORT void HDAPI 		FlushTraitements	() ;
API_EXPORT LPSTR HDAPI 		MakeTraitementsKey	(LPSTR lpKey, USHORT uFiche, HDDATE Date, HDTIME Time) ;
API_EXPORT HGLOBAL HDAPI 	ReadTraitements		(HDFILEPOS Idx, LPRECTraitements lpTraitements) ;
API_EXPORT HDFILEPOS HDAPI 	WriteTraitements	(HGLOBAL hRec, LPRECTraitements lpTraitements) ;
API_EXPORT void HDAPI 		DeleteTraitements	(HDFILEPOS Idx) ;

API_EXPORT HDFILEPOS HDAPI 	AddTraitements		(LPCSTR lpPath /*= NULL*/, HGLOBAL hRec, LPRECTraitements lpTraitements) ;
API_EXPORT HDFILEPOS HDAPI	ChangeTraitements	(LPCSTR lpPath /*= NULL*/, HDFILEPOS Idx, HGLOBAL hRec, LPRECTraitements lpTraitements) ;
API_EXPORT BOOL HDAPI	 	RemoveTraitements	(LPCSTR lpPath /*= NULL*/, HDFILEPOS Idx) ;

// #endif	// HELLOSANTE_VERSION

//////////////////////////////////////////////////////////////////////
//
//  Fichiers CD-ROM VIDAL
//
//////////////////////////////////////////////////////////////////////
#define MAX_RUB				24

#pragma pack(1)

typedef struct
{
	char	szCle [78] ;			// Cl d'acces
	WORD	wIdx ;					// Numro d'index
} TYPEDEF (RECVIDALSpecials) ;

typedef struct
{
	char		szName [72] ;		// Nom mdicament
	short		nFiller1 ;
	short		nFiller2 ;
	char		szOrigine [10] ;
	DWORD		dwBegin ;			// Ligne de dbut (Len=86)
	USHORT		uLen ;				// Nombre de lignes
	short		nFiller3 ;
	short		nFiller4 ;
	WORD		Rub [MAX_RUB] ;		// Position des rubriques
} TYPEDEF (RECVIDALRubriques) ;

#pragma pack()

API_EXPORT HGLOBAL HDAPI 	OpenVIDALSpecials (LPCSTR lpPath) ;
API_EXPORT void HDAPI 		CloseVIDALSpecials (HGLOBAL hRec) ;
API_EXPORT int HDAPI 		GetOpenFlagVIDALSpecials () ;
API_EXPORT HANDLE HDAPI		GetHFileVIDALSpecials () ;

API_EXPORT HGLOBAL HDAPI 	OpenVIDALRubriques (void) ;
API_EXPORT void HDAPI 		CloseVIDALRubriques (HGLOBAL hRec) ;
API_EXPORT int HDAPI 		GetOpenFlagVIDALRubriques () ;
API_EXPORT HANDLE HDAPI		GetHFileVIDALRubriques () ;

API_EXPORT HGLOBAL HDAPI 	OpenVIDALDocuments (void) ;
API_EXPORT void HDAPI 		CloseVIDALDocuments (HGLOBAL hRec) ;
API_EXPORT int HDAPI 		GetOpenFlagVIDALDocuments () ;
API_EXPORT HANDLE HDAPI		GetHFileVIDALDocuments () ;

//////////////////////////////////////////////////////////////////////
//
//  Fichiers CD-ROM MEDIAVIDAL
//
//////////////////////////////////////////////////////////////////////
#define	MEDIAVIDALLEN	1 + 30 + 1 + 4	// Type de libell + Libell + Type produit + DupKey

#pragma pack(1)

typedef struct
{
	int		nType ;					// Type de libell (PHARMLIB_MEDICAMENT / PHARMLIB_SUBSTANCE / PHARMLIB_LABO)
	char	szNom [121] ;			// Libell
	char	szPtr [8] ;				// Pointeur mdicament
	long	lProd ;					// Type de produit
} TYPEDEF (RECMediaVidal) ;

#pragma pack()

API_EXPORT BOOL HDAPI		CreatMediaVidal (LPCSTR lpPath) ;
API_EXPORT HGLOBAL HDAPI 	OpenMediaVidal (LPCSTR lpPath) ;
API_EXPORT void HDAPI 		CloseMediaVidal (HGLOBAL) ;
API_EXPORT void HDAPI 		FlushMediaVidal () ;
API_EXPORT LPSTR HDAPI 		MakeMediaVidalKey (LPSTR lpKey, int nType, LPCSTR lpDesc, long lProd) ;
API_EXPORT int HDAPI 		GetOpenFlagMediaVidal () ;
API_EXPORT HANDLE HDAPI		GetHFileMediaVidal () ;
API_EXPORT HDFILEPOS HDAPI	FindFirstMediaVidal (LPRECMediaVidal lpMediaVidal) ;
API_EXPORT HDFILEPOS HDAPI	FindNextMediaVidal (LPRECMediaVidal lpMediaVidal) ;
API_EXPORT BOOL HDAPI 		WriteMediaVidal (LPRECMediaVidal lpMediaVidal) ;

//////////////////////////////////////////////////////////////////////
//
//  Fichiers DATASEMP
//
//////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////
//
//  Fichier bote d'arrive
//
//////////////////////////////////////////////////////////////////////
#define	INBOXLEN1			30				// User + Date + Time
#define	INBOXLEN2			32				// User + Type + Date + Time

#define INBOX_BY_DATE		0
#define INBOX_BY_TYPE		1

#pragma pack(1)

typedef struct
{
	WORD		wStatus ;					// Etat enregistrement (0 = OK)
	HDDATE		Date ;						// Date du message
	HDTIME		Time ;						// Heure du message
	char		szUser [SIZE_USER] ;		// Nom du destinataire du message
	short		nType ;						// Type du message (MSG_MESSAGE, MSG_EMAIL,...)
	char		szSender [41] ;				// Nom de l'expditeur
	char		szSubject [81] ;			// Objet
	char		szText [512] ;				// Corps du message
	char		szFileName [14] ;			// Nom du fichier associ
	SBOOL		bRead ;						// VRAI si message lu
	BYTE		Extension [40] ;			// Rserve pour extension
} TYPEDEF (RECInbox) ;

#pragma pack()

API_EXPORT BOOL HDAPI 		CreatInbox (LPCSTR lpPath /*= NULL*/) ;
API_EXPORT HGLOBAL HDAPI 	OpenInbox (LPCSTR lpPath /*= NULL*/) ;
API_EXPORT void HDAPI 		CloseInbox (HGLOBAL) ;
API_EXPORT void HDAPI 		FlushInbox () ;
API_EXPORT int HDAPI 		GetOpenFlagInbox () ;
API_EXPORT LPSTR HDAPI 		MakeInbox1Key (LPSTR lpKey, LPCSTR lpUser, HDDATE Date, HDTIME Time) ;
API_EXPORT LPSTR HDAPI 		MakeInbox2Key (LPSTR lpKey, LPCSTR lpUser, int nType, HDDATE Date, HDTIME Time) ;
API_EXPORT HDFILEPOS HDAPI 	ReadInbox (LPRECInbox lpInbox, int nKey) ;
API_EXPORT BOOL HDAPI 		WriteInbox (LPRECInbox lpInbox) ;
API_EXPORT BOOL HDAPI 		DeleteInbox (HDFILEPOS Idx) ;
API_EXPORT HDFILEPOS HDAPI 	AddRecInbox (LPRECInbox lpInbox) ;
API_EXPORT BOOL HDAPI 		DelRecInbox (HDFILEPOS Idx) ;
API_EXPORT DWORD HDAPI 		GetInboxSize (LPCSTR lpPath /*= NULL*/) ;
API_EXPORT DWORD HDAPI 		GetInboxRec (LPCSTR lpPath /*= NULL*/) ;

//////////////////////////////////////////////////////////////////////
//
//  Fichier messagerie
//
//////////////////////////////////////////////////////////////////////
#define	MAILLEN1			30			// User + Date + Time
#define	MAILLEN2			32			// User + Type + Date + Time

#define MAIL_BY_DATE		0
#define MAIL_BY_TYPE		1

#define MAIL_HEADER_SIZE	128
#define MAIL_RECORD_IDENT	0x4C4D4448	// "HDML"

// Header du fichier
//////////////////////////////////////////////////////////////////////
#pragma pack(1)

typedef struct
{
	DWORD		dwIdent ;				// "HDML" (0x4C4D4448)
	WORD		wStatus ;				// Etat fichier (0 = Ok)
	HDFILEPOS	Delete ;				// Chaine des enregistrements supprims
	DWORD		dwMaxSize ;				// Taille du plus grand enregistrement supprim
	DWORD		dwLen ;					// Longueure du fichier
	DWORD		dwRec ;					// Nombre d'enregistrements total
	DWORD		dwDel ;					// Nombre d'enregistrements supprims
   	BYTE		Filler [MAIL_HEADER_SIZE - (sizeof (DWORD) + sizeof (WORD) + sizeof (HDFILEPOS) + sizeof (USHORT) + sizeof (DWORD) + sizeof (DWORD) + sizeof (DWORD))] ;
} TYPEDEF (MAIL_HEADER) ;

#pragma pack()

// Enregistrement
//////////////////////////////////////////////////////////////////////
#pragma pack(1)

typedef struct
{
	DWORD		dwIdent ;					// "HDML" (0x4C4D4448)
	WORD		wStatus ;					// Etat enregistrement (0 = OK)
	HDDATE		Date ;						// Date du message
	HDTIME		Time ;						// Heure du message
	SHORT		nDirection ;				// Sens de transfer (MSG_IN, MSG_OUT, MSG_XFR)
	char		szUser [SIZE_USER] ;		// Nom du destinataire du message
	short		nType ;						// Type du message (MSG_MESSAGE, MSG_EMAIL,...)
	char		szSender [128] ;			// Nom de l'expditeur
	char		szSubject [128] ;			// Objet
	SBOOL		bRead ;						// VRAI si message lu
	USHORT		uRecLen ;					// Longueure de l'enregistrement de longueure fixe
	DWORD		dwLength ;					// Longueure totale de l'enregistrement (structure fixe + texte)
	BYTE		Extension [128] ;			// Rserve pour extension
} TYPEDEF (RECMail) ;

#pragma pack()

API_EXPORT BOOL HDAPI		CreatMail		(LPCSTR lpPath /* = NULL*/) ;
API_EXPORT HGLOBAL HDAPI	OpenMail		(LPCSTR lpPath /* = NULL*/) ;
API_EXPORT BOOL HDAPI		CreatMail2		(UINT uIDFile, UINT uIDIndex, LPCSTR lpPath /* = NULL*/) ;
API_EXPORT HGLOBAL HDAPI	OpenMail2		(UINT uIDFile, UINT uIDIndex, LPCSTR lpPath /* = NULL*/) ;
API_EXPORT void HDAPI		CloseMail		(HGLOBAL hRec) ;

API_EXPORT void HDAPI		FlushMail		() ;
API_EXPORT int HDAPI		GetOpenFlagMail () ;

API_EXPORT LPSTR HDAPI		MakeMail1Key	(LPSTR lpKey, LPCSTR lpUser, HDDATE Date, HDTIME Time) ;
API_EXPORT LPSTR HDAPI		MakeMail2Key	(LPSTR lpKey, LPCSTR lpUser, int nType, HDDATE Date, HDTIME Time) ;

API_EXPORT HGLOBAL HDAPI	ReadMail3		(HANDLE hFile, HDFILEPOS Idx, LPRECMail lpMail) ;
API_EXPORT HGLOBAL HDAPI	ReadMail2		(HDFILEPOS Idx, LPRECMail lpMail) ;
API_EXPORT HGLOBAL HDAPI	ReadMail1		(LPRECMail lpMail, int nKey) ;

API_EXPORT HDFILEPOS HDAPI	WriteMail2		(HANDLE hFile, HGLOBAL hText, DWORD dwTextLen, LPRECMail lpMail) ;
API_EXPORT HDFILEPOS HDAPI	WriteMail		(HGLOBAL hText, DWORD dwTextLen, LPRECMail lpMail) ;

API_EXPORT void HDAPI		DeleteMail2		(HANDLE hFile, HDFILEPOS Idx) ;
API_EXPORT void HDAPI		DeleteMail		(HDFILEPOS Idx) ;

API_EXPORT DWORD HDAPI		GetMailRec		(LPCSTR lpPath) ;
API_EXPORT DWORD HDAPI		GetMailSize		(LPCSTR lpPath) ;

//////////////////////////////////////////////////////////////////////
//
//	KEYWORDS
//
//////////////////////////////////////////////////////////////////////
#define	KEYWORDSMAX			25 // longueur maxi de mot-cl
#define KEYWORDSLEN			KEYWORDSMAX + 7 // longueur cl d'index

API_EXPORT BOOL HDAPI		CreatKeywords (LPCSTR lpPath) ;
API_EXPORT BOOL HDAPI		OpenKeywords (LPCSTR lpPath) ;
API_EXPORT void HDAPI		CloseKeywords () ;
API_EXPORT void HDAPI		FlushKeywords () ;
API_EXPORT int HDAPI 		GetOpenFlagKeywords () ;
API_EXPORT LPSTR HDAPI		MakeKeywordsKey (LPSTR lpKey, LPCSTR lpKeyword) ;
API_EXPORT LPSTR HDAPI		MakeKeywordsKey1 (LPSTR lpKey, LPCSTR lpKeyword, UINT nType) ;
API_EXPORT HDFILEPOS HDAPI	ReadKeywords (LPSTR lpKeywords) ;
API_EXPORT BOOL HDAPI		WriteKeywords (LPSTR lpKeywords, HDFILEPOS Idx, UINT nType) ;
//API_EXPORT BOOL HDAPI		DeleteKeywords (HDFILEPOS Idx) ;
API_EXPORT BOOL HDAPI		DeleteKeywords (LPSTR lpKeywords, UINT nType, HDFILEPOS Idx) ;

//////////////////////////////////////////////////////////////////////
//
//	LIEN PATIENT - CARTE VITALE
//
//////////////////////////////////////////////////////////////////////
#define LIENVITALELEN		22	// Numro + Date naissance + Rang gemellaire

#pragma pack(1)

typedef struct
{
	char	szNumIN [14] ;		// Numro d'imatriculation nationale (scurit sociale)
	HDDATE	DateNai ;			// Date de naissance
	char	cRangGemellaire ;	// Rang gmellaire de l'assur
} TYPEDEF (RECLienVitale) ;

#pragma pack()

API_EXPORT BOOL HDAPI		CreatLienVitale (LPCSTR lpPath) ;
API_EXPORT BOOL HDAPI		OpenLienVitale (LPCSTR lpPath) ;
API_EXPORT void HDAPI		CloseLienVitale () ;
API_EXPORT void HDAPI		FlushLienVitale () ;
API_EXPORT int HDAPI 		GetOpenFlagLienVitale () ;
API_EXPORT LPSTR HDAPI		MakeLienVitaleKey (LPSTR lpKey, LPRECLienVitale lpRecLV) ;
API_EXPORT HDFILEPOS HDAPI	ReadLienVitale (LPRECLienVitale lpRecLV) ;	// GTEKEY
API_EXPORT HDFILEPOS HDAPI	FindLienVitale (LPRECLienVitale lpRecLV) ;	// EQLKEY
API_EXPORT BOOL HDAPI		WriteLienVitale (LPRECLienVitale lpRecLV, HDFILEPOS Idx) ;
API_EXPORT BOOL HDAPI		DeleteLienVitale (LPRECLienVitale lpRecLV) ;
//API_EXPORT BOOL HDAPI		DeleteAllLienVitale (HDFILEPOS Idx) ;


//////////////////////////////////////////////////////////////////////
//
//  SESAM-VITALE
//
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
//
//  Fichier FSE
//
//////////////////////////////////////////////////////////////////////
// - Contient les deux formes (non compile par les API et compile par
// les API si l'indicateur de tri est renseign)
// - A t transfr en lot si le numro et la date de lot ont t
// renseignes

#define	FSELEN1				14			// Date + Time (8 + 6)
#define	FSELEN2				22			// szUser + Date + Time (8 + 8 + 6)
#define	FSELEN3				27			// uFiche + szUser + Date + Time (5 + 8 + 8 + 6)

#ifdef TLA_VERSION

#define	FSELEN4				26			// wFlagState + szUser + Date + Time (4 + 8 + 8 + 6)
#define FSELEN5				54			// szCritereLot + Date + Time (40 + 8 + 6)

#else	// TLA_VERSION

#define	FSELEN4				25			// wFlagState + szUser + Date + Time (3 + 8 + 8 + 6)
#define FSELEN5				39			// szCritereLot + Date + Time (25 + 8 + 6)

#endif	// TLA_VERSION

#define FSE_BY_DATE			0			// clef sur date et heure
#define FSE_BY_USER			1			// clef sur medecin (szNumIF)
#define FSE_BY_UFICH		2			// clef sur patient (uFiche) + medecin (szNumIF)
#define FSE_BY_FLAG			3			// clef sur tat (wFlagState) + medecin (szNumIF)
#define FSE_BY_CRITERE		4			// clef sur numro de critere

#define	FSE_STATE_API		1			// 00000000 00000001 // compile sous forme SESAM-Vitale
#define	FSE_STATE_LOT		2			// 00000000 00000010 // transfre en lot
#define	FSE_STATE_ARL_OK	4			// 00000000 00000100 // recu ARL positif
#define	FSE_STATE_ARL_NOK	8			// 00000000 00001000 // recu ARL negatif :  supprimer ou rmettre
#define	FSE_STATE_2X		16			// 00000000 00010000 // recu deux ARL negatifs ou MSF conscutifs : bloque
#define	FSE_STATE_MANUEL	32			// 00000000 00100000 // bloque traite en manuel
#define	FSE_STATE_MSF		64			// 00000000 01000000 // a reu un MSF
#define	FSE_STATE_DELETED	128			// 00000000 10000000 // Enregistrement effac
#define	FSE_STATE_CANCELED	256			// 00000001 00000000 // Enregistrement annul
#define	FSE_STATE_DOMANUAL	512			// 00000010 00000000 // bloque,  traiter manuellement
#define	FSE_STATE_WAIT_TLA	1024		// 00000100 00000000 // FSE en attente de chargement sur TLA
#define	FSE_STATE_ON_TLA	2048		// 00001000 00000000 // FSE charge sur TLA

#define FSE_HEADER_SIZE		128
#define FSE_RECORD_IDENT	0x56534448	// "HDSV"

//	Header du fichier
//////////////////////////////////////////////////////////////////////
#pragma pack(1)

typedef struct
{
	DWORD		dwIdent ;				// "HDSV" (0x56534448)
	WORD		wStatus ;				// Etat fichier (0 = Ok)
	HDFILEPOS	Delete ;				// Chaine des enregistrements supprims
	USHORT		uMaxSize ;				// Taille du plus grand enregistrement supprim
	DWORD		dwLen ;					// Longueure du fichier
	DWORD		dwRec ;					// Nombres d'enregistrements total
	DWORD		dwDel ;					// Nombres d'enregistrements supprims
   	BYTE		Filler [FSE_HEADER_SIZE - (sizeof (DWORD) + sizeof (WORD) + sizeof (HDFILEPOS) + sizeof (USHORT) + sizeof (DWORD) + sizeof (DWORD) + sizeof (DWORD))] ;
} TYPEDEF (FSE_HEADER) ;

#pragma pack()

//	Enregistrement
//////////////////////////////////////////////////////////////////////
#pragma pack(1)
typedef struct
{

#ifdef TLA_VERSION

	DWORD		dwIdent ;				// "HDSV" (0x56534448)
	WORD		wStatus ;				// Etat enregistrement (0 = OK)
	ULONG		ulNumFSE ;				// Numro de FSE
	USHORT		uFiche ;				// Numro de fiche patient
	HDDATE		Date ;					// Date cration FSE
	HDTIME		Time ;					// Heure de cration FSE
	char		szUser [SIZE_USER] ;	// Nom de l'utilisateur
	char		szNumIF [9] ;			// Numro Identification de facturation du PS
	WORD		wFlagState ;			// Etat de la FSE
	char		szCRL [41] ;			// Critere pour transf en lot (27 pour FSE, 40 pour TLA)
	char		szNumSerieTLA [21] ;	// Numro de srie du lecteur TLA associ
	char		szRefLot [4] ;			// Reference du lot lorsq transf en lot
	HDDATE		DateLot ;				// Date lot
	HDDATE		DateArl ;				// Date de traitement ARL (ajout pour la 1.20b)
	BYTE		Extension [64] ;		// Rserve pour extension (sur 16 pour la 1.10, 14 depuis la 1.20b)
	size_t		TailleBlocFSE1 ;		// taille bloc FSE non API
	size_t		TailleBlocFSE2 ;		// taille bloc FSE API

#else	// TLA_VERSION

	DWORD		dwIdent ;				// "HDSV" (0x56534448)
	WORD		wStatus ;				// Etat enregistrement (0 = OK)
	ULONG		ulNumFSE ;				// Numro de FSE
	USHORT		uFiche ;				// Numro de fiche patient
	HDDATE		Date ;					// Date cration FSE
	HDTIME		Time ;					// Heure de cration FSE
	char		szUser [SIZE_USER] ;	// Nom de l'utilisateur
	char		szNumIF [9] ;			// Numro Identification de facturation du PS
	WORD		wFlagState ;			// Etat de la FSE
	char		szCritereLot [26] ;		// Critere pour transf en lot
	char		szRefLot [4] ;			// Reference du lot lorsq transf en lot
	HDDATE		DateLot ;				// Date lot
	HDDATE		DateArl ;				// Date de traitement ARL (ajout pour la 1.20b)
	char		szCritereLotEx [3] ;	// Fin du Critere (pass de 25  27 dans la 1.30)
	BYTE		Extension [9] ;			// Rserve pour extension (sur 16 pour la 1.10, 14 depuis la 1.20b)
	size_t		TailleBlocFSE1 ;		// taille bloc FSE non API
	size_t		TailleBlocFSE2 ;		// taille bloc FSE API

#endif	// TLA_VERSION

} TYPEDEF (RECFse) ;
#pragma pack()

// Prototypes d'accs au fichier FSE
//////////////////////////////////////////////////////////////////////
API_EXPORT BOOL HDAPI  		SVCreatFSE			(LPCSTR lpPath) ;
API_EXPORT HGLOBAL HDAPI	SVOpenFSE			(LPCSTR lpPath) ;
API_EXPORT HGLOBAL HDAPI	SVOpenFSE_			(LPCSTR lpPath) ;
API_EXPORT void HDAPI		SVCloseFSE			(HGLOBAL) ;
API_EXPORT void HDAPI		SVCloseFSE_			(HGLOBAL) ;
API_EXPORT void HDAPI		SVFlushFSE			() ;
API_EXPORT int HDAPI		SVGetOpenFlagFSE	() ;
API_EXPORT LPSTR HDAPI		SVMakeFSE1Key		(LPSTR lpKey,	 HDDATE Date,	HDTIME Time) ;
API_EXPORT LPSTR HDAPI		SVMakeFSE2Key		(LPSTR lpKey,	 LPSTR lpNumIF,	 HDDATE Date,	HDTIME Time) ;
API_EXPORT LPSTR HDAPI		SVMakeFSE3Key		(LPSTR lpKey,	 USHORT uFiche, LPSTR lpNumIF,	 HDDATE Date,	HDTIME Time) ;
API_EXPORT LPSTR HDAPI		SVMakeFSE4Key		(LPSTR lpKey,	 WORD wFlag,	LPSTR lpNumIF,	 HDDATE Date,	HDTIME Time) ;
API_EXPORT LPSTR HDAPI		SVMakeFSE5Key		(LPSTR lpKey,	 LPSTR lpCritLot,	 HDDATE Date,	HDTIME Time) ;
API_EXPORT HDFILEPOS HDAPI	SVReadFSE1			(LPRECFse lpFSE, HDFILEPOS Idx) ;
API_EXPORT HDFILEPOS HDAPI	SVReadFSE2			(LPRECFse lpFSE, HDFILEPOS Idx,	HGLOBAL* phFSE1, HGLOBAL* phFSE2) ;
API_EXPORT HDFILEPOS HDAPI	SVReadFSE3			(HANDLE hFile, LPRECFse lpFSE, HDFILEPOS Idx) ;
API_EXPORT HDFILEPOS HDAPI	SVReadFSE4			(HANDLE hFile, LPRECFse lpFSE, HDFILEPOS Idx,	HGLOBAL* phFSE1, HGLOBAL* phFSE2) ;
API_EXPORT HDFILEPOS HDAPI	SVReadFSE1_			(LPRECFse lpFSE, HDFILEPOS Idx) ;
API_EXPORT HDFILEPOS HDAPI	SVReadFSE2_			(LPRECFse lpFSE, HDFILEPOS Idx,	HGLOBAL* phFSE1, HGLOBAL* phFSE2) ;
API_EXPORT HDFILEPOS HDAPI	SVBrowseFSE1		(LPRECFse lpFSE, int nKey) ;
API_EXPORT HDFILEPOS HDAPI	SVBrowseFSE2		(LPRECFse lpFSE, int nKey, HGLOBAL* phFSE1, HGLOBAL* phFSE2) ;
API_EXPORT HDFILEPOS HDAPI	SVReadFirstFSE1		(LPRECFse lpFSE, int nKey) ;
API_EXPORT HDFILEPOS HDAPI	SVReadFirstFSE2		(LPRECFse lpFSE, int nKey, HGLOBAL* phFSE1, HGLOBAL* phFSE2) ;
API_EXPORT HDFILEPOS HDAPI	SVReadNextFSE1		(LPRECFse lpFSE, int nKey) ;
API_EXPORT HDFILEPOS HDAPI	SVReadNextFSE2		(LPRECFse lpFSE, int nKey, HGLOBAL* phFSE1, HGLOBAL* phFSE2) ;
API_EXPORT BOOL HDAPI		SVWriteFSE			(LPRECFse lpFSE, LPCSTR lpFSE1, LPCSTR LPFSE2) ;
API_EXPORT BOOL HDAPI		SVWriteFSE2			(HANDLE hFile, LPRECFse lpFSE, LPCSTR lpFSE1, LPCSTR LPFSE2) ;
API_EXPORT BOOL HDAPI		SVWriteFSE_			(LPRECFse lpFSE, LPCSTR lpFSE1, LPCSTR LPFSE2) ;
API_EXPORT BOOL HDAPI		SVUpdateFSE			(LPRECFse lpFSE, HDFILEPOS Idx) ;
API_EXPORT BOOL HDAPI		SVDeleteFSE			(HDFILEPOS Idx) ;
API_EXPORT BOOL HDAPI		SVDeleteFSE2		(HANDLE hFile, HDFILEPOS Idx) ;
API_EXPORT BOOL HDAPI		SVDeleteFSE_		(HDFILEPOS Idx) ;

//////////////////////////////////////////////////////////////////////
//
//  Fichier LOT
//
//////////////////////////////////////////////////////////////////////
#define	LOTLEN1				19			// Date + Time + unNumLOT (8 + 6 + 5)
#define	LOTLEN2				17			// wFlagState + Date + Time (3 + 8 + 6)
#define	LOTLEN3				19			// unNumLOT + Date + Time (5 + 8 + 6)
#define	LOTLEN4				39			// szCritere + Date + Time (25 + 8 + 6)

#define LOT_BY_DATE			0			// clef sur date (pour clef unique)
#define LOT_BY_FLAG			1			// clef sur wFlagState (pour compte-rendus)
#define LOT_BY_NUM			2			// clef sur numro de lot (pour traiter ARL)
#define LOT_BY_CRITERE		3			// clef sur critere (pour regroupement)

#define LOT_STATE_FIC				1		// 00000000 00000001 // le lot a dj t regroup dans un fichier
#define LOT_STATE_ARL_OK			2		// 00000000 00000010 // le lot a reu un ARL positif
#define LOT_STATE_3DAYS				4		// 00000000 00000100 // le lot n'a pas reu d'ARL dans le temps limite (=> le rmettre  l'identique)
#define LOT_STATE_2X				8		// 00000000 00001000 // le lot n'a pas reu d'ARL dans le temps limite deux fois conscutives (=> ne pas le rmettre) ou MSF
#define LOT_STATE_ART_OK			16		// 00000000 00010000 // le lot a reu un ART (flag utile juste pour affichage sinon les ART sont traits comme des ARL)
#define LOT_STATE_MSF				32		// 00000000 00100000 // le lot a reu un MSF
#define LOT_STATE_DOMANUAL			64		// 00000000 01000000 // lot  traiter manuellement
#define LOT_STATE_DELETED			128		// 00000000 10000000 // enregistrement effac (ARL ngatif)
#define LOT_STATE_MANUEL			256		// 00000001 00000000 // le lot a t trait manuellement (bloqu)
#define LOT_STATE_EMIS				512		// 00000010 00000000 // le fichier contenant le lot a t mis
#define LOT_STATE_ANR				1024	// 00000100 00000000 // le fichier a reu un avis de non remise

#define LOT_HEADER_SIZE		128
#define LOT_RECORD_IDENT	0x56534448	// "HDSV"

//	Header du fichier
//////////////////////////////////////////////////////////////////////
#pragma pack(1)

typedef struct
{
	DWORD		dwIdent ;				// "HDSV" (0x56534448)
	WORD		wStatus ;				// Etat fichier (0 = Ok)
	HDFILEPOS	Delete ;				// Chaine des enregistrements supprims
	USHORT		uMaxSize ;				// Taille du plus grand enregistrement supprim
	DWORD		dwLen ;					// Longueure du fichier
	DWORD		dwRec ;					// Nombres d'enregistrements total
	DWORD		dwDel ;					// Nombres d'enregistrements supprims
   	BYTE		Filler [LOT_HEADER_SIZE - (sizeof (DWORD) + sizeof (WORD) + sizeof (HDFILEPOS) + sizeof (USHORT) + sizeof (DWORD) + sizeof (DWORD) + sizeof (DWORD))] ;
} TYPEDEF (LOT_HEADER) ;

#pragma pack()

//	Enregistrement
//////////////////////////////////////////////////////////////////////
#pragma pack(1)

typedef struct
{
	DWORD		dwIdent ;				// "HDSV" (0x56534448)
	WORD		wStatus ;				// Etat enregistrement (0 = OK)
	UINT		unNumLOT ;				// Numro de LOT
	HDDATE		Date ;					// Date cration LOT
	HDTIME		Time ;					// Heure de cration LOT
	char		szUser [SIZE_USER] ;	// Nom de l'utilisateur
	char		cSyntaxe ;				// Syntaxe utilise (1A) (B : B2, E : EDIFACT)
	char		cTypeEmet ;				// Type emetteur lot (1N)
	char		szNumEmetARL [15] ;		// Numro d'metteur du fichier retourn par FormaterLOT, sert pour ARL(14N)
	char		szNumEmetB2 [15] ;		// Numro d'metteur du fichier  passer en paramtre de Formater B2 (14N)
	char		szDestinataire [15] ;	// Numro identification PS (8A)
	char		szReference [4] ;		// Reference du lot (3N)
	UINT		nNb ;					// Nombre de FSE dans le lot
	WORD		wFlagState ;			// Etat du lot
	char		szCritere [26] ;		// Critere de regroupement
	char		szNomFic [9] ;			// Numro du fichier B2 (anciennement : 6 car. + 1 car. de fin = 7)
	size_t		TailleBlocLOT ;			// taille Lot (qd regroupe)
	BYTE		Extension [16] ;		// Rserve pour extension
} TYPEDEF (RECLot) ;

#pragma pack()

// Prototypes d'accs au fichier LOT
//////////////////////////////////////////////////////////////////////
API_EXPORT BOOL HDAPI		SVCreatLOT			(LPCSTR lpPath) ;
API_EXPORT HGLOBAL HDAPI	SVOpenLOT			(LPCSTR lpPath) ;
API_EXPORT HGLOBAL HDAPI	SVOpenLOT_			(LPCSTR lpPath) ;
API_EXPORT void HDAPI		SVCloseLOT			(HGLOBAL) ;
API_EXPORT void HDAPI		SVCloseLOT_			(HGLOBAL) ;
API_EXPORT void HDAPI		SVFlushLOT			() ;
API_EXPORT int HDAPI		SVGetOpenFlagLOT	() ;
API_EXPORT LPSTR HDAPI		SVMakeLOT1Key		(LPSTR lpKey, HDDATE Date, HDTIME Time, UINT unNumLot) ;
API_EXPORT LPSTR HDAPI		SVMakeLOT2Key		(LPSTR lpKey, WORD wFlagState, HDDATE Date, HDTIME Time) ;
API_EXPORT LPSTR HDAPI		SVMakeLOT3Key		(LPSTR lpKey, UINT unNumLot, HDDATE Date, HDTIME Time) ;
API_EXPORT LPSTR HDAPI		SVMakeLOT4Key		(LPSTR lpKey, LPSTR lpCritere, HDDATE Date, HDTIME Time) ;
API_EXPORT HDFILEPOS HDAPI	SVReadLOT1			(LPRECLot lprecLOT, HDFILEPOS Idx) ;
API_EXPORT HDFILEPOS HDAPI	SVReadLOT2			(LPRECLot lprecLOT, HDFILEPOS Idx, HGLOBAL* phLOT) ;
API_EXPORT HDFILEPOS HDAPI	SVReadLOT3			(HANDLE hFile, LPRECLot lprecLOT, HDFILEPOS Idx) ;
API_EXPORT HDFILEPOS HDAPI	SVReadLOT4			(HANDLE hFile, LPRECLot lprecLOT, HDFILEPOS Idx, HGLOBAL* phLOT) ;
API_EXPORT HDFILEPOS HDAPI	SVReadLOT1_			(LPRECLot lprecLOT, HDFILEPOS Idx) ;
API_EXPORT HDFILEPOS HDAPI	SVReadLOT2_			(LPRECLot lprecLOT, HDFILEPOS Idx, HGLOBAL* phLOT) ;
API_EXPORT HDFILEPOS HDAPI	SVBrowseLOT1		(LPRECLot lprecLOT, int nKey) ;
API_EXPORT HDFILEPOS HDAPI	SVBrowseLOT2		(LPRECLot lprecLOT, int nKey, HGLOBAL* phLOT) ;
API_EXPORT HDFILEPOS HDAPI	SVReadFirstLOT1		(LPRECLot lprecLOT, int nKey) ;
API_EXPORT HDFILEPOS HDAPI	SVReadFirstLOT2		(LPRECLot lprecLOT, int nKey, HGLOBAL* phLOT) ;
API_EXPORT HDFILEPOS HDAPI	SVReadNextLOT1		(LPRECLot lprecLOT, int nKey) ;
API_EXPORT HDFILEPOS HDAPI	SVReadNextLOT2		(LPRECLot lprecLOT, int nKey, HGLOBAL* phLOT) ;
API_EXPORT BOOL HDAPI		SVWriteLOT			(LPRECLot lpLOT, LPCSTR strLOT) ;
API_EXPORT BOOL HDAPI		SVWriteLOT2			(HANDLE hFile, LPRECLot lpLOT, LPCSTR strLOT) ;
API_EXPORT BOOL HDAPI		SVWriteLOT_			(LPRECLot lpLOT, LPCSTR strLOT) ;
API_EXPORT BOOL HDAPI		SVUpdateLOT			(LPRECLot lpLOT, HDFILEPOS Idx) ;
API_EXPORT BOOL HDAPI		SVDeleteLOT			(HDFILEPOS Idx) ;
API_EXPORT BOOL HDAPI		SVDeleteLOT2		(HANDLE hFile, HDFILEPOS Idx) ;
API_EXPORT BOOL HDAPI		SVDeleteLOT_		(HDFILEPOS Idx) ;



//////////////////////////////////////////////////////////////////////
//
//  Fichier CPTLIB.INI
//
//////////////////////////////////////////////////////////////////////

// Gestion des exercices
//////////////////////////////////////////////////////////////////////
API_EXPORT LPSTR HDAPI		GetFirstExercice	(LPSTR lpExercice) ;
API_EXPORT LPSTR HDAPI		GetLastExercice		(LPSTR lpExercice) ;
API_EXPORT int HDAPI		GetExercicesRec		() ;

// Gestion des comptes
//////////////////////////////////////////////////////////////////////
// Mise en forme
API_EXPORT LPSTR HDAPI		GetShortCompte		(LPCSTR lpCompte) ;
API_EXPORT LPSTR HDAPI		GetLongCompte		(LPCSTR lpCompte) ;

// Slection du compte de prlvement personnel
API_EXPORT LPSTR HDAPI		GetComptePerso		(LPSTR lpCompte) ;
API_EXPORT BOOL HDAPI		SetComptePerso		(LPSTR lpCompte) ;

// Slection des comptes de virements
API_EXPORT LPSTR HDAPI		GetCompteVireTo		(LPSTR lpCompte) ;
API_EXPORT BOOL HDAPI		SetCompteVireTo		(LPSTR lpCompte) ;
API_EXPORT LPSTR HDAPI		GetCompteVireFrom	(LPSTR lpCompte) ;
API_EXPORT BOOL HDAPI		SetCompteVireFrom	(LPSTR lpCompte) ;

// Slectionne les comptes d'carts
API_EXPORT LPSTR HDAPI		GetCompteEcartCredit (LPSTR lpCompte) ;
API_EXPORT BOOL HDAPI		SetCompteEcartCredit (LPSTR lpCompte) ;
API_EXPORT LPSTR HDAPI		GetCompteEcartDebit	 (LPSTR lpCompte) ;
API_EXPORT BOOL HDAPI		SetCompteEcartDebit	 (LPSTR lpCompte) ;

// Conversion des montant
//////////////////////////////////////////////////////////////////////
API_EXPORT double HDAPI		GetTauxEuro			(HDDATE Date) ;
API_EXPORT double HDAPI		ConvertFrancToEuro	(double dTaux, double dFranc) ;
API_EXPORT double HDAPI		ConvertEuroToFranc	(double dTaux, double dEuro) ;


//////////////////////////////////////////////////////////////////
//
//  Fichier VERSION
//
//////////////////////////////////////////////////////////////////

#pragma pack(1)

typedef	struct
{
	char	Ident [5] ;					// Identificateur ("AMID")
	BYTE	cVersion ;					// Numro de version
	BYTE	cRevision ;					// Numro de rvision
	HDDATE	Date ;						// Date de cration
	WORD	wBuild ;					// Numro de construction

// Reserves
	BYTE	Reserve	[126] ;				// Reserve pour extension
} TYPEDEF (RECComptaVersion) ;


API_EXPORT BOOL HDAPI		ReadComptaVersion	(LPCSTR lpExercice, LPRECComptaVersion lpVersion) ;
API_EXPORT BOOL HDAPI		WriteComptaVersion	(LPCSTR lpExercice, LPRECComptaVersion lpVersion) ;


//////////////////////////////////////////////////////////////////////
//
//  Fichier PLAN Comptable
//
//////////////////////////////////////////////////////////////////////

#define	PLANLEN1		SIZE_CPT + 1
#define	PLANLEN2		SIZE_CODE + SIZE_CPT + 1
#define	PLANLEN3		SIZE_RUB + SIZE_CPT + 1
#define	PLANLEN4		SIZE_PLANTYPE + SIZE_CPT + 1
#define	PLANLEN5		SIZE_KLIB + SIZE_CPT + 1

#define PLAN_BY_CPT		0
#define PLAN_BY_CODE	1
#define PLAN_BY_RUB		2
#define PLAN_BY_TYPE	3
#define PLAN_BY_LIB		4


#pragma pack(1)

typedef	struct
{
	USHORT	uStatus ;						// Status enregistrement
	char	szCompte [SIZE_CPT + 1] ;		// Numro de compte
	char	szCode [SIZE_CODE + 1] ;		// Code du compte
	char	szDesign [SIZE_LIB + 1] ;		// Dsignation du compte
	char	szRubrique [SIZE_RUB + 1] ;		// Rubrique associe
	USHORT	uType ;							// Type de compte (CPT_TRESOR / CPT_RECETTE / CPT_DEPENSE / CPT_TVA / CPT_AUTRECPT)
	short	bBank ;							// Compte bancaire si nType == 0
	char	szCompteTaxe [SIZE_CPT + 1] ;	// Numro de compte de TVA
	double	dTaxe ;							// Taux de TVA associ
	double	dRepartition ;					// % de rpartition Prof / Perso

	double	dSoldeInitialFranc ;			// Solde du compte en dbut d'exercice en Franc
	double	dSoldeInitialEuro ;				// Solde du compte en dbut d'exercice en Euro
	double	dSoldePersoFranc ;				// Solde personnel en Franc
	double	dSoldePersoEuro ;				// Solde personnel en Euro
	double	dSoldeTaxeFranc ;				// Solde de TVA en Franc
	double	dSoldeTaxeEuro ;				// Solde de TVA en Euro

	double	dCreditFranc ;					// Crdit pour trsorerie en Franc
	double	dCreditEuro ;					// Crdit pour trsorerie en Euro
	double	dDebitFranc ;					// Dbit pour trsorerie en Franc
	double	dDebitEuro ;					// Dbit pour trsorerie en Euro

	double	dCreditRappFranc ;				// Crdit rapproch pour trsorerie en Franc
	double	dCreditRappEuro ;				// Crdit rapproch pour trsorerie en Euro
	double	dDebitRappFranc ;				// Dbit rapproch pour trsorerie en Franc
	double	dDebitRappEuro ;				// Dbit rapproch pour trsorerie en Euro

	// Reserves
	BYTE	Reserve [50] ;					// Reserve pour extension
} TYPEDEF (RECPlan) ;

#pragma pack()


API_EXPORT BOOL HDAPI		CreatPlan (LPCSTR lpPath) ;
API_EXPORT HGLOBAL HDAPI	OpenPlan (LPCSTR lpPath) ;
API_EXPORT void HDAPI		ClosePlan (HGLOBAL hRec) ;
API_EXPORT void HDAPI		FlushPlan () ;
API_EXPORT int HDAPI		GetOpenFlagPlan () ;
API_EXPORT LPSTR HDAPI		MakePlanKey1 (LPSTR lpKey, LPCSTR lpCompte) ;
API_EXPORT LPSTR HDAPI		MakePlanKey2 (LPSTR lpKey, LPCSTR lpCode, LPCSTR lpCompte) ;
API_EXPORT LPSTR HDAPI		MakePlanKey3 (LPSTR lpKey, LPCSTR lpRubrique, LPCSTR lpCompte) ;
API_EXPORT LPSTR HDAPI		MakePlanKey4 (LPSTR lpKey, USHORT uType, LPCSTR lpCompte) ;
API_EXPORT LPSTR HDAPI		MakePlanKey5 (LPSTR lpKey, LPCSTR lpDesign, LPCSTR lpCompte) ;
API_EXPORT HDFILEPOS HDAPI	ReadPlan (LPRECPlan lpPlan, int nKey) ;
API_EXPORT BOOL HDAPI		WritePlan (LPRECPlan lpPlan) ;
API_EXPORT BOOL HDAPI		DeletePlan (HDFILEPOS Idx) ;
API_EXPORT DWORD HDAPI		GetPlanRec (LPCSTR lpPath) ;
API_EXPORT DWORD HDAPI		GetPlanSize (LPCSTR lpPath) ;



//////////////////////////////////////////////////////////////////
//
//  Fichier des RUBRIQUES
//
//////////////////////////////////////////////////////////////////
#define	RUBRIQUESLEN1		SIZE_RUB + 1
#define	RUBRIQUESLEN2		SIZE_RUBTYPE + SIZE_RUB + 1
#define	RUBRIQUESLEN3		SIZE_KLIB + SIZE_RUB + 1
#define	RUBRIQUESLEN4		SIZE_RUBLINE + SIZE_RUB + 1

#define RUBRIQUES_BY_CODE	0
#define RUBRIQUES_BY_TYPE	1
#define RUBRIQUES_BY_LIB	2
#define RUBRIQUES_BY_LINE	3

#pragma pack(1)

typedef	struct
{
	USHORT	uStatus ;					// Status enregistrement
	char	szCode [SIZE_RUB + 1] ;		// Code de rubrique
	char	szDesign [SIZE_LIB + 1] ;	// Dsignation de la rubrique
	short	nLine ;						// Numro de ligne
	char	szFormule [SIZE_CALC] ;		// Relation avec les autres rubriques
	short	nType ;						// Type de rubrique 0 = Recette, 1 = Dpense, 2 = Rsultat, 3 = T.V.A.
	short	bManual ;					// Mise  jour manuelle
	double	dValueFranc ;				// Valeur saisie
	double	dValueEuro ;				// Valeur saisie en Euro

// Reserves
	BYTE	Reserve [146] ;				// Reserve pour extension
} TYPEDEF (RECRubriques) ;

#pragma pack()

API_EXPORT BOOL HDAPI		CreatRubriques (LPCSTR lpPath) ;
API_EXPORT HGLOBAL HDAPI	OpenRubriques (LPCSTR lpPath) ;
API_EXPORT void HDAPI		CloseRubriques (HGLOBAL hRec) ;
API_EXPORT void HDAPI		FlushRubriques () ;
API_EXPORT int HDAPI		GetOpenFlagRubriques () ;
API_EXPORT LPSTR HDAPI		MakeRubriquesKey1 (LPSTR lpKey, LPCSTR lpCode) ;
API_EXPORT LPSTR HDAPI		MakeRubriquesKey2 (LPSTR lpKey, short nType, LPCSTR lpCode) ;
API_EXPORT LPSTR HDAPI		MakeRubriquesKey3 (LPSTR lpKey, LPCSTR lpDesign, LPCSTR lpCode) ;
API_EXPORT LPSTR HDAPI		MakeRubriquesKey4 (LPSTR lpKey, short nLine, LPCSTR lpCode) ;
API_EXPORT HDFILEPOS HDAPI	ReadRubriques (LPRECRubriques lpRubriques, int nKey) ;
API_EXPORT BOOL HDAPI		WriteRubriques (LPRECRubriques lpRubriques) ;
API_EXPORT BOOL HDAPI		DeleteRubriques (HDFILEPOS Idx) ;
API_EXPORT DWORD HDAPI		GetRubriquesRec (LPCSTR lpPath) ;
API_EXPORT DWORD HDAPI		GetRubriquesSize (LPCSTR lpPath) ;


//////////////////////////////////////////////////////////////////
//
//  Fichier des BANQUES
//
//////////////////////////////////////////////////////////////////
#define	BANQUESLEN1			SIZE_CPT + SIZE_DATE + SIZE_IDX + 1
#define	BANQUESLEN2			SIZE_DATE + SIZE_CPT + SIZE_IDX + 1
#define	BANQUESLEN3			SIZE_BOOL + SIZE_CPT + SIZE_DATE + SIZE_IDX + 1

#define BANQUES_BY_CPT		0
#define BANQUES_BY_DATE		1
#define BANQUES_BY_TYPE		2

#pragma pack(1)

typedef	struct
{
	USHORT	uStatus ;					// Status enregistrement
	char	szCompte [SIZE_CPT + 1] ;	// Compte de trsorerie
	char	szDesign [SIZE_LIB + 1] ;	// Dsignation de l'opration
	HDDATE	Date ;						// Date de l'opration
	HDDATE	DateValeur ;				// Date de valeur
	double	dValueFranc ;				// Montant de l'opration en Franc
	double	dValueEuro ;				// Montant de l'opration en Euro
	short	bCredit ;					// VRAI si Crdit SINON Dbit

#ifdef EURO_VERSION
	// Monnaie
	BOOL	bMvtEuro ;					// Monnaie en euro

// Reserves
	BYTE	Reserve [46] ;				// Reserve pour extension
#else	// EURO_VERSION
// Reserves
	BYTE	Reserve [50] ;				// Reserve pour extension
#endif	// EURO_VERSION
} TYPEDEF (RECBanques) ;

#pragma pack()

API_EXPORT BOOL HDAPI		CreatBanques (LPCSTR lpPath) ;
API_EXPORT HGLOBAL HDAPI	OpenBanques (LPCSTR lpPath) ;
API_EXPORT void HDAPI		CloseBanques (HGLOBAL hRec) ;
API_EXPORT void HDAPI		FlushBanques () ;
API_EXPORT int HDAPI		GetOpenFlagBanques () ;
API_EXPORT LPSTR HDAPI		MakeBanquesKey1 (LPSTR lpKey, LPCSTR lpCompte, HDDATE Date) ;
API_EXPORT LPSTR HDAPI		MakeBanquesKey2 (LPSTR lpKey, HDDATE Date, LPCSTR lpCompte) ;
API_EXPORT LPSTR HDAPI		MakeBanquesKey3 (LPSTR lpKey, BOOL bCredit, LPCSTR lpCompte, HDDATE Date) ;
API_EXPORT HDFILEPOS HDAPI	ReadBanques (LPRECBanques lpBanques, int nKey) ;
API_EXPORT BOOL HDAPI		WriteBanques (LPRECBanques lpBanques) ;
API_EXPORT BOOL HDAPI		DeleteBanques (HDFILEPOS Idx) ;
API_EXPORT DWORD HDAPI		GetBanquesRec (LPCSTR lpPath) ;
API_EXPORT DWORD HDAPI		GetBanquesSize (LPCSTR lpPath) ;



//////////////////////////////////////////////////////////////////////
//
//	Fichier Journal
//
//////////////////////////////////////////////////////////////////////

#define	JOURNALLEN1		(SIZE_MVTTYPE + SIZE_DATE + SIZE_MVT + SIZE_LINE + SIZE_CPT + SIZE_MVTJLINE + 1)
#define	JOURNALLEN2		(SIZE_MVTTYPE + SIZE_CPT + SIZE_DATE + SIZE_MVT + SIZE_LINE + SIZE_MVTJLINE + 1)
#define	JOURNALLEN3		(SIZE_CPT + SIZE_DATE + SIZE_MVT + SIZE_LINE + SIZE_MVTTYPE + SIZE_MVTJLINE + 1)
#define	JOURNALLEN4		(SIZE_DATE + SIZE_CPT + SIZE_MVT + SIZE_LINE + SIZE_MVTTYPE + SIZE_MVTJLINE + 1)
#define	JOURNALLEN5		(SIZE_MVT + SIZE_LINE + SIZE_MVTTYPE + SIZE_MVTJLINE + 1)
#define	JOURNALLEN6		(15 + SIZE_DATE + SIZE_TIME + SIZE_MVT + SIZE_LINE + SIZE_MVTTYPE + SIZE_MVTJLINE + 1)

#define JOURNAL_ALL			0
#define JOURNAL_BY_TYPE		1
#define JOURNAL_BY_CPT		2
#define JOURNAL_BY_DATE		3
#define	JOURNAL_BY_ID		4
#define	JOURNAL_BY_FICHE	5


#define	HEADER_MVTRECORD					\
	USHORT	wStatus ;						\
	ULONG	uMvt ;							\
	USHORT	uMvtType ;						\
	USHORT	uMvtMode ;						\
	char	szMvtDesign [SIZE_LIB + 1] ;	\
	ULONG	uMvtJLine ;						\
	HDDATE	MvtDate ;						\
	BOOL	bMvtValid ;						\
	char	szMvtRecUser [SIZE_USER] ;		\
	char	szMvtRecCode [SIZE_CODE + 1] ;	\
	USHORT	uMvtRecFiche ;					\
	HDDATE	MvtRecDate ;					\
	HDTIME	MvtRecTime ;


//	USHORT	wStatus ;						// Etat fichier (0 = Ok)
//	ULONG	uMvt ;							// Numro d'index du mouvement
//	USHORT	uMvtType ;						// Type de mouvement (MVT_RECETTE/MVT_DEPENSE/MVT_OD)
//  USHORT	uMvtMode ;						// Mode d'dition du mouvement (MODE_MVT/MODE_ECRSIMPLE/MODE_ECRSTANDARD)
//	char	szMvtDesign [SIZE_LIB + 1] ;	// Libell du mouvement
//	ULONG	uMvtJLine ;						// Numro de ligne du mouvement dans le journal
//	HDDATE	MvtDate ;						// Date
//	BOOL	bMvtValid ;						// Valid
//	char	szMvtRecUser [SIZE_USER] ;		// Utilisateur de la recette ou dpense Hellodoc
//	char	szMvtRecCode [SIZE_CODE + 1] ;	// Code de la depense HelloDOC
//	UINT	uMvtRecFiche ;					// Fiche patient de la recette HelloDOC correspondante
//	HDDATE	MvtRecDate ;					// Date de la recette ou de la dpense HelloDOC
//	HDTIME	MvtRecTime ;					// Heure de la recette ou de la dpense HelloDOC


// Gestion globale
//////////////////////////////////////////////////////////////////////
#pragma pack(1)

typedef struct
{
	HEADER_MVTRECORD

	HDDATE	Date ;							// Date de la ligne

	ULONG	uLine ;							// Numro d'index de la ligne
	char	szDesign [SIZE_LIB + 1] ;		// Libell de la ligne
//	ULONG	uJLine ;						// Numro de la ligne dans le journal

	char	szCompte [SIZE_CPT + 1] ;		// Numro du compte comptable
	USHORT	uTypeCompte ;					// Type de compte (CPT_TRESOR/CPT_RECETTE/CPT_DEPENSE/CPT_TVA/CPT_AUTRECPT)
	char	szRecCode [SIZE_CODE + 1] ;		// Code HelloDOC

	double	dValueFranc ;					// Montant de l'criture HT en Franc
	double	dValueEuro ;					// Montant de l'criture HT en Euro
	BOOL	bCredit ;						// VRAI si Crdit SINON Dbit

	// Paramtres
	double	dPersoFranc ;					// Solde personnel en franc
	double	dPersoEuro ;					// Solde personnel en euro
	double	dTaxeFranc ;					// Montant de taxe en franc
	double	dTaxeEuro ;						// Montant de taxe en euro
	double	dTaxe ;							// Taux de taxe
	USHORT	uPaiement ;						// Mode de paiement : PAIEMENT_CHEQUE/PAIEMENT_VIREMENT

	// Etats
	BOOL	bRapp ;							// Rapproche
	BOOL	bMark ;							// Pointe
	BOOL	bRemis ;						// Remise

	// Information rapprochement bancaire
	char	szRappCompte [SIZE_CPT + 1] ;	// Numro du compte bancaire
	char	szRappDesign [SIZE_LIB + 1] ;	// Dsignation de l'opration
	HDDATE	RappDate ;						// Date de l'opration
	HDDATE	RappDateValeur ;				// Date de valeur de l'opration
	double	dRappValueFranc ;				// Montant de l'opration en Franc
	double	dRappValueEuro ;				// Montant de l'opration en Euro
	BOOL	bRappCredit ;					// VRAI si Crdit SINON Dbit

	// Dates pour limitation de la version de dmo
	HDDATE	DateStart, DateEnd, DateLast ;

	// Source d'un mouvement
	USHORT	uMvtGamme ;						// Application  l'origine du mouvement (APPSRC_HELLODOC/APPSRC_HDES)

#ifdef EURO_VERSION
	// Monnaie
	BOOL	bMvtEuro ;						// Monnaie en Euro
	HDDATE	DateRemise ;					// FQ enregistrement date de la remise en banque
	// Reserves
	BYTE	Reserve [40] ;					// Reserve pour extension
#else	// EURO_VERSION
	// Reserves
	BYTE	Reserve [48] ;					// Reserve pour extension
#endif	// EURO_VERSION
} TYPEDEF (RECJournal) ;

#pragma pack()

API_EXPORT BOOL HDAPI		CreatJournal		(LPCSTR lpPath) ;
API_EXPORT HGLOBAL HDAPI	OpenJournal			(LPCSTR lpPath) ;
API_EXPORT void HDAPI		CloseJournal		(HGLOBAL hRec) ;
API_EXPORT void HDAPI		FlushJournal		() ;
API_EXPORT int HDAPI		GetOpenFlagJournal	() ;
API_EXPORT LPSTR HDAPI 		MakeJournalKey1		(LPSTR lpKey, USHORT uMvtType, HDDATE MvtDate, ULONG uMvt, ULONG uLine, LPCSTR lpCompte, ULONG uMvtJLine) ;
API_EXPORT LPSTR HDAPI 		MakeJournalKey2		(LPSTR lpKey, USHORT uMvtType, LPCSTR lpCompte, HDDATE MvtDate, ULONG uMvt, ULONG uLine, ULONG uMvtJLine) ;
API_EXPORT LPSTR HDAPI 		MakeJournalKey3		(LPSTR lpKey, LPCSTR lpCompte, HDDATE Date, ULONG uMvt, ULONG uLine, USHORT uMvtType, ULONG uMvtJLine) ;
API_EXPORT LPSTR HDAPI 		MakeJournalKey4		(LPSTR lpKey, HDDATE Date, LPCSTR lpCompte, ULONG uMvt, ULONG uLine, USHORT uMvtType, ULONG uMvtJLine) ;
API_EXPORT LPSTR HDAPI 		MakeJournalKey5		(LPSTR lpKey, ULONG uMvt, ULONG uLine, USHORT uMvtType, ULONG uMvtJLine) ;
API_EXPORT LPSTR HDAPI 		MakeJournalKey6		(LPSTR lpKey, LPCSTR lpMvtRecUser, HDDATE MvtRecDate, HDTIME MvtRecTime, ULONG uMvt, ULONG uLine, USHORT uMvtType, ULONG uMvtJLine) ;
API_EXPORT HDFILEPOS HDAPI	ReadJournal			(LPRECJournal lpJournal, int nKey) ;
API_EXPORT HDFILEPOS HDAPI	WriteJournal		(LPRECJournal lpJournal) ;
API_EXPORT BOOL HDAPI		DeleteJournal		(HDFILEPOS Idx) ;

API_EXPORT DWORD HDAPI		GetJournalRec		(LPCSTR lpPath) ;
API_EXPORT DWORD HDAPI		GetJournalSize		(LPCSTR lpPath) ;

API_EXPORT ULONG HDAPI		GetMouvements		(LPCSTR lpKey, int nKey) ;
API_EXPORT ULONG HDAPI		GetLines			(LPCSTR lpKey, int nKey) ;
API_EXPORT USHORT HDAPI		GetMouvementsType	(LPCSTR lpKey, int nKey) ;

API_EXPORT ULONG HDAPI		GetFreeJournalLine	(LPCSTR lpPath, USHORT uMvtType, LPCSTR lpCompte, HDDATE MvtDate) ;

API_EXPORT BOOL HDAPI		IsCompteExist		(LPCSTR lpPath, LPCSTR lpCompte, USHORT uType) ;


// Gestion des lignes
//////////////////////////////////////////////////////////////////////
typedef RECJournal TYPEDEF (RECLines) ;

API_EXPORT void HDAPI		AddCompte3			(LPRECPlan lpPlan, LPRECLines lpLines) ;
API_EXPORT BOOL HDAPI		AddCompte2			(LPRECPlan lpPlan, LPRECLines lpLines) ;
API_EXPORT BOOL HDAPI		AddCompte			(LPCSTR lpPath, LPRECLines lpLines) ;
API_EXPORT BOOL HDAPI		UpdateCompte		(LPCSTR lpPath, LPRECLines lpOldLines, LPRECLines lpNewLines) ;
API_EXPORT BOOL HDAPI		RemoveCompte		(LPCSTR lpPath, LPRECLines lpLines) ;

API_EXPORT BOOL HDAPI		ReadLines			(LPCSTR lpPath, HDFILEPOS Idx, LPRECJournal lpLines) ;
API_EXPORT HDFILEPOS HDAPI	AddLines			(LPCSTR lpPath, LPRECLines lpLines) ;
API_EXPORT BOOL HDAPI		UpdateLines			(LPCSTR lpPath, HDFILEPOS Idx, LPRECLines lpLines) ;
API_EXPORT BOOL HDAPI		RemoveLines			(LPCSTR lpPath, HDFILEPOS Idx) ;

API_EXPORT BOOL HDAPI		MarkLines			(LPCSTR lpPath, HDFILEPOS Idx, BOOL bMark) ;
API_EXPORT BOOL HDAPI		ReverseMarkLines	(LPCSTR lpPath, HDFILEPOS Idx) ;
API_EXPORT BOOL HDAPI		RappLines			(LPCSTR lpPath, HDFILEPOS Idx, LPRECBanques lpBanques) ;
API_EXPORT BOOL HDAPI		RemisLines			(LPCSTR lpPath, HDFILEPOS Idx, BOOL bRemis) ;
API_EXPORT BOOL HDAPI		ReverseRemisLines	(LPCSTR lpPath, HDFILEPOS Idx) ;

API_EXPORT DWORD HDAPI		GetLinesRec			(LPCSTR lpPath) ;
API_EXPORT DWORD HDAPI		GetLinesSize		(LPCSTR lpPath) ;

API_EXPORT BOOL HDAPI		ExistLinesID		(LPCSTR lpPath, ULONG uMvt, ULONG uLigne) ;
API_EXPORT ULONG HDAPI		GetFreeLinesID		(LPCSTR lpPath, ULONG uMvt) ;


// Gestion des mouvements
//////////////////////////////////////////////////////////////////////
#pragma pack(1)

typedef struct
{
	HEADER_MVTRECORD

	// Source d'un mouvement
	USHORT	uMvtGamme ;			// Application  l'origine du mouvement (APPSRC_HELLODOC/APPSRC_HDES)

#ifdef EURO_VERSION
	// Monnaie
	BOOL	bMvtEuro ;			// Monnaie en Euro
#endif	// EURO_VERSION

	// Etats
	BOOL	bMark ;				// Pointe
} TYPEDEF (RECMouvements) ;

#pragma pack()


API_EXPORT BOOL HDAPI		ReadMouvements			(LPCSTR lpPath, ULONG uMvt, LPRECMouvements lpMouvements) ;
API_EXPORT BOOL HDAPI		UpdateMouvements		(LPCSTR lpPath, ULONG uMvt, LPRECMouvements lpNewMvt) ;
API_EXPORT BOOL HDAPI		RemoveMouvements		(LPCSTR lpPath, ULONG uMvt) ;

API_EXPORT BOOL HDAPI		IsRappLineInMouvements	(ULONG uMvt) ;
API_EXPORT BOOL HDAPI		IsMarkLineInMouvements	(ULONG uMvt) ;

API_EXPORT BOOL HDAPI		ValidMouvements			(LPCSTR lpPath, ULONG uMvt, BOOL bValider) ;
API_EXPORT BOOL HDAPI		MarkMouvements			(LPCSTR lpPath, ULONG uMvt, BOOL bMark) ;
API_EXPORT BOOL HDAPI		ReverseMarkMouvements	(LPCSTR lpPath, ULONG uMvt) ;

API_EXPORT DWORD HDAPI		GetMouvementsRec		(LPCSTR lpPath) ;
API_EXPORT DWORD HDAPI		GetMouvementsSize		(LPCSTR lpPath) ;

API_EXPORT ULONG HDAPI		GetMouvementsLinesCount	(ULONG uMvt) ;

API_EXPORT ULONG HDAPI		GetLastMouvementsID		(int nYear) ;
API_EXPORT BOOL HDAPI		WriteLastMouvementsID	(ULONG uMvt, int nYear) ;
API_EXPORT BOOL HDAPI		ExistMouvementsID		(LPCSTR lpPath, ULONG uMvt) ;
API_EXPORT ULONG HDAPI		GetFreeMouvementsID		(LPCSTR lpPath, int nYear) ;

API_EXPORT BOOL HDAPI		DeleteRecetteWithMouvement	(LPCSTR lpPath, LPRECMouvements lpMouvements) ;
API_EXPORT BOOL HDAPI		DeleteDepenseWithMouvement	(LPCSTR lpPath, LPRECMouvements lpMouvements) ;

API_EXPORT LPSTR HDAPI		MakeLibelleRecette		(LPRECRecettes lpRecettes, LPSTR lpLibelle, int nLen) ;
API_EXPORT LPSTR HDAPI		AddLibelleTresor		(LPRECRecettes lpRecettes, int nPaie, LPSTR lpLibelle, int nLen) ;

API_EXPORT BOOL HDAPI		AddRecettes				(LPRECRecettes lpRecettes, BOOL bMark) ;
API_EXPORT BOOL HDAPI		AddDepenses				(LPCSTR lpPath, ULONG uMvt, LPRECDepenses lpDepenses, BOOL bMark) ;
API_EXPORT BOOL HDAPI		IsComptaRecetteValid	(LPRECRecettes lpRecettes) ;
API_EXPORT BOOL HDAPI		IsComptaDepenseValid	(LPRECDepenses lpDepenses) ;

API_EXPORT BOOL HDAPI		ConsolidationRecettes	(HDFILEPOS Idx) ;
API_EXPORT BOOL HDAPI		ConsolidationDepenses	(HDFILEPOS Idx) ;


// Gestion des critures standards
//////////////////////////////////////////////////////////////////////
#pragma pack(1)

typedef struct
{
	// Trsorerie
	char	szCompte [SIZE_CPT + 1] ;	// Numro du compte de trsorerie
	double	dValueFranc ;					// Montant de l'criture TTC en Franc
	double	dValueEuro ;					// Montant de l'criture TTC en Euro

	// Caractristiques
	USHORT	uPaiement ;						// Mode de paiement : PAIEMENT_CHEQUE/PAIEMENT_VIREMENT

	// Etats
	BOOL	bRapp ;							// Rapproche
	BOOL	bMark ;							// Pointe
	BOOL	bRemis ;						// Remise
	BOOL	bValid ;						// Valide

	// Information rapprochement bancaire
	char	szRappCompte [SIZE_CPT + 1] ;	// Numro du compte bancaire
	char	szRappDesign [SIZE_LIB + 1] ;	// Dsignation de l'opration
	HDDATE	RappDate ;						// Date de l'opration
	HDDATE	RappDateValeur ;				// Date de valeur de l'opration
	double	dRappValueFranc ;				// Montant de l'opration en Franc
	double	dRappValueEuro ;				// Montant de l'opration en Euro
	BOOL	bRappCredit ;					// VRAI si Crdit SINON Dbit

} TYPEDEF (RECEcrLineTresor) ;

typedef struct
{
	HEADER_MVTRECORD

	// Source d'un mouvement
	USHORT	uMvtGamme ;						// Application  l'origine du mouvement (APPSRC_HELLODOC/APPSRC_HDES)

#ifdef EURO_VERSION
	// Monnaie
	BOOL	bMvtEuro ;						// Monnaie en Euro
#endif	// EURO_VERSION

	// Tresor
	ULONG	uTresorLine ;					// Nombre de lignes en trsorerie
	HGLOBAL	hListLineTresor ;				// Liste de lignes en trsorerie
	double	dValueFranc ;					// Montant total de l'criture TTC en Franc
	double	dValueEuro ;					// Montant total de l'criture TTC en Euro

	// Rpartition Pro / Perso
	char	szComptePro [SIZE_CPT + 1] ;	// Compte de rpartition professionnel
	char	szComptePerso [SIZE_CPT + 1] ;	// Compte de rpartition personnelle
	double	dProFranc	;					// Montant de la rpartition Pro TTC en Franc
	double	dProEuro ;						// Montant de la rpartition Pro TTC en Euro

	// Taxe
	char	szCompteTaxe [SIZE_CPT + 1] ;	// Compte de TVA
	double	dTaxeFranc	;					// Montant de la rpartition Pro TTC en Franc
	double	dTaxeEuro ;						// Montant de la rpartition Pro TTC en Euro
	double	dTaxe ;							// Taux de taxe

	// Caractristiques
	BOOL	bCredit ;						// VRAI si Crdit SINON Dbit

	// Etats
	BOOL	bMark ;							// Pointe

} TYPEDEF (RECEcrStandard) ;

#pragma pack()


API_EXPORT BOOL HDAPI		ReadEcrStandard			(LPCSTR lpPath, ULONG uMvt, LPRECEcrStandard lpEcrStandard) ;
API_EXPORT BOOL HDAPI		AddEcrStandard			(LPCSTR lpPath, LPRECEcrStandard lpEcrStandard) ;
API_EXPORT BOOL HDAPI		UpdateEcrStandard		(LPCSTR lpPath, ULONG uMvt, LPRECEcrStandard lpEcrStandard) ;
API_EXPORT BOOL HDAPI		RemoveEcrStandard		(LPCSTR lpPath, ULONG uMvt) ;

API_EXPORT DWORD HDAPI		GetEcrStandardRec		(LPCSTR lpPath) ;
API_EXPORT DWORD HDAPI		GetEcrStandardSize		(LPCSTR lpPath) ;

API_EXPORT BOOL HDAPI		GetEcrLineTresor		(LONG nPos, LPRECEcrStandard lpEcrStandard, LPRECEcrLineTresor lpEcrLineTresor) ;
API_EXPORT BOOL HDAPI		SetEcrLineTresor		(LONG nPos, LPRECEcrStandard lpEcrStandard, LPRECEcrLineTresor lpEcrLineTresor) ;

API_EXPORT BOOL HDAPI		MakeEcrStandardLineTresor	(ULONG uPos, LPRECEcrStandard lpEcrStandard, LPRECLines lpLines) ;
API_EXPORT BOOL HDAPI		MakeEcrStandardLinePro		(LPRECEcrStandard lpEcrStandard, LPRECLines lpLigne) ;
API_EXPORT BOOL HDAPI		MakeEcrStandardLineTaxe		(LPRECEcrStandard lpEcrStandard, LPRECLines lpLines) ;
API_EXPORT BOOL HDAPI		MakeEcrStandardLinePerso	(LPRECEcrStandard lpEcrStandard, LPRECLines lpLines) ;

API_EXPORT BOOL HDAPI		ValidEcrStandard		(LPCSTR lpPath, ULONG uMvt, BOOL bValid) ;
API_EXPORT BOOL HDAPI		MarkEcrStandard			(LPCSTR lpPath, ULONG uMvt, BOOL bMark) ;
API_EXPORT BOOL HDAPI		ReverseMarkEcrStandard	(LPCSTR lpPath, ULONG uMvt) ;
API_EXPORT BOOL HDAPI		RemisEcrStandard		(LPCSTR lpPath, ULONG uMvt, BOOL bRemis) ;
API_EXPORT BOOL HDAPI		ReverseRemisEcrStandard	(LPCSTR lpPath, ULONG uMvt) ;
API_EXPORT BOOL HDAPI		RappEcrStandard			(LPCSTR lpPath, ULONG uMvt, LPRECBanques lpBanques) ;



// Gestion des critures simplifies
//////////////////////////////////////////////////////////////////////
#pragma pack(1)

typedef struct
{
	HEADER_MVTRECORD

	// Source d'un mouvement
	USHORT	uMvtGamme ;						// Application  l'origine du mouvement (APPSRC_HELLODOC/APPSRC_HDES)

#ifdef EURO_VERSION
	// Monnaie
	BOOL	bMvtEuro ;						// Monnaie en Euro
#endif	// EURO_VERSION

	// Trsorerie
	char	szCompteTresor [SIZE_CPT + 1] ;	// Numro du compte de trsorerie
	double	dValueFranc ;					// Montant de l'criture TTC en Franc
	double	dValueEuro ;					// Montant de l'criture TTC en Euro

	// Rpartition Pro / Perso
	char	szComptePro [SIZE_CPT + 1] ;	// Compte de rpartition professionnel
	char	szComptePerso [SIZE_CPT + 1] ;	// Compte de rpartition personnelle
	double	dProFranc	;					// Montant de la rpartition Pro TTC en Franc
	double	dProEuro ;						// Montant de la rpartition Pro TTC en Euro

	// Taxe
	char	szCompteTaxe [SIZE_CPT + 1] ;	// Compte de TVA
	double	dTaxeFranc	;					// Montant de la rpartition Pro TTC en Franc
	double	dTaxeEuro ;						// Montant de la rpartition Pro TTC en Euro
	double	dTaxe ;							// Taux de taxe

	// Caractristiques
	BOOL	bCredit ;						// VRAI si Crdit SINON Dbit
	USHORT	uPaiement ;						// Mode de paiement : PAIEMENT_CHEQUE/PAIEMENT_VIREMENT

	// Etats
	BOOL	bRapp ;							// Rapproche
	BOOL	bMark ;							// Pointe
	BOOL	bRemis ;						// Remise

	// Information rapprochement bancaire
	char	szRappCompte [SIZE_CPT + 1] ;	// Numro du compte bancaire
	char	szRappDesign [SIZE_LIB + 1] ;	// Dsignation de l'opration
	HDDATE	RappDate ;						// Date de l'opration
	HDDATE	RappDateValeur ;				// Date de valeur de l'opration
	double	dRappValueFranc ;				// Montant de l'opration en Franc
	double	dRappValueEuro ;				// Montant de l'opration en Euro
	BOOL	bRappCredit ;					// VRAI si Crdit SINON Dbit

} TYPEDEF (RECEcrSimple) ;

#pragma pack()


API_EXPORT BOOL HDAPI		ReadEcrSimple			(LPCSTR lpPath, ULONG uMvt, LPRECEcrSimple lpEcrSimple) ;
API_EXPORT BOOL HDAPI		AddEcrSimple			(LPCSTR lpPath, LPRECEcrSimple lpEcrSimple) ;
API_EXPORT BOOL HDAPI		UpdateEcrSimple			(LPCSTR lpPath, ULONG uMvt, LPRECEcrSimple lpEcrSimple) ;
API_EXPORT BOOL HDAPI		RemoveEcrSimple			(LPCSTR lpPath, ULONG uMvt) ;

API_EXPORT DWORD HDAPI		GetEcrSimpleRec			(LPCSTR lpPath) ;
API_EXPORT DWORD HDAPI		GetEcrSimpleSize		(LPCSTR lpPath) ;

API_EXPORT BOOL HDAPI		MakeEcrSimpleLinePro	(LPRECEcrSimple lpEcrSimple, LPRECLines lpLines) ;
API_EXPORT BOOL HDAPI		MakeEcrSimpleLineTaxe	(LPRECEcrSimple lpEcrSimple, LPRECLines lpLines) ;
API_EXPORT BOOL HDAPI		MakeEcrSimpleLineTresor	(LPRECEcrSimple lpEcrSimple, LPRECLines lpLines) ;
API_EXPORT BOOL HDAPI		MakeEcrSimpleLinePerso	(LPRECEcrSimple lpEcrSimple, LPRECLines lpLines) ;

API_EXPORT BOOL HDAPI		ValidEcrSimple			(LPCSTR lpPath, ULONG uMvt, BOOL bValid) ;
API_EXPORT BOOL HDAPI		MarkEcrSimple			(LPCSTR lpPath, ULONG uMvt, BOOL bMark) ;
API_EXPORT BOOL HDAPI		ReverseMarkEcrSimple	(LPCSTR lpPath, ULONG uMvt) ;
API_EXPORT BOOL HDAPI		RemisEcrSimple			(LPCSTR lpPath, ULONG uMvt, BOOL bRemis) ;
API_EXPORT BOOL HDAPI		ReverseRemisEcrSimple	(LPCSTR lpPath, ULONG uMvt) ;
API_EXPORT BOOL HDAPI		RappEcrSimple			(LPCSTR lpPath, ULONG uMvt, LPRECBanques lpBanques) ;

// Gestion des oprations diverses
//////////////////////////////////////////////////////////////////////
#pragma pack(1)

typedef struct
{
	HEADER_MVTRECORD

	// Source d'un mouvement
	USHORT	uMvtGamme ;						// Application  l'origine du mouvement (APPSRC_HELLODOC/APPSRC_HDES)

#ifdef EURO_VERSION
	// Monnaie
	BOOL	bMvtEuro ;						// Monnaie en Euro
#endif	// EURO_VERSION

	// Etats
	BOOL	bMark ;							// Pointe

} TYPEDEF (RECOpDiverses) ;

#pragma pack()

API_EXPORT BOOL HDAPI		ReadOpDiverses			(LPCSTR lpPath, ULONG uMvt, LPRECOpDiverses lpOpDiverses) ;
API_EXPORT BOOL HDAPI		UpdateOpDiverses		(LPCSTR lpPath, ULONG uMvt, LPRECOpDiverses lpOpDiverses) ;
API_EXPORT BOOL HDAPI		RemoveOpDiverses		(LPCSTR lpPath, ULONG uMvt) ;

API_EXPORT BOOL HDAPI		ValidOpDiverses			(LPCSTR lpPath, ULONG uMvt, BOOL bValid) ;
API_EXPORT BOOL HDAPI		MarkOpDiverses			(LPCSTR lpPath, ULONG uMvt, BOOL bMark) ;
API_EXPORT BOOL HDAPI		ReverseMarkOpDiverses	(LPCSTR lpPath, ULONG uMvt) ;
API_EXPORT BOOL HDAPI		RappOpDiverses			(LPCSTR lpPath, ULONG uMvt, LPRECBanques lpBanques) ;

API_EXPORT DWORD HDAPI		GetOpDiversesRec		(LPCSTR lpPath) ;
API_EXPORT DWORD HDAPI		GetOpDiversesSize		(LPCSTR lpPath) ;


//////////////////////////////////////////////////////////////////
//
//  Fichier des critures automatiques
//
//////////////////////////////////////////////////////////////////

#pragma pack(1)

typedef struct
{
	ULONG	uEcrAuto ;						// Numro de l'criture automatique
	USHORT	uMvtType ;						// Type de mouvement (MVT_RECETTE/MVT_DEPENSE/MVT_OD)
	char	szMvtDesign [SIZE_LIB + 1] ;	// Libell du mouvement
	HDDATE	MvtDate ;						// Date

#ifdef EURO_VERSION
	// Monnaie
	BOOL	bMvtEuro ;						// Monnaie en Euro
#endif	// EURO_VERSION

	// Trsorerie
	char	szCompteTresor [SIZE_CPT + 1] ;	// Numro du compte de trsorerie
	double	dValueFranc ;					// Montant de l'criture en Franc
	double	dValueEuro ;					// Montant de l'criture en Euro

	// Rpartition Pro / Perso
	char	szComptePro [SIZE_CPT + 1] ;	// Compte de rpartition professionnel
	double	dProFranc ;						// Montant de la rpartition Pro TTC en Franc
	double	dProEuro ;						// Montant de la rpartition Pro TTC en Euro

	// Taxe
	char	szCompteTaxe [SIZE_CPT + 1] ;	// Compte de TVA
	double	dTaxeFranc	;					// Montant de la rpartition Pro TTC en Franc
	double	dTaxeEuro ;						// Montant de la rpartition Pro TTC en Euro
	double	dTaxe ;							// Taux de taxe

	// Paiements
	USHORT	uPaiement ;						// Mode de paiement (PAIEMENT_CHEQUE/PAIEMENT_VIREMENT)
	ULONG	uNbPaiements ;					// Nombre de paiements
	ULONG	uNbPaiementsRestant ;			// Nombre de paiements restant
	USHORT	uPeriodicite ;					// Priodicite (PER_UNIQUE/PER_SEMAINE...)
	HDDATE	DateTransaction ;				// Date de dernire transaction

	// Caractristiques
	BOOL	bAnnoncer ;						// Annoncer avant

} TYPEDEF (RECEcrituresAuto) ;

#pragma pack()


API_EXPORT HGLOBAL HDAPI 	OpenEcrituresAuto		(void) ;
API_EXPORT void HDAPI 		CloseEcrituresAuto		(HGLOBAL) ;
API_EXPORT void HDAPI 		FlushEcrituresAuto		() ;
API_EXPORT BOOL HDAPI		ReadEcrituresAuto		(int nIdx, LPRECEcrituresAuto lpEcrituresAuto, LPCSTR lpExercice /*= NULL*/) ;
API_EXPORT BOOL HDAPI		WriteEcrituresAuto		(LPRECEcrituresAuto lpEcrituresAuto, LPCSTR lpExercice /*= NULL*/) ;
API_EXPORT BOOL HDAPI		DeleteEcrituresAuto		(int nIdx, LPCSTR lpExercice /*= NULL*/) ;
API_EXPORT DWORD HDAPI		GetEcrituresAutoRec		(LPCSTR lpExercice /*= NULL*/) ;

API_EXPORT BOOL HDAPI		IsEcrituresAuto			(ULONG uEcrAuto, LPCSTR lpExercice /*= NULL*/) ;
API_EXPORT ULONG HDAPI		GetNewEcrituresAuto		() ;
API_EXPORT USHORT HDAPI		GetPeriodiciteID		(LPCSTR lpPeriodicite) ;
API_EXPORT LPSTR HDAPI		GetPeriodiciteString	(USHORT uID, LPSTR lpPeriodicite, ULONG uSize) ;
API_EXPORT HDDATE HDAPI		GetNextDateEcrituresAuto (HDDATE Date, HDDATE DateLast, USHORT uPeriodicite) ;


//////////////////////////////////////////////////////////////////////
//
//	Fichiers des immobilisations
//
//////////////////////////////////////////////////////////////////////

#define	IMMOBILISATIONSLEN1	SIZE_DATE + SIZE_IMMO	// Date + uImmo
#define	IMMOBILISATIONSLEN2	SIZE_IMMO				// uImmo

#define IMMOBILISATIONS_BY_DATE		0
#define IMMOBILISATIONS_BY_ID		1

#pragma pack(1)

typedef struct
{
	ULONG	uImmo ;						// Numro de l'immobilisation
	char	szLibelle [SIZE_LIB + 1] ;	// Libell de l'amortissement
	HDDATE	Date ;						// Date
	double	dTauxTVA ;					// Taux de TVA dductible
	double	dPrixTTCFranc ;				// Prix d'achat TTC en Franc
	double	dPrixTTCEuro ;				// Prix d'achat TTC en Euro
	double	dPrixTVAFranc ;				// Prix d'achat HT en Franc
	double	dPrixTVAEuro ;				// Prix d'achat HT en Euro
	double	dValueFranc ;				// Valeur amortissable en Franc
	double	dValueEuro ;				// Valeur amortissable en Euro

	BYTE	nMode ;						// IMMO_DUREE / IMMO_TAUX
	BYTE	nTypeTaux ;					// TAUX_LINEAIRE / TAUX_DEGRESSIF / TAUX_EXCEPTIONNEL
	double	dDuree ;					// Dure d'utilisation
	double	dTaux ;						// Valeur du Taux

	HDDATE	DateCession ;				// Date de cession
	double	dPrixCessionFranc ;			// Prix de cession en Franc
	double	dPrixCessionEuro ;			// Prix de cession en Euro

	BOOL	bRebut ;					// Mise au rebut

#ifdef EURO_VERSION
	// Monnaie
	BOOL	bEuro ;						// Monnaie en Euro
	BOOL	bCessionEuro ;				// Monnaie de cession en Euro

	// Reserves
	BYTE	Reserve [38] ;				// Reserve pour extension
#else	// EURO_VERSION
	// Reserves
	BYTE	Reserve [46] ;				// Reserve pour extension
#endif	// EURO_VERSION

} TYPEDEF (RECImmobilisations) ;

#pragma pack()

API_EXPORT BOOL HDAPI 		CreatImmobilisations (LPCSTR lpPath /*= NULL*/) ;
API_EXPORT HGLOBAL HDAPI 	OpenImmobilisations (LPCSTR lpPath /*= NULL*/) ;
API_EXPORT void HDAPI 		CloseImmobilisations (HGLOBAL) ;
API_EXPORT void HDAPI 		FlushImmobilisations () ;
API_EXPORT int HDAPI 		GetOpenFlagImmobilisations () ;
API_EXPORT LPSTR HDAPI		MakeImmobilisationsKey1 (LPSTR lpKey, HDDATE Date, ULONG uImmo) ;
API_EXPORT LPSTR HDAPI		MakeImmobilisationsKey2 (LPSTR lpKey, ULONG uImmo) ;
API_EXPORT BOOL HDAPI	 	ReadImmobilisations (LPRECImmobilisations lpImmobilisations, int nKey) ;
API_EXPORT HDFILEPOS HDAPI 	WriteImmobilisations (LPRECImmobilisations lpImmobilisations) ;
API_EXPORT BOOL HDAPI		DeleteImmobilisations (HDFILEPOS Idx) ;
API_EXPORT ULONG HDAPI		GetFreeImmobilisationsID (LPCSTR lpPath /*= NULL*/) ;
API_EXPORT ULONG HDAPI		GetLastImmobilisationsID () ;
API_EXPORT BOOL HDAPI		WriteLastImmobilisationsID (ULONG uImmo) ;

//////////////////////////////////////////////////////////////////////
//
//	Fichiers des amortissements
//
//////////////////////////////////////////////////////////////////////

#define	AMORTISSEMENTSLEN	SIZE_IMMO + SIZE_YEAR		// uImmo + nYear

#define AMORTISSEMENTS_BY_YEAR		0

#pragma pack(1)

typedef struct
{
	ULONG	uImmo ;				// Numro de l'immobilisation
	UINT	uYear ;				// Anne de l'amortissement
	double	dValueFranc ;		// Valeur de l'amortissement en Franc
	double	dValueEuro ;		// Valeur de l'amortissement en Euro

	// Reserves
	BYTE	Reserve [50] ;		// Reserve pour extension
} TYPEDEF (RECAmortissements) ;

#pragma pack()

API_EXPORT BOOL HDAPI 		CreatAmortissements (LPCSTR lpPath) ;
API_EXPORT HGLOBAL HDAPI 	OpenAmortissements (LPCSTR lpPath) ;
API_EXPORT void HDAPI 		CloseAmortissements (HGLOBAL) ;
API_EXPORT void HDAPI 		FlushAmortissements () ;
API_EXPORT int HDAPI 		GetOpenFlagAmortissements () ;
API_EXPORT LPSTR HDAPI		MakeAmortissementsKey (LPSTR lpKey, ULONG uImmo, UINT uYear) ;
API_EXPORT BOOL HDAPI	 	ReadAmortissements (LPRECAmortissements lpAmortissements) ;
API_EXPORT HDFILEPOS HDAPI 	WriteAmortissements (LPRECAmortissements lpAmortissements) ;
API_EXPORT BOOL HDAPI		DeleteAmortissements (HDFILEPOS Idx) ;


//#ifdef IMS_VERSION
//////////////////////////////////////////////////////////////////////
//
//	Fichiers de conversion DFCC
//
//////////////////////////////////////////////////////////////////////

//  Fichier DFCC
//////////////////////////////////////////////////////////////////////
#define	DFCCLEN1			8		// DFCC (SIZE_DFCC)
#define	DFCCLEN2			31		// MOT (25) + POSITION (1) + 4

#pragma pack(1)

typedef struct
{
	char		szCodeDFCC [SIZE_DFCC + 1] ;	// Code DFCC
	char		szCodeCIM9 [SIZE_CIM9 + 1] ;	// Code CIM9
	char		szCodeCIM10 [SIZE_CIM10 + 1] ;	// Code CIM10
	char		szLibelle [128] ;				// Libell DFCC
} TYPEDEF (RECDFCC) ;

#pragma pack()

API_EXPORT BOOL HDAPI 		CreatDFCC (LPCSTR lpPath /*= NULL*/) ;
API_EXPORT HGLOBAL HDAPI 	OpenDFCC (LPCSTR lpPath /*= NULL*/) ;
API_EXPORT void HDAPI 		CloseDFCC (HGLOBAL) ;
API_EXPORT void HDAPI 		FlushDFCC () ;
API_EXPORT int HDAPI 		GetOpenFlagDFCC () ;
API_EXPORT HANDLE HDAPI		GetHFileDFCC () ;
API_EXPORT LPSTR HDAPI		MakeDFCC1Key (LPSTR lpKey, LPCSTR lpCodeDFCC) ;
API_EXPORT LPSTR HDAPI		MakeDFCC2Key (LPSTR lpKey, LPCSTR lpWord, USHORT uPos) ;
API_EXPORT BOOL HDAPI	 	ReadDFCC (HDFILEPOS Idx, LPRECDFCC lpDFCC) ;
API_EXPORT BOOL HDAPI 		WriteDFCC (HDFILEPOS Idx, LPRECDFCC lpDFCC) ;

//#endif	// IMS_VERSION

//#ifdef PEDIATRIE_VERSION
//////////////////////////////////////////////////////////////////////
//
//	Fichiers HdPediatrie
//
//////////////////////////////////////////////////////////////////////

//  Fichier HdPediatrie
//////////////////////////////////////////////////////////////////////
#define	PEDIATRIELEN	(5 + 8 + 1)		// N Fiche + DateMesure

#define PEDIATRIE_BY_DATE	0

#pragma pack(1)

typedef struct
{
	WORD	wStatus ;					// Etat enregistrement (0 = OK)
	USHORT	uFiche ;					// Numro de fiche patient
	HDDATE	DateMesure ;				// Date derniere Mesure
	float	nPoids ;					// Poids en Kg //short
	float	nPc	;						// Primtre Crnien en Cm //short
	float	nTaille ;					// Taille en Cm //short
	char	szNom [21] ;				// Nom du patient
	char	szPrenom [21] ;				// Prnom du patient
	BYTE	Extension [16] ;			// Rserve pour extension

} TYPEDEF (RECPediatrie) ;

#pragma pack()

API_EXPORT BOOL	HDAPI		CreatPediatrie (LPCSTR lpPath /*= NULL*/) ;
API_EXPORT HGLOBAL HDAPI 	OpenPediatrie (LPCSTR lpPath /*= NULL*/) ;
API_EXPORT void	HDAPI 		ClosePediatrie (HGLOBAL) ;
API_EXPORT void HDAPI 		FlushPediatrie () ;
API_EXPORT int HDAPI 		GetOpenFlagPediatrie () ;
API_EXPORT LPSTR HDAPI 		MakePediatrieKey (LPSTR lpKey, USHORT	uFiche, HDDATE Date) ;
API_EXPORT HDFILEPOS HDAPI 	ReadPediatrie (LPRECPediatrie lpPediatrie, int nKey) ;
API_EXPORT BOOL HDAPI 		WritePediatrie (LPRECPediatrie lpPediatrie) ;
API_EXPORT BOOL HDAPI 		DeletePediatrie (HDFILEPOS Idx) ;
API_EXPORT DWORD HDAPI 		GetPediatrieSize (LPCSTR lpPath /*= NULL*/) ;
API_EXPORT DWORD HDAPI 		GetPediatrieRec (LPCSTR lpPath /*= NULL*/) ;

//#endif	// PEDIATRIE_VERSION

//#ifdef HELLOSANTE_VERSION
//////////////////////////////////////////////////////////////////////
//
//	Fichiers Seances
//
//////////////////////////////////////////////////////////////////////

//  Fichier Seances
//////////////////////////////////////////////////////////////////////
#define	SEANCESLEN1	(5 + 5 + 8 + 6 + 5 + 3 + 1)	// N Fiche + N Traitement + Date + Heure + N Seance + N Acte
#define	SEANCESLEN2	(5 + 8 + 6 + 5 + 5 + 3 + 1)	// N Fiche + Date + Heure + N Traitement + N Seance + N Acte
#define	SEANCESLEN3	(8 + 6 + 5 + 5 + 5 + 3 + 1)	// Date + Heure + N Fiche + N Traitement + N Seance + N Acte
#define	SEANCESLEN4	(5 + 8 + 6 + 5 + 5 + 3 + 1)	// N Seance + N Fiche + N Traitement + Date + Heure + N Acte
#define	SEANCESLEN5	(1 + 5 + 5 + 5 + 3 + 1)		// WaitPointe + N Seance + Date + Heure + N Fiche + N Traitement + N Acte
#define	SEANCESLEN6	(9 + 5 + 5 + 5 + 3 + 1)		// N FSE + N Fiche + N Traitement + N Seance + N Acte

#define SEANCES_BY_TRAITEMENTS	0
#define SEANCES_BY_FICHES		1
#define SEANCES_BY_DATES		2
#define SEANCES_BY_ID			3
#define	SEANCES_BY_WAITPOINTE	4
#define	SEANCES_BY_NUMFSE		5

#pragma pack(1)

typedef struct
{
	WORD	wStatus ;							// Etat enregistrement (0 = OK)
	USHORT	uFiche ;							// Numro de fiche patient
	USHORT	uTraitement ;						// Numro de traitement
	USHORT	uSeance ;							// Numro de la scance
	USHORT	uActe ;								// Numro d'acte
	HDDATE	Date ;								// Date prvue
	HDTIME	Time ;								// Heure prvue
	char	szUser [SIZE_USER] ;				// Utilisateur
	char	szFacturant [SIZE_USER] ;			// Utilisateur facturant
	char	szCode [SIZE_CODE + 1] ;			// Code acte
	char	szNomenclature [SIZE_CODE + 1] ;	// Nomenclature
	LONG	lQuantite ;							// Quantite
	double	dTarif ;							// Tarif
	double	dCoef ;								// Coefficient
	char	cNumTM ;							// Ticket Modrateur
	char	cTypeMajor ;						// Majoration
	char	cCodeJust ;							// Justificatif de dpense
	SBOOL	bPointe ;							// Pointe
	SBOOL	bFacture ;							// Facture
	SBOOL	bPlanifiee ;						// Seance planifiee
	UINT	uCotation ;							// Numro de la cotation associe
	SBOOL	bKms ;								// Prsence de kilomtres dans la sance

	// Gestion pointage temporaire
	SBOOL	bWaitPointe ;						// Pointage en cours
	SBOOL	bWaitDepointe ;						// Depointage en cours
	HDDATE	OldDate ;							// Date avant pointage
	HDTIME	OldTime ;							// Heure avant pointage
	SBOOL	bAddPointe ;						// Ajout d'un pointage en cours

	// Lien avec le rendez-vous
	HDDATE	DateRDV ;							// Date du rendez-vous
	HDTIME	TimeRDV ;							// Heure du rendez-vous

	double	dMontant ;							// Montant  facturer

	ULONG	uFse ;								// Numro de FSE

	BYTE	Extension [38] ;					// Rserve pour extension

} TYPEDEF (RECSeances) ;

#pragma pack()

API_EXPORT BOOL	HDAPI		CreatSeances (LPCSTR lpPath /*= NULL*/) ;
API_EXPORT HGLOBAL HDAPI 	OpenSeances (LPCSTR lpPath /*= NULL*/) ;
API_EXPORT void	HDAPI 		CloseSeances (HGLOBAL) ;
API_EXPORT void HDAPI 		FlushSeances () ;
API_EXPORT int HDAPI 		GetOpenFlagSeances () ;
API_EXPORT LPSTR HDAPI 		MakeSeancesKey1 (LPSTR lpKey, USHORT uFiche, USHORT uTraitement, HDDATE Date, HDTIME Time, USHORT uSeance, USHORT uActe) ;
API_EXPORT LPSTR HDAPI 		MakeSeancesKey2 (LPSTR lpKey, USHORT uFiche, HDDATE Date, HDTIME Time, USHORT uTraitement, USHORT uSeance, USHORT uActe) ;
API_EXPORT LPSTR HDAPI 		MakeSeancesKey3 (LPSTR lpKey, HDDATE Date, HDTIME Time, USHORT uFiche, USHORT uTraitement, USHORT uSeance, USHORT uActe) ;
API_EXPORT LPSTR HDAPI 		MakeSeancesKey4 (LPSTR lpKey, USHORT uFiche, USHORT uTraitement, USHORT uSeance, HDDATE Date, HDTIME Time, USHORT uActe) ;
API_EXPORT LPSTR HDAPI 		MakeSeancesKey5 (LPSTR lpKey, SBOOL bWaitPointe, SBOOL bWaitDepointe, USHORT uFiche, USHORT uTraitement, USHORT uSeance, USHORT uActe) ;
API_EXPORT LPSTR HDAPI 		MakeSeancesKey6 (LPSTR lpKey, ULONG uFse, USHORT uFiche, USHORT uTraitement, USHORT uSeance, USHORT uActe) ;
API_EXPORT HDFILEPOS HDAPI 	ReadSeances (LPRECSeances lpSeances, int nKey) ;
API_EXPORT HDFILEPOS HDAPI 	WriteSeances (LPRECSeances lpSeances) ;
API_EXPORT BOOL HDAPI 		DeleteSeances (HDFILEPOS Idx) ;
API_EXPORT DWORD HDAPI 		GetSeancesSize (LPCSTR lpPath /*= NULL*/) ;
API_EXPORT DWORD HDAPI 		GetSeancesRec (LPCSTR lpPath /*= NULL*/) ;

API_EXPORT HDFILEPOS HDAPI 	AddSeances		(LPCSTR lpPath /*= NULL*/, LPRECSeances lpSeances) ;
API_EXPORT BOOL HDAPI		ChangeSeances	(LPCSTR lpPath /*= NULL*/, HDFILEPOS Idx, LPRECSeances lpSeances) ;
API_EXPORT BOOL HDAPI	 	RemoveSeances	(LPCSTR lpPath /*= NULL*/, HDFILEPOS Idx) ;

API_EXPORT USHORT HDAPI		GetLastSeancesID (LPCSTR lpPath, USHORT uFiche, USHORT uTraitement) ;
API_EXPORT BOOL HDAPI		ExistSeancesID (LPCSTR lpPath, USHORT uFiche, USHORT uTraitement, USHORT uSeance) ;
API_EXPORT USHORT HDAPI		GetFreeSeancesID (LPCSTR lpPath, USHORT uFiche, USHORT uTraitement) ;


//////////////////////////////////////////////////////////////////////
//
//	Fichiers TraitementsID
//
//////////////////////////////////////////////////////////////////////

//  Fichier Traitements ID
//////////////////////////////////////////////////////////////////////
#define	TRAITEMENTSIDLEN1	(5 + 5 + 1)			// N Fiche + N Traitement
#define	TRAITEMENTSIDLEN2	(1 + 5 + 5 + 1)		// Cloture + N Fiche + N Traitement
#define	TRAITEMENTSIDLEN3	(1 + 5 + 5 + 1)		// WaitCloture + N Fiche + N Traitement
#define	TRAITEMENTSIDLEN4	(8 + 5 + 5 + 1)		// DateDemande + N Fiche + N Traitement

#define TRAITEMENTSID_BY_ID				0
#define TRAITEMENTSID_BY_CLOTURE		1
#define TRAITEMENTSID_BY_WAITCLOTURE	2
#define TRAITEMENTSID_BY_DATEDEMANDE	3

API_EXPORT BOOL	HDAPI		CreatTraitementsID (LPCSTR lpPath /*= NULL*/) ;
API_EXPORT BOOL HDAPI	 	OpenTraitementsID (LPCSTR lpPath /*= NULL*/) ;
API_EXPORT void	HDAPI 		CloseTraitementsID () ;
API_EXPORT void HDAPI 		FlushTraitementsID () ;
API_EXPORT int HDAPI 		GetOpenFlagTraitementsID () ;
API_EXPORT LPSTR HDAPI 		MakeTraitementsIDKey1 (LPSTR lpKey, USHORT uFiche, USHORT uTraitement) ;
API_EXPORT LPSTR HDAPI 		MakeTraitementsIDKey2 (LPSTR lpKey, SBOOL bCloture, USHORT uFiche, USHORT uTraitement) ;
API_EXPORT LPSTR HDAPI 		MakeTraitementsIDKey3 (LPSTR lpKey, SBOOL bWaitCloture, USHORT uFiche, USHORT uTraitement) ;
API_EXPORT LPSTR HDAPI 		MakeTraitementsIDKey4 (LPSTR lpKey, HDDATE DatePresc, USHORT uFiche, USHORT uTraitement) ;
API_EXPORT USHORT HDAPI		GetLastTraitementsID	(LPCSTR lpPath, USHORT uFiche) ;
API_EXPORT BOOL HDAPI		ExistTraitementsID		(LPCSTR lpPath, USHORT uFiche, USHORT uTraitement) ;
API_EXPORT USHORT HDAPI		GetFreeTraitementsID	(LPCSTR lpPath, USHORT uFiche) ;

//////////////////////////////////////////////////////////////////////
//
//	Fichiers FSP
//
//////////////////////////////////////////////////////////////////////

//  Fichier FSP
//////////////////////////////////////////////////////////////////////
#define	FSPLEN	(5 + 8 + 6 + 2 + 1)					// N Fiche + Date + Heure + NFSP

#pragma pack(1)

typedef struct
{
	WORD	wStatus ;							// Etat enregistrement (0 = OK)

	USHORT	uFSP ;								// Numro de FSP
	USHORT	uFiche ;							// Numro de fiche patient
	HDDATE	Date ;								// Date de cration de la recette
	HDDATE	Time ;								// Heure de cration de la recette

	USHORT	uTraitement ;						// Numro de traitement
	char	szUser [SIZE_USER] ;				// Utilisateur

	// Bnficiaire des soins
	char	szNomBenef [27] ;					// Nom du bnficiaire
	char	szPrenomBenef [27] ;				// Prnom du bnficiaire
	HDDATE	DateNaiBenef ;						// Date de naissance du bnficiaire
	char	cRangGemellaireBenef ;				// Rang gmellaire du bnficiaire
	char	szNumINBenef [14] ;					// Numro d'identification nationale
	char	szCleINBenef [3] ;					// Cl du numro d'IN
	char	szNumAMCBenef [11] ;				// N Organisme complmentaire

	// Assur
	char	szNomAssure [27] ;					// Nom du bnficiaire
	char	szPrenomAssure [27] ;				// Prnom du bnficiaire
	char	szNumINAssure [14] ;				// Numro d'identification nationale
	char	szCleINAssure [3] ;					// Cl du numro d'IN

	// Adresse
	char	szAdresse [81] ;					// Adresse
	char	szCPostal [6] ;						// Code Postal
	char	szVille [21] ;						// Ville

	// Auxiliaire mdical(e)
	char	szNomAux [21] ;						// Nom de l'auxiliaire mdical(e)
	char	szNumINAux [9] ;					// Cl du numro d'identification facture
	char	cCleINAux ;							// Cl du numro d'identification facture
	char	szCodeSpecialiteAux [3] ;			// Code spcialit

	// Auxiliaire mdical(e) salari(e)
	char	szNomAuxS [21] ;					// Nom de l'auxiliaire mdical(e)
	char	szNumINAuxS [9] ;					// Cl du numro d'identification facture
	char	cCleINAuxS ;						// Cl du numro d'identification facture
	char	szCodeSpecialiteAuxS [3] ;			// Code spcialit

	// Prescripteur
	char	szNomPresc [21] ;					// Nom du prescripteur
	char	szNumINPresc [9] ;					// Numro de prescripteur
	char	cCleINPresc ;						// Cl de prescription
	char	szCodeSpecialitePresc [3] ;			// Code spcialit du prescripteur
	HDDATE	DatePresc ;							// Date de la prescription
	HDDATE	DateEntente ;						// Date entente pralable

	// Conditions de prise en charge
	HDDATE	DateAss ;							// Date assurance
	SBOOL	bMaladie ;							// Indicateur assurance Maladie
	SBOOL	bAccident ;							// Indicateur assurance Accident
	SBOOL	bMaternite ;						// Indicateur assurance Maternit
	char	szNumAT [9] ;						// Numro d'accident de travail
	char	cCleAT ;							// Cl du numro d'accident de travail

	// Monnaie
	char	szMonnaie [4] ;						// Monnaie

	// Tiers
	SBOOL	bAMO ;								// L'assur n'a pas pau la part obligatoire
	SBOOL	bAMC ;								// L'assur n'a pas pay la part complmentaire

	// Actes effectus
	struct
	{
		HDDATE	DateActe ;						// Date d'acte
		char	szActe [SIZE_CODE + 1] ;		// Code d'acte
		UINT	unQuantite ;					// Quantit d'actes pratiqus
		UINT	unCoeff ;						// Coeff (en centimes)
		UINT	unPU ;							// Prix unitaire (en centimes)
		char	cActeCompl ;					// Nuit/Dimanche
		UINT	unTotal ;						// Total (en centimes)
		double	dMontant ;						// Montant des honoraires facturs

		BYTE	Extension [20] ;				// Rserve pour extension
	} Acte [6] ;

	BYTE	Extension [50] ;					// Rserve pour extension

} TYPEDEF (RECFSP) ;

#pragma pack()

API_EXPORT BOOL	HDAPI		CreatFSP (LPCSTR lpPath /*= NULL*/) ;
API_EXPORT HGLOBAL HDAPI	OpenFSP (LPCSTR lpPath /*= NULL*/) ;
API_EXPORT void	HDAPI 		CloseFSP (HGLOBAL) ;
API_EXPORT void HDAPI 		FlushFSP () ;
API_EXPORT LPSTR HDAPI 		MakeFSPKey (LPSTR lpKey, USHORT uFiche, HDDATE Date, HDTIME Time, USHORT uFSP) ;
API_EXPORT HDFILEPOS HDAPI 	ReadFSP (LPRECFSP lpFSP) ;
API_EXPORT HDFILEPOS HDAPI 	WriteFSP (LPRECFSP lpFSP) ;
API_EXPORT BOOL HDAPI 		DeleteFSP (HDFILEPOS Idx) ;
API_EXPORT DWORD HDAPI 		GetFSPSize (LPCSTR lpPath /*= NULL*/) ;
API_EXPORT DWORD HDAPI 		GetFSPRec (LPCSTR lpPath /*= NULL*/) ;
API_EXPORT int HDAPI 		GetOpenFlagFSP () ;


//#endif	// HELLOSANTE_VERSION

//////////////////////////////////////////////////////////////////////
//
//	CONSTANTES
//
//////////////////////////////////////////////////////////////////////

//	Taille maximum d'un enregistrement dossier
//////////////////////////////////////////////////////////////////////
#define DOSSIER_MAX	sizeof (RECTraitements)


//////////////////////////////////////////////////////////////////////

#ifdef __cplusplus
}
#endif

#endif	// !defined(HDAPI_H_INCLUDED)

