///////////////////////////////////////////////////////////////////////////
// HD_export2
///////////////////////////////////////////////////////////////////////////
// 16/04/2002
//
// Copyright (c) 2002-2003, E. Ravon (Bat)
///////////////////////////////////////////////////////////////////////////

#include <windows.h>
#include "config.h"		//paramtres de config
#include "hdapi.h"		//proto HDAPI
#include <time.h>		//pour avoir la conversion HMS=>heure GMT


///////////////////////////////////////////////////////////////////////////////////////////
// Helper pour Palm
///////////////////////////////////////////////////////////////////////////////////////////

int n_entry;	//nb d'entres
int pos_entry;	//position dans le fichier
HANDLE hdle;	//handle pour la lecture
void palm_write_cstring(HANDLE fic,char *str);	//ecrit une chaine appele CString (rien  voir avec une chaine C)
void palm_read_cstring(HANDLE hdle,char *str,int len_buf);
		//lit une chaine CString,
		//	str pointe vers le buffer de reception (p NULL)
		//  len_buf longueur du buffer
		// attention si le buffer est trop court, la chaine est ignore (on avance dans le fichier)
//Donnes PALM

#define PALM_DESKTOP_KEY "Software\\U.S. Robotics\\Pilot Desktop\\Core"
#define PALM_DESKTOP_KEY_USER "Software\\U.S. Robotics\\Pilot Desktop\\Preferences"

unsigned const char HEADER_PALM[4]={0x00,0x01,0x42,0x44};


/*****************************************************/
void palm_write_header(HANDLE hdle,char *nom){
/*****************************************************/
int ecrit;
int len;
int dummy;

WriteFile(hdle,HEADER_PALM,4,&ecrit,NULL);		// Format DB10
palm_write_cstring(hdle,nom);			// Nom du fichier de sortie
palm_write_cstring(hdle,"");				// Custom show header
dummy=128;
WriteFile(hdle,&dummy,4,&ecrit,NULL);	// Next Free Category ID
dummy=0;
WriteFile(hdle,&dummy,4,&ecrit,NULL);	// Count - 1 of the number of category entries (does not include Unfiled category)
//Category
dummy=54;
WriteFile(hdle,&dummy,4,&ecrit,NULL);	// Schema Resource ID
dummy=15;
WriteFile(hdle,&dummy,4,&ecrit,NULL);	// Schema Fields per row. Will be 15 for datebook.
dummy=0;
WriteFile(hdle,&dummy,4,&ecrit,NULL);	// Schema Record ID Position (index to field table entry that contains record id)
dummy=1;
WriteFile(hdle,&dummy,4,&ecrit,NULL);	// Schema Record Status Position (index to field table entry that contains record status)
dummy=2;
WriteFile(hdle,&dummy,4,&ecrit,NULL);	// Schema Placement Position (index to field table entry that contains record placement position)
dummy=15;
WriteFile(hdle,&dummy,2,&ecrit,NULL);	// Schema Field Count (number of fields in schema)
unsigned short field_entry[]={1,1,1,3,1,5,1,5,6,6,1,6,1,1,8};
WriteFile(hdle,&field_entry,15*2,&ecrit,NULL);	// Schema Field Entry
n_entry=0;
pos_entry=SetFilePointer(hdle,0,NULL,FILE_CURRENT);

dummy=0;
WriteFile(hdle,&dummy,4,&ecrit,NULL);	// Record count * 15

}

/*****************************************************/
void palm_close_header(HANDLE hdle){
/*****************************************************/
int ecrit;
int dummy;
SetFilePointer(hdle,pos_entry,NULL,FILE_BEGIN);

// nb d'entres
dummy=(n_entry)*15;
WriteFile(hdle,&dummy,4,&ecrit,NULL);	// Record count * 15
}


/*****************************************************/
void palm_write_entry(HANDLE hdle,HDDATE date,HDTIME time,char *txt1,char *txt2){
/*****************************************************/
int ecrit;
int len;
int dummy;
struct tm t,*tret;		//pour l'heure
time_t debut;		//heure de dbut du RDV
TIME_ZONE_INFORMATION tz;

dummy=1;								// Field Type : Integer
WriteFile(hdle,&dummy,4,&ecrit,NULL);	//
dummy=n_entry;							// Record ID
WriteFile(hdle,&dummy,4,&ecrit,NULL);	//

dummy=1;								// Field Type : Integer
WriteFile(hdle,&dummy,4,&ecrit,NULL);	//
dummy=1;								// Record Add
WriteFile(hdle,&dummy,4,&ecrit,NULL);	//

dummy=1;								// Field Type : Integer
WriteFile(hdle,&dummy,4,&ecrit,NULL);	//
dummy=0x7FFFFFFF;						// Position
WriteFile(hdle,&dummy,4,&ecrit,NULL);	//

dummy=3;								// Field Type : Date
WriteFile(hdle,&dummy,4,&ecrit,NULL);	//


memset(&t,0,sizeof(t));
t.tm_sec=0;
t.tm_min=MINUTE(time);
t.tm_hour=HOUR(time);
t.tm_mday=DAY(date);
t.tm_mon=MONTH(date)-1;
t.tm_year=YEAR(date)-1900;
t.tm_isdst=0;
debut=mktime(&t);
tret=localtime(&debut); // reconvertit pour avoir le flag tret->tm_isdt(heure d't)

if (tret->tm_isdst) // la date que l'on code est en heure d't
	debut-=60*60; 						// enlve une heure pour rcuprer le temps UTC
else 				// la date que l'on code est en heure d'hiver
	debut-=0;

WriteFile(hdle,&debut,4,&ecrit,NULL);	// Date Start

dummy=1;								// Field Type : Date
WriteFile(hdle,&dummy,4,&ecrit,NULL);	//
debut=debut+config.increment_agenda*60;						// 15 mn par dfaut (pb aprs 23h45)
WriteFile(hdle,&debut,4,&ecrit,NULL);	// Date

dummy=5;								// Field Type : CString
WriteFile(hdle,&dummy,4,&ecrit,NULL);	//
dummy=0;								// Always 0
WriteFile(hdle,&dummy,4,&ecrit,NULL);	//
palm_write_cstring(hdle,txt1);			// Description

dummy=1;								// Field Type : Integer
WriteFile(hdle,&dummy,4,&ecrit,NULL);	//
dummy=0;								// Duration
WriteFile(hdle,&dummy,4,&ecrit,NULL);	//


dummy=5;								// Field Type : CString
WriteFile(hdle,&dummy,4,&ecrit,NULL);	//
dummy=0;								// Always 0
WriteFile(hdle,&dummy,4,&ecrit,NULL);	//
palm_write_cstring(hdle,txt2);			// Note

dummy=6;								// Field Type : Boolean
WriteFile(hdle,&dummy,4,&ecrit,NULL);	//
dummy=0;								// Untimed
WriteFile(hdle,&dummy,4,&ecrit,NULL);	//

dummy=6;								// Field Type : Boolean
WriteFile(hdle,&dummy,4,&ecrit,NULL);	//
dummy=0;								// Private
WriteFile(hdle,&dummy,4,&ecrit,NULL);	//

dummy=1;								// Field Type : Integer
WriteFile(hdle,&dummy,4,&ecrit,NULL);	//
dummy=0;								// Category
WriteFile(hdle,&dummy,4,&ecrit,NULL);	//

dummy=6;								// Field Type : Boolean
WriteFile(hdle,&dummy,4,&ecrit,NULL);	//
dummy=0;								// Alarme Set
WriteFile(hdle,&dummy,4,&ecrit,NULL);	//

dummy=1;								// Field Type : Integer
WriteFile(hdle,&dummy,4,&ecrit,NULL);	//
dummy=0xFFFF;							// Alarm Advance time units
WriteFile(hdle,&dummy,4,&ecrit,NULL);	//

dummy=1;								// Field Type : Integer
WriteFile(hdle,&dummy,4,&ecrit,NULL);	//
dummy=0xFFFF;							// Alarm Adv Type
WriteFile(hdle,&dummy,4,&ecrit,NULL);	//

dummy=8;								// Field Type : Repeat Event
WriteFile(hdle,&dummy,4,&ecrit,NULL);	//
dummy=0x0000;							// Alarm Adv Type
WriteFile(hdle,&dummy,4,&ecrit,NULL);	//

n_entry++;
}

/*****************************************************/
void palm_write_cstring(HANDLE hdle,char *str){
/*****************************************************/
unsigned char tmp[3];
int ecrit;
int len;

if (!(*str)){//chaine vide
	tmp[0]=0;
	WriteFile(hdle,tmp,1,&ecrit,NULL);		// Ecriture dans le fichier de sortie
	return;
	}
len=strlen(str);
if (len<255){	//longueur infrieure  255 caractres
	tmp[0]=len;
	WriteFile(hdle,tmp,1,&ecrit,NULL);		// Ecriture dans le fichier de sortie
	WriteFile(hdle,str,len,&ecrit,NULL);		// Ecriture dans le fichier de sortie
	}
else{			//suprieure ou gale  255
	tmp[0]=0xFF;
	*(unsigned short*)&tmp[1]=len;
	WriteFile(hdle,tmp,3,&ecrit,NULL);		// Ecriture dans le fichier de sortie
	WriteFile(hdle,str,len,&ecrit,NULL);		// Ecriture dans le fichier de sortie
	}
}

/*****************************************************/
void palm_read_cstring(HANDLE hdle,char *str,int len_buf){
/*****************************************************/
unsigned char tmp[3];
int lu;
int len;

ReadFile(hdle,tmp,1,&lu,NULL);
if (!tmp[0]){	// Chaine vide
	if (str && len_buf>=1)
		*str=0;
	return;
	}
if (tmp[0]!=0xFF) //longueur infrieure  255 caractres
	len=tmp[0];
else{
	ReadFile(hdle,tmp,2,&lu,NULL);
	len=*(unsigned short *)tmp[0];
	}

if (str && len_buf>len){
	ReadFile(hdle,str,len,&lu,NULL);
	*(str+len)=0;
	return;
	}
else
	SetFilePointer(hdle,len,NULL,FILE_CURRENT);
}


/******************************************************/
int palm_open_datebook(){
/******************************************************/
HKEY key,key1;
int type,lg;
char path[MAX_PATH];	//emplacement du fichier datebook
char tmp[MAX_PATH];		//buffer temporaire

int lu;
//int len;
int dummy;
int nb_cat;	//nb de categories
int err;	// TRUE indique une erreur  l'ouverture du fichier

//Cration de la chaine o est situ datebook.dat
//
// Rep de Palm desktop + nom de l'utilisateur par dfaut + datebook.dat

if (!config.path_datebook[0]){
	//Recherche automatique
	RegOpenKey(HKEY_CURRENT_USER,PALM_DESKTOP_KEY,&key);	// lit les donnes (si disponibles)
	if (key==NULL)
		return -1;
	path[0]=0;
	lg=MAX_PATH;
	RegQueryValueEx(key,"DesktopPath",0,&type,&path,&lg);
	RegCloseKey(key);
	strcat(path,"\\");

	RegOpenKey(HKEY_CURRENT_USER,PALM_DESKTOP_KEY_USER,&key);	// lit les donnes (si disponibles)
	if (key==NULL)
		return -1;

	lg=MAX_PATH-strlen(path);
	RegQueryValueEx(key,"DesktopUser",0,&type,&path[strlen(path)],&lg);
	RegCloseKey(key);

	strcat(path,"\\datebook\\datebook.dat");
	}
else
	strcpy(path,config.path_datebook);

//Ouvre le fichier
hdle=CreateFile(path,GENERIC_READ,FILE_SHARE_READ,NULL,OPEN_EXISTING,0,NULL);
if (hdle==INVALID_HANDLE_VALUE)
	return -1;

//Lit le header
ReadFile(hdle,tmp,4,&lu,NULL);			// Format DB10
if (memcmp(tmp,HEADER_PALM,4)){			// Correct ?
	CloseHandle(hdle);
	return -1;
	}
palm_read_cstring(hdle,NULL,0);			// Nom du fichier (IGNORE)
palm_read_cstring(hdle,NULL,0);			// Custom show header
ReadFile(hdle,&dummy,4,&lu,NULL);		// Next Free Category ID
ReadFile(hdle,&nb_cat,4,&lu,NULL);		// Count - 1 of the number of category entries (does not include Unfiled category)

//Passe les catgories
for (;nb_cat;nb_cat--){
	ReadFile(hdle,&dummy,4,&lu,NULL);	// Category Index
	ReadFile(hdle,&dummy,4,&lu,NULL);	// Category ID
	ReadFile(hdle,&dummy,4,&lu,NULL);	// Category Dirty Flag
	palm_read_cstring(hdle,NULL,0);		// Long Category Name
	palm_read_cstring(hdle,NULL,0);		// Short Category Name
	}

//Category
ReadFile(hdle,&dummy,4,&lu,NULL);	// Schema Resource ID
ReadFile(hdle,&dummy,4,&lu,NULL);	// Schema Fields per row. Will be 15 for datebook.
ReadFile(hdle,&dummy,4,&lu,NULL);	// Schema Record ID Position (index to field table entry that contains record id)
ReadFile(hdle,&dummy,4,&lu,NULL);	// Schema Record Status Position (index to field table entry that contains record status)
ReadFile(hdle,&dummy,4,&lu,NULL);	// Schema Placement Position (index to field table entry that contains record placement position)
ReadFile(hdle,&dummy,2,&lu,NULL);	// Schema Field Count (number of fields in schema)
unsigned short field_entry[15];
ReadFile(hdle,&field_entry,15*2,&lu,NULL);	// Schema Field Entry
ReadFile(hdle,&dummy,4,&lu,NULL);	// Record count * 15
dummy/=15;
return dummy;	//record count
}


/*****************************************************************************/
int palm_read_entry(HDDATE *date,HDTIME *time,char *txt1,char *txt2,int len){
/*****************************************************************************/
int lu;
int dummy;
int status;
unsigned short repeat;	//repeat event
unsigned short len_txt;		//longueur
unsigned short brand;	//brand data
unsigned short nb_exception;

ReadFile(hdle,&dummy,4,&lu,NULL);	//
ReadFile(hdle,&dummy,4,&lu,NULL);	//

ReadFile(hdle,&dummy,4,&lu,NULL);	//
ReadFile(hdle,&status,4,&lu,NULL);	// Status

ReadFile(hdle,&dummy,4,&lu,NULL);	//
ReadFile(hdle,&dummy,4,&lu,NULL);	//

ReadFile(hdle,&dummy,4,&lu,NULL);	//
if (dummy!=3)		//date
	return FALSE;

struct tm *t;
ReadFile(hdle,&dummy,4,&lu,NULL);	// Date Start
t=localtime(&dummy);
*date=MAKEDATE(t->tm_mday,t->tm_mon+1,t->tm_year+1900);
*time=MAKETIME(t->tm_hour,t->tm_min,t->tm_sec);

ReadFile(hdle,&dummy,4,&lu,NULL);	//
ReadFile(hdle,&dummy,4,&lu,NULL);	// Date Fin

ReadFile(hdle,&dummy,4,&lu,NULL);	//
if (dummy!=5)		//CString : description
	return FALSE;
ReadFile(hdle,&dummy,4,&lu,NULL);	//
palm_read_cstring(hdle,txt1,len);		// Description

ReadFile(hdle,&dummy,4,&lu,NULL);	//
ReadFile(hdle,&dummy,4,&lu,NULL);	//


ReadFile(hdle,&dummy,4,&lu,NULL);	//
if (dummy!=5)		//CString : Note
	return FALSE;
ReadFile(hdle,&dummy,4,&lu,NULL);	//
palm_read_cstring(hdle,txt2,len);		// Note

ReadFile(hdle,&dummy,4,&lu,NULL);	// Untimed
ReadFile(hdle,&dummy,4,&lu,NULL);	//

ReadFile(hdle,&dummy,4,&lu,NULL);	// Private
ReadFile(hdle,&dummy,4,&lu,NULL);	//

ReadFile(hdle,&dummy,4,&lu,NULL);	// Category
ReadFile(hdle,&dummy,4,&lu,NULL);	//

ReadFile(hdle,&dummy,4,&lu,NULL);	// Alamr Set
ReadFile(hdle,&dummy,4,&lu,NULL);	//

ReadFile(hdle,&dummy,4,&lu,NULL);	// Alarm Adv Units
ReadFile(hdle,&dummy,4,&lu,NULL);	//

ReadFile(hdle,&dummy,4,&lu,NULL);	//Alarm Adv Type
ReadFile(hdle,&dummy,4,&lu,NULL);	//

ReadFile(hdle,&dummy,4,&lu,NULL);	//Repeat Event
if (dummy!=8)		//CString : Repeat Event
	return FALSE;

ReadFile(hdle,&nb_exception,2,&lu,NULL);	//Date Exceptions
for (;nb_exception;nb_exception--)
	ReadFile(hdle,&dummy,4,&lu,NULL);	//Exception entry

ReadFile(hdle,&repeat,2,&lu,NULL);	//Repeat Event Flag

if (repeat){ //diffrent de 0, il y a encore qquechose  lire
	if (repeat==0xFFFF){ //il y a un Class entry  lire
		ReadFile(hdle,&dummy,2,&lu,NULL);	//Constant 1
		ReadFile(hdle,&len_txt,2,&lu,NULL);	//Length of Class Name
		SetFilePointer(hdle,len_txt,NULL,FILE_CURRENT);		//passe le texte suivant
		}
	ReadFile(hdle,&brand,4,&lu,NULL);	//Brand
	ReadFile(hdle,&dummy,4,&lu,NULL);	//Interval
	ReadFile(hdle,&dummy,4,&lu,NULL);	//End Date
	ReadFile(hdle,&dummy,4,&lu,NULL);	//First Day of Week
	switch (brand){
		case 1:
			SetFilePointer(hdle,4,NULL,FILE_CURRENT);
			break;
		case 2:
			SetFilePointer(hdle,5,NULL,FILE_CURRENT);
			break;
		case 3:
			SetFilePointer(hdle,8,NULL,FILE_CURRENT);
			break;
		case 4:
			SetFilePointer(hdle,4,NULL,FILE_CURRENT);
			break;
		case 5:
			SetFilePointer(hdle,8,NULL,FILE_CURRENT);
			break;
		default:
			return FALSE;
		}
	}

if (status==0x80 || status==0x04){ //archiv ou effac => ignor
	*date=0;
	*time=0;
	}

return TRUE;
}


/******************************************************/
void palm_close_datebook(){
/******************************************************/
CloseHandle(hdle);
}

/**************************************************************************/
void palm_make_string_export(char *tmp,LPRECAgendas ag,LPRECPatients pat){
/**************************************************************************/
wsprintf(tmp,"%c %s %s",
	ag->nWarning==2 ? 'V' : ' ',					// Visite ?
	pat->uFiche ? pat->szNom : "N.A.",				// Nom Patient
	pat->uFiche ? pat->szPrenom : "N.A."			// Prenom Patient
	);
}

