///////////////////////////////////////////////////////////////////////////
// HD_export2
///////////////////////////////////////////////////////////////////////////
// 16/04/2002
//
// Copyright (c) 2002-2003, E. Ravon (Bat)
///////////////////////////////////////////////////////////////////////////


#include <windows.h>
#include "hdapi5.h"		//proto HDAPI
#include "config.h"		//configuration
#include "main.h"
#include "res.h"		//lments interface utilisateur
#include "process.h"
#include "palm.h"		//helper palm
#include "psion.h"		//helper psion

void traite_agenda(HWND hwnd,LPRECAgendas ag,LPRECPatients pat,int type); // exporte les donnes du fichier Agenda
//type indique le type d'export (EXPORT_TEXTE, EXPORT_PALM,etc)

void import_palm(HWND hwnd,LPRECAgendas ag,LPRECPatients pat);	  	// importe les donnes depuis un fichier PALM
void import_psion(HWND hwnd,LPRECAgendas ag,LPRECPatients pat);		// importe les donnes depuis un fichier PSION

int is_patient_in_list(LPRECPatients pat);
	//retourne TRUE si le patient est dans la liste fourni par l'utilisateur (config.liste_patient)

/**********************************************/
void hd_conf_cabinet(HWND hwnd){
/**********************************************/
//char password[MAX_PATH]="";
if (!config.path[0]){
	HDGetApplicationInfo("Chemins","Cabinets",config.path,MAX_PATH);
	HDGetApplicationInfo ("Cabinets","Dernier",config.cabinet,MAX_PATH) ;
	HDGetApplicationInfo ("Cabinets",config.cabinet,config.user,MAX_PATH) ;
	}
if (HDOpenCabinetDlg (hwnd,config.path,config.cabinet,config.user,config.password))
	HDCloseCabinet();

}


/**********************************************/
void hd_traite_agenda(HWND hwnd,int type){
/**********************************************/
HGLOBAL 		Agenda;		//handle sur le fichier Agenda
HGLOBAL 		Patient;	//handle sur le fichier Patient
LPRECAgendas	ag;			//pointeur sur les donnes
LPRECPatients	pat;		//pointeur sur les donnes
int ok;						// a 1 si ouverture correcte

    if (!HDOpenCabinet(config.path,config.cabinet,config.user,config.password)){ 		// tentative ouverture
        aff_erreur(NULL,"Impossible d'ouvrir le cabinet.\nSi il est protg par un mot de passe, vous devez le rouvrir");
        return;
        }


// Rcupration Info utilisateur (incrment de l'agenda)
LPRECPasses lpPasses;
HGLOBAL hRec;
int idx;	// index (N d'enregistrement dans le fichier utilisateur)

    hRec = OpenPasses () ;										//ouvre le fichier des utilisateurs
    lpPasses = (LPRECPasses) GlobalLock (hRec) ;				//lock la zone mmoire fournie
    for (ok=0,idx=1;ok==0;idx++){								//pour chaque enreigstrement
        if (ReadPasses (idx, lpPasses, config.cabinet)==FALSE)	//lit les donnes
            ok=-1;												//si ce n'tait pas bon, alors on a fini de lire +> pas trouv l'utilisateur
        if (strcmp(lpPasses->szUser,config.user)==0)			//si c'est le bon
            ok=1;												//ok on l'a trouv
        }
    if (ok!=1){	// si ce n'est pas le bon => petit message d'info
        MessageBox(NULL,"Erreur impossible de trouver l'utilisateur","ATTENTION !",MB_ICONERROR);
        config.increment_agenda=15;			//valeur par dfaut
        }
    else
        config.increment_agenda=lpPasses->nInterAgenda;			//Rcupre la valeur

    GlobalUnlock(hRec);											//Dlocke et libre la zone
    ClosePasses (hRec);

    ok=0;
    // Ouverture Agenda+Patient
    Agenda=OpenAgendas(NULL);							// ouvre l'agenda
    if (Agenda){										// ouverture OK
        ag=(LPRECAgendas)GlobalLock(Agenda); 			// Lockage mmoire
        if (ag){										// lock mmoire OK
            Patient=OpenPatients(NULL);					// ouvre le fichier patients
            if (Patient){
                pat=(LPRECPatients)GlobalLock(Patient);
                if (pat){
                    ok=1;
                    switch (type){
                        case EXPORT_TEXTE: case EXPORT_PALM: case EXPORT_PSION: case EXPORT_CSV:
                            traite_agenda(hwnd,ag,pat,type);
                            break;
                        case IMPORT_PALM:
                            import_palm(hwnd,ag,pat);
                            break;
                        case IMPORT_PSION:
                            import_psion(hwnd,ag,pat);
                            break;
                        default:
                            aff_erreur(NULL,"Action inconnue !");
                        }
                    GlobalUnlock(Patient);
                    }
                ClosePatients(Patient);
                }
            GlobalUnlock(Agenda);
            }
        CloseAgendas(Agenda);
        }
    HDCloseCabinet();
    if (!ok)
        aff_erreur(NULL,"Impossible d'ouvrir les fichiers d'HD !");
    return;
}

/***************************************************************/
char *conv(char *str){
/***************************************************************/
char *p;
char *o;
char *out=LocalAlloc(LMEM_FIXED,strlen(str)*2+1);
    o=out;
    p=str;
    while (*p){
        switch (*p){
            case '\t': *o++='\\';*o++='t'; p++; break;
            case '\r': *o++='\\';*o++='r'; p++; break;
            case '\n': *o++='\\';*o++='n'; p++; break;
            default: *o++=*p++; break;
        }
    }
    *o=0;
    return out;
}


/***************************************************************/
void traite_agenda(HWND hwnd,LPRECAgendas ag,LPRECPatients pat,int type){
/***************************************************************/

// Fichier HD
char cle[MAX_KEYLEN];	//cl de recherche
HDDATE 		date;		//date actuelle
HDFILEPOS	index;		//index (position dans le fichier)
// Fichier externe
HANDLE hdle;

char tmp[255];		//buffer temporaire
int nb_export;		//nb d'enregistrements exports
int nb_char;		//nb de caracres dans la chaine
int ecrit;			//nb d'octets rellement erits dans le fichier

    //Ouverture du fichier sur le disque
    switch (type){
        case EXPORT_CSV:
            hdle=CreateFile(FIC_EXPORT_AGENDA_CSV,GENERIC_WRITE,FILE_SHARE_READ,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL);
            break;
        case EXPORT_TEXTE:
            hdle=CreateFile(FIC_EXPORT_AGENDA,GENERIC_WRITE,FILE_SHARE_READ,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL);
            break;
        case EXPORT_PALM:
            hdle=CreateFile(FIC_EXPORT_AGENDA_PALM,GENERIC_WRITE,FILE_SHARE_READ,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL);
            break;
        case EXPORT_PSION:
            hdle=CreateFile(FIC_EXPORT_AGENDA_PSION,GENERIC_WRITE,FILE_SHARE_READ,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL);
            break;
        }
    if (hdle==INVALID_HANDLE_VALUE){
        aff_erreur(hwnd,"Impossible d'ouvrir le fichier de sortie");
        return;
        }

    if (type==EXPORT_PALM){
        char dir[MAX_PATH];
        GetCurrentDirectory(MAX_PATH,dir);
        strcat(dir,"\\");
        strcat(dir,FIC_EXPORT_AGENDA_PALM);
        palm_write_header(hdle,dir);
        }

    SendDlgItemMessage(hwnd,IDD_MAIN_ACTION,WM_SETTEXT,0,(LPARAM)"Export Agenda");

    //Initilaisation nombre d'exports et affichage
    nb_export=0;
    wsprintf(tmp,"%d",nb_export);
    SendDlgItemMessage(hwnd,IDD_MAIN_CPT,WM_SETTEXT,0,(LPARAM)tmp);

    date=Today();
    MakeAgendas1Key(cle,config.user,config.export_all ? 0 : date,0);
                                                    // Construit une cl de recherche pour obtenir
                                                    // les enregistrements classs dans l'ordre suivant
                                                    // par utilisateur
                                                    // pour chaque utilisateur, par date
                                                    // pour chaque utilisateur, par date et par heure
                                                    // Ex : Pierre  05/04 13:15
                                                    // Ex : Pierre  05/04 18:15
                                                    // Ex : Pierre  15/04 13:15
                                                    // Ex : Vincent 02/04 11:00

    index=HDBrowseKey(AGENDAS1X,cle);				// Trouve la premire cl  partir de "cle", ceci dans l'ordre dfini
                                                    // par le type de cl (AGENDAS1X) (cf au dessus)
                                                    // Ici, on ne trouvera pas la cl exacte
                                                    // ([config.user],[Date du jour],[00:00])
                                                    // Mais la premire dispo, par ex :
                                                    // ([config.user],[Date du jour],[08:00])


    while (index){									// tant que l'index est correct, c'est  dire !=0
        HDReadRec(AGENDAS,index,(char *)ag); 		// lecture de l'enregistrement
        if (!stricmp(ag->szUser,config.user) &&
           (!config.today_only || ag->Date==date) ){
                                                    // tjrs le mme utilisateur ?
                                                    // et tjrs le mme jour (si il faut tenir compte du jour)

            pat->uFiche=ag->uFiche;
            if (pat->uFiche)
                ReadPatients (pat,PATIENTS_BY_REC);	// On peut ici rapidement lire l'enregistrement recherch, sans
                                                        // avoir  construire une cl, rechercher la cl, lire l'enregistrement,etc,etc
            else									// ne pas oublier de remettre  0 si pas de patient ...
                memset(pat,0,sizeof(RECPatients));

            if ((!config.use_visite || (config.use_visite&&ag->nWarning==2)) &&
                (!config.use_patient || (config.use_patient&&is_patient_in_list(pat)))  &&
                    ((HOUR(ag->Time))<24) ){	// Visite ?

                switch (type){
                    case EXPORT_TEXTE:
                        nb_char=wsprintf(tmp,"%02d/%02d/%04d %02d:%02d %c %s %s %s\r\n",
                                DAY(ag->Date),MONTH(ag->Date),YEAR(ag->Date),	// Date
                                HOUR(ag->Time),MINUTE(ag->Time),				// Heure
                                ag->nWarning==2 ? 'V' : ' ',					// Visite ?
                                pat->uFiche ? pat->szNom : "N.A.",				// Nom Patient
                                pat->uFiche ? pat->szPrenom : "N.A.",			// Prenom Patient
                                ag->szText										// Texte
                                );
                        WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie
                        break;
                    case EXPORT_CSV:
                        ;char *str=conv(ag->szText);
                        nb_char=wsprintf(tmp,"%02d/%02d/%04d;%02d:%02d;%c;%s;%s;%s\r\n",
                                DAY(ag->Date),MONTH(ag->Date),YEAR(ag->Date),	// Date
                                HOUR(ag->Time),MINUTE(ag->Time),				// Heure
                                ag->nWarning==2 ? 'V' : ' ',					// Visite ?
                                pat->uFiche ? pat->szNom : "N.A.",				// Nom Patient
                                pat->uFiche ? pat->szPrenom : "N.A.",			// Prenom Patient
                                str								                // Texte
                                );
                        LocalFree(str);
                        WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie
                        break;
                    case EXPORT_PALM:
                        ;
                        //Vrifie que ce n'est pas dj export dans le Palm
                        int n_entry=palm_open_datebook();
                        HDDATE datel;
                        HDTIME timel;
                        int ok=TRUE;
                        int i;
                        if (n_entry!=-1){	//pas d'erreur
                            for (i=0;i<n_entry;i++){
                                if (!palm_read_entry(&datel,&timel,NULL,NULL,0)){
                                    ok=FALSE;
                                    i=n_entry;
                                    }
                                if (ag->Date==datel && ag->Time==timel){
                                    ok=FALSE;
                                    i=n_entry;
                                    }
                                }
                            palm_close_datebook();
                            }
                        if (ok){
                            palm_make_string_export(tmp,ag,pat);
                            if (config.palm_group){ // on grouppe le nom et le commentaire  la suite
                                strcat(tmp," ");
                                strcat(tmp,ag->szText);
                                palm_write_entry(hdle,ag->Date,ag->Time,tmp,"");// Ecriture dans le fichier de sortie
                                }
                            else // nom group, en 2 champs spars
                                palm_write_entry(hdle,ag->Date,ag->Time,tmp,ag->szText);// Ecriture dans le fichier de sortie
                            }
                        else
                            nb_export--;		//compense
                        break;
                    case EXPORT_PSION:
                        psion_make_string_export(tmp,ag,pat);
                        WriteFile(hdle,tmp,strlen(tmp),&ecrit,NULL);		// Ecriture dans le fichier de sortie
                        break;
                    }

                // Affichage des infos sur l'avancement de l'export
                nb_export++;
                wsprintf(tmp,"%d",nb_export);
                SendDlgItemMessage(hwnd,IDD_MAIN_CPT,WM_SETTEXT,0,(LPARAM)tmp);
                }
            index=HDNextKey(AGENDAS1X,cle); 		// cl suivante
            }
        else										// l'enregistrement qu'on a lu est d'un autre utilisateur
            index=0;								// on a donc rcupr tous les enregistrements utiles
        }
    if (type==EXPORT_PALM){
        palm_close_header(hdle);
        MessageBox(hwnd,"Le fichier Agenda.dba a t cr.\n"\
        "Il peut tre import dans PalmDesktop","HD_Export",MB_ICONINFORMATION);
        }
    if (type==EXPORT_PSION)
        MessageBox(hwnd,"Le fichier HD_AG_UP.x a t cr.\n"\
        "Il doit tre transfr dans le rpertoire 'C:\\documents\\' du Psion\n"\
        "Il faut ensuite lancer HSync sur le Psion\n","HD_Export",MB_ICONINFORMATION);
    CloseHandle(hdle);								//referme le fichier de sortie

    SendDlgItemMessage(hwnd,IDD_MAIN_ACTION,WM_SETTEXT,0,(LPARAM)"Export Termin");
}


/***************************************************************/
void import_palm(HWND hwnd,LPRECAgendas ag,LPRECPatients pat){
/***************************************************************/

    MessageBox(hwnd,"Import PALM dsactiv","HDExport2",MB_ICONINFORMATION);
    return;
#if 0
// Fichier HD
char cle[MAX_KEYLEN];	//cl de recherche
HDFILEPOS	index;		//index (position dans le fichier)

int nb_import;		//nb d'enregistrements imports
//int nb_char;		//nb de caracres dans la chaine


int n_entry,i;

//Element rcupr du palm
HDDATE date;
HDTIME time;
char texte[255];		//buffer temporaire
char note[255];		//buffer temporaire

char txt_total[128];
char buf_user[1000];

n_entry=palm_open_datebook();
if (n_entry==-1){
	if (!config.path_datebook[0]){
		ouvre_fichier(hwnd,config.path_datebook,MAX_PATH,"Fichier DateBook.dat\x0 DateBook.dat\x0\x0\x0",
					"Recherche du fichier DateBook.dat");
		ecrit_config();
		n_entry=palm_open_datebook();
		if (n_entry==-1){
			aff_erreur(hwnd,"Erreur  l'ouverture du fichier DateBook.dat");
			return;
			}
		}
	}

nb_import=0;
wsprintf(buf_user,"%d",nb_import);
SendDlgItemMessage(hwnd,IDD_MAIN_CPT,WM_SETTEXT,0,(LPARAM)buf_user);

for (i=0;i<n_entry;i++){
	if (!palm_read_entry(&date,&time,texte,note,255)){
		aff_erreur(hwnd,"Erreur  la lecture d'un enregistrement de DateBook.dat");
		palm_close_datebook();
		return;
		}
	if (date>=Today()){	//enregistrement  importer

		// Cre le texte  importer
		strncpy(txt_total,texte,128);
		strncpy(&txt_total[strlen(txt_total)],note,128-strlen(txt_total));
		txt_total[127]=0;

		// Recherche si l'lment existe dj
		MakeAgendas1Key (cle,config.user,date,time);
		index=HDFindKey(AGENDAS1X,cle); // recherche cet enregistrement EXACT

		if (index){	//oui, il existe
			HDReadRec(AGENDAS,index,(char *)ag); 		// lecture de l'enregistrement
			pat->uFiche=ag->uFiche;
			if (pat->uFiche)
				ReadPatients (pat,PATIENTS_BY_REC);		// et fiche patient associe
			else
				memset(pat,0,sizeof(RECPatients));

			palm_make_string_export(buf_user,ag,pat);	// Si cet lment a t export vers le Palm, quelle
														// tte aurait il ?
			if (config.palm_group){ // on grouppe le nom et le commentaire  la suite
				strcat(buf_user," ");
				strcat(buf_user,ag->szText);
				}


			if (
				(config.palm_group &&					// palm group et tout le texte identique
					(strcmp(buf_user,txt_total) && strcmp(ag->szText,txt_total))  ) ||
			   	(!config.palm_group &&					// pas palm group
					(strcmp(ag->szText,txt_total) && 		// diffrent du texte de base
					(strcmp(ag->szText,note) || strcmp(buf_user,texte)) )
					)
				){ //diffrent du texte import depuis HD

				// L'lment existe dj et il est diffrent ..
				wsprintf(buf_user,"Il existe dj un lment le %02d/%02d/%04d  %02d:%02d\n\n"\
				"----- HD -----\n%s\n----- Palm -----\n%s\n\nRemplacer dans HD ?",
					DAY(ag->Date),MONTH(ag->Date),YEAR(ag->Date),	// Date
					HOUR(ag->Time),MINUTE(ag->Time),ag->szText,txt_total); 				// Heure

				// Remplacer ?
				if (MessageBox(hwnd,buf_user,"HD_Export - Attention !",MB_ICONQUESTION|MB_YESNO)==IDYES){
					strcpy(ag->szText,txt_total);	//oui
					WriteAgendas(ag);
					nb_import++;
					}
				}
			}
		else{	//l'lment n'existe pas
			memset(ag,0,sizeof(RECAgendas));
			ag->Date=date;
			ag->Time=time;
			strcpy(ag->szUser,config.user);
			strcpy(ag->szText,txt_total);	//oui
			WriteAgendas(ag);
			nb_import++;
			}
		}
	wsprintf(buf_user,"%d",nb_import);
	SendDlgItemMessage(hwnd,IDD_MAIN_CPT,WM_SETTEXT,0,(LPARAM)buf_user);
	}
palm_close_datebook();

SendDlgItemMessage(hwnd,IDD_MAIN_ACTION,WM_SETTEXT,0,(LPARAM)"Import Termin");
#endif
}




/***************************************************************/
void import_psion(HWND hwnd,LPRECAgendas ag,LPRECPatients pat){
/***************************************************************/
    MessageBox(hwnd,"Import PSION dsactiv","HDExport2",MB_ICONINFORMATION);
    return;
#if 0
HANDLE hdle;			//handle du fichier d'import

// Fichier HD
char cle[MAX_KEYLEN];	//cl de recherche
HDFILEPOS	index;		//index (position dans le fichier)

int nb_import;		//nb d'enregistrements imports
//int nb_char;		//nb de caracres dans la chaine


int n_entry,i;

//Element rcupr du palm
HDDATE date;
HDTIME time;
char texte[255];		//buffer temporaire

char buf_user[1000];

char *buffer;		//buffer contenant le fichier  importer
char *b;			//pointeur sur le buffer
char *c;			//pointeur sur la chaine de destination
int off;			//offset dans le bufffer
int taille;			//taille du buffer

hdle=CreateFile(FIC_IMPORT_AGENDA_PSION,GENERIC_READ,FILE_SHARE_READ,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
if (hdle==INVALID_HANDLE_VALUE){
	wsprintf(buf_user,"Erreur  l'ouverture du fichier d'import pour le Psion : %s",FIC_IMPORT_AGENDA_PSION);
	aff_erreur(hwnd,buf_user);
	return;
	}
taille=GetFileSize(hdle,NULL);
buffer=LocalAlloc(LMEM_FIXED,taille);
if (!buffer){
	CloseHandle(hdle);
	aff_erreur(hwnd,"Erreur d'allocation mmoire");
	}
ReadFile(hdle,buffer,taille,&i,NULL);
CloseHandle(hdle);

nb_import=0;
wsprintf(buf_user,"%d",nb_import);
SendDlgItemMessage(hwnd,IDD_MAIN_CPT,WM_SETTEXT,0,(LPARAM)buf_user);

off=0;
while (taille-off>12){	//plus assez d'lments

	b=&buffer[off]+12;			//pointeur sur le debut de la chaine de caractre
	c=texte;
	while (b<&buffer[taille] && *b!='\n')	//recopie de cette chaine
		*c++=*b++;
	*c=0;

	int n,h,j,m,a;
	buffer[off+12]=0;	//minute
	n=atoi(&(buffer[off+10]));

	buffer[off+10]=0;	//heure
	h=atoi(&(buffer[off+8]));

	buffer[off+8]=0;	//jour
	j=atoi(&(buffer[off+6]));

	buffer[off+6]=0;	//mois
	m=atoi(&(buffer[off+4]));

	buffer[off+4]=0;	//anne
	a=atoi(buffer);

	//ajustement offset
	if (*b=='\n')
		b++;
	off+=b-&buffer[off];

	date=MAKEDATE(j,m,a);
	time=MAKETIME(h,n,0);

	if (date>=Today()){	//enregistrement  importer


		texte[127]=0;
		// Recherche si l'lment existe dj
		MakeAgendas1Key (cle,config.user,date,time);
		index=HDFindKey(AGENDAS1X,cle); // recherche cet enregistrement EXACT

		if (index){	//oui, il existe
			HDReadRec(AGENDAS,index,(char *)ag); 		// lecture de l'enregistrement
			pat->uFiche=ag->uFiche;
			if (pat->uFiche)
				ReadPatients (pat,PATIENTS_BY_REC);		// et fiche patient associe

			psion_make_string_export(buf_user,ag,pat);	// Si cet lment a t export vers le Psion, quelle
														// tte aurait il ?


			if (strcmp(ag->szText,texte) && 		// diffrent du texte de base
				(strcmp(texte,buf_user)) ){ //diffrent du texte import depuis HD

				// L'lment existe dj et il est diffrent ..
				wsprintf(buf_user,"Il existe dj un lment le %02d/%02d/%04d  %02d:%02d\n\n"\
				"----- HD -----\n%s\n----- Psion -----\n%s\n\nRemplacer dans HD ?",
					DAY(ag->Date),MONTH(ag->Date),YEAR(ag->Date),	// Date
					HOUR(ag->Time),MINUTE(ag->Time),ag->szText,texte); 				// Heure

				// Remplacer ?
				if (MessageBox(hwnd,buf_user,"HD_Export - Attention !",MB_ICONQUESTION|MB_YESNO)==IDYES){
					strcpy(ag->szText,texte);	//oui
					WriteAgendas(ag);
					nb_import++;
					}
				}
			}
		else{	//l'lment n'existe pas
			memset(ag,0,sizeof(RECAgendas));
			ag->Date=date;
			ag->Time=time;
			strcpy(ag->szUser,config.user);
			strcpy(ag->szText,texte);	//oui
			WriteAgendas(ag);
			nb_import++;
			}
		}
	wsprintf(buf_user,"%d",nb_import);
	SendDlgItemMessage(hwnd,IDD_MAIN_CPT,WM_SETTEXT,0,(LPARAM)buf_user);
	}

LocalFree(buffer);
SendDlgItemMessage(hwnd,IDD_MAIN_ACTION,WM_SETTEXT,0,(LPARAM)"Import Termin");
#endif
}



















/////////////////////////////////////////////////////////////////////////////
// Helpers

/*****************************************************************/
int is_patient_in_list(LPRECPatients pat){
/*****************************************************************/
char *liste;	//pointeur sur la position courante dans la liste
char *end;		//pointeur sur la fin de l'lment courant
//Liste : "aaaa bbbb;cccc dddd"
char match[MAX_PATH];	//nom prnom  rechercher
int len_match;

    len_match=wsprintf(match,"%s %s",pat->szNom,pat->szPrenom);

    liste=config.liste_patient;	//pointeur sur le dbut la liste
    do{
        end=liste;
        while (*end && *end!=';')	//avance jusqu'au ';'
            end++;
        if (end-liste==len_match && !strnicmp(match,liste,len_match)) //compare (sans tenir compte de la casse)
            return TRUE;	//trouv
        liste=end+1;		//dbut  l'lment suivant
        }while(*end);		//fin de liste ? non, on continue ...

    return FALSE;	//pas trouv
}

