unit Unit1;

///////////////////////////////////////////////////////////////////////////
// Dmo HDAPI Delphi
///////////////////////////////////////////////////////////////////////////
// 08/11/2002
//
// Copyright (c) 2002, E. Ravon (Bat)
//
// Auteur : manu_bat_manu@yahoo.fr
//
// Dmonstration minimale de l'utilisation d'HDAPI en Delphi
//
// Ce code est un exemple d'accs en Delphi aux donnes du logiciel HelloDOC
// Il utilise la bibliothque HDAPI.
//
// Ce code a t dvelopp pour HelloDOC Etendu 4.56.791
// Ainsi que pour la version d'HDAPI.DLL associe.
//
// Il a t test avec HD 4.56 tendu
// Son fonctionnement n'est pas guaranti avec des versions plus rcentes d'HD
//
//
// HelloDOC est dvelopp par Imagine Editions.
// Windows est une marque de Microsoft Corporation
////////////////////////////////////////////////////////////////////////////


interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

  /////////////////////////////////////////////////////////////////////////
  // Import d'HDAPI
  /////////////////////////////////////////////////////////////////////////

  // Cet import (brutal ici) correspond au fichier '.h' dans le
  // cas du langage C. Il indique quels sont les fonctions mises
  //  disposition par HDAPI.DLL, mais aussi les types de donnes
  // (structures, constantes, utilises).
  //
  // Cet import peut (pourrait) tre ralis de plusieurs faon :
  //   *tel quel en le compltant pour chaque nouvelle fonction utilise
  //   *regroup dans une 'Unit' spciale HDAPI
  //   *gnr automatique par un outil (existant - si toutefois ce genre
  //     d'outil est disponible), ou outil maison
  //
  // La cration de cette section est ralise,  la fois  partir de la
  // documentation d'HDAPI (pdf) et d'hdapi.h

  /////////////////////////////////////////////////////////////////////////
  // ATTENTION !!!!! La 'translation' ralise ici n'est en aucun cas
  //                 guarantie ! On peut raisonablement estimer que peu
  //                 d'erreurs peuvent venir se loger dans la dfinition
  //                 des fonctions (function , procedure),
  //
  //                 PAR CONTRE, il est tout a fait possible qu'il reste des
  //                 erreurs dans les structures (record)
  //                 (notamment des erreurs d'alignement !)
  /////////////////////////////////////////////////////////////////////////

  // [hdapi.h] : typedef short	HDFILE ; // Identificateur fichier de squentiel index
  // [hdapi.h] : enum{...}
  type HdFileType =  (
	AGENDAS = 1,AGENDASX,AGENDAS1X = AGENDASX,AGENDAS2X,AGENDAS3X,

	PATIENTS,PATIENTSX,PATIENTS1X = PATIENTSX,PATIENTS2X,PATIENTS3X,
	PATIENTS_,PATIENTSX_,PATIENTS1X_ = PATIENTSX_,PATIENTS2X_,PATIENTS3X_,

	RECETTES,RECETTESX,RECETTES1X = RECETTESX,RECETTES2X,RECETTES3X,
	RECETTES4X,RECETTES_,RECETTESX_,RECETTES1X_ = RECETTESX_,RECETTES2X_,
	RECETTES3X_,RECETTES4X_,

	DEPENSES,DEPENSESX,

	PHARMACIES,PHARMACIESX,

	POSOLOGIES,POSOLOGIESX,

	DSIMEDICAMENTS,DSIMEDICAMENTSX,DSICIPX,

	DSIINTERACTIONS,DSIINTERACTIONSX,

	DSICLASSES,DSICLASSESX,

	DSIGRAVITES,DSIGRAVITESX,

	DSITEXTS,DSITEXTSX,

	DSIABSTRATS,DSIABSTRATSX,

	HOMEO,HOMEOX,

	DOSSIERS,DOSSIERSX,ANTECEDENTS = DOSSIERS,ANTECEDENTSX = DOSSIERSX,
	CONSULTATIONS = DOSSIERS,CONSULTATIONSX = DOSSIERSX,ORDONNANCES = DOSSIERS,
	ORDONNANCESX = DOSSIERSX,COURRIERS = DOSSIERS,COURRIERSX = DOSSIERSX,
	VACCINS = DOSSIERS,VACCINSX = DOSSIERSX,BIOLOGIES35 = DOSSIERS,
	BIOLOGIES35X = DOSSIERSX,BIOLOGIES = DOSSIERS,BIOLOGIESX = DOSSIERSX,
	NOTES = DOSSIERS,NOTESX = DOSSIERSX,BITMAPS = DOSSIERS,
	BITMAPSX = DOSSIERSX,PIECESJOINTES = DOSSIERS,PIECESJOINTESX = DOSSIERSX,
	INFOSESAM = DOSSIERS,INFOSESAMX = DOSSIERSX,SITFACTTLA = DOSSIERS,
	SITFACTTLAX = DOSSIERSX,TRAITEMENTS = DOSSIERS,TRAITEMENTSX = DOSSIERSX,
	DOSSIERS_,DOSSIERSX_,

	MEDIAVIDALX,

	INBOX,INBOXX,INBOX1X = INBOXX,INBOX2X,

	MAILX,MAIL1X = MAILX,MAIL2X,

	KEYWORDS,KEYWORDSX,LIENVITALEX,

	FSE,FSEX,FSE1X = FSEX,FSE2X,FSE3X,FSE4X,FSE5X,FSE_,
	FSEX_,FSE1X_ = FSEX_,FSE2X_,FSE3X_,FSE4X_,FSE5X_,

        LOT,LOTX,LOT1X = LOTX,LOT2X,LOT3X,LOT4X,

        LOT_,LOTX_,LOT1X_ = LOTX_,LOT2X_,LOT3X_,LOT4X_,

	PLAN,PLANX,PLAN1X = PLANX,PLAN2X,PLAN3X,PLAN4X,PLAN5X,

	JOURNAL,JOURNALX,JOURNAL1X = JOURNALX,JOURNAL2X,JOURNAL3X,
	JOURNAL4X,JOURNAL5X,JOURNAL6X,

	RUBRIQUES,RUBRIQUESX,RUBRIQUES1X = RUBRIQUESX,RUBRIQUES2X,
	RUBRIQUES3X,RUBRIQUES4X,

	BANQUES,BANQUESX,BANQUES1X = BANQUESX,BANQUES2X,BANQUES3X,

	DFCCX,DFCC1X = DFCCX,DFCC2X,

	IMMOBILISATIONS,IMMOBILISATIONSX,IMMOBILISATIONS1X = IMMOBILISATIONSX,
	IMMOBILISATIONS2X,

	AMORTISSEMENTS,AMORTISSEMENTSX,

	PEDIATRIE,PEDIATRIEX,

	SEANCES,SEANCESX,SEANCES1X = SEANCESX,SEANCES2X,SEANCES3X,SEANCES4X,
	SEANCES5X,SEANCES6X,

        TRAITEMENTSIDX,TRAITEMENTSID1X = TRAITEMENTSIDX,TRAITEMENTSID2X,
	TRAITEMENTSID3X,TRAITEMENTSID4X,

	FSP,FSPX,

	HD_TEMP_FILE,HD_TEMP_FILEX);

// [hdapi.h] : typedef	unsigned long HDDATE ;
type HDDATE = Longword;
type HDTIME = Longword;
type USHORT = Word;
type SBOOL = short;
type HDFILEPOS = LongWord;	// Position dans un fichier
const SIZE_USER = 16;   // Taille de l'identifcateur de l'utilisateur
const MAX_KEYLEN = 64;   //
const SIZE_PHONE = 12;   //
const SIZE_NAME = 20;   //
const PATIENTS_BY_REC = 1 ;

type
  RECAgendas =  packed record
  wStatus : WORD;		      // Etat enregistrement (0 = OK)
  Date : HDDATE;		      // Date du jour
  Time : HDTIME;		      // Heure du rendez-vous
  szUser : array[0..SIZE_USER-1] of Char ;// Nom de l'utilisateur
  nWarning : short;			// Source du rendez-vous RDV_RENDEZVOUS, RDV_VACCIN
  uFiche : USHORT;			// Numro de fiche patient
  szText : array[0..128-1] of Char ;      // Textes
  szTextName : array[0..13-1] of Char ;// Nom du fichier texte associ
  szSoundName : array[0..13-1] of Char ;	// Nom du fichier son associ
  szBitmapName : array[0..13-1] of Char ;	// Nom du fichier image associ
  bAlarme : SBOOL;			// VRAI si gnration d'une alarme ou Type de journe AGENDA_FERIE, AGENDA_GARDE, AGENDA_CONGE, AGENDA_AUTRE
  nRappel : short;			// Rappel xx xxxxxxxx avant l'alarme
  nTypeRappel : short;		// 0=Minute, 1=Heures, 2=Jours, 3=Semaine, 4=Mois
  DateSeance : HDDATE;		// Date de la sance associe
  TimeSeance : HDTIME;		// Heure de la sance associe
  Extension : array[0..8-1] of BYTE ;		// Rserve pour extension
  end;

type LPRECAgendas = ^RECAgendas;

type
  RECPatients =  packed record
  wStatus :WORD;					// Etat enregistrement (0 = OK)
  bDeleted : SBOOL;					// Flag si supprim / archiv
  szDossier : array[0..16-1] of Char ;			// Rfrence de dossier papier	(Cl 3)
  szNom : array[0..21-1] of Char  ;    			// Nom du patient        (Cle 1)
  szPrenom : array[0..21-1] of Char  ; 			// Prnom du patient     (Cle 1)
  szNomJF : array[0..21-1] of Char   ;  		// Nom de jeune fille
  cSexe : Char;						// H = Homme,  F = Femme
  cSitFam : Char;					// C = Celibataire, M = Mari, D = Divorc(e), V = Veuf(ve), O = Cocubin(e), P = Parent clibataire
  DateNai : HDDATE;					// Date de naissance
  szLieuNai : array[0..41-1] of Char  ;			// Lieu de naissance
  szAdresse : array[0..81-1] of Char ;			// Adresse
  szCPostal : array[0..6-1] of Char;			// Code Postal
  szVille : array[0..21-1] of Char ; 			// Ville
  szTelPerso : array[0..SIZE_PHONE-1] of Char  ;	// Numro de tlphone personnel
  szTelPro : array[0..SIZE_PHONE-1] of Char ;		// Numro de tlphone professionnel
  nEnfants : short;					// Nombre d'enfants
  nTaille : short;					// Taille en Cm
  nPoids : short;					// Poids en Kg
  szGroupe : array[0..11-1] of Char  ;			// Groupe sanguin
  szProfession : array[0..41-1] of Char  ;		// Profession
  szNumSS : array[0..31-1] of Char  ;			// Numro de scurit sociale
  szCaisse : array[0..SIZE_NAME+1-1] of Char;	        // Caisse d'assur social
  szTiers : array[0..SIZE_NAME+1-1] of Char ;	        // Tiers payant
  szRemarque : array[0..81-1] of Char ;			// Remarque
  uFiche : USHORT;					// Numro de fiche patient (Cl 2)
  szUser : array[0..SIZE_USER-1] of Char ;		// Nom de l'utilisateur
  DateFiche : HDDATE;					// Date de cration fiche
  DateConsulte : HDDATE;				// Date derniere consultation
  nCourrier : short;					// Numro squentiel courrier
  nOrdonnance : short;				        // Numro squentiel ordonnance.
  szMedecin : array[0..81-1] of Char;			// Medecin traitant
  szLibZone1 : array[0..11-1] of Char;			// Libll de la zone supplmentaire 1
  szLibZone2 : array[0..11-1] of Char ;			// Libll de la zone supplmentaire 2
  szLibZone3 : array[0..11-1] of Char ;			// Libll de la zone supplmentaire 3
  szLibZone4 : array[0..11-1] of Char ;			// Libll de la zone supplmentaire 4
  szZone1 : array[0..25-1] of Char ;	    		// Zone supplmentaire 1
  szZone2 : array[0..25-1] of Char ;	    		// Zone supplmentaire 2
  szZone3 : array[0..25-1] of Char ;	    		// Zone supplmentaire 3
  szZone4 : array[0..25-1] of Char ;	    		// Zone supplmentaire 4
  szLibCZone1 : array[0..11-1] of Char ;    		// Libll de la zone supplmentaire en consultation 1
  szLibCZone2 : array[0..11-1] of Char ;    		// Libll de la zone supplmentaire en consultation 2
  szLibCZone3 : array[0..11-1] of Char ;    		// Libll de la zone supplmentaire en consultation 3
  szLibCZone4 : array[0..11-1] of Char ;    		// Libll de la zone supplmentaire en consultation 4
  cMaskEvent : BYTE;		        		// Elments affich dans le dossier (1 bit par lment)
  cSeparatorPos : BYTE;	        			// Position du sparateur dans le dossier (en %)
  nItems : USHORT;					// Nombres d'lments dans le dossier
  DateDeces : HDDATE;					// Date de dcs (brrrrr)
  uIDIMS : ULONG;					// Identifiant IMS
  uTraitementID : USHORT;				// N du dernier traitement
  cRangGemellaire : char;			// Rang gmellaire (RANG_GEMELLAIRE_1/RANG_GEMELLAIRE_2...)
  Extension2 : array[0..1] of BYTE ;			// Rserve pour extension
  end;

type LPRECPatients = ^RECPatients;

  // *-*-*-*-* Session *-*-*-*-*

  // [hdapi.h] : API_EXPORT BOOL HDAPI HDOpenSession (BOOL bNetwork);
  function HDOpenSession(network : boolean):boolean; stdcall;

  // [hdapi.h] : API_EXPORT void HDAPI HDCloseSession ();
  procedure HDCloseSession();  stdcall;

  // *-*-*-*-* Cabinet *-*-*-*-*

  // [hdapi.h] : API_EXPORT BOOL HDAPI HDGetApplicationInfo (LPCSTR lpSection, LPCSTR lpEntry, LPSTR lpValue) ;
  function HDGetApplicationInfo (rubrique: PChar; cle:PChar; valeur:PChar): DWORD;  stdcall;

  // [hdapi.h] : API_EXPORT int HDAPI HDOpenCabinetDlg (HWND hWnd, LPSTR lpPath, LPSTR lpCabinet, LPSTR lpUser, LPSTR lpPassword) ;
  function HDOpenCabinetDlg (hwnd :HWND; path: PChar;cabinet:PChar; user:PChar; pwd:PChar): DWORD;  stdcall;

  // [hdapi.h] : API_EXPORT BOOL HDAPI HDOpenCabinet (LPCSTR lpPath, LPCSTR lpCabinet, LPCSTR lpUser, LPCSTR lpPassword) ;
  function HDOpenCabinet (path: PChar;cabinet:PChar; user:PChar; pwd:PChar): DWORD;  stdcall;


  // [hdapi.h] : API_EXPORT void HDAPI HDCloseCabinet () ;
  procedure HDCloseCabinet();  stdcall;

  // *-*-*-*-* Accs Fichiers Squentiels Indexs *-*-*-*-*

  // [hdapi.h] : API_EXPORT DWORD HDAPI	HDNumberOfKey (HDFILE hFile);
  function HDNumberOfKey (hFile : HdFileType):DWORD ; stdcall  ;

  // [hdapi.h] : API_EXPORT HGLOBAL HDAPI OpenPatients (LPCSTR lpPath /*= NULL*/) ;
  function OpenPatients (lpPath : PChar):HGLOBAL ; stdcall  ;

  // [hdapi.h] : API_EXPORT HGLOBAL HDAPI OpenAgendas (LPCSTR lpPath /*= NULL*/) ;
  function OpenAgendas (lpPath : PChar):HGLOBAL ; stdcall  ;

  // [hdapi.h] : API_EXPORT LPSTR HDAPI	MakeAgendas1Key (LPSTR lpKey, LPCSTR lpUser, HDDATE Date, HDTIME Time) ;
  function MakeAgendas1Key (lpKey : PChar ; lpUser:PChar; Date : HDDATE; Time : HDTIME ):PChar ; stdcall  ;

  // [hdapi.h] : API_EXPORT BOOL HDAPI HDReadRec (HDFILE hFile, HDFILEPOS Idx, LPSTR lpBuffer) ;
  function HDReadRec (hFile : HdFileType; Idx : HDFILEPOS; lpBuffer: PChar ):boolean ; stdcall  ;

  // [hdapi.h] : API_EXPORT HDFILEPOS HDAPI ReadPatients (LPRECPatients lpPatients, int nKey) ;
  function ReadPatients (lpPatients : LPRECPatients; nKey: integer ):HDFILEPOS ; stdcall  ;

  // [hdapi.h] : API_EXPORT void HDAPI ClosePatients (HGLOBAL) ;
  procedure ClosePatients (Patient:HGLOBAL) ; stdcall  ;

  // [hdapi.h] : API_EXPORT void HDAPI CloseAgendas (HGLOBAL) ;
  procedure CloseAgendas (Patient:HGLOBAL) ; stdcall  ;


  // [hdapi.h] : API_EXPORT HDFILEPOS HDAPI HDBrowseKey	(HDFILE hFile, LPSTR lpKey) ;
  function HDBrowseKey (hFile : HDFileType ; lpKey:PChar):HDFILEPOS ; stdcall  ;

  // [hdapi.h] : API_EXPORT HDFILEPOS HDAPI HDNextKey (HDFILE hFile, LPSTR lpKey) ;
  function HDNextKey (hFile : HDFileType ; lpKey:PChar):HDFILEPOS ; stdcall  ;

  // [hdapi.h] : API_EXPORT HDDATE HDAPI Today () ;
  function Today():HDDATE; stdcall;

  function DAY(Date : HDDATE):integer; stdcall;
  function MONTH(Date : HDDATE):integer; stdcall;
  function YEAR(Date : HDDATE):integer; stdcall;
  function HOUR(Time : HDTIME):integer; stdcall;
  function MINUTE(Time : HDTIME):integer; stdcall;

type

  TForm1 = class(TForm)
    Button1: TButton;
    HD_Path: TEdit;
    HD_Cabinet: TEdit;
    HD_User: TEdit;
    HD_Pwd: TEdit;
    GroupBox1: TGroupBox;
    Info: TGroupBox;
    Chemin: TLabel;
    Cabinet: TLabel;
    Utilisateur: TLabel;
    Password: TLabel;
    Quitter: TButton;
    Edit1: TEdit;
    Edit2: TEdit;
    NBPAT: TEdit;
    Button2: TButton;
    NBEXP: TEdit;
    Edit4: TEdit;
    procedure Button1Click(Sender: TObject);
    procedure QuitterClick(Sender: TObject);
    procedure Button2Click(Sender: TObject);

    procedure aff_erreur(hwnd : HWND;err : PChar);
    procedure traite_agenda(ag: LPRECAgendas;pat : LPRECPatients);
  private
    { Private declarations }
  public
  end;

  const FIC_EXPORT_AGENDA = ('agenda.exp.txt') ;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.Button1Click(Sender: TObject);
    var path:  array[0..MAX_PATH] of Char;
    var cabinet: array[0..MAX_PATH] of Char;
    var user: array[0..MAX_PATH] of Char;
    var pwd: array[0..MAX_PATH] of Char;
    var hwndl: HWND;
    var Patient: HGLOBAL;
begin
    path:='';
    cabinet:='';
    user:='';
    pwd:='';
    hwndl:=0;

    //Ouverture de session HD
    HDOpenSession(TRUE);

    //Rcupre les valeurs par dfaut
    HDGetApplicationInfo('Chemins','Cabinets',path);
    HDGetApplicationInfo ('Cabinets','Dernier',cabinet) ;
    HDGetApplicationInfo ('Cabinets',cabinet,user) ;

    //Boite d'ouverture
    HDOpenCabinetDlg (hwndl,path,cabinet,user,pwd);

    //Renseigne les champs de la fentre
    HD_Path.Text:=path;
    HD_Cabinet.Text:=cabinet;
    HD_User.Text:=user;
    HD_Pwd.Text:=pwd;


    // Obtient quelques statistiques

    Patient:=OpenPatients(nil);
    NBPAT.Text:=IntToStr(HDNumberOfKey(PATIENTS1X));
    ClosePatients(Patient);

    //Ferme le cabinet
    HDCloseCabinet();

    //Ferme la session
    HDCloseSession();

end;

procedure TForm1.Button2Click(Sender: TObject);
var Agenda:HGLOBAL;		//handle sur le fichier Agenda
var Patient:HGLOBAL;	//handle sur le fichier Patient
var ag: LPRECAgendas;		//pointeur sur les donnes
var pat: LPRECPatients;		//pointeur sur les donnes
var ok: boolean;			// a 1 si ouverture correcte
begin

    //Ouverture de session HD
    HDOpenSession(TRUE);

if HDOpenCabinet(PChar(HD_Path.Text),PChar(HD_Cabinet.Text),
        PChar(HD_User.Text),PChar(HD_Pwd.Text))=0 then
        begin
        aff_erreur(0,'Impossible d''ouvrir le cabinet.'+#13+
                'Si il est protg par un mot de passe, vous devez le rouvrir');
        exit;
        end;

ok:=FALSE;
// Ouverture Agenda+Patient
Agenda:=OpenAgendas(nil); // ouvre l'agenda
if Agenda<>0 then		  // ouverture OK
begin
        ag:=Pointer(GlobalLock(Agenda));   // Lockage mmoire
	if ag<>nil then
        begin				    // lock mmoire OK
                Patient:=OpenPatients(nil); // ouvre le fichier patients
		if Patient<>0 then
                begin
                        pat:=Pointer(GlobalLock(Patient));
			if pat<>nil then
                        begin
                                ok:=TRUE;
				traite_agenda(ag,pat);
				GlobalUnlock(Patient);
                        end;
			ClosePatients(Patient);
                end;
		GlobalUnlock(Agenda);
        end;
	CloseAgendas(Agenda);
end;
HDCloseCabinet();

//Ferme la session
HDCloseSession();

if ok=FALSE then
        aff_erreur(0,'Impossible d''ouvrir les fichiers d''HD !');
end;


procedure TForm1.traite_agenda(ag: LPRECAgendas ;pat : LPRECPatients );
// Fichier HD
var cle:  array[0..MAX_KEYLEN-1] of Char;
var date: HDDATE;     //date actuelle
var index: HDFILEPOS; //index (position dans le fichier)
// Fichier externe (rsultat de l'export)
var hdle: Cardinal;

var tmp:  String; //array[0..255] of Char; //buffer temporaire
var nb_export : integer;		//nb d'enregistrements exportsvar nb_char : Cardinal;		//nb de caracres dans la chaine
var ecrit : Cardinal;		//nb d'octets rellement erits dans le fichier

begin

//Ouverture du fichier sur le disque
hdle:=CreateFile(PChar(FIC_EXPORT_AGENDA),GENERIC_WRITE,FILE_SHARE_READ,nil,
                CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,0);
if hdle=INVALID_HANDLE_VALUE then
begin
        aff_erreur(0,'Impossible d''ouvrir le fichier de sortie');
	exit;
end;

//SendDlgItemMessage(hwnd,IDD_MAIN_ACTION,WM_SETTEXT,0,(LPARAM)"Export Agenda");
NBEXP.Text:='';
nb_export:=0;
date:=Today();
MakeAgendas1Key(cle,PChar(HD_User.Text),date,0); // Construit une cl de recherche pour obtenir
					  // les enregistrements classs dans l'ordre suivant
					  // par utilisateur
					  // pour chaque utilisateur, par date
					  // pour chaque utilisateur, par date et par heure
					  // Ex : Pierre  05/04 13:15
					  // Ex : Pierre  05/04 18:15
					  // Ex : Pierre  15/04 13:15
					  // Ex : Vincent 02/04 11:00

index:=HDBrowseKey(AGENDAS1X,cle); 	// Trouve la premire cl  partir de "cle", ceci dans l'ordre dfini
				   	// par le type de cl (AGENDAS1X) (cf au dessus)
				   	// Ici, on ne trouvera pas la cl exacte
				   	// ([config.user],[Date du jour],[00:00])
				        // Mais la premire dispo, par ex :
					// ([config.user],[Date du jour],[08:00])

while index<>0 do
begin // tant que l'index est correct, c'est  dire !=0
        HDReadRec(AGENDAS,index,PChar(ag)); 		// lecture de l'enregistrement
	if StrComp(ag^.szUser,PChar(HD_User.Text))=0 then
        begin		// tjrs le mme utilisateur ?
        	pat^.uFiche:=ag^.uFiche;
	        if pat^.uFiche<>0 then
	        	ReadPatients (pat,PATIENTS_BY_REC);	// On peut ici rapidement lire l'enregistrement recherch, sans
		 						// avoir  construire une cl, rechercher la cl, lire l'enregistrement,etc,etc

                 tmp:=IntToStr(DAY(ag^.Date))+'/'+IntToStr(MONTH(ag^.Date))+'/'+
                                IntToStr(YEAR(ag^.Date))+' '+
                                IntToStr(HOUR(ag^.Time))+':'+
                                IntToStr(MINUTE(ag^.Time))+' ';

                 if ag^.nWarning=2 then
                        tmp:=tmp+'V'
                 else
                        tmp:=tmp+' ';

                 if pat^.uFiche<>0 then
                        tmp:=tmp+  pat^.szNom+' '+pat^.szPreNom+' '
                 else
                        tmp:=tmp+  ' N.A. ';

                 tmp:=tmp+ag^.szText+#13+#10;

                 WriteFile(hdle,tmp[1],Length(tmp),ecrit,nil);		// Ecriture dans le fichier de sortie

                 // Affichage des infos sur l'avancement de l'export
                 nb_export:=nb_export+1;
                 NBEXP.Text:=IntToStr(nb_export);
                 index:=HDNextKey(AGENDAS1X,cle); // cl suivante
        end
	else						  // l'enregistrement qu'on a lu est d'un autre utilisateur
        	index:=0;				  // on a donc rcupr tous les enregistrements utiles
end;
CloseHandle(hdle);					  //referme le fichier de sortie

end;

function DAY(Date : HDDATE):integer;
begin
Result :=  integer(Date and $FF);
end;

function MONTH(Date : HDDATE):integer;
begin
Result :=  integer ((Date shr 8) and $FF);
end;

function YEAR(Date : HDDATE):integer;
begin
Result := integer ((Date shr 16) and $FFFF);
end;

function HOUR(Time : HDTIME):integer;
begin
Result := integer ((Time shr 16) and $FFFF);
end;

function MINUTE(Time : HDTIME):integer;
begin
Result := integer ((Time shr 8) and $FF);
end;



procedure TForm1.QuitterClick(Sender: TObject);
begin
        Close;
end;


procedure TForm1.aff_erreur(hwnd : HWND;err : PChar);
begin
        MessageBox(hwnd,err,'HD Export - Erreur',MB_OK or MB_ICONERROR);
end;



// Implmentation des fonctions/procdures d'HDAPI ... dans HDAPI.DLL
const
  DLLName = 'HDAPI.dll';

function HDOpenCabinetDlg; external DLLName;
function HDOpenCabinet; external DLLName;
function HDOpenSession; external DLLName;
function HDGetApplicationInfo; external DLLName;
procedure HDCloseSession; external DLLName;
procedure HDCloseCabinet; external DLLName;
function HDNumberOfKey; external DLLName;
function OpenPatients; external DLLName;
function MakeAgendas1Key; external DLLName;
function HDBrowseKey; external DLLName;
function HDReadRec; external DLLName;
function HDNextKey; external DLLName;
function ReadPatients; external DLLName;
procedure ClosePatients; external DLLName;
function OpenAgendas; external DLLName;
procedure CloseAgendas; external DLLName;

function Today; external DLLName;


end.
