///////////////////////////////////////////////////////////////////////////
// HD_export
///////////////////////////////////////////////////////////////////////////
// 16/04/2002
//
// Copyright (c) 2002, E. Ravon (Bat)
///////////////////////////////////////////////////////////////////////////

#include <windows.h>
#include "config.h"


/////////////////////////////
// Accs  la registry
/////////////////////////////

#define READ_KEY(_type,_lg,_key,_var)		lg=_lg;type=_type;RegQueryValueEx(key,_key,NULL,&type,&_var,&lg);
#define WRITE_KEY_STR(_type,_lg,_key,_var)	RegSetValueEx(key,_key,0,_type,&_var,strlen(_var));

/*****************************************/
void lit_config(){
/*****************************************/
HKEY key=NULL;
int type;
int lg;

memset(&config,0,sizeof(config));			// met  0 toutes les donnes

RegOpenKey(HKEY_CURRENT_USER,_CLE,&key);	// lit les donnes (si disponibles)
if (key!=NULL){
	READ_KEY(REG_SZ,MAX_PATH,"Chemin",config.path);
	READ_KEY(REG_SZ,MAX_PATH,"Cabinet",config.cabinet);
	READ_KEY(REG_SZ,MAX_PATH,"User",config.user);
	}
}

/*****************************************/
void ecrit_config(){
/*****************************************/
HKEY key;
int type;

type=REG_SZ;
RegCreateKeyEx(HKEY_CURRENT_USER,_CLE,0,"",REG_OPTION_NON_VOLATILE,KEY_ALL_ACCESS,NULL,&key,&type);
WRITE_KEY_STR(REG_SZ,MAX_PATH,"Chemin",config.path);
WRITE_KEY_STR(REG_SZ,MAX_PATH,"Cabinet",config.cabinet);
WRITE_KEY_STR(REG_SZ,MAX_PATH,"User",config.user);
RegCloseKey(key);
}









/////////////////////////////
// Parse la ligne de commande
/////////////////////////////

/*****************************************/
void process_cmd_line(char *txt){
/*****************************************/
int lg,pt=0,i,j;

lg=strlen(txt);
while (pt<lg){
	if (txt[pt]=='/'){
		pt++;
		switch(txt[pt]){
			case 'A': case 'a':
				config.mode=MODE_AUTO;
				break;
			}
		}
	pt++;
	}
}


/////////////////////////////////////
// Lecture fichier par 'ligne'
/////////////////////////////////////

static HANDLE fic;
#define LG_BUF 5000
char buf[LG_BUF];
int pos_buf=0;
int taille_buf=0;

/*******************************************************/
int open_fic(char *nom){
/*******************************************************/
fic=CreateFile(nom,GENERIC_READ,FILE_SHARE_READ,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
if (fic==INVALID_HANDLE_VALUE)
	return 1;
ReadFile(fic,buf,LG_BUF,&taille_buf,NULL);
pos_buf=0;
return 0;
}


/*******************************************************/
void close_fic(){
/*******************************************************/
CloseHandle(fic);
}


/***************************************/
int read_line(char *buf1,int l_max){
/***************************************/
int t=0;

if (!taille_buf){	//fin de fichier
	buf1[0]=0;
	return -1;
	}
while (t<l_max && buf[pos_buf]!='\r'){
	buf1[t++]=buf[pos_buf++];
	if (pos_buf>=taille_buf){
		ReadFile(fic,buf,LG_BUF,&taille_buf,NULL);
		pos_buf=0;
		if (!taille_buf){
			return -1;
			}
		}
	}
pos_buf+=2;
if (pos_buf>=taille_buf){
	ReadFile(fic,buf,LG_BUF,&taille_buf,NULL);
	pos_buf=0;
	}
buf1[t]=0;
if (!t && pos_buf==taille_buf)
	return -1;
return t;
}

