///////////////////////////////////////////////////////////////////////////
// HD_export
///////////////////////////////////////////////////////////////////////////
// 16/04/2002 Version initiale
// 21/01/2003 Ajout export recettes
// 19/06/2003 Ajout export posologies
// 14/09/2003 Ajout export dossiers bruts
// Copyright (c) 2002, E. Ravon (Bat)
///////////////////////////////////////////////////////////////////////////


#define MULTITIERS_VERSION
#define EURO_VERSION

#include <windows.h>
#include "hdapi.h"
#include "config.h"
#include "main.h"
#include "res.h"
#include <stdio.h>

void traite_agenda(HWND hwnd,LPRECAgendas ag,LPRECPatients pat); // exporte les donnes du fichier Agenda
void traite_recette(HWND hwnd,LPRECRecettes rec,LPRECPatients pat); //exporte les donnes des recettes
void traite_biologie(HWND hwnd,LPRECBiologies bio,LPRECPatients pat); // exporte les donnes des biologies
void traite_posologie(HWND hwnd,LPRECPosologies poso);	//exporte les donnes des posologies
void traite_dossier(HWND hwnd,LPRECDossiers dos,LPRECPatients pat); // export des dossiers
void import_posologie(HWND hwnd,LPRECPosologies poso);	//importe les donnes des posologies
HMODULE vidal_open();				// Charge la DLL msvmpl32.dll (OVP)
void vidal_close(HMODULE hVidal);	// Dcharge la DLL de OVP

// Fonctions importes de la DLL msvmpl32.dll permettant d'accder au Vidal
long PASCAL (*OVP_ini)(char *path);	// Initialisation du Vidal
char * PASCAL (*OVP_cip)(char *cip); //Retourne des infos  partir d'un (ou plusieurs) code CIP
char * PASCAL (*HMK_Doc)(char *cip,int vidal,char *etendue); //Retourne des infos  partir d'un (ou plusieurs) code CIP
long PASCAL (*OVP_close)();			// Fermeture du Vidal

/**********************************************/
void hd_conf_cabinet(HWND hwnd){
/**********************************************/
char password[MAX_PATH]="";
if (!config.path[0]){
	HDGetApplicationInfo("Chemins","Cabinets",config.path);
	HDGetApplicationInfo ("Cabinets","Dernier",config.cabinet) ;
	HDGetApplicationInfo ("Cabinets",config.cabinet,config.user) ;
	}
if (HDOpenCabinetDlg (hwnd,config.path,config.cabinet,config.user,config.password))
	HDCloseCabinet();

}


////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Agenda
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


/**********************************************/
void hd_export_agenda(HWND hwnd){
/**********************************************/
HGLOBAL 		Agenda;		//handle sur le fichier Agenda
HGLOBAL 		Patient;	//handle sur le fichier Patient
LPRECAgendas	ag;			//pointeur sur les donnes
LPRECPatients	pat;		//pointeur sur les donnes

int ok;						// a 1 si ouverture correcte

if (!HDOpenCabinet(config.path,config.cabinet,config.user,config.password)){ 		// tentative ouverture
	aff_erreur(NULL,"Impossible d'ouvrir le cabinet.\nSi il est protg par un mot de passe, vous devez le rouvrir");
	return;
	}

ok=0;
// Ouverture Agenda+Patient
Agenda=OpenAgendas(NULL);							// ouvre l'agenda
if (Agenda){										// ouverture OK
	ag=(LPRECAgendas)GlobalLock(Agenda); 			// Lockage mmoire
	if (ag){										// lock mmoire OK
		Patient=OpenPatients(NULL);					// ouvre le fichier patients
		if (Patient){
			pat=(LPRECPatients)GlobalLock(Patient);
			if (pat){
				ok=1;
				traite_agenda(hwnd,ag,pat);
				GlobalUnlock(Patient);
				}
			ClosePatients(Patient);
			}
		GlobalUnlock(Agenda);
		}
	CloseAgendas(Agenda);
	}
HDCloseCabinet();
if (!ok)
	aff_erreur(NULL,"Impossible d'ouvrir les fichiers d'HD !");
return;
}

/***************************************************************/
void traite_agenda(HWND hwnd,LPRECAgendas ag,LPRECPatients pat){
/***************************************************************/

// Fichier HD
char cle[MAX_KEYLEN];	//cl de recherche
HDDATE 		date;		//date actuelle
HDFILEPOS	index;		//index (position dans le fichier)
// Fichier externe
HANDLE hdle;

char tmp[255];		//buffer temporaire
int nb_export;		//nb d'enregistrements exports
int nb_char;		//nb de caracres dans la chaine
int ecrit;			//nb d'octets rellement erits dans le fichier

//Ouverture du fichier sur le disque
hdle=CreateFile(FIC_EXPORT_AGENDA,GENERIC_WRITE,FILE_SHARE_READ,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL);
if (hdle==INVALID_HANDLE_VALUE){
	aff_erreur(hwnd,"Impossible d'ouvrir le fichier de sortie");
	return;
	}


SendDlgItemMessage(hwnd,IDD_MAIN_ACTION,WM_SETTEXT,0,(LPARAM)"Export Agenda");
nb_export=0;
date=Today();
MakeAgendas1Key(cle,config.user,date,0);		// Construit une cl de recherche pour obtenir
												// les enregistrements classs dans l'ordre suivant
												// par utilisateur
												// pour chaque utilisateur, par date
												// pour chaque utilisateur, par date et par heure
												// Ex : Pierre  05/04 13:15
												// Ex : Pierre  05/04 18:15
												// Ex : Pierre  15/04 13:15
												// Ex : Vincent 02/04 11:00

index=HDBrowseKey(AGENDAS1X,cle);				// Trouve la premire cl  partir de "cle", ceci dans l'ordre dfini
												// par le type de cl (AGENDAS1X) (cf au dessus)
												// Ici, on ne trouvera pas la cl exacte
												// ([config.user],[Date du jour],[00:00])
												// Mais la premire dispo, par ex :
												// ([config.user],[Date du jour],[08:00])


while (index){									// tant que l'index est correct, c'est  dire !=0
	HDReadRec(AGENDAS,index,(char *)ag); 		// lecture de l'enregistrement
	if (!strcmp(ag->szUser,config.user)){		// tjrs le mme utilisateur ?

		pat->uFiche=ag->uFiche;
		if (pat->uFiche)
			ReadPatients (pat,PATIENTS_BY_REC);	// On peut ici rapidement lire l'enregistrement recherch, sans
												// avoir  construire une cl, rechercher la cl, lire l'enregistrement,etc,etc

		nb_char=wsprintf(tmp,"%02d/%02d/%04d %02d:%02d %c %s %s %s\r\n",
				DAY(ag->Date),MONTH(ag->Date),YEAR(ag->Date),	// Date
				HOUR(ag->Time),MINUTE(ag->Time),				// Heure
				ag->nWarning==2 ? 'V' : ' ',					// Visite ?
				pat->uFiche ? pat->szNom : "N.A.",				// Nom Patient
				pat->uFiche ? pat->szPrenom : "N.A.",			// Prenom Patient
				ag->szText										// Texte
				);
		WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie

		// Affichage des infos sur l'avancement de l'export
		nb_export++;
		wsprintf(tmp,"%d",nb_export);
		SendDlgItemMessage(hwnd,IDD_MAIN_CPT,WM_SETTEXT,0,(LPARAM)tmp);
		index=HDNextKey(AGENDAS1X,cle); 		// cl suivante
		}
	else										// l'enregistrement qu'on a lu est d'un autre utilisateur
		index=0;								// on a donc rcupr tous les enregistrements utiles
	}
CloseHandle(hdle);								//referme le fichier de sortie

SendDlgItemMessage(hwnd,IDD_MAIN_ACTION,WM_SETTEXT,0,(LPARAM)"Export Termin");

}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Contenu Dossier
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


/**********************************************/
void hd_export_dossier(HWND hwnd){
/**********************************************/
HGLOBAL 		Dossier;	//handle sur le fichier Dossier
HGLOBAL 		Patient;	//handle sur le fichier Patient
LPRECDossiers	dos;		//pointeur sur les donnes
LPRECPatients	pat;		//pointeur sur les donnes

int ok;						// a 1 si ouverture correcte

if (!HDOpenCabinet(config.path,config.cabinet,config.user,config.password)){ 		// tentative ouverture
	aff_erreur(NULL,"Impossible d'ouvrir le cabinet.\nSi il est protg par un mot de passe, vous devez le rouvrir");
	return;
	}

ok=0;
// Ouverture Agenda+Patient
Dossier=OpenDossiers(DOSSIER_MAX,NULL,0,0);			// ouvre les dossiers
if (Dossier){										// ouverture OK
	dos=(LPRECDossiers)GlobalLock(Dossier); 		// Lockage mmoire
	if (dos){										// lock mmoire OK
		Patient=OpenPatients(NULL);					// ouvre le fichier patients
		if (Patient){
			pat=(LPRECPatients)GlobalLock(Patient);
			if (pat){
				ok=1;
				traite_dossier(hwnd,dos,pat);
				GlobalUnlock(Patient);
				}
			ClosePatients(Patient);
			}
		GlobalUnlock(Dossier);
		}
	CloseDossiers(Dossier);
	}
HDCloseCabinet();
if (!ok)
	aff_erreur(NULL,"Impossible d'ouvrir les fichiers d'HD !");
return;
}

/***************************************************************/
void traite_dossier(HWND hwnd,LPRECDossiers dos,LPRECPatients pat){
/***************************************************************/

// Fichier HD
char cle[MAX_KEYLEN];	//cl de recherche
HDFILEPOS	index;		//index (position dans le fichier)
// Fichier externe
HANDLE hdle;

char tmp[255];		//buffer temporaire
int nb_export;		//nb d'enregistrements exports
int nb_char;		//nb de caracres dans la chaine
int ecrit;			//nb d'octets rellement erits dans le fichier

//Ouverture du fichier sur le disque
hdle=CreateFile(FIC_EXPORT_DOSSIER,GENERIC_WRITE,FILE_SHARE_READ,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL);
if (hdle==INVALID_HANDLE_VALUE){
	aff_erreur(hwnd,"Impossible d'ouvrir le fichier de sortie");
	return;
	}


SendDlgItemMessage(hwnd,IDD_MAIN_ACTION,WM_SETTEXT,0,(LPARAM)"Export Dossier");
nb_export=0;
MakeDossiersKey(cle,1,0,0,0);					// Construit une cl de recherche pour obtenir
												// les enregistrements classs dans l'ordre suivant
												// par N de patient (ici le N1)
												// pour patient, par type
												// pour chaque type, par date et par heure

index=HDBrowseKey(DOSSIERSX,cle);				// Trouve la premire cl  partir de "cle", ceci dans l'ordre dfini


nb_char=wsprintf(tmp,"Lecture des dossiers\r\nLe plus grand enregistrement est de taille DOSSIER_MAX, soit %d octets\r\n",
		DOSSIER_MAX);
WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie

while (index){									// tant que l'index est correct, c'est  dire !=0
	ReadDossiers (index,dos,sizeof(RECDossiers)) ;

	pat->uFiche=dos->uFiche;
	if (pat->uFiche)
		ReadPatients (pat,PATIENTS_BY_REC);	// On peut ici rapidement lire l'enregistrement recherch, sans
											// avoir  construire une cl, rechercher la cl, lire l'enregistrement,etc,etc

	nb_char=wsprintf(tmp,"Enregistrement : %02d/%02d/%04d %02d:%02d\r\nTaille(dwLength) : %d\r\nType : %d\r\n"\
						"Fiche : %d (%s %s)\r\nUtilisateur : %s\r\nLongeur enregistrement (uRecLen) : %d\r\n"\
						"Longueur texte (uTextLen) : %d\r\n\r\n",
			DAY(dos->Date),MONTH(dos->Date),YEAR(dos->Date),	// Date
			HOUR(dos->Time),MINUTE(dos->Time),				// Heure
			dos->dwLength,dos->cType,dos->uFiche,pat->szNom,pat->szPrenom,dos->szUser,dos->uRecLen,dos->uTextLen);
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie

	// Affichage des infos sur l'avancement de l'export
	nb_export++;
	wsprintf(tmp,"%d",nb_export);
	SendDlgItemMessage(hwnd,IDD_MAIN_CPT,WM_SETTEXT,0,(LPARAM)tmp);
	index=HDNextKey(DOSSIERSX,cle); 		// cl suivante
	if (MessageBox(hwnd,"Exporter l'enregistrement suivant ?","HDExport",MB_YESNO)==IDNO)
		index=0;
	}
CloseHandle(hdle);								//referme le fichier de sortie

SendDlgItemMessage(hwnd,IDD_MAIN_ACTION,WM_SETTEXT,0,(LPARAM)"Export Termin");
}


////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Recettes
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**********************************************/
void hd_export_recette(HWND hwnd){
/**********************************************/
HGLOBAL 		Recette;	//handle sur le fichier Recette
HGLOBAL 		Patient;	//handle sur le fichier Patient
LPRECRecettes	rec;		//pointeur sur les donnes
LPRECPatients	pat;		//pointeur sur les donnes

int ok;						// a 1 si ouverture correcte

if (!HDOpenCabinet(config.path,config.cabinet,config.user,config.password)){ 		// tentative ouverture
	aff_erreur(NULL,"Impossible d'ouvrir le cabinet.\nSi il est protg par un mot de passe, vous devez le rouvrir");
	return;
	}

ok=0;
// Ouverture Recettes+Patient
Recette=OpenRecettes(NULL);							// ouvre l'agenda
if (Recette){										// ouverture OK
	rec=(LPRECRecettes)GlobalLock(Recette);			// Lockage mmoire
	if (rec){										// lock mmoire OK
		Patient=OpenPatients(NULL);					// ouvre le fichier patients
		if (Patient){
			pat=(LPRECPatients)GlobalLock(Patient);
			if (pat){
				ok=1;
				traite_recette(hwnd,rec,pat);
				GlobalUnlock(Patient);
				}
			ClosePatients(Patient);
			}
		GlobalUnlock(Recette);
		}
	CloseRecettes(Recette);
	}
HDCloseCabinet();
if (!ok)
	aff_erreur(NULL,"Impossible d'ouvrir les fichiers d'HD !");
return;
}


/***************************************************************/
void traite_recette(HWND hwnd,LPRECRecettes rec,LPRECPatients pat){
/***************************************************************/

// Fichier HD
char cle[MAX_KEYLEN];	//cl de recherche
HDDATE 		date;		//date actuelle
HDFILEPOS	index;		//index (position dans le fichier)
// Fichier externe
HANDLE hdle;

char tmp[255];		//buffer temporaire
int nb_export;		//nb d'enregistrements exports
int nb_char;		//nb de caracres dans la chaine
int ecrit;			//nb d'octets rellement erits dans le fichier
int i;
//Ouverture du fichier sur le disque
hdle=CreateFile(FIC_EXPORT_RECETTE,GENERIC_WRITE,FILE_SHARE_READ,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL);
if (hdle==INVALID_HANDLE_VALUE){
	aff_erreur(hwnd,"Impossible d'ouvrir le fichier de sortie");
	return;
	}


SendDlgItemMessage(hwnd,IDD_MAIN_ACTION,WM_SETTEXT,0,(LPARAM)"Export Recette");
nb_export=0;
MakeRecettes1Key (cle,0,0,0);
		// Construit une cl de recherche pour obtenir
		// les enregistrements classs dans l'ordre suivant
		// par jour puis par patient, puis par heure

		// Ici le jour de dpart est '0', le patient de dpart est '0' et l'heure '0'.
		// On aura donc le plus ancien enregistrement en premier, puis les enregistrements classs par
		// jour

index=HDBrowseKey(RECETTES1X,cle);

while (index){									// tant que l'index est correct, c'est  dire !=0
	HDReadRec(RECETTES,index,(char *)rec); 		// lecture de l'enregistrement

	pat->uFiche=rec->uFiche;					// Recherche la fiche patient associ
	if (pat->uFiche)
		ReadPatients (pat,PATIENTS_BY_REC);	// On peut ici rapidement lire l'enregistrement recherch, sans
												// avoir  construire une cl, rechercher la cl, lire l'enregistrement,etc,etc

	nb_char=wsprintf(tmp,"-=-=-=-=-=-=-=-=-=-=-=-= Recette =-=-=-=-=-=-=-=-=-=-=-=-\r\n");
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie

	nb_char=wsprintf(tmp,"Date de la recette : (Date) %02d/%02d/%04d (Time) %02d:%02d\r\n",
				DAY(rec->Date),MONTH(rec->Date),YEAR(rec->Date),	// Date
				HOUR(rec->Time),MINUTE(rec->Time));				// Heure
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie


	nb_char=wsprintf(tmp,"Utilisateur :        (szUser) %s\r\n",rec->szUser);
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie

	nb_char=wsprintf(tmp,"Acte :               (szActe) %s\r\n",rec->szActe);
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie

	nb_char=wsprintf(tmp,"Patient :            (uFiche) %d [%s %s]\r\n",rec->uFiche,pat->szNom,pat->szPrenom);
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie

	nb_char=wsprintf(tmp,"Date 1er paiement :  (DatePaie) %02d/%02d/%04d\r\n",
				DAY(rec->DatePaie),MONTH(rec->DatePaie),YEAR(rec->DatePaie));	// Date
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie
	nb_char=sprintf(tmp,"*Doit correspondondre  la date du paiement le plus ancien ? Le premier entr ?\r\n");
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie


	nb_char=sprintf(tmp,"\r\n--- Ce qui est d ---\r\n");
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie

	nb_char=sprintf(tmp,"Euro ? : %s\r\n",rec->bEuro ? "Oui":"Non");
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie

	nb_char=sprintf(tmp,"Dtail : (dMontant) %5.2f * (dCoef) %5.2f + \r\n",rec->dMontant,rec->dCoef);
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie
	nb_char=sprintf(tmp,"         (dIDKilometre) %5.2f * (nKilometre) %d\r\n",rec->dIDKilometre,rec->nKilometre);
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie
	nb_char=sprintf(tmp,"        = (Calcul local) %5.2f \r\n",rec->dMontant*rec->dCoef+rec->dIDKilometre*rec->nKilometre);
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie
	nb_char=sprintf(tmp,"Montant total : %5.2f\r\n",rec->dTotal);
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie

	nb_char=sprintf(tmp,"A la cration de la recette ce total EST EGAL au calcul au dessus\r\n");
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie
	nb_char=sprintf(tmp,"Mais par la suite l'utilisateur PEUT modifier le total\r\n");
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie


	nb_char=sprintf(tmp,"\r\n--- Ce qui a t pay ---\r\n");
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie

	for (i=0;i<4;i++){
		nb_char=sprintf(tmp,"Code                 : (szCode) %s\r\n",rec->Paie[i].szCode);
		WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie

		nb_char=sprintf(tmp,"Libelle              : (szLibelle) %s\r\n",rec->Paie[i].szLibelle);
		WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie


		nb_char=sprintf(tmp,"Montant              : (dMontant) %5.2f\r\n",rec->Paie[i].dMontant);
		WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie

		nb_char=wsprintf(tmp,"Date paiement        : (DatePaie) %02d/%02d/%04d\r\n",
				DAY(rec->Paie[i].Date),MONTH(rec->Paie[i].Date),YEAR(rec->Paie[i].Date));	// Date
		WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie

		nb_char=sprintf(tmp,"Banque/Cheque/Compte : (szBanque) %s (szCheque) %s (szCompte) %s\r\n",
			rec->Paie[i].szBanque,rec->Paie[i].szCheque,rec->Paie[i].szCompte);
		WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie

		}

	nb_char=sprintf(tmp,"\r\n\r\n");
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie

	nb_char=sprintf(tmp,"\r\n--- Ce qui reste  payer ---\r\n");
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie

	nb_char=sprintf(tmp,"Reste : (dReste) %5.2f\r\n",rec->dReste);
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie
	nb_char=sprintf(tmp,"*Doit tre cohrent avec dMontant - Paie[x].dMontant\r\n");
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie

	// Il est ncesaire d'avoir dfini #define MULTITIERS_VERSION avant d'inclure HDAPI pour avoir
	// les infos relatives au tiers multiples

	nb_char=sprintf(tmp,"Reste AMO : (dResteAMO) %5.2f\r\n",rec->dResteAMO);
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie
	nb_char=sprintf(tmp,"*Doit tre cohrent avec ???\r\n");
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie

	nb_char=sprintf(tmp,"Reste AMC : (dResteAMO) %5.2f\r\n",rec->dResteAMC);
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie
	nb_char=sprintf(tmp,"*Doit tre cohrent avec ???\r\n");
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie

	nb_char=sprintf(tmp,"Reste Patient : (dRestePatient) %5.2f\r\n",rec->dRestePatient);
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie
	nb_char=sprintf(tmp,"*Doit tre cohrent avec ???\r\n");
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie

	nb_char=sprintf(tmp,"\r\n--- Autres ---\r\n");
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie

	nb_char=sprintf(tmp,"Nom Tiers AMO      : (szTiersAMO) %s\r\n",rec->szTiersAMO);
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie
	nb_char=sprintf(tmp,"Nom Tiers AMC      : (szTiersAMC) %s\r\n",rec->szTiersAMC);
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie
	nb_char=sprintf(tmp,"Fiche Payeur       : (uPayeur) %d\r\n",rec->uPayeur);
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie
	nb_char=sprintf(tmp,"Xfer en compta     : (bXfr) %s\r\n",rec->bXfr ? "Oui":"Non");
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie
	nb_char=sprintf(tmp,"FSE associe       : (bFSE) %s\r\n",rec->bFSE ? "Oui":"Non");
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie
	nb_char=sprintf(tmp,"bFSE updat ??     : (bFSEUpdated) %s\r\n",rec->bFSEUpdated ? "Oui":"Non");
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie
	nb_char=sprintf(tmp,"paiement group ?? : (bPaieGroupe) %s\r\n",rec->bPaieGroupe ? "Oui":"Non");
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie

	nb_char=wsprintf(tmp,"Date FSE           : (DateFSE) %02d/%02d/%04d\r\n",
				DAY(rec->DateFSE),MONTH(rec->DateFSE),YEAR(rec->DateFSE));	// Date
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie
	nb_char=wsprintf(tmp,"Date FSP           : (DateFSP) %02d/%02d/%04d\r\n",
				DAY(rec->DateFSP),MONTH(rec->DateFSP),YEAR(rec->DateFSP));	// Date
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie

	nb_char=sprintf(tmp,"\r\n\r\n");
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie


	// Affichage des infos sur l'avancement de l'export
	nb_export++;
	wsprintf(tmp,"%d",nb_export);
	SendDlgItemMessage(hwnd,IDD_MAIN_CPT,WM_SETTEXT,0,(LPARAM)tmp);
	index=HDNextKey(RECETTES1X,cle); 		// cl suivante
	if (MessageBox(hwnd,"Exporter l'enregistrement suivant ?","HDExport",MB_YESNO)==IDNO)
		index=0;
	}
CloseHandle(hdle);								//referme le fichier de sortie

SendDlgItemMessage(hwnd,IDD_MAIN_ACTION,WM_SETTEXT,0,(LPARAM)"Export Termin");

}



////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Biologies
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**********************************************/
void hd_export_biologie(HWND hwnd){
/**********************************************/
HGLOBAL 		Biologie;	//handle sur le fichier Biologie
HGLOBAL 		Patient;	//handle sur le fichier Patient
LPRECBiologies	bio;		//pointeur sur les donnes
LPRECPatients	pat;		//pointeur sur les donnes

int ok;						// a 1 si ouverture correcte

if (!HDOpenCabinet(config.path,config.cabinet,config.user,config.password)){ 		// tentative ouverture
	aff_erreur(NULL,"Impossible d'ouvrir le cabinet.\nSi il est protg par un mot de passe, vous devez le rouvrir");
	return;
	}

ok=0;
// Ouverture Recettes+Patient
Biologie=OpenBiologies(NULL);						// ouvre le fichier des posologies
if (Biologie){										// ouverture OK
	bio=(LPRECBiologies)GlobalLock(Biologie);			// Lockage mmoire
	if (bio){										// lock mmoire OK
		Patient=OpenPatients(NULL);					// ouvre le fichier patients
		if (Patient){
			pat=(LPRECPatients)GlobalLock(Patient);
			if (pat){
				ok=1;
				traite_biologie(hwnd,bio,pat);
				GlobalUnlock(Patient);
				}
			ClosePatients(Patient);
			}
		GlobalUnlock(Biologie);
		}
	CloseBiologies(Biologie);
	}
HDCloseCabinet();
if (!ok)
	aff_erreur(NULL,"Impossible d'ouvrir les fichiers d'HD !");
return;
}


/***************************************************************/
void traite_biologie(HWND hwnd,LPRECBiologies bio,LPRECPatients pat){
/***************************************************************/

// Fichier HD
char cle[MAX_KEYLEN];	//cl de recherche
HDFILEPOS	index;		//index (position dans le fichier)
HGLOBAL hBiologie;		//handle de la zone mmoire contenant le texte de la biologie

// Fichier externe
HANDLE hdle;

char tmp[255];		//buffer temporaire
int nb_export;		//nb d'enregistrements exports
int nb_char;		//nb de caracres dans la chaine
int ecrit;			//nb d'octets rellement erits dans le fichier
int i;

//Ouverture du fichier sur le disque
hdle=CreateFile(FIC_EXPORT_BIOLOGIE,GENERIC_WRITE,FILE_SHARE_READ,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL);
if (hdle==INVALID_HANDLE_VALUE){
	aff_erreur(hwnd,"Impossible d'ouvrir le fichier de sortie");
	return;
	}

// Rcupre le nom et le prnom entrs dans la boite
SendDlgItemMessage(hwnd,IDD_MAIN_NOM,WM_GETTEXT,MAX_PATH,(LPARAM)pat->szNom);
SendDlgItemMessage(hwnd,IDD_MAIN_PRENOM,WM_GETTEXT,MAX_PATH,(LPARAM)pat->szPrenom);

// Recherche le N de fiche du patient
if (!ReadPatients (pat,PATIENTS_BY_NAME)){ //l'utilisateur a du mal avec ses 10 doigts et  entr un nom incorrect ?
	MessageBox(hwnd,"Attention, le nom entr n'a pas t trouv dans HelloDOC","HD_Export - Erreur",MB_ICONERROR);
	SendDlgItemMessage(hwnd,IDD_MAIN_ACTION,WM_SETTEXT,0,(LPARAM)"Erreur  l'export");
	CloseHandle(hdle);								//referme le fichier de sortie
	return;
	}

SendDlgItemMessage(hwnd,IDD_MAIN_ACTION,WM_SETTEXT,0,(LPARAM)"Export Biologie");
nb_export=0;

MakeBiologiesKey (cle,pat->uFiche,0,0);
		// Construit une cl de recherche pour obtenir
		// les enregistrements classs dans l'ordre suivant
		// par patient, puis par jour, puis par heure

		// Ici le patient est celui entr par l'utilisateur, le jour de dpart est '0' et l'heure '0'.
		// On aura donc le plus ancien enregistrement en premier, puis les enregistrements classs par
		// jour et heure


index=HDBrowseKey(DOSSIERSX,cle);

while (index){									// tant que l'index est correct, c'est  dire !=0
	ReadDossiers2(index,(LPRECDossiers)bio);	// lecture de l'enregistrement

	if (bio->uFiche==pat->uFiche){				// On lit bien toujours pour le mme patient ?
		if (bio->cType==DOSSIERS_BIOLOGIES){	// On est en train de lire un BIOLOGIES (et non un autre lment du dossier)
			hBiologie=ReadBiologies(index,bio);	// Oui, alors go => Lecture de la biologie
												// on lit la structure dans 'bio'
												// et le contenu des donnes accessible par hBiologie

			nb_char=wsprintf(tmp,"-=-=-=-=-=-=-=-=-=-=-=-= Biologie =-=-=-=-=-=-=-=-=-=-=-=-\r\n");
			WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie

			nb_char=wsprintf(tmp,"Date : %02d / %02d / %04d \r\n",(bio->Date)&0x1F,((bio->Date)>>8)&0xF,(bio->Date)>>16);
			WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie

			if (hBiologie){									// Il y a un texte ou un quelque chose d'associ ?
				char *txt=(LPSTR) GlobalLock (hBiologie);	//Lock la zone mmoire
				if (!strncmp(txt,"#FORM",5))				// Est-ce un formulaire ?
					nb_char=wsprintf(tmp,"=-Biologie utilisant un formulaire-=\r\n");
				else
					nb_char=wsprintf(tmp,"=-Biologie en texte libre=-\r\n");
				WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie

				// Ecriture du texte proprement dit
				WriteFile(hdle,txt,strlen(txt),&ecrit,NULL);	// Ecriture dans le fichier de sortie
				GlobalUnlock (hBiologie);						// libre la zone mmoire
				}
			nb_char=sprintf(tmp,"\r\n\r\n");
			WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie

			// Affichage des infos sur l'avancement de l'export
			nb_export++;
			wsprintf(tmp,"%d",nb_export);
			SendDlgItemMessage(hwnd,IDD_MAIN_CPT,WM_SETTEXT,0,(LPARAM)tmp);
			}
		index=HDNextKey(BIOLOGIESX,cle);		// Suivant

		}
	else										// On a chang de patient, donc c'est termin
		index=0;
	}
CloseHandle(hdle);								//referme le fichier de sortie

SendDlgItemMessage(hwnd,IDD_MAIN_ACTION,WM_SETTEXT,0,(LPARAM)"Export Termin");

}


////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Posologies
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**********************************************/
void hd_export_posologie(HWND hwnd){
/**********************************************/
HGLOBAL 		Posologie;	//handle sur le fichier Posologie
HGLOBAL 		Pharmacie;	//handle sur le fichier Media Vidal
LPRECPosologies	poso;		//pointeur sur les donnes
LPRECPharmacies	phar;		//pointeur sur les donnes
HMODULE 		hVidal;		//Handle Vidal
int ok;						// a 1 si ouverture correcte

if (!HDOpenCabinet(config.path,config.cabinet,config.user,config.password)){ 		// tentative ouverture
	aff_erreur(NULL,"Impossible d'ouvrir le cabinet.\nSi il est protg par un mot de passe, vous devez le rouvrir");
	return;
	}

ok=0;
// Ouverture Posologie
Posologie=OpenPosologies(NULL);						// ouvre le fichier des posologies
if (Posologie){										// ouverture OK
	poso=(LPRECPosologies)GlobalLock(Posologie);		// Lockage mmoire
	if (poso){										// lock mmoire OK
		hVidal=vidal_open();
		if (hVidal){
			ok=1;
			traite_posologie(hwnd,poso);
			vidal_close(hVidal);
			}
		GlobalUnlock(Posologie);
		}
	ClosePosologies(Posologie);
	}
HDCloseCabinet();
if (!ok)
	aff_erreur(NULL,"Impossible d'ouvrir les fichiers d'HD !");
return;
}


/***************************************************************/
void traite_posologie(HWND hwnd,LPRECPosologies poso){
/***************************************************************/

// Fichier HD
char cle[MAX_KEYLEN];	//cl de recherche
char cle_vidal[MAX_KEYLEN];	//cl de recherche
HDFILEPOS	index;		//index (position dans le fichier)
HDFILEPOS	index_vidal;		//index (position dans le fichier)
HGLOBAL 	hPoso;		//handle de la zone mmoire contenant le texte de la posologie
char		*data_vidal;//chaine retourne par OVP
char 		*end;

// Fichier externe
HANDLE hdle;

char tmp[1000];		//buffer temporaire
char cip[9];		//code CIP
int nb_export;		//nb d'enregistrements exports
int nb_char;		//nb de caracres dans la chaine
int ecrit;			//nb d'octets rellement erits dans le fichier
int i;


i=OVP_ini("VCD");
if (i<=0) // erreur ou date dpasse
	i=OVP_ini("TVS");
if (!i){
	MessageBox(hwnd,"Impossible de trouver TVS ou Vidal CD","HD_Export",MB_ICONERROR);
	return;
	}
if (i<0){
	MessageBox(hwnd,"Base prime","HD_Export",MB_ICONERROR);
	return;
	}

//Ouverture du fichier sur le disque
hdle=CreateFile(FIC_EXPORT_POSOLOGIE,GENERIC_WRITE,FILE_SHARE_READ,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL);
if (hdle==INVALID_HANDLE_VALUE){
	aff_erreur(hwnd,"Impossible d'ouvrir le fichier de sortie");
	return;
	}

SendDlgItemMessage(hwnd,IDD_MAIN_ACTION,WM_SETTEXT,0,(LPARAM)"Export Posologie");
nb_export=0;

MakePosologiesKey(cle,"00000000",0);
		// Construit une cl de recherche pour obtenir
		// les enregistrements classs dans l'ordre des cls CIP [des mdicaments ??]
index=HDBrowseKey(POSOLOGIESX,cle);

cip[8]=0;		//pour crer le chaine du code CIP
while (index){									// tant que l'index est correct, c'est  dire !=0
	hPoso=ReadPosologies2(index,poso) ;
	memcpy(cip,poso->szCIP,8);					// cre la chaine du code CIP

	data_vidal=OVP_cip(cip);
	while (*data_vidal && *data_vidal!='\t')	// Avance jusqu' la premire tabulation (entre 1er et 2me champ)
		data_vidal++;
	if (*data_vidal) data_vidal++;				// Si on est pas (encore) au bout de la chaine passe le 'tab'
	end=data_vidal;
	while (*end && *end!='\t')					// Avance jusqu' la fin du champ suivant
		end++;
	*end=0;										// Tronque la chaine ...

	nb_char=wsprintf(tmp,"%s;%s;",cip,data_vidal);
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie


	if (hPoso){									// Il y a un texte ou un quelque chose d'associ ?
		char *txt=(LPSTR) GlobalLock (hPoso);	//Lock la zone mmoire
		// Ecriture du texte proprement dit
		WriteFile(hdle,txt,poso->dwLength-poso->uRecLen,&ecrit,NULL);	// Ecriture dans le fichier de sortie
		GlobalUnlock (hPoso);						// libre la zone mmoire
		}
	nb_char=wsprintf(tmp,"\r\n");
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie

	//data_vidal=HMK_Doc(cip,2,"");
	//WriteFile(hdle,data_vidal,strlen(data_vidal),&ecrit,NULL);		// Ecriture dans le fichier de sortie

//	nb_char=wsprintf(tmp,"\r\n");
//	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie

	// Affichage des infos sur l'avancement de l'export
	nb_export++;
	if (!(nb_export%100)){ // tous les 100 lments exports
		wsprintf(tmp,"%d",nb_export);	//affiche l'avancement
		SendDlgItemMessage(hwnd,IDD_MAIN_CPT,WM_SETTEXT,0,(LPARAM)tmp);
		MSG msg;						// traite les messages
		while (PeekMessage (&msg, NULL, 0, 0, PM_REMOVE)){
			if (msg.message == WM_QUIT)
				return;
			TranslateMessage (&msg) ;
			DispatchMessage (&msg) ;
			}
		}

	index=HDNextKey(POSOLOGIESX,cle);		// Suivant
	}
CloseHandle(hdle);								//referme le fichier de sortie

OVP_close();
SendDlgItemMessage(hwnd,IDD_MAIN_ACTION,WM_SETTEXT,0,(LPARAM)"Export Termin");

}


/*****************************************/
HMODULE vidal_open(){
/*****************************************/
HMODULE hVidal;

hVidal=LoadLibrary("mvsmpl32.dll");			// charge la DLL en mmoire
if (!hVidal) return NULL;
OVP_ini=GetProcAddress(hVidal,"OVP_ini");	// obtient l'@ de base de la fonction concerne
if (!OVP_ini) goto vidal_err;				// droute (non proprement) ver sune routine d'erreur
OVP_cip=GetProcAddress(hVidal,"OVP_cip");	// obtient l'@ de base de la fonction concerne
if (!OVP_cip) goto vidal_err;				// droute (non proprement) ver sune routine d'erreur
HMK_Doc=GetProcAddress(hVidal,"Hmk_Doc");	// obtient l'@ de base de la fonction concerne
if (!HMK_Doc) goto vidal_err;				// droute (non proprement) ver sune routine d'erreur
OVP_close=GetProcAddress(hVidal,"OVP_close");	// obtient l'@ de base de la fonction concerne
if (!OVP_close) goto vidal_err;				// droute (non proprement) ver sune routine d'erreur
return hVidal;								// droulement OK

vidal_err:									// Routine d'erreur si fonction non trouve
FreeLibrary(hVidal);
MessageBox(NULL,"Une fonction ncessaire n'a pas t trouve dan la DLL msvmpl32.dll","Erreur",MB_ICONERROR);
return NULL;
}

/*****************************************/
void vidal_close(HMODULE hVidal){
/*****************************************/
FreeLibrary(hVidal);
}






/**********************************************/
void hd_import_posologie(HWND hwnd,int direct_in_HD){
/**********************************************/
HGLOBAL 		Posologie;	//handle sur le fichier Posologie
HGLOBAL 		Pharmacie;	//handle sur le fichier Media Vidal
LPRECPosologies	poso;		//pointeur sur les donnes
LPRECPharmacies	phar;		//pointeur sur les donnes
HMODULE 		hVidal;		//Handle Vidal
int ok;						// a 1 si ouverture correcte

if (!HDOpenCabinet(config.path,config.cabinet,config.user,config.password)){ 		// tentative ouverture
	aff_erreur(NULL,"Impossible d'ouvrir le cabinet.\nSi il est protg par un mot de passe, vous devez le rouvrir");
	return;
	}
if (!direct_in_HD){ // Fichiers externes crs
	if (MessageBox(hwnd,"Cette fonction va crer 2 fichiers dans le rpertoire courant :\nHDPosologies.hdd et HDPosologies.hdi.\nCes 2 fichiers peuvent ensuite tre copis dans le rpertoire d'HD pour remplacer les fichiers existants\nVoulez vous continuer ?","HD_Export - Import Posologies",MB_YESNO|MB_ICONQUESTION)==IDNO){
		HDCloseCabinet();
		return;
		}
	ok=0;
	if (!CreatPosologies(".")){						// ouvre le fichier des posologies
		MessageBox(hwnd,"Erreur  la cration des fichiers destinations pour les posologies. Ces fichiers sont peut-tre dj existants\n(HDPosologies.hdd et HDPosologies.hdi)","HD Export - erreur",MB_ICONERROR);
		HDCloseCabinet();
		return;
		}
	// Ouverture Posologie
	Posologie=OpenPosologies(".");
	}
else{
	// Ouverture Posologie de HD directement
	Posologie=OpenPosologies(NULL);
	}

if (Posologie){										// ouverture OK
	poso=(LPRECPosologies)GlobalLock(Posologie);		// Lockage mmoire
	if (poso){										// lock mmoire OK
		ok=1;
		import_posologie(hwnd,poso);
		GlobalUnlock(Posologie);
		}
	ClosePosologies(Posologie);
	}
HDCloseCabinet();
if (!ok)
	aff_erreur(NULL,"Impossible d'ouvrir les fichiers d'HD !");
return;
}


/***************************************************************/
void import_posologie(HWND hwnd,LPRECPosologies poso){
/***************************************************************/
#define MAX_SIZE_POSO 10000		//taille maximum d'une posologie
// Fichier HD
char cle[MAX_KEYLEN];	//cl de recherche
char cle_vidal[MAX_KEYLEN];	//cl de recherche
HDFILEPOS	index;		//index (position dans le fichier)
HDFILEPOS	index_vidal;		//index (position dans le fichier)
HGLOBAL 	hPoso;		//handle de la zone mmoire contenant le texte de la posologie
char		*data;		//
char 		*end;
char 		*poso_data;
int 		len;

char tmp[MAX_SIZE_POSO];	//buffer temporaire [pose un pb pour une posologie de taille >]
char cip[9];		//code CIP
int nb_export;		//nb d'enregistrements exports
int nb_char;		//nb de caracres dans la chaine
int ecrit;			//nb d'octets rellement erits dans le fichier
int i;

poso_data=GlobalAlloc(GMEM_FIXED,MAX_SIZE_POSO);
//Ouverture du fichier sur le disque
if (open_fic(FIC_IMPORT_POSOLOGIE)){
	char err[MAX_PATH];
	wsprintf (err,"Impossible d'ouvrir le fichier d'import : %s",FIC_IMPORT_POSOLOGIE);
	aff_erreur(hwnd,err);
	return;
	}

SendDlgItemMessage(hwnd,IDD_MAIN_ACTION,WM_SETTEXT,0,(LPARAM)"Import Posologie");
nb_export=0;

while ((len=read_line(tmp,MAX_SIZE_POSO))!=-1){		//lit une ligne du fichier
	if (len>=MAX_SIZE_POSO)
		MessageBox(hwnd,"Attention posologie trop longue, fichier de sortie probablement inutilisable !","HD Export",MB_ICONERROR);
	memset(poso,0,sizeof(RECPosologies));	// RAZ structure Posologie

	// Format de la ligne : code_cip;nom entier;posologie
	data=tmp;
	while (*data++!=';');		// avance jusque aprs le premier ';'
	*(data-1)=0;
	strcpy(poso->szCIP,tmp);	// rcupre le code CIP
	while (*data++!=';');		// avance jusque aprs le deuxime ';'
	strcpy(poso_data,data);		// rcupre le texte de la posologie

//MessageBox(NULL,data,poso->szCIP,MB_OK);								// *data contient le libell

	poso->uRecLen=sizeof(RECPosologies);				//renseigne les tailles. Ncessaire ????
	poso->dwLength=sizeof(RECPosologies)+strlen(data);

	poso->uPosoID=GetFreePosoID(".",poso->szCIP);
	WritePosologies	(poso_data,strlen(data),poso) ;

	// Affichage des infos sur l'avancement de l'export
	nb_export++;
	if (!(nb_export%100)){ // tous les 100 lments exports
		wsprintf(tmp,"%d",nb_export);	//affiche l'avancement
		SendDlgItemMessage(hwnd,IDD_MAIN_CPT,WM_SETTEXT,0,(LPARAM)tmp);
		MSG msg;						// traite les messages
		while (PeekMessage (&msg, NULL, 0, 0, PM_REMOVE)){
			if (msg.message == WM_QUIT)
				return;
			TranslateMessage (&msg) ;
			DispatchMessage (&msg) ;
			}
		}
	}
GlobalFree(poso_data);
SendDlgItemMessage(hwnd,IDD_MAIN_ACTION,WM_SETTEXT,0,(LPARAM)"Import Termin");
}


