///////////////////////////////////////////////////////////////////////////
// HD_export
///////////////////////////////////////////////////////////////////////////
// 16/04/2002
//
// Copyright (c) 2002, E. Ravon (Bat)
//
// Auteur : manu_bat_manu@yahoo.fr
//
// Export simple des donnes d'HD
//
// Ce code est un exemple d'accs en C aux donnes du logiciel HelloDOC
// Il utilise la bibliothque HDAPI.
//
// Ce code a t dvelopp pour HelloDOC Etendu 4.56.116
// Ainsi que pour la version d'hdapi.h associe.
//
// Il a t test avec HD 4.56 tendu et HDES
// Son fonctionnement n'est pas guaranti avec des versions plus rcentes d'HD
//
//
// HelloDOC est dvelopp par Imagine Editions.
// Windows est une marque de Microsoft Corporation
////////////////////////////////////////////////////////////////////////////

#include <windows.h>		// Prototypes des fonctions Windows
#include "res.h"			// Constantes des ressources (boite d'affichage,etc,etc)
#include "hdapi.h"			// Prototypes des fonction disponibles dans HDAPI.DLL
#include "config.h"			// Prototypes des fonctions de configuration
#include "process.h"		// Prototypes des fonctions d'export
#include "main.h"			// Fonctions d'affichage

HINSTANCE 		hInst;		// Handle sur l'instance
CONFIG			config;		// Contient toute la configuration

BOOL _stdcall Main_Dlg(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);
							// CallBack fenetre principale
void aff_config(HWND hwnd);	// Affiche la configuration


/************************************************************************************************/
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, INT nCmdShow){
/************************************************************************************************/
hInst=hInstance;

if (!HDOpenSession(TRUE)){		// Ouvre la session HD
	aff_erreur(NULL,"Impossible d'ouvrir une session HD\nARRET\n");
	return 0;
	}

lit_config();					// Lit la config en BDR
process_cmd_line(lpCmdLine);	// Lit les options en ligne de commande
DialogBox(hInst,MAKEINTRESOURCE(IDD_MAIN),NULL,Main_Dlg);	// Cration boite principale
ecrit_config();					// Ecrit la config en BDR

HDCloseSession();				// Ferme la session HD
return 0;
}


///////////////////////////////////////////////////////////////////////////////////
// MAIN DLG CALLBACK
///////////////////////////////////////////////////////////////////////////////////
/******************************************************************************/
BOOL _stdcall Main_Dlg(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam){
/******************************************************************************/

switch(msg) {
	case WM_INITDIALOG:
		aff_config(hwnd);			// Affiche la config
		switch (config.mode){		// Effectue les actions automatiques
			case MODE_AUTO:
				hd_export_agenda(hwnd);
				config.mode=MODE_NORMAL;
				break;
			}
		return 1;
		break;
	case WM_COMMAND:
		switch (LOWORD(wParam)){
			case IDD_MAIN_CH:				// Configuration
				hd_conf_cabinet(hwnd);
				aff_config(hwnd);
				break;
			case IDD_MAIN_EXP_AGENDA:
				hd_export_agenda(hwnd);		// Export Agenda
				break;
			case IDD_MAIN_EXP_RECETTE:
				hd_export_recette(hwnd);		// Export Recette
				break;
			case IDD_MAIN_EXP_BIOLOGIE:
				hd_export_biologie(hwnd);		// Export Biologie
				break;
			case IDD_MAIN_EXIT:
				PostMessage(hwnd,WM_CLOSE,0,0);
				break;
			}
		break;
	case WM_CLOSE:
		EndDialog(hwnd,0);
		break;
	}
return 0;
}


/*************************************/
void aff_config(HWND hwnd){
/*************************************/
SendDlgItemMessage(hwnd,IDD_MAIN_PATH,WM_SETTEXT,0,(LPARAM)config.path);
SendDlgItemMessage(hwnd,IDD_MAIN_CABINET,WM_SETTEXT,0,(LPARAM)config.cabinet);
SendDlgItemMessage(hwnd,IDD_MAIN_USER,WM_SETTEXT,0,(LPARAM)config.user);
}

/*************************************/
void aff_erreur(HWND hwnd,char *err){
/*************************************/
MessageBox(hwnd,err,"HD Export - Erreur",MB_OK|MB_ICONERROR);
}
