///////////////////////////////////////////////////////////////////////////
// HD_export
///////////////////////////////////////////////////////////////////////////
// 16/04/2002 Version initiale
// 21/01/2003 Ajout export recettes
//
// Copyright (c) 2002, E. Ravon (Bat)
///////////////////////////////////////////////////////////////////////////


#define MULTITIERS_VERSION
#define EURO_VERSION

#include <windows.h>
#include "hdapi.h"
#include "config.h"
#include "main.h"
#include "res.h"
#include <stdio.h>

void traite_agenda(HWND hwnd,LPRECAgendas ag,LPRECPatients pat); // exporte les donnes du fichier Agenda
void traite_recette(HWND hwnd,LPRECRecettes rec,LPRECPatients pat); //exporte les donnes des recettes
void traite_biologie(HWND hwnd,LPRECBiologies bio,LPRECPatients pat); // exporte les donnes des biologies
/**********************************************/
void hd_conf_cabinet(HWND hwnd){
/**********************************************/
char password[MAX_PATH]="";
if (!config.path[0]){
	HDGetApplicationInfo("Chemins","Cabinets",config.path);
	HDGetApplicationInfo ("Cabinets","Dernier",config.cabinet) ;
	HDGetApplicationInfo ("Cabinets",config.cabinet,config.user) ;
	}
if (HDOpenCabinetDlg (hwnd,config.path,config.cabinet,config.user,config.password))
	HDCloseCabinet();

}


////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Agenda
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


/**********************************************/
void hd_export_agenda(HWND hwnd){
/**********************************************/
HGLOBAL 		Agenda;		//handle sur le fichier Agenda
HGLOBAL 		Patient;	//handle sur le fichier Patient
LPRECAgendas	ag;			//pointeur sur les donnes
LPRECPatients	pat;		//pointeur sur les donnes

int ok;						// a 1 si ouverture correcte

if (!HDOpenCabinet(config.path,config.cabinet,config.user,config.password)){ 		// tentative ouverture
	aff_erreur(NULL,"Impossible d'ouvrir le cabinet.\nSi il est protg par un mot de passe, vous devez le rouvrir");
	return;
	}

ok=0;
// Ouverture Agenda+Patient
Agenda=OpenAgendas(NULL);							// ouvre l'agenda
if (Agenda){										// ouverture OK
	ag=(LPRECAgendas)GlobalLock(Agenda); 			// Lockage mmoire
	if (ag){										// lock mmoire OK
		Patient=OpenPatients(NULL);					// ouvre le fichier patients
		if (Patient){
			pat=(LPRECPatients)GlobalLock(Patient);
			if (pat){
				ok=1;
				traite_agenda(hwnd,ag,pat);
				GlobalUnlock(Patient);
				}
			ClosePatients(Patient);
			}
		GlobalUnlock(Agenda);
		}
	CloseAgendas(Agenda);
	}
HDCloseCabinet();
if (!ok)
	aff_erreur(NULL,"Impossible d'ouvrir les fichiers d'HD !");
return;
}

/***************************************************************/
void traite_agenda(HWND hwnd,LPRECAgendas ag,LPRECPatients pat){
/***************************************************************/

// Fichier HD
char cle[MAX_KEYLEN];	//cl de recherche
HDDATE 		date;		//date actuelle
HDFILEPOS	index;		//index (position dans le fichier)
// Fichier externe
HANDLE hdle;

char tmp[255];		//buffer temporaire
int nb_export;		//nb d'enregistrements exports
int nb_char;		//nb de caracres dans la chaine
int ecrit;			//nb d'octets rellement erits dans le fichier

//Ouverture du fichier sur le disque
hdle=CreateFile(FIC_EXPORT_AGENDA,GENERIC_WRITE,FILE_SHARE_READ,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL);
if (hdle==INVALID_HANDLE_VALUE){
	aff_erreur(hwnd,"Impossible d'ouvrir le fichier de sortie");
	return;
	}


SendDlgItemMessage(hwnd,IDD_MAIN_ACTION,WM_SETTEXT,0,(LPARAM)"Export Agenda");
nb_export=0;
date=Today();
MakeAgendas1Key(cle,config.user,date,0);		// Construit une cl de recherche pour obtenir
												// les enregistrements classs dans l'ordre suivant
												// par utilisateur
												// pour chaque utilisateur, par date
												// pour chaque utilisateur, par date et par heure
												// Ex : Pierre  05/04 13:15
												// Ex : Pierre  05/04 18:15
												// Ex : Pierre  15/04 13:15
												// Ex : Vincent 02/04 11:00

index=HDBrowseKey(AGENDAS1X,cle);				// Trouve la premire cl  partir de "cle", ceci dans l'ordre dfini
												// par le type de cl (AGENDAS1X) (cf au dessus)
												// Ici, on ne trouvera pas la cl exacte
												// ([config.user],[Date du jour],[00:00])
												// Mais la premire dispo, par ex :
												// ([config.user],[Date du jour],[08:00])


while (index){									// tant que l'index est correct, c'est  dire !=0
	HDReadRec(AGENDAS,index,(char *)ag); 		// lecture de l'enregistrement
	if (!strcmp(ag->szUser,config.user)){		// tjrs le mme utilisateur ?

		pat->uFiche=ag->uFiche;
		if (pat->uFiche)
			ReadPatients (pat,PATIENTS_BY_REC);	// On peut ici rapidement lire l'enregistrement recherch, sans
												// avoir  construire une cl, rechercher la cl, lire l'enregistrement,etc,etc

		nb_char=wsprintf(tmp,"%02d/%02d/%04d %02d:%02d %c %s %s %s\r\n",
				DAY(ag->Date),MONTH(ag->Date),YEAR(ag->Date),	// Date
				HOUR(ag->Time),MINUTE(ag->Time),				// Heure
				ag->nWarning==2 ? 'V' : ' ',					// Visite ?
				pat->uFiche ? pat->szNom : "N.A.",				// Nom Patient
				pat->uFiche ? pat->szPrenom : "N.A.",			// Prenom Patient
				ag->szText										// Texte
				);
		WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie

		// Affichage des infos sur l'avancement de l'export
		nb_export++;
		wsprintf(tmp,"%d",nb_export);
		SendDlgItemMessage(hwnd,IDD_MAIN_CPT,WM_SETTEXT,0,(LPARAM)tmp);
		index=HDNextKey(AGENDAS1X,cle); 		// cl suivante
		}
	else										// l'enregistrement qu'on a lu est d'un autre utilisateur
		index=0;								// on a donc rcupr tous les enregistrements utiles
	}
CloseHandle(hdle);								//referme le fichier de sortie

SendDlgItemMessage(hwnd,IDD_MAIN_ACTION,WM_SETTEXT,0,(LPARAM)"Export Termin");

}


////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Recettes
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**********************************************/
void hd_export_recette(HWND hwnd){
/**********************************************/
HGLOBAL 		Recette;	//handle sur le fichier Recette
HGLOBAL 		Patient;	//handle sur le fichier Patient
LPRECRecettes	rec;		//pointeur sur les donnes
LPRECPatients	pat;		//pointeur sur les donnes

int ok;						// a 1 si ouverture correcte

if (!HDOpenCabinet(config.path,config.cabinet,config.user,config.password)){ 		// tentative ouverture
	aff_erreur(NULL,"Impossible d'ouvrir le cabinet.\nSi il est protg par un mot de passe, vous devez le rouvrir");
	return;
	}

ok=0;
// Ouverture Recettes+Patient
Recette=OpenRecettes(NULL);							// ouvre l'agenda
if (Recette){										// ouverture OK
	rec=(LPRECRecettes)GlobalLock(Recette);			// Lockage mmoire
	if (rec){										// lock mmoire OK
		Patient=OpenPatients(NULL);					// ouvre le fichier patients
		if (Patient){
			pat=(LPRECPatients)GlobalLock(Patient);
			if (pat){
				ok=1;
				traite_recette(hwnd,rec,pat);
				GlobalUnlock(Patient);
				}
			ClosePatients(Patient);
			}
		GlobalUnlock(Recette);
		}
	CloseRecettes(Recette);
	}
HDCloseCabinet();
if (!ok)
	aff_erreur(NULL,"Impossible d'ouvrir les fichiers d'HD !");
return;
}


/***************************************************************/
void traite_recette(HWND hwnd,LPRECRecettes rec,LPRECPatients pat){
/***************************************************************/

// Fichier HD
char cle[MAX_KEYLEN];	//cl de recherche
HDDATE 		date;		//date actuelle
HDFILEPOS	index;		//index (position dans le fichier)
// Fichier externe
HANDLE hdle;

char tmp[255];		//buffer temporaire
int nb_export;		//nb d'enregistrements exports
int nb_char;		//nb de caracres dans la chaine
int ecrit;			//nb d'octets rellement erits dans le fichier
int i;
//Ouverture du fichier sur le disque
hdle=CreateFile(FIC_EXPORT_RECETTE,GENERIC_WRITE,FILE_SHARE_READ,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL);
if (hdle==INVALID_HANDLE_VALUE){
	aff_erreur(hwnd,"Impossible d'ouvrir le fichier de sortie");
	return;
	}


SendDlgItemMessage(hwnd,IDD_MAIN_ACTION,WM_SETTEXT,0,(LPARAM)"Export Recette");
nb_export=0;
MakeRecettes1Key (cle,0,0,0);
		// Construit une cl de recherche pour obtenir
		// les enregistrements classs dans l'ordre suivant
		// par jour puis par patient, puis par heure

		// Ici le jour de dpart est '0', le patient de dpart est '0' et l'heure '0'.
		// On aura donc le plus ancien enregistrement en premier, puis les enregistrements classs par
		// jour

index=HDBrowseKey(RECETTES1X,cle);

while (index){									// tant que l'index est correct, c'est  dire !=0
	HDReadRec(RECETTES,index,(char *)rec); 		// lecture de l'enregistrement

	pat->uFiche=rec->uFiche;					// Recherche la fiche patient associ
	if (pat->uFiche)
		ReadPatients (pat,PATIENTS_BY_REC);	// On peut ici rapidement lire l'enregistrement recherch, sans
												// avoir  construire une cl, rechercher la cl, lire l'enregistrement,etc,etc

	nb_char=wsprintf(tmp,"-=-=-=-=-=-=-=-=-=-=-=-= Recette =-=-=-=-=-=-=-=-=-=-=-=-\r\n");
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie

	nb_char=wsprintf(tmp,"Date de la recette : (Date) %02d/%02d/%04d (Time) %02d:%02d\r\n",
				DAY(rec->Date),MONTH(rec->Date),YEAR(rec->Date),	// Date
				HOUR(rec->Time),MINUTE(rec->Time));				// Heure
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie


	nb_char=wsprintf(tmp,"Utilisateur :        (szUser) %s\r\n",rec->szUser);
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie

	nb_char=wsprintf(tmp,"Acte :               (szActe) %s\r\n",rec->szActe);
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie

	nb_char=wsprintf(tmp,"Patient :            (uFiche) %d [%s %s]\r\n",rec->uFiche,pat->szNom,pat->szPrenom);
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie

	nb_char=wsprintf(tmp,"Date 1er paiement :  (DatePaie) %02d/%02d/%04d\r\n",
				DAY(rec->DatePaie),MONTH(rec->DatePaie),YEAR(rec->DatePaie));	// Date
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie
	nb_char=sprintf(tmp,"*Doit correspondondre  la date du paiement le plus ancien ? Le premier entr ?\r\n");
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie


	nb_char=sprintf(tmp,"\r\n--- Ce qui est d ---\r\n");
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie

	nb_char=sprintf(tmp,"Euro ? : %s\r\n",rec->bEuro ? "Oui":"Non");
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie

	nb_char=sprintf(tmp,"Dtail : (dMontant) %5.2f * (dCoef) %5.2f + \r\n",rec->dMontant,rec->dCoef);
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie
	nb_char=sprintf(tmp,"         (dIDKilometre) %5.2f * (nKilometre) %d\r\n",rec->dIDKilometre,rec->nKilometre);
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie
	nb_char=sprintf(tmp,"        = (Calcul local) %5.2f \r\n",rec->dMontant*rec->dCoef+rec->dIDKilometre*rec->nKilometre);
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie
	nb_char=sprintf(tmp,"Montant total : %5.2f\r\n",rec->dTotal);
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie

	nb_char=sprintf(tmp,"A la cration de la recette ce total EST EGAL au calcul au dessus\r\n");
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie
	nb_char=sprintf(tmp,"Mais par la suite l'utilisateur PEUT modifier le total\r\n");
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie


	nb_char=sprintf(tmp,"\r\n--- Ce qui a t pay ---\r\n");
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie

	for (i=0;i<4;i++){
		nb_char=sprintf(tmp,"Code                 : (szCode) %s\r\n",rec->Paie[i].szCode);
		WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie

		nb_char=sprintf(tmp,"Libelle              : (szLibelle) %s\r\n",rec->Paie[i].szLibelle);
		WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie


		nb_char=sprintf(tmp,"Montant              : (dMontant) %5.2f\r\n",rec->Paie[i].dMontant);
		WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie

		nb_char=wsprintf(tmp,"Date paiement        : (DatePaie) %02d/%02d/%04d\r\n",
				DAY(rec->Paie[i].Date),MONTH(rec->Paie[i].Date),YEAR(rec->Paie[i].Date));	// Date
		WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie

		nb_char=sprintf(tmp,"Banque/Cheque/Compte : (szBanque) %s (szCheque) %s (szCompte) %s\r\n",
			rec->Paie[i].szBanque,rec->Paie[i].szCheque,rec->Paie[i].szCompte);
		WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie

		}

	nb_char=sprintf(tmp,"\r\n\r\n");
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie

	nb_char=sprintf(tmp,"\r\n--- Ce qui reste  payer ---\r\n");
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie

	nb_char=sprintf(tmp,"Reste : (dReste) %5.2f\r\n",rec->dReste);
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie
	nb_char=sprintf(tmp,"*Doit tre cohrent avec dMontant - Paie[x].dMontant\r\n");
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie

	// Il est ncesaire d'avoir dfini #define MULTITIERS_VERSION avant d'inclure HDAPI pour avoir
	// les infos relatives au tiers multiples

	nb_char=sprintf(tmp,"Reste AMO : (dResteAMO) %5.2f\r\n",rec->dResteAMO);
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie
	nb_char=sprintf(tmp,"*Doit tre cohrent avec ???\r\n");
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie

	nb_char=sprintf(tmp,"Reste AMC : (dResteAMO) %5.2f\r\n",rec->dResteAMC);
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie
	nb_char=sprintf(tmp,"*Doit tre cohrent avec ???\r\n");
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie

	nb_char=sprintf(tmp,"Reste Patient : (dRestePatient) %5.2f\r\n",rec->dRestePatient);
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie
	nb_char=sprintf(tmp,"*Doit tre cohrent avec ???\r\n");
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie

	nb_char=sprintf(tmp,"\r\n--- Autres ---\r\n");
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie

	nb_char=sprintf(tmp,"Nom Tiers AMO      : (szTiersAMO) %s\r\n",rec->szTiersAMO);
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie
	nb_char=sprintf(tmp,"Nom Tiers AMC      : (szTiersAMC) %s\r\n",rec->szTiersAMC);
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie
	nb_char=sprintf(tmp,"Fiche Payeur       : (uPayeur) %d\r\n",rec->uPayeur);
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie
	nb_char=sprintf(tmp,"Xfer en compta     : (bXfr) %s\r\n",rec->bXfr ? "Oui":"Non");
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie
	nb_char=sprintf(tmp,"FSE associe       : (bFSE) %s\r\n",rec->bFSE ? "Oui":"Non");
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie
	nb_char=sprintf(tmp,"bFSE updat ??     : (bFSEUpdated) %s\r\n",rec->bFSEUpdated ? "Oui":"Non");
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie
	nb_char=sprintf(tmp,"paiement group ?? : (bPaieGroupe) %s\r\n",rec->bPaieGroupe ? "Oui":"Non");
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie

	nb_char=wsprintf(tmp,"Date FSE           : (DateFSE) %02d/%02d/%04d\r\n",
				DAY(rec->DateFSE),MONTH(rec->DateFSE),YEAR(rec->DateFSE));	// Date
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie
	nb_char=wsprintf(tmp,"Date FSP           : (DateFSP) %02d/%02d/%04d\r\n",
				DAY(rec->DateFSP),MONTH(rec->DateFSP),YEAR(rec->DateFSP));	// Date
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie

	nb_char=sprintf(tmp,"\r\n\r\n");
	WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie


	// Affichage des infos sur l'avancement de l'export
	nb_export++;
	wsprintf(tmp,"%d",nb_export);
	SendDlgItemMessage(hwnd,IDD_MAIN_CPT,WM_SETTEXT,0,(LPARAM)tmp);
	index=HDNextKey(RECETTES1X,cle); 		// cl suivante
	if (MessageBox(hwnd,"Exporter l'enregistrement suivant ?","HDExport",MB_YESNO)==IDNO)
		index=0;
	}
CloseHandle(hdle);								//referme le fichier de sortie

SendDlgItemMessage(hwnd,IDD_MAIN_ACTION,WM_SETTEXT,0,(LPARAM)"Export Termin");

}



////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Biologies
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**********************************************/
void hd_export_biologie(HWND hwnd){
/**********************************************/
HGLOBAL 		Biologie;	//handle sur le fichier Biologie
HGLOBAL 		Patient;	//handle sur le fichier Patient
LPRECBiologies	bio;		//pointeur sur les donnes
LPRECPatients	pat;		//pointeur sur les donnes

int ok;						// a 1 si ouverture correcte

if (!HDOpenCabinet(config.path,config.cabinet,config.user,config.password)){ 		// tentative ouverture
	aff_erreur(NULL,"Impossible d'ouvrir le cabinet.\nSi il est protg par un mot de passe, vous devez le rouvrir");
	return;
	}

ok=0;
// Ouverture Recettes+Patient
Biologie=OpenBiologies(NULL);							// ouvre l'agenda
if (Biologie){										// ouverture OK
	bio=(LPRECBiologies)GlobalLock(Biologie);			// Lockage mmoire
	if (bio){										// lock mmoire OK
		Patient=OpenPatients(NULL);					// ouvre le fichier patients
		if (Patient){
			pat=(LPRECPatients)GlobalLock(Patient);
			if (pat){
				ok=1;
				traite_biologie(hwnd,bio,pat);
				GlobalUnlock(Patient);
				}
			ClosePatients(Patient);
			}
		GlobalUnlock(Biologie);
		}
	CloseBiologies(Biologie);
	}
HDCloseCabinet();
if (!ok)
	aff_erreur(NULL,"Impossible d'ouvrir les fichiers d'HD !");
return;
}


/***************************************************************/
void traite_biologie(HWND hwnd,LPRECBiologies bio,LPRECPatients pat){
/***************************************************************/

// Fichier HD
char cle[MAX_KEYLEN];	//cl de recherche
HDFILEPOS	index;		//index (position dans le fichier)
HGLOBAL hBiologie;		//handle de la zone mmoire contenant le texte de la biologie

// Fichier externe
HANDLE hdle;

char tmp[255];		//buffer temporaire
int nb_export;		//nb d'enregistrements exports
int nb_char;		//nb de caracres dans la chaine
int ecrit;			//nb d'octets rellement erits dans le fichier
int i;

//Ouverture du fichier sur le disque
hdle=CreateFile(FIC_EXPORT_BIOLOGIE,GENERIC_WRITE,FILE_SHARE_READ,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL);
if (hdle==INVALID_HANDLE_VALUE){
	aff_erreur(hwnd,"Impossible d'ouvrir le fichier de sortie");
	return;
	}

// Rcupre le nom et le prnom entrs dans la boite
SendDlgItemMessage(hwnd,IDD_MAIN_NOM,WM_GETTEXT,MAX_PATH,(LPARAM)pat->szNom);
SendDlgItemMessage(hwnd,IDD_MAIN_PRENOM,WM_GETTEXT,MAX_PATH,(LPARAM)pat->szPrenom);

// Recherche le N de fiche du patient
if (!ReadPatients (pat,PATIENTS_BY_NAME)){ //l'utilisateur a du mal avec ses 10 doigts et  entr un nom incorrect ?
	MessageBox(hwnd,"Attention, le nom entr n'a pas t trouv dans HelloDOC","HD_Export - Erreur",MB_ICONERROR);
	SendDlgItemMessage(hwnd,IDD_MAIN_ACTION,WM_SETTEXT,0,(LPARAM)"Erreur  l'export");
	CloseHandle(hdle);								//referme le fichier de sortie
	return;
	}

SendDlgItemMessage(hwnd,IDD_MAIN_ACTION,WM_SETTEXT,0,(LPARAM)"Export Biologie");
nb_export=0;

MakeBiologiesKey (cle,pat->uFiche,0,0);
		// Construit une cl de recherche pour obtenir
		// les enregistrements classs dans l'ordre suivant
		// par patient, puis par jour, puis par heure

		// Ici le patient est celui entr par l'utilisateur, le jour de dpart est '0' et l'heure '0'.
		// On aura donc le plus ancien enregistrement en premier, puis les enregistrements classs par
		// jour et heure


index=HDBrowseKey(DOSSIERSX,cle);

while (index){									// tant que l'index est correct, c'est  dire !=0
	ReadDossiers2(index,(LPRECDossiers)bio);	// lecture de l'enregistrement

	if (bio->uFiche==pat->uFiche){				// On lit bien toujours pour le mme patient ?
		if (bio->cType==DOSSIERS_BIOLOGIES){	// On est en train de lire un BIOLOGIES (et non un autre lment du dossier)
			hBiologie=ReadBiologies(index,bio);	// Oui, alors go => Lecture de la biologie
												// on lit la structure dans 'bio'
												// et le contenu des donnes accessible par hBiologie

			nb_char=wsprintf(tmp,"-=-=-=-=-=-=-=-=-=-=-=-= Biologie =-=-=-=-=-=-=-=-=-=-=-=-\r\n");
			WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie

			nb_char=wsprintf(tmp,"Date : %02d / %02d / %04d \r\n",(bio->Date)&0x1F,((bio->Date)>>8)&0xF,(bio->Date)>>16);
			WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie

			if (hBiologie){									// Il y a un texte ou un quelque chose d'associ ?
				char *txt=(LPSTR) GlobalLock (hBiologie);	//Lock la zone mmoire
				if (!strncmp(txt,"#FORM",5))				// Est-ce un formulaire ?
					nb_char=wsprintf(tmp,"=-Biologie utilisant un formulaire-=\r\n");
				else
					nb_char=wsprintf(tmp,"=-Biologie en texte libre=-\r\n");
				WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie

				// Ecriture du texte proprement dit
				WriteFile(hdle,txt,strlen(txt),&ecrit,NULL);	// Ecriture dans le fichier de sortie
				GlobalUnlock (hBiologie);						// libre la zone mmoire
				}
			nb_char=sprintf(tmp,"\r\n\r\n");
			WriteFile(hdle,tmp,nb_char,&ecrit,NULL);		// Ecriture dans le fichier de sortie

			// Affichage des infos sur l'avancement de l'export
			nb_export++;
			wsprintf(tmp,"%d",nb_export);
			SendDlgItemMessage(hwnd,IDD_MAIN_CPT,WM_SETTEXT,0,(LPARAM)tmp);
			}
		index=HDNextKey(BIOLOGIESX,cle);		// Suivant

		}
	else										// On a chang de patient, donc c'est termin
		index=0;
	}
CloseHandle(hdle);								//referme le fichier de sortie

SendDlgItemMessage(hwnd,IDD_MAIN_ACTION,WM_SETTEXT,0,(LPARAM)"Export Termin");

}

