Attribute VB_Name = "Module1"
'///////////////////////////////////////////////////////////////////////////
'// Dmo HDAPI Visual Basic
'///////////////////////////////////////////////////////////////////////////
'// 08/11/2002
'//
'// Copyright (c) 2002, E. Ravon (Bat)
'//
'// Auteur : manu_bat_manu@yahoo.fr
'//
'// Dmonstration minimale de l'utilisation d'HDAPI en Delphi
'//
'// Ce code est un exemple d'accs en Delphi aux donnes du logiciel HelloDOC
'// Il utilise la bibliothque HDAPI.
'//
'// Ce code a t dvelopp pour HelloDOC Etendu 4.56.791
'// Ainsi que pour la version d'HDAPI.DLL associe.
'//
'// Il a t test avec HD 4.56 tendu
'// Son fonctionnement n'est pas guaranti avec des versions plus rcentes d'HD
'//
'//
'// HelloDOC est dvelopp par Imagine Editions.
'// Windows est une marque de Microsoft Corporation
'////////////////////////////////////////////////////////////////////////////

'----------------------------------------------
'Dclaration des fonctions WIN32 indispensables
'----------------------------------------------

Declare Function GlobalLock Lib "kernel32.dll" (ByVal hMem As Long) As Long
Declare Function GlobalUnlock Lib "kernel32.dll" (ByVal hMem As Long) As Long
Declare Sub MoveMemory Lib "kernel32.dll" Alias "RtlMoveMemory" _
  (Destination As Any, Source As Any, ByVal Length As Long)

'----------------------------------------------
'Dclaration des fonctions Exports par HDAPI
'----------------------------------------------
'
'Il doit tre apport le plus grand soin au type de donnes
'
'Byte    1 byte  0  255
'Boolean 2 bytes True ou False
'Integer 2 bytes -32,768  32,767
'Long    4 bytes -2,147,483,648  2,147,483,647
'Single  4 bytes -3.402823E38  -1.401298E-45 (pour les valeurs ngatives) 1.401298E-45  3.402823E38 (pour les valeurs positives)
'Double  8 bytes -1.79769313486232E308  -4.94065645841247E-324 (pour les valeurs ngatives) 4.94065645841247E-324  1.79769313486232E308 (pour les valeurs positives)
'

'type HDDATE => Long
'type HDTIME => Long
'type USHORT => Integer -- faux car normallement non sign
'type SBOOL => Integer
'type HDFILEPOS => Long

' Attention en particulier aux chaines de caractres (String)
'
' Leur type est diffrent en C et en Visual Basic
' Une chaine en C est un ensmelbe de caractres termin par un caractre nul (\0)
' Une chaine en Visual Basic est un type plus complexe et la longueur est
'   stocke en dehors de la chaine.
'
' Lorsque l'on passe une chaine  HDAPI, il faut s'assurer que celle-ci contient
'  le caractre \0 terminal

'/////////////////////////////////////////////////////////////////////////
'// ATTENTION !!!!! La 'translation' ralise ici n'est en aucun cas
'//                 guarantie ! On peut raisonablement estimer que peu
'//                 d'erreurs peuvent venir se loger dans la dfinition
'//                 des fonctions (function , procedure),
'//
'//                 PAR CONTRE, il est tout a fait possible qu'il reste des
'//                 erreurs dans les structures (record)
'//                 (notamment des erreurs d'alignement !)
'/////////////////////////////////////////////////////////////////////////

'[hdapi.h] : typedef short  HDFILE ; // Identificateur fichier de squentiel index
'[hdapi.h] : enum{...}
Enum HdFileType
    AGENDAS = 1
    AGENDASX
    AGENDAS1X = AGENDASX
    AGENDAS2X
    AGENDAS3X

    PATIENTS
    PATIENTSX
    PATIENTS1X = PATIENTSX
    PATIENTS2X
    PATIENTS3X
    PATIENTS_
    PATIENTSX_
    PATIENTS1X_ = PATIENTSX_
    PATIENTS2X_
    PATIENTS3X_

    RECETTES
    RECETTESX
    RECETTES1X = RECETTESX
    RECETTES2X
    RECETTES3X
    RECETTES4X
    RECETTES_
    RECETTESX_
    RECETTES1X_ = RECETTESX_
    RECETTES2X_
    RECETTES3X_
    RECETTES4X_

    DEPENSES
    DEPENSESX

    PHARMACIES
    PHARMACIESX

    POSOLOGIES
    POSOLOGIESX

    DSIMEDICAMENTS
    DSIMEDICAMENTSX
    DSICIPX

    DSIINTERACTIONS
    DSIINTERACTIONSX

    DSICLASSES
    DSICLASSESX

    DSIGRAVITES
    DSIGRAVITESX

    DSITEXTS
    DSITEXTSX

    DSIABSTRATS
    DSIABSTRATSX

    HOMEO
    HOMEOX

    DOSSIERS
    DOSSIERSX
    ANTECEDENTS = DOSSIERS
    ANTECEDENTSX = DOSSIERSX
    CONSULTATIONS = DOSSIERS
    CONSULTATIONSX = DOSSIERSX
    ORDONNANCES = DOSSIERS
    ORDONNANCESX = DOSSIERSX
    COURRIERS = DOSSIERS
    COURRIERSX = DOSSIERSX
    VACCINS = DOSSIERS
    VACCINSX = DOSSIERSX
    BIOLOGIES35 = DOSSIERS
    BIOLOGIES35X = DOSSIERSX
    BIOLOGIES = DOSSIERS
    BIOLOGIESX = DOSSIERSX
    NOTES = DOSSIERS
    NOTESX = DOSSIERSX
    BITMAPS = DOSSIERS
    BITMAPSX = DOSSIERSX
    PIECESJOINTES = DOSSIERS
    PIECESJOINTESX = DOSSIERSX
    INFOSESAM = DOSSIERS
    INFOSESAMX = DOSSIERSX
    SITFACTTLA = DOSSIERS
    SITFACTTLAX = DOSSIERSX
    TRAITEMENTS = DOSSIERS
    TRAITEMENTSX = DOSSIERSX
    DOSSIERS_
    DOSSIERSX_

    MEDIAVIDALX

    INBOX
    INBOXX
    INBOX1X = INBOXX
    INBOX2X
    

    MAILX
    MAIL1X = MAILX
    MAIL2X

    KEYWORDS
    KEYWORDSX
    LIENVITALEX

    FSE
    FSEX
    FSE1X = FSEX
    FSE2X
    FSE3X
    FSE4X
    FSE5X
    FSE_
    FSEX_
    FSE1X_ = FSEX_
    FSE2X_
    FSE3X_
    FSE4X_
    FSE5X_

    LOT
    LOTX
    LOT1X = LOTX
    LOT2X
    LOT3X
    LOT4X

    LOT_
    LOTX_
    LOT1X_ = LOTX_
    LOT2X_
    LOT3X_
    LOT4X_

    PLAN
    PLANX
    PLAN1X = PLANX
    PLAN2X
    PLAN3X
    PLAN4X
    PLAN5X

    JOURNAL
    JOURNALX
    JOURNAL1X = JOURNALX
    JOURNAL2X
    JOURNAL3X
    JOURNAL4X
    JOURNAL5X
    JOURNAL6X

    RUBRIQUES
    RUBRIQUESX
    RUBRIQUES1X = RUBRIQUESX
    RUBRIQUES2X
    
    RUBRIQUES3X
    RUBRIQUES4X

    BANQUES
    BANQUESX
    BANQUES1X = BANQUESX
    BANQUES2X
    BANQUES3X

    DFCCX
    DFCC1X = DFCCX
    DFCC2X

    IMMOBILISATIONS
    IMMOBILISATIONSX
    IMMOBILISATIONS1X = IMMOBILISATIONSX
    IMMOBILISATIONS2X

    AMORTISSEMENTS
    AMORTISSEMENTSX

    PEDIATRIE
    PEDIATRIEX

    SEANCES
    SEANCESX
    SEANCES1X = SEANCESX
    SEANCES2X
    SEANCES3X
    SEANCES4X
    SEANCES5X
    SEANCES6X

    TRAITEMENTSIDX
    TRAITEMENTSID1X = TRAITEMENTSIDX
    TRAITEMENTSID2X
    TRAITEMENTSID3X
    TRAITEMENTSID4X

    FSP
    FSPX

    HD_TEMP_FILE
    HD_TEMP_FILEX
End Enum

Public Const SIZE_USER = 16   ' Taille de l'identifcateur de l'utilisateur
Public Const MAX_KEYLEN = 64
Public Const SIZE_PHONE = 12
Public Const SIZE_NAME = 20
Public Const PATIENTS_BY_REC = 1

Public Type HDDATE
  Day As Byte
  Month As Byte
  Year As Integer
End Type

Public Type HDTIME
  Second As Byte
  Minute As Byte
  Hour As Byte
  Dmy As Byte
End Type

Public Type RECAgendas
  wStatus As Integer             ' Etat enregistrement (0 = OK)
  Date As HDDATE                   ' Date du jour
  Time As HDTIME                   ' Heure du rendez-vous
  szUser(SIZE_USER - 1) As Byte    ' Nom de l'utilisateur
  nWarning As Integer            ' Source du rendez-vous RDV_RENDEZVOUS, RDV_VACCIN
  uFiche As Integer              ' Numro de fiche patient
  szText(128 - 1) As Byte          ' Textes
  szTextName(13 - 1) As Byte       ' Nom du fichier texte associ
  szSoundName(13 - 1) As Byte      ' Nom du fichier son associ
  szBitmapName(13 - 1) As Byte     ' Nom du fichier image associ
  bAlarme As Integer             ' VRAI si gnration d'une alarme ou Type de journe AGENDA_FERIE, AGENDA_GARDE, AGENDA_CONGE, AGENDA_AUTRE
  nRappel As Integer             ' Rappel xx xxxxxxxx avant l'alarme
  nTypeRappel As Integer         ' 0=Minute, 1=Heures, 2=Jours, 3=Semaine, 4=Mois
  DateSeance As Long             ' Date de la sance associe
  TimeSeance As Long             ' Heure de la sance associe
  Extension(8 - 1) As Byte         ' Rserve pour extension
End Type
'type LPRECAgendas = ^RECAgendas;

'Byte    1 byte  0  255
'Boolean 2 bytes True ou False
'Integer 2 bytes -32,768  32,767
'Long    4 bytes -2,147,483,648  2,147,483,647
'Single  4 bytes -3.402823E38  -1.401298E-45 (pour les valeurs ngatives) 1.401298E-45  3.402823E38 (pour les valeurs positives)
'Double  8 bytes -1.79769313486232E308  -4.94065645841247E-324 (pour les valeurs ngatives) 4.94065645841247E-324  1.79769313486232E308 (pour les valeurs positives)

Type RECPatients
  wStatus As Integer              ' Etat enregistrement (0 = OK)
  bDeleted As Integer             ' Flag si supprim / archiv
  szDossier(16 - 1) As Byte         ' Rfrence de dossier papier  (Cl 3)
  szNom(21 - 1) As Byte             ' Nom du patient        (Cle 1)
  szPrenom(21 - 1) As Byte          ' Prnom du patient     (Cle 1)
  szNomJF(21 - 1) As Byte                ' Nom de jeune fille
  cSexe As Byte                   ' H = Homme,  F = Femme
  cSitFam As Byte                 ' C = Celibataire, M = Mari, D = Divorc(e), V = Veuf(ve), O = Cocubin(e), P = Parent clibataire
  DateNai As Long                 ' Date de naissance
  szLieuNai(41 - 1) As Byte         ' Lieu de naissance
  szAdresse(81 - 1) As Byte         ' Adresse
  szCPostal(6 - 1) As Byte          ' Code Postal
  szVille(21 - 1) As Byte           ' Ville
  szTelPerso(SIZE_PHONE - 1) As Byte ' Numro de tlphone personnel
  szTelPro(SIZE_PHONE - 1) As Byte  ' Numro de tlphone professionnel
  nEnfants As Integer             ' Nombre d'enfants
  nTaille As Integer              ' Taille en Cm
  nPoids As Integer               ' Poids en Kg
  szGroupe(11 - 1) As Byte          ' Groupe sanguin
  szProfession(41 - 1) As Byte      ' Profession
  szNumSS(31 - 1) As Byte           ' Numro de scurit sociale
  szCaisse(SIZE_NAME + 1 - 1) As Byte ' Caisse d'assur social
  szTiers(SIZE_NAME + 1 - 1) As Byte ' Tiers payant
  szRemarque(81 - 1) As Byte        ' Remarque
  uFiche As Integer               ' Numro de fiche patient (Cl 2)
  szUser(SIZE_USER - 1) As Byte     ' Nom de l'utilisateur
  DateFiche As HDDATE               ' Date de cration fiche
  DateConsulte As HDDATE            ' Date derniere consultation
  nCourrier As Integer            ' Numro squentiel courrier
  nOrdonnance As Integer          ' Numro squentiel ordonnance.
  szMedecin(81 - 1) As Byte         ' Medecin traitant
  szLibZone1(11 - 1) As Byte        ' Libll de la zone supplmentaire 1
  szLibZone2(11 - 1) As Byte        ' Libll de la zone supplmentaire 2
  szLibZone3(11 - 1) As Byte        ' Libll de la zone supplmentaire 3
  szLibZone4(11 - 1) As Byte        ' Libll de la zone supplmentaire 4
  szZone1(25 - 1) As Byte           ' Zone supplmentaire 1
  szZone2(25 - 1) As Byte           ' Zone supplmentaire 2
  szZone3(25 - 1) As Byte           ' Zone supplmentaire 3
  szZone4(25 - 1) As Byte           ' Zone supplmentaire 4
  szLibCZone1(11 - 1) As Byte       ' Libll de la zone supplmentaire en consultation 1
  szLibCZone2(11 - 1) As Byte       ' Libll de la zone supplmentaire en consultation 2
  szLibCZone3(11 - 1) As Byte       ' Libll de la zone supplmentaire en consultation 3
  szLibCZone4(11 - 1) As Byte       ' Libll de la zone supplmentaire en consultation 4
  cMaskEvent As Byte              ' Elments affich dans le dossier (1 bit par lment)
  cSeparatorPos As Byte           ' Position du sparateur dans le dossier (en %)
  nItems As Integer               ' Nombres d'lments dans le dossier
  DateDeces As HDDATE               ' Date de dcs (brrrrr)
  uIDIMS As Long                  ' Identifiant IMS
  uTraitementID As Integer        ' N du dernier traitement
  cRangGemellaire As Byte         ' Rang gmellaire (RANG_GEMELLAIRE_1/RANG_GEMELLAIRE_2...)
  Extension2(2 - 1) As Byte         ' Rserve pour extension
  End Type

'type LPRECPatients = ^RECPatients;

' *-*-*-*-* Session *-*-*-*-*

'[hdapi.h] : API_EXPORT BOOL HDAPI HDOpenSession (BOOL bNetwork);
Public Declare Function HDOpenSession Lib "HDAPI" (network As Boolean) As Boolean

'[hdapi.h] : API_EXPORT void HDAPI HDCloseSession ();
Public Declare Sub HDCloseSession Lib "HDAPI" ()

'*-*-*-*-* Cabinet *-*-*-*-*

'[hdapi.h] : API_EXPORT BOOL HDAPI HDGetApplicationInfo (LPCSTR lpSection, LPCSTR lpEntry, LPSTR lpValue) ;
Public Declare Function HDGetApplicationInfo Lib "HDAPI" _
    (ByVal rubrique As String, ByVal cle As String, ByVal valeur As String) As Long
    
'[hdapi.h] : API_EXPORT int HDAPI HDOpenCabinetDlg (HWND hWnd, LPSTR lpPath, LPSTR lpCabinet, LPSTR lpUser, LPSTR lpPassword) ;
Public Declare Function HDOpenCabinetDlg Lib "HDAPI" _
    (ByVal hwnd As Long, ByVal path As String, ByVal Cabinet As String, _
     ByVal User As String, ByVal Pwd As String) As Long

'[hdapi.h] : API_EXPORT BOOL HDAPI HDOpenCabinet (LPCSTR lpPath, LPCSTR lpCabinet, LPCSTR lpUser, LPCSTR lpPassword) ;
Public Declare Function HDOpenCabinet Lib "HDAPI" _
    (ByVal path As String, ByVal Cabinet As String, ByVal User As String, _
    ByVal Pwd As String) As Long
    
'[hdapi.h] : API_EXPORT void HDAPI HDCloseCabinet () ;
Public Declare Sub HDCloseCabinet Lib "HDAPI" ()

'*-*-*-*-* Accs Fichiers Squentiels Indexs *-*-*-*-*

'[hdapi.h] : API_EXPORT DWORD HDAPI HDNumberOfKey (HDFILE hFile);
Public Declare Function HDNumberOfKey Lib "HDAPI" _
    (ByVal hFile As HdFileType) As Long

'[hdapi.h] : API_EXPORT HGLOBAL HDAPI OpenPatients (LPCSTR lpPath /*= NULL*/) ;
Public Declare Function OpenPatients Lib "HDAPI" _
    (ByVal lpPath As String) As Long

'[hdapi.h] : API_EXPORT HGLOBAL HDAPI OpenAgendas (LPCSTR lpPath /*= NULL*/) ;
Public Declare Function OpenAgendas Lib "HDAPI" _
    (ByVal lpPath As String) As Long

'[hdapi.h] : API_EXPORT LPSTR HDAPI MakeAgendas1Key (LPSTR lpKey, LPCSTR lpUser, HDDATE Date, HDTIME Time) ;
Public Declare Function MakeAgendas1Key Lib "HDAPI" _
    (ByVal cle As Long, ByVal lpUser As String, ByVal Date1 As Long, _
    ByVal Time As Long) As Long

'[hdapi.h] : API_EXPORT BOOL HDAPI HDReadRec (HDFILE hFile, HDFILEPOS Idx, LPSTR lpBuffer) ;
Public Declare Function HDReadRec Lib "HDAPI" _
    (ByVal hFile As HdFileType, ByVal Idx As Long, ByVal lpBuffer As Long) _
    As Integer

'[hdapi.h] : API_EXPORT HDFILEPOS HDAPI ReadPatients (LPRECPatients lpPatients, int nKey) ;
Public Declare Function ReadPatients Lib "HDAPI" _
    (ByVal lpPatients As Long, ByVal nKey As Integer) _
    As Long

'[hdapi.h] : API_EXPORT void HDAPI ClosePatients (HGLOBAL) ;
Public Declare Sub ClosePatients Lib "HDAPI" _
    (ByVal Patient As Long)

'[hdapi.h] : API_EXPORT void HDAPI CloseAgendas (HGLOBAL) ;
Public Declare Sub CloseAgendas Lib "HDAPI" _
    (ByVal Patient As Long)

'[hdapi.h] : API_EXPORT HDFILEPOS HDAPI HDBrowseKey (HDFILE hFile, LPSTR lpKey) ;
Public Declare Function HDBrowseKey Lib "HDAPI" _
    (ByVal hFile As HdFileType, ByVal lpKey As Long) As Long

'[hdapi.h] : API_EXPORT HDFILEPOS HDAPI HDNextKey (HDFILE hFile, LPSTR lpKey) ;
Public Declare Function HDNextKey Lib "HDAPI" _
    (ByVal hFile As HdFileType, ByVal lpKey As String) As Long

'[hdapi.h] : API_EXPORT HDDATE HDAPI Today () ;
Public Declare Function Today Lib "HDAPI" () As Long



     

