//Bat (c) 2001
#include <windows.h>
#include "res_main.h"


HINSTANCE hInst;
HANDLE hdle;
BOOL _stdcall Main_Dlg(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);

#define FICHIER_OUT "HDRegSav.reg"
#define TAG_FILE "Windows Registry Editor Version 5.00\r\n\r\n"

int sav_reg_key(HKEY key_base,char *cle);
char *bullet_data(char *d);

/************************************************************************************************/
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, INT nCmdShow){
/************************************************************************************************/
int ec;

hdle=CreateFile(FICHIER_OUT,GENERIC_WRITE,FILE_SHARE_READ,NULL,CREATE_ALWAYS,0,NULL);
if (hdle==INVALID_HANDLE_VALUE){
	MessageBox(NULL,FICHIER_OUT,"Impossible de crer le fichier de sortie",MB_ICONERROR);
	return 0;
	}

WriteFile(hdle,TAG_FILE,strlen(TAG_FILE),&ec,NULL);
if (!sav_reg_key(HKEY_CURRENT_USER,"Software\\IMAGINE Editions"))
	goto sav_error;
if (!sav_reg_key(HKEY_LOCAL_MACHINE,"Software\\IMAGINE Editions"))
	goto sav_error;

MessageBox(NULL,"Sauvegarde OK.\n","HelloREG (manu_bat_manu@yahoo.fr)",MB_ICONINFORMATION);
CloseHandle(hdle);
return 0;
sav_error:
MessageBox(NULL,"Erreur  la sauvegarde","HelloREG",MB_ICONERROR);
CloseHandle(hdle);
return 0;
}

/****************************************/
int sav_reg_key(HKEY key_base,char *cle){
/****************************************/
HKEY lkey;
int max_size_data,max_size_name;
int size_name,size_data;
char name[1000],data[1000];
int n,ec,type;
char dat[1000];

if (RegOpenKeyEx(key_base,cle,0,KEY_READ|KEY_ENUMERATE_SUB_KEYS,&lkey)!=ERROR_SUCCESS)
	return FALSE;

	strcpy(dat,"[");
switch ((int)key_base){
	case (int)HKEY_CURRENT_USER:
		strcat(dat,"HKEY_CURRENT_USER\\");
		break;
	case (int)HKEY_LOCAL_MACHINE:
		strcat(dat,"HKEY_LOCAL_MACHINE\\");
		break;
	default:
		MessageBox(NULL,"cl de base inconnue !!","HelloREG",MB_ICONERROR);
		return FALSE;
		break;
	}

strcat(dat,cle);
strcat(dat,"]\r\n");
WriteFile(hdle,dat,strlen(dat),&ec,NULL);

n=0;

size_name=1000;
size_data=1000;
while (RegEnumValue(lkey,n,name,&size_name,NULL,&type,data,&size_data)!=ERROR_NO_MORE_ITEMS){;
	switch (type){
		case REG_SZ:
			if (name[0])
				wsprintf(dat,"\"%s\"=\"%s\"\r\n",name,bullet_data(data));
			else
				wsprintf(dat,"@=\"%s\"\r\n",bullet_data(data));
			WriteFile(hdle,dat,strlen(dat),&ec,NULL);
			break;
		case REG_DWORD:
			//"Position"=dword:00000004
			wsprintf(dat,"\"%s\"=dword:%08x\r\n",name,*(int*)(&data[0]));
			WriteFile(hdle,dat,strlen(dat),&ec,NULL);
			break;
		case REG_BINARY:
			//"Position"=dword:00000004
			;
			int pos;
			char *d;
			d=dat+wsprintf(dat,"\"%s\"=hex:",name,data);
			pos=0;
			while (pos<size_data){
				if (pos<size_data-1)
					d+=wsprintf(d,"%02x,",data[pos]&0xFF);
				else
					d+=wsprintf(d,"%02x",data[pos]&0xFF);
				pos++;
				if (d-dat>76){
					strcpy(d,"\\\r\n");
					WriteFile(hdle,dat,strlen(dat),&ec,NULL);
					d=dat;
					strcpy(d,"  ");
					d+=2;
					}
				}
			strcpy(d,"\r\n");
			WriteFile(hdle,dat,strlen(dat),&ec,NULL);
			break;
		default:
			;
			char err[MAX_PATH];
			wsprintf(err,"Type de cl inconnu : %d (nom : %s)",type,name);
			MessageBox(NULL,err,"HelloREG",MB_ICONERROR);
			RegCloseKey(lkey);
			return FALSE;
			break;
		}
	size_name=1000;
	size_data=1000;
	n++;
	}

strcpy(dat,"\r\n");
WriteFile(hdle,dat,strlen(dat),&ec,NULL);

n=0;
size_name=1000;
while (RegEnumKeyEx(lkey,n,name,&size_name,0,NULL,NULL,NULL)!=ERROR_NO_MORE_ITEMS){
	n++;
	char new_path[1000];
	wsprintf(new_path,"%s\\%s",cle,name);
	if (!sav_reg_key(key_base,new_path)){
		RegCloseKey(lkey);
		return FALSE;
		}
	size_name=1000;
	}
RegCloseKey(lkey);
return TRUE;
}

/*************************************/
char *bullet_data(char *d){
/*************************************/
static char data_bullet[2000],*p;

p=data_bullet;
while (*d){
	switch (*d){
		case '\\':
			*p++='\\';
			*p='\\';
			break;
		default:
			*p=*d;
		}
	d++;
	p++;
	}
*p=0;
return data_bullet;
}
