///////////////////////////////////////////////////////////////////////////
// VioxxFinderLite
///////////////////////////////////////////////////////////////////////////
// 03/05/2004
//
// Copyright (c) 2004, E. Ravon (Bat)
//
// Auteur : manu_bat_manu@yahoo.fr
//
// Recherche de prescriptions dans HelloDOC - dmonstration
//
// Ce code est un exemple d'accs en C aux donnes du logiciel HelloDOC
// Il utilise la bibliothque HDAPI.
//
// Ce code a t dvelopp pour HelloDOC tendu 5.0.11813
// Ainsi que pour la version d'hdapi.h associe.
//
// Il a t test avec HD 5.0.11813 tendu
// Son fonctionnement n'est pas garanti avec des versions plus rcentes ou plus anciennes d'HD
//
// Ce code peut tre librement utilis, modifi, diffus.
// La seule obligation est que l'auteur d'un code modifi doit le faire apparaitre clairement comme tel.
// Il n'est pas obligatoire de laisser cette notice ni de faire rfrence  ce code.
//
// HelloDOC est dvelopp par Imagine ditions.
// Windows est une marque de Microsoft Corporation
////////////////////////////////////////////////////////////////////////////
// N.B. 	: les commentaires ont t fait pour cette application UNIQUEMENT
// 			  afin d'en faciliter la comprhension
// N.B.2 	: les solutions techniques donnes ici ne sont pas les mmes
//			  que celles de VioxFinder dans un souci de simplicit.
////////////////////////////////////////////////////////////////////////////

#include <windows.h>						// routines standard
#include "res.h"							// identifiants des ressources
#include "hdapi.h"							// fonctions d'HDAPI pour accder au cabinet


typedef struct{								// Structure qui va permettre de stocker les rsultats pour 1 patient.
	HDDATE 			first;					// Date de l'occurence la plus ancienne pour ce patient
	HDDATE 			last;					// Date de l'occurence la plus rcente pour ce patient
	int 			nb;						// Nombre d'occurences
	}PATIENT_ENTRY;


// ----------- Variables globales --------------
HINSTANCE hInst;							// Permet(entre autre)  l'application de retrouver
											// les ressources (la boite, l'icone,etc)
static char recherche_lower[256];			// Tableau permettant de transformer tout caractre en une minuscule
static int recherche_en_cours;				// Si la recherche est en cours (TRUE), on doit bloquer certaines fontions

// ----------- Fonctions --------------

void initialisation_affichage(HWND hwnd);	// Initialise les diffrents lments de la fenetre prncipale
void initialisation_recherche();			// Initialise la fonction permettant de faire les comparaisons
void initialisation_std_cab(HWND hwnd);		// Ouvre le dernier cabinet utilis

void recherche_ordonnance(HWND hwnd);		// routine principale de recherche
char *recherche_strxstr(char *buf,char *s);	// Recherche une chaine dans un grosse chaine

BOOL _stdcall Main_Dlg(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);
											// "CallBack", autrement fonction qui va tre appele automatiquement
											// par Win quand quelque chose s'est pass dans la fenetre
											// (elle vient d'tre cre, l'utilisateur  appuy sur un bouton,
											//  la fenetre est ferme,etc,etc).

/************************************************************************************************/
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, INT nCmdShow){
/************************************************************************************************/
hInst=hInstance;

HDOpenSession(TRUE);	// Ouvre une session, ceci est indispensable
						// avant tout autre accs aux fonctions d'HDAPI
DialogBox(hInst,MAKEINTRESOURCE(IDD_MAIN),NULL,Main_Dlg); // Affiche la boite principale et gre cette boite
														  // jusqu' ce que l'utilisateur la quitte
														  // A chaque evenement (appuis sur un bouton,etc)
														  // la fonction Main_Dlg est appele
HDCloseSession();		// Ferme la session HDAPI, ceci est indispensable
return 0;				// Retourne 0, tout s'est bien termin
}


///////////////////////////////////////////////////////////////////////////////////
// MAIN DLG CALLBACK
///////////////////////////////////////////////////////////////////////////////////
/******************************************************************************/
BOOL _stdcall Main_Dlg(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam){
/******************************************************************************/
int i;
switch(msg) {
	case WM_INITDIALOG:						// *** Message envoy au premier affichage la fentre
		initialisation_affichage(hwnd);		// Initialise la fenetre
		initialisation_recherche();			// Initialise la fonction qui permettra de faire des recherches
		initialisation_std_cab(hwnd);		// Ouvre le dernier cabinet utilis

		SendDlgItemMessage(hwnd,IDD_TXT_ORDO,WM_SETTEXT,0,(LPARAM)"Vioxx");
											// Initialise le texte de recherche dans la boite ...
		recherche_en_cours=FALSE;			// Aucune recherche n'est actuellement en cours
		return 1;							// On a trait personellement ce message.
		break;
	case WM_COMMAND:						//*** Message envoy quand l'utilisateur appuie sur un bouton
		switch (LOWORD(wParam)) {
			case IDD_START:					// On veut lancer la recherche ?
				if (recherche_en_cours==FALSE){	// Si on est pas dj en train d'effectuer une recherche
					recherche_en_cours=TRUE;
					recherche_ordonnance(hwnd);
					recherche_en_cours=FALSE;
					}
				break;
			}
		break;
	case WM_CLOSE:
		if (recherche_en_cours==TRUE){	// Si on est en train d'effectuer une recherche
			// Informe l'utilisateur que a va pas tre possible ...
			MessageBox(hwnd,"Il est ncessaire d'attendre la fin de la recherche","VioxxFinderLite",MB_ICONINFORMATION);
			return 1;
			}
		HDCloseCabinet();				// Ferme le cabinet
		EndDialog(hwnd,0);				// Ferme la fenetre
		break;
	}
return 0;		// Indique que l'on a pas trait ce message ...
}


/**************************************/
void initialisation_affichage(HWND hwnd){
/**************************************/
// -- Affiche l'icone en haut de la boite ---
HICON icon;
icon=LoadIcon(hInst,MAKEINTRESOURCE(IDI_ICON));
SendMessage(hwnd,WM_SETICON,ICON_SMALL,(LPARAM)icon);
SendMessage(hwnd,WM_SETICON,ICON_BIG,(LPARAM)icon);

// -- Cre les colonnes ---
int ncol=0;
LVCOLUMN col;

// 1 re colonne
col.mask=LVCF_TEXT|LVCF_WIDTH;		// initialisation du texte et de la largeur de la colonne
col.cx=200;							// largeur initiale de la colonne
col.pszText="Nom Patient";			// texte
SendDlgItemMessage(hwnd,IDD_LIST,LVM_INSERTCOLUMN,ncol++,(LPARAM)&col);	// Ajout de la colonne

// 2 me colonne
col.mask=LVCF_TEXT|LVCF_WIDTH|LVCF_FMT; // Ici en + on initialise l'alignement
col.cx=80;
col.pszText="Age";
col.fmt=LVCFMT_RIGHT;					// align  droite
SendDlgItemMessage(hwnd,IDD_LIST,LVM_INSERTCOLUMN,ncol++,(LPARAM)&col);

// 3 me colonne
col.mask=LVCF_TEXT|LVCF_WIDTH|LVCF_FMT;
col.cx=50;
col.fmt=LVCFMT_RIGHT;
col.pszText="Nombre d'occurences";
SendDlgItemMessage(hwnd,IDD_LIST,LVM_INSERTCOLUMN,ncol++,(LPARAM)&col);

// 4 me colonne
col.mask=LVCF_TEXT|LVCF_WIDTH|LVCF_FMT;
col.cx=80;
col.pszText="Premire occurence";
col.fmt=LVCFMT_RIGHT;
SendDlgItemMessage(hwnd,IDD_LIST,LVM_INSERTCOLUMN,ncol++,(LPARAM)&col);

// 5 me colonne
col.mask=LVCF_TEXT|LVCF_WIDTH|LVCF_FMT;
col.cx=80;
col.fmt=LVCFMT_RIGHT;
col.pszText="Dernire occurence";
SendDlgItemMessage(hwnd,IDD_LIST,LVM_INSERTCOLUMN,ncol++,(LPARAM)&col);
}

/**********************************************/
void initialisation_std_cab(HWND hwnd){
/**********************************************/
// Une macro pas propre pour lire une chaine en base de registre
#define QVALUE_STR(key,str,var) 	type=REG_SZ;lg=sizeof(var);RegQueryValueEx(key,str,NULL,&type,&var,&lg);

// Accs  la BDR
HKEY key;					// Handle de la cl en BDR
int type,lg;				// Type de cl, longueur
// Ce qu'on souhaite rcuprer
char path[MAX_PATH];		// Chemin d'HelloDOC.
char cabinet[MAX_PATH];		// Nom du cabinet.
char user[MAX_PATH];		// Nom de l'utilisateur.


RegOpenKey(HKEY_CURRENT_USER,"Software\\IMAGINE Editions\\HelloDOC\\Chemins",&key); // recherche le chemin d'HD en BDR
QVALUE_STR(key,"Cabinets",path); 		// Stocke dans path
RegCloseKey(key);
RegOpenKey(HKEY_CURRENT_USER,"Software\\IMAGINE Editions\\HelloDOC\\Cabinets",&key); // recherche le dernier cabinet utilis
QVALUE_STR(key,"Dernier",cabinet);		// Stocke le nom du dernier cabinet dans cabinet.
QVALUE_STR(key,cabinet,user);			// Rcupre le nom du dernier utilisateur ayant ouvert ce cabinet.
										// Ce nom ne servira qu' effectivement 'ouvrir' le cabinet
RegCloseKey(key);
HDSetPathCabinet(path);					// FORCE le chemin du cabinet pour viter un vieux bug d'HDAPI
										// ayant tendence  EXPLOSER les fichiers de config d'HD
										// si le prcdent cabinet ouvert tait une antiquit 4.2, antiquit qui
										// se retrouve trs facilement dans le cabinet de dmo sur d'anciennes
										// installations ...
										// GRRRRR.

if (!HDOpenCabinet(path,cabinet,user,"")) // Ouvre le cabinet
	MessageBox(hwnd,"Impossible d'ouvrir le cabinet par dfaut","VioxxFinderLite",MB_ICONERROR);
	// Si l'ouverture se passe mal, alors avertit l'utilisateur que a va lui exploser  la figure ...
}




//////////////////////////////////////////////////////////////////////////////////////////////
// Fonctions assurant la recherche d'une chaine ( a rechercher) dans un buffer (o l'on doit
// trouver la chaine).
// La recherche est insensible  la casse, et prend en compte (peut prendre en compte)
// n'importe quels caractres bizarodes (,,, etc).
//////////////////////////////////////////////////////////////////////////////////////////////
// On cre un tableau (recherche_lower), dans lequel pour chaque caractre ASCII d'origine,
// on associe un caractre  utiliser pour la recherche.
// Par ex : le caractre assoic  'a' sera 'a', celui associ 'A' sera 'a',
// celui associ  '' sera 'a', etc. Ainsi "aA" sera bien trouv identique  "aA"





#define MAKE_LOWER(x,y)  z=((unsigned int)x); recherche_lower[z]=y;

/****************************************/
void initialisation_recherche(){
/****************************************/
int i,j,z;
for (i=0;i<256;i++)					// par dfaut tout caractre est associ  lui mme.
	recherche_lower[i]=i;

for (i='A',j='a';i<='Z';i++,j++)	// On associe ensuite  chaque majuscule, le caractre minuscule associ
	recherche_lower[i]=j;			// A noter qu'on peut faire cette partie avec un simple masque.

// On traite ensuite les cas particuliers, c'est  dire tous les caractres spciaux
// Pour reprer les caractres  problme, : l'utilitaire "charmap" est adapt.

// Attention ! cette table est initialise diffrement pour palier aux diffrence de compilation de
// certains compilateurs qui ne prennent pas en compte les index de tableaux en unsigned char 
MAKE_LOWER('','a');
MAKE_LOWER('','a');
MAKE_LOWER('','a');
MAKE_LOWER('','a');
MAKE_LOWER('','a');
MAKE_LOWER('','a');
MAKE_LOWER('','c');
MAKE_LOWER('','e');
MAKE_LOWER('','e');
MAKE_LOWER('','e');
MAKE_LOWER('','e');
MAKE_LOWER('','i');
MAKE_LOWER('','i');
MAKE_LOWER('','i');
MAKE_LOWER('','i');
MAKE_LOWER('','n');
MAKE_LOWER('','o');
MAKE_LOWER('','o');
MAKE_LOWER('','o');
MAKE_LOWER('','o');
MAKE_LOWER('','o');
MAKE_LOWER('','u');
MAKE_LOWER('','u');
MAKE_LOWER('','u');
MAKE_LOWER('','u');
MAKE_LOWER('','y');
MAKE_LOWER('','a');
MAKE_LOWER('','a');
MAKE_LOWER('','a');
MAKE_LOWER('','a');
MAKE_LOWER('','a');
MAKE_LOWER('','a');
MAKE_LOWER('','c');
MAKE_LOWER('','e');
MAKE_LOWER('','e');
MAKE_LOWER('','e');
MAKE_LOWER('','e');
MAKE_LOWER('','i');
MAKE_LOWER('','i');
MAKE_LOWER('','i');
MAKE_LOWER('','i');
MAKE_LOWER('','n');
MAKE_LOWER('','o');
MAKE_LOWER('','o');
MAKE_LOWER('','o');
MAKE_LOWER('','o');
MAKE_LOWER('','o');
MAKE_LOWER('','u');
MAKE_LOWER('','u');
MAKE_LOWER('','u');
MAKE_LOWER('','u');
MAKE_LOWER('','y');
MAKE_LOWER('','y');
}

//////////////////////////////////////////////////////////////////////////////////////
// recherche_strxstr(buf,s);
// Recherche la chaine 's' dans la chaine 'buf', en ne tenant pa compte de la casse
// La chaine 's' doit avoir pralablement t transforme pour ne pas tenir compte de la casse
// Retourne un pointeur sur l'occurence trouve, ou bien NULL si non trouv
//////////////////////////////////////////////////////////////////////////////////////
/*****************************************************/
char *recherche_strxstr(char *buf,char *s){
/*****************************************************/
char *t,*b;

if (!buf) return NULL; // Buffer de recherche non existant
// "Soupe aux pointeurs" ...
while (*buf){
	if (recherche_lower[*buf]==*s){
		t=s+1;b=buf+1;
		while (recherche_lower[*b]==*t){
			b++;t++;
			if (!*t) return buf;
			}
		}
	buf++;
	}
return NULL;
}



//////////////////////////////////////////////////////////////////////////////////////
// Routine de recherche dans les dossiers d'HD proprement dit
//////////////////////////////////////////////////////////////////////////////////////

#define MAX_DOSSIERS 65536				// Nombre de patients MAX dans HD

/********************************/
static int compar(int *a,int *b){		// Petite fonction de comparaison qui servira  trier les indexs.
/********************************/
return *a-*b;
}

/*****************************************************************************************/
void recherche_ordonnance(HWND hwnd){
/*****************************************************************************************/
char str_srch_orig[MAX_PATH];	// Chaine  rechercher telle que l'utilisateur l'a entre
char str_srch[MAX_PATH];		// Chaine  rechercher en interne (une fois pass en minuscule pour s'affranchir de la casse)

char tmp[500];


HGLOBAL Dossier;				// "Handle" du fichier contenant les dossiers  fournir  chaque accs
char cle_dossier[MAX_KEYLEN] ;	// Cl de recherche sur le dossier, peu usit ici, on passe tout en revue
LPRECDossiers dossier;			// Pointeur vers une structure contenant un lment de dossier
								// La structure de donnes contenant un lment de dossier est contenue dans HDAPI
RECOrdonnances ordo;			// Une structure contenant une orodonnance dfinie dans hdapi.h
HGLOBAL hOrdo;					// Encore un "Handle", celui ci c'est pour rcuprer le texte d'une ordonnance.

PATIENT_ENTRY patlist[MAX_DOSSIERS];
								// Tableau qui va contenir les rusltats
								// Pour chaque patient stocke le nombre d'occurence, la date de la premire
								// la date de la dernire
// Nota :
// 1) Il y a 65536 patients possibles, mais certains seront vides (non existant)
// 2) Tout ceci est fait ici en allocation statique (on dfinit la taille des tableaux  l'avance)
//    pour simplifier la dmonstration. La taille totale occupe sera d'environ 1 Mo de mmoire.

int *index;						// Liste qui va contenir l'index (l'endroit o se trouve) chaque lment de dossier
								// stock dans HD
int ndossiers_tot; 				// Nombre total d'elements de dossiers (un patient a en gnral plusieurs element de dossier)
int npatients;					// Nombre de patients o la chaine de recherche a t trouve
int nocc;						// Nombre d'occurences
int naff;						// Compteur utilis pour l'affichage
int naff_max;					// Compteur utilis pour l'affichage
int i;							// Compteur

// --- Efface les rsultats prcdents ( l'cran) ---
SendDlgItemMessage(hwnd,IDD_LIST,LVM_DELETEALLITEMS,0,0);	// Efface tous les rsultats de recherche dans la fenetre de rsultat.

// --- Rcupre la chaine de recherche ---
SendDlgItemMessage(hwnd,IDD_TXT_ORDO,WM_GETTEXT,MAX_PATH,(LPARAM)str_srch_orig);
								// Lit la chaine  rechercher
strcpy(str_srch,str_srch_orig); // copie cette mme chaine dans set_srch
char *s=str_srch;				// Transforme cette mme chaine en minuscule
while (*s){*s=recherche_lower[*s]; s++;} // Pour chaque caractre, transforme prend le caractre associ dans le tableau de recherche

// --- Intialise les donnes en mmoire ---
memset(patlist,0,sizeof(patlist));	// met  zero tous les resultats de recherche
npatients=0;						// nombre de patients o la chaine de recherche a t trouve
nocc=0;								// nombre d'occurences  0

// --- Ouvre les donnes d'HD ---
Dossier=OpenDossiers(DOSSIER_MAX,NULL,0,0);			// Ouvre le fichier de dossiers d'HD
dossier=GlobalLock(Dossier);						// S'assure que la zone mmoire identifiant notre accs  la base ne bouge pas.

// --- Initialise la barre de progression ----
ndossiers_tot=HDNumberOfKey(DOSSIERSX);				// rcupre le nombre total de dossiers
SendDlgItemMessage(hwnd,IDD_PB,PBM_SETRANGE,0,MAKELPARAM(0,ndossiers_tot));
													// La barre va de 0 au nb max de dossiers
SendDlgItemMessage(hwnd,IDD_PB,PBM_SETPOS,0,0);		// La position actuelle est 0
naff_max=ndossiers_tot/50;							// Permet de remettre  jour l'affichage seulement 50 fois pendant le traitement
naff=0;												// Progression de l'affichage

// --- Lit l'ensemble des indexs ----
index=LocalAlloc(LMEM_FIXED,ndossiers_tot*sizeof(int));		// Alloue de la mmoire pour la liste des indexs.
memset(index,0,sizeof(int)*ndossiers_tot);			// met  zero tous les indexs.
index[0]=HDFirstKey(DOSSIERSX,cle_dossier);			// Lit l'index du premier dossier et le stocke dans le tableau
for (i=1;i<ndossiers_tot;i++){
	index[i]=HDNextKey(DOSSIERSX,cle_dossier);
	if (index[i]==0)								// Au cas o si la base d'HD n'est pas clean ...
		ndossiers_tot=i;
	}
qsort(index,ndossiers_tot,sizeof(int),compar);		// Trie cette liste d'indexs par ordre croissant.
// Nota : on aurait pu virer l'ensemble des indexs contenant autre chose que des ordonnances ...
//        (dans la cl on connait cette info, mais elle n'est pas documente).


// --- Recherche ----
for (i=0;i<ndossiers_tot;i++){ 							// Pour chaque lment de dossier
	ReadDossiers2(index[i],(LPRECDossiers)&ordo);		// Lit l'lment de dossier
	if (ordo.cType==DOSSIERS_ORDONNANCES){				// Si c'est une ordonnance ...
		hOrdo=ReadXMLOrdonnances(index[i],&ordo);		// Lit compltement l'ordonnance (avec le texte associ)
		if (hOrdo){										// Si ce n'est pas un enregistrement zombi ...
			char *txt=(LPSTR)GlobalLock (hOrdo);		// Fixe le texte de l'ordonnance
			char *start_text;
			char *end_text;								// Fin de la zone de texte
			char *start_rtf;
			char *end_rtf;								// Fin de la zone de texte

			// -------------- Zone "text" -------------
			start_text=stristr(txt,"<text>");			// Recherche le dbut de la zone de texte
			if (start_text)
				end_text=stristr(start_text,"</text>");		// Recherche la fin de la zone texte
			else
				end_text=NULL;
			// -------------- Zone "RTF" -------------
			start_rtf=stristr(txt,"<rtf>");				// Recherche le dbut de la zone RTF
			if (start_rtf)
				end_rtf=stristr(start_rtf,"</rtf>");			// Recherche la fin de la zone RTF
			else
				end_rtf=NULL;

			if (end_text)	*end_text=0;							// tronque l'ordo (en mmoire, pas dans les donnes d'HD !)
			if (end_rtf)	*end_rtf=0;									// tronque l'ordo (en mmoire, pas dans les donnes d'HD !)

			if (recherche_strxstr(start_text,str_srch) || recherche_strxstr(start_rtf,str_srch)){			// Recherche de la chaine dans cette ordo
				nocc++;							// Augmente le nombre d'occurences
				if (patlist[ordo.uFiche].nb==0){ // C'est la premire occurence pour ce patient
					patlist[ordo.uFiche].last=ordo.Date;
					patlist[ordo.uFiche].first=ordo.Date;
					npatients++;
					}
				patlist[ordo.uFiche].nb++; 	// Augmente le nb d'occurence
				if (ordo.Date < patlist[ordo.uFiche].first)	// mmorise la date de premire ou dernire occurence si besoin
					patlist[ordo.uFiche].first=ordo.Date;
				if (ordo.Date > patlist[ordo.uFiche].last)
					patlist[ordo.uFiche].last=ordo.Date;
				}
			GlobalUnlock (hOrdo);			//libre l'ordonnance
			GlobalFree(hOrdo);
			}
		}
	naff++;
	if (naff>naff_max){
		naff=0;
		SendDlgItemMessage(hwnd,IDD_PB,PBM_SETPOS,i,0);
		HDMessageLoop(hwnd);
		}
	}
SendDlgItemMessage(hwnd,IDD_PB,PBM_SETPOS,ndossiers_tot,0);

// -------- ferme les dossiers -------------
GlobalUnlock(Dossier);
CloseDossiers(Dossier);

// -------- Affichage des rsusltats -------------
HGLOBAL Patient;				// "Handle" pour le fichier de patients
LPRECPatients patient;			// pointeur vers une structure contenant un enregistrement patient
LV_ITEM item;					// Un item du tableau d'affichage

Patient=OpenPatients(NULL);
patient=(LPRECPatients)GlobalLock(Patient);

item.iItem=0;					// Item en cours
for (i=0;i<MAX_DOSSIERS;i++){
	if (patlist[i].nb>0){		// S'il y a qqchose de trouv

		// -------- Affichage nom patient -----------
		item.mask=LVIF_TEXT;
		item.iSubItem=0;
		patient->uFiche=i;
		patient->szNom[0]=0;
		patient->szPrenom[0]=0;
		ReadPatients(patient,PATIENTS_BY_REC);	// Recherche le nom du patient
		wsprintf(tmp,"%s %s",patient->szNom,patient->szPrenom);
		item.pszText=tmp;
		SendDlgItemMessage(hwnd,IDD_LIST,LVM_INSERTITEM,0,(LPARAM)&item);

		// -------- Affichage age -----------
		item.iSubItem=1;
		HDDATE age=GetAge(patient->DateNai,Today());
		wsprintf(tmp,"%d an%s %02d m",YEAR(age),YEAR(age)>1 ? "s" : "",MONTH(age));
		SendDlgItemMessage(hwnd,IDD_LIST,LVM_SETITEM,0,(LPARAM)&item);
		// -------- Affichage nb occurences -----------
		item.iSubItem=2;
		wsprintf(tmp,"%d",patlist[i].nb);
		SendDlgItemMessage(hwnd,IDD_LIST,LVM_SETITEM,0,(LPARAM)&item);
		// -------- Affichage date premire occurence -----------
		item.iSubItem=3;
		wsprintf(tmp,"%02d/%02d/%4d",DAY(patlist[i].first),MONTH(patlist[i].first),YEAR(patlist[i].first));
		SendDlgItemMessage(hwnd,IDD_LIST,LVM_SETITEM,0,(LPARAM)&item);
		// -------- Affichage date dernire occurence -----------
		item.iSubItem=4;
		wsprintf(tmp,"%02d/%02d/%4d",DAY(patlist[i].last),MONTH(patlist[i].last),YEAR(patlist[i].last));
		SendDlgItemMessage(hwnd,IDD_LIST,LVM_SETITEM,0,(LPARAM)&item);
		item.iItem++;
		}
	}

// -------- Fermeture fichiers patients ---------
GlobalUnlock(Patient);
ClosePatients(Patient);

// -------- Informations ------------
char txt[MAX_PATH];
wsprintf(txt,"%d occ. - %d Patients",nocc,item.iItem);
MessageBox(hwnd,txt,"VioxxFinderLite",MB_ICONINFORMATION);

LocalFree(index);	// libre le tableau d'indexs
}

